/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.renameattribute;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.sixrr.xrp.base.XRPBaseRefactoringProcessor;
import com.sixrr.xrp.base.XRPUsageInfo;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.psi.TagSearchVisitor;
import com.sixrr.xrp.renameattribute.RenameAttribute;
import com.sixrr.xrp.renameattribute.RenameAttributeUsageViewDescriptor;
import com.sixrr.xrp.utils.RefactorXBundle;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class RenameAttributeProcessor
extends XRPBaseRefactoringProcessor {
    private final XmlAttribute attribute;
    private final String newAttributeName;
    private final Context context;

    @VisibleForTesting
    public RenameAttributeProcessor(XmlAttribute attribute, String newAttributeName, Context context) {
        super(attribute.getProject());
        this.attribute = attribute;
        this.newAttributeName = newAttributeName;
        this.context = context;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usageInfos) {
        if (usageInfos == null) {
            RenameAttributeProcessor.$$$reportNull$$$0(0);
        }
        return new RenameAttributeUsageViewDescriptor(this.attribute);
    }

    @Override
    public void findUsages(@NotNull List<? super XRPUsageInfo> usages) {
        if (usages == null) {
            RenameAttributeProcessor.$$$reportNull$$$0(1);
        }
        XmlTag tag = this.attribute.getParent();
        String tagName = tag.getName();
        String attributeName = this.attribute.getName();
        String attributeNamespace = this.attribute.getNamespace();
        TagSearchVisitor visitor = new TagSearchVisitor(tagName);
        for (XmlFile file : this.context) {
            file.accept((PsiElementVisitor)visitor);
        }
        List<XmlTag> tagsFound = visitor.getTags();
        for (XmlTag xmlTag : tagsFound) {
            XmlAttribute attribute = xmlTag.getAttribute(attributeName, attributeNamespace);
            if (attribute == null) continue;
            usages.add(new RenameAttribute(attribute, this.newAttributeName));
        }
    }

    @NotNull
    protected String getCommandName() {
        String string = RefactorXBundle.message("command.name.rename.attribute.0", this.attribute.getName());
        if (string == null) {
            RenameAttributeProcessor.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/sixrr/xrp/renameattribute/RenameAttributeProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/sixrr/xrp/renameattribute/RenameAttributeProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

