/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.mcp.listeners;

import com.intellij.code.provenance.DocumentChangesKind;
import com.intellij.code.provenance.core.ProvenanceEntry;
import com.intellij.code.provenance.core.ProvenanceRegistry;
import com.intellij.code.provenance.core.events.listeners.utils.Listener_toolsKt;
import com.intellij.code.provenance.core.events.utils.Path_utilsKt;
import com.intellij.code.provenance.core.events.utils.UtilsKt;
import com.intellij.code.provenance.core.mcp.listeners.McpCallEvent;
import com.intellij.code.provenance.core.mcp.listeners.ProvenanceToolCallListener;
import com.intellij.code.provenance.core.mcp.utils.Mcp_toolsKt;
import com.intellij.mcpserver.FileContentChangeEvent;
import com.intellij.mcpserver.McpCallInfo;
import com.intellij.mcpserver.McpToolDescriptor;
import com.intellij.mcpserver.McpToolSideEffectEvent;
import com.intellij.mcpserver.ToolCallListener;
import com.intellij.mcpserver.impl.util.Schema_utilKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000I\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002*\u0001\u000f\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/code/provenance/core/mcp/listeners/ProvenanceToolCallListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "contentHashCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/code/provenance/core/mcp/listeners/McpCallEvent;", "projectPath", "Ljava/nio/file/Path;", "createToolCallListener", "com/intellij/code/provenance/core/mcp/listeners/ProvenanceToolCallListener$createToolCallListener$1", "()Lcom/intellij/code/provenance/core/mcp/listeners/ProvenanceToolCallListener$createToolCallListener$1;", "findProjectPath", "", "obj", "", "findPathInJsonObjects", "dispose", "", "Companion", "intellij.code.provenance.core.mcp"})
@SourceDebugExtension(value={"SMAP\nProvenanceToolCallListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProvenanceToolCallListener.kt\ncom/intellij/code/provenance/core/mcp/listeners/ProvenanceToolCallListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n1#2:146\n*E\n"})
public final class ProvenanceToolCallListener
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final ConcurrentHashMap<Integer, McpCallEvent> contentHashCache;
    @NotNull
    private final Path projectPath;

    public ProvenanceToolCallListener(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.scope = scope;
        this.contentHashCache = new ConcurrentHashMap();
        this.projectPath = Path_utilsKt.getProjectDirectory((Project)this.project);
        ApplicationKt.getApplication().getMessageBus().connect((Disposable)this).subscribe(ToolCallListener.Companion.getTOPIC(), (Object)this.createToolCallListener());
    }

    private final createToolCallListener.1 createToolCallListener() {
        return new ToolCallListener(this){
            final /* synthetic */ ProvenanceToolCallListener this$0;
            {
                this.this$0 = $receiver;
            }

            public void beforeMcpToolCall(McpToolDescriptor mcpToolDescriptor, McpCallInfo additionalData) {
                Intrinsics.checkNotNullParameter((Object)mcpToolDescriptor, (String)"mcpToolDescriptor");
                Intrinsics.checkNotNullParameter((Object)additionalData, (String)"additionalData");
                if (!ProvenanceRegistry.INSTANCE.isProvenanceEnabled()) {
                    return;
                }
                String projectPathFromMcpCall = ProvenanceToolCallListener.access$findProjectPath(this.this$0, additionalData.getRawArguments());
                if (projectPathFromMcpCall != null) {
                    Path path = Paths.get(projectPathFromMcpCall, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                    Path mcpPath = path.normalize().toRealPath(new LinkOption[0]);
                    if (!mcpPath.startsWith(ProvenanceToolCallListener.access$getProjectPath$p(this.this$0))) {
                        return;
                    }
                }
                ((Map)ProvenanceToolCallListener.access$getContentHashCache$p(this.this$0)).put(additionalData.getCallId(), new McpCallEvent(0L, 1, null));
            }

            public void afterMcpToolCall(McpToolDescriptor mcpToolDescriptor, List<? extends McpToolSideEffectEvent> events, Throwable error, McpCallInfo callInfo) {
                Intrinsics.checkNotNullParameter((Object)mcpToolDescriptor, (String)"mcpToolDescriptor");
                Intrinsics.checkNotNullParameter(events, (String)"events");
                Intrinsics.checkNotNullParameter((Object)callInfo, (String)"callInfo");
                if (!ProvenanceRegistry.INSTANCE.isProvenanceEnabled()) {
                    return;
                }
                McpCallEvent mcpCallEvent = (McpCallEvent)ProvenanceToolCallListener.access$getContentHashCache$p(this.this$0).remove(callInfo.getCallId());
                if (mcpCallEvent == null) {
                    return;
                }
                McpCallEvent callEvent = mcpCallEvent;
                long currentTimestamp = System.currentTimeMillis();
                long duration = currentTimestamp - callEvent.getStartTimestamp();
                BuildersKt.launch$default((CoroutineScope)ProvenanceToolCallListener.access$getScope$p(this.this$0), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(events, callInfo, currentTimestamp, duration, this.this$0, null){
                    int label;
                    final /* synthetic */ List<McpToolSideEffectEvent> $events;
                    final /* synthetic */ McpCallInfo $callInfo;
                    final /* synthetic */ long $currentTimestamp;
                    final /* synthetic */ long $duration;
                    final /* synthetic */ ProvenanceToolCallListener this$0;
                    {
                        this.$events = $events;
                        this.$callInfo = $callInfo;
                        this.$currentTimestamp = $currentTimestamp;
                        this.$duration = $duration;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                for (McpToolSideEffectEvent event : this.$events) {
                                    long newContentHash;
                                    long oldContentHash;
                                    String oldContent;
                                    if (!(event instanceof FileContentChangeEvent) || ((FileContentChangeEvent)event).getOldContent() == null || UtilsKt.isTooBigContent((CharSequence)oldContent) || UtilsKt.isTooBigContent((CharSequence)((FileContentChangeEvent)event).getNewContent()) || (oldContentHash = UtilsKt.contentHash((CharSequence)oldContent)) == (newContentHash = UtilsKt.contentHash((CharSequence)((FileContentChangeEvent)event).getNewContent()))) continue;
                                    ProvenanceEntry.MetadataEntryOfDocumentChange change = Listener_toolsKt.createToolDocumentChange((DocumentChangesKind)Mcp_toolsKt.detectKind(this.$callInfo), (VirtualFile)((FileContentChangeEvent)event).getFile(), (Long)Boxing.boxLong((long)oldContentHash), (Long)Boxing.boxLong((long)newContentHash), (long)this.$currentTimestamp, (long)this.$duration);
                                    Listener_toolsKt.saveToolChange((Project)ProvenanceToolCallListener.access$getProject$p(this.this$0), (ProvenanceEntry.MetadataEntryOfDocumentChange)change);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
        };
    }

    private final String findProjectPath(Object obj) {
        if (obj instanceof JsonObject && ((Map)obj).containsKey(Schema_utilKt.getProjectPathParameterName())) {
            JsonPrimitive projectPath;
            Object object = ((JsonObject)obj).get((Object)Schema_utilKt.getProjectPathParameterName());
            JsonPrimitive jsonPrimitive = projectPath = object instanceof JsonPrimitive ? (JsonPrimitive)object : null;
            if (projectPath != null && (object = JsonElementKt.getContentOrNull((JsonPrimitive)projectPath)) != null) {
                Object it = object;
                boolean bl = false;
                return it;
            }
        }
        return null;
    }

    private final String findPathInJsonObjects(Object obj) {
        if (obj instanceof JsonObject) {
            for (Map.Entry entry : ((Map)obj).entrySet()) {
                String string;
                String key = (String)entry.getKey();
                JsonElement value = (JsonElement)entry.getValue();
                if (Intrinsics.areEqual((Object)key, (Object)Schema_utilKt.getProjectPathParameterName())) continue;
                String string2 = key.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"path", (boolean)false, (int)2, null) || !(value instanceof JsonPrimitive) || (string = JsonElementKt.getContentOrNull((JsonPrimitive)((JsonPrimitive)value))) == null) continue;
                String it = string;
                boolean bl = false;
                return it;
            }
            Iterator iterator = ((Map)obj).entrySet().iterator();
            while (iterator.hasNext()) {
                JsonElement value = (JsonElement)iterator.next().getValue();
                String string = this.findPathInJsonObjects(value);
                if (string == null) continue;
                String it = string;
                boolean bl = false;
                return it;
            }
        }
        return null;
    }

    public void dispose() {
        this.contentHashCache.clear();
    }

    public static final /* synthetic */ String access$findProjectPath(ProvenanceToolCallListener $this, Object obj) {
        return $this.findProjectPath(obj);
    }

    public static final /* synthetic */ Path access$getProjectPath$p(ProvenanceToolCallListener $this) {
        return $this.projectPath;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getContentHashCache$p(ProvenanceToolCallListener $this) {
        return $this.contentHashCache;
    }

    public static final /* synthetic */ CoroutineScope access$getScope$p(ProvenanceToolCallListener $this) {
        return $this.scope;
    }

    public static final /* synthetic */ Project access$getProject$p(ProvenanceToolCallListener $this) {
        return $this.project;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/code/provenance/core/mcp/listeners/ProvenanceToolCallListener$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/code/provenance/core/mcp/listeners/ProvenanceToolCallListener;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.code.provenance.core.mcp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProvenanceToolCallListener getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(ProvenanceToolCallListener.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (ProvenanceToolCallListener)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

