/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.facet;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.facet.FacetFinder;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.jpa.JavaeePersistenceDescriptorsConstants;
import com.intellij.jpa.JpaInspectionToolProvider;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.facet.JpaModuleConfiguration;
import com.intellij.jpa.highlighting.HibernateModelValidator;
import com.intellij.jpa.highlighting.JpaModelValidator;
import com.intellij.jpa.model.VirtualPersistenceUnit;
import com.intellij.jpa.model.common.MergedPersistenceMappings;
import com.intellij.jpa.model.xml.impl.converters.PersistentUnitFileConverterImpl;
import com.intellij.jpa.model.xml.persistence.Persistence;
import com.intellij.jpa.model.xml.persistence.PersistenceUnit;
import com.intellij.jpa.model.xml.persistence.mapping.AccessType;
import com.intellij.jpa.model.xml.persistence.mapping.EntityMappings;
import com.intellij.jpa.model.xml.persistence.mapping.PersistenceUnitDefaults;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.extensions.PersistencePackagesProvider;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.facet.PersistencePackageDefaults;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.validators.ModelValidator;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JpaFacetUtil {
    private static final Key<CachedValue<PersistencePackageDefaults>> PERSISTENCE_UNIT_DEFAULTS = Key.create((String)"PERSISTENCE_UNIT_DEFAULTS");

    static Class<? extends LocalInspectionTool> @NotNull [] getInspectionClasses() {
        Class<? extends LocalInspectionTool>[] classArray = new JpaInspectionToolProvider().getInspectionClasses();
        if (classArray == null) {
            JpaFacetUtil.$$$reportNull$$$0(0);
        }
        return classArray;
    }

    static PersistencePackageDefaults getPersistencePackageDefaults(@NotNull PersistenceFacet persistenceFacet, @NotNull PersistencePackage unit) {
        if (persistenceFacet == null) {
            JpaFacetUtil.$$$reportNull$$$0(1);
        }
        if (unit == null) {
            JpaFacetUtil.$$$reportNull$$$0(2);
        }
        assert (unit.isValid());
        CachedValue cachedValue = (CachedValue)unit.getUserData(PERSISTENCE_UNIT_DEFAULTS);
        if (cachedValue == null) {
            cachedValue = CachedValuesManager.getManager((Project)unit.getPsiManager().getProject()).createCachedValue(() -> {
                Collection mappings = PersistenceCommonUtil.getDomEntityMappings(EntityMappings.class, (PersistencePackage)unit, (PersistenceFacet)persistenceFacet);
                String _schema = null;
                String _catalog = null;
                PropertyMemberType _access = null;
                for (Object mapping : mappings) {
                    PersistenceUnitDefaults defaults = mapping.getPersistenceUnitMetadata().getPersistenceUnitDefaults();
                    if (!DomUtil.hasXml((DomElement)defaults)) continue;
                    _schema = (String)defaults.getSchema().getValue();
                    _catalog = (String)defaults.getCatalog().getValue();
                    AccessType type = (AccessType)((Object)((Object)defaults.getAccess().getValue()));
                    _access = type == null ? null : (type == AccessType.FIELD ? PropertyMemberType.FIELD : PropertyMemberType.GETTER);
                    break;
                }
                HashSet<ModificationTracker> dependencies = new HashSet<ModificationTracker>();
                dependencies.add(persistenceFacet.getModificationTracker());
                ContainerUtil.addIfNotNull(dependencies, (Object)unit.getContainingFile());
                for (EntityMappings mapping : mappings) {
                    ContainerUtil.addIfNotNull(dependencies, (Object)mapping.getContainingFile());
                }
                final String schema = _schema;
                final String catalog = _catalog;
                final PropertyMemberType access = _access;
                PersistencePackageDefaults result = new PersistencePackageDefaults(){

                    @Nullable
                    public String getSchema() {
                        return schema;
                    }

                    @Nullable
                    public String getCatalog() {
                        return catalog;
                    }

                    @Nullable
                    public PropertyMemberType getAccess() {
                        return access;
                    }
                };
                return new CachedValueProvider.Result((Object)result, dependencies.toArray());
            }, false);
            unit.putUserData(PERSISTENCE_UNIT_DEFAULTS, (Object)cachedValue);
        }
        return (PersistencePackageDefaults)cachedValue.getValue();
    }

    @NotNull
    static ModelValidator getModelValidator(@Nullable PersistenceFacet facet, @Nullable PersistencePackage unit) {
        PersistenceModelBrowser browser = PersistenceHelper.getHelper().createModelBrowser();
        return unit instanceof PersistenceUnit && JpaUtil.isHibernateProvider(facet, unit) ? new HibernateModelValidator(browser) : new JpaModelValidator(browser);
    }

    public static List<XmlFile> getPersistenceXmlsInLibraries(Module module) {
        return (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            VirtualFile[] files;
            ArrayList<XmlFile> resourceFiles = new ArrayList<XmlFile>();
            for (VirtualFile file : files = OrderEnumerator.orderEntries((Module)module).getAllLibrariesAndSdkClassesRoots()) {
                PsiFile psiFile;
                String tagNS;
                VirtualFile candidate;
                if (!file.isValid() || (candidate = file.findFileByRelativePath(JavaeeUtil.getDefaultDescriptorPath((ConfigFileMetaData)JavaeePersistenceDescriptorsConstants.PERSISTENCE_XML_META_DATA))) == null || (tagNS = JavaeeUtil.getRootTagNS((PsiFile)(psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(candidate)), (String)"persistence")) == null || !tagNS.isEmpty() && !"http://java.sun.com/xml/ns/persistence".equals(tagNS)) continue;
                resourceFiles.add((XmlFile)psiFile);
            }
            Object[] objects = resourceFiles.toArray();
            return CachedValueProvider.Result.create(resourceFiles, (Object[])ArrayUtil.append((Object[])objects, (Object)JavaLibraryModificationTracker.getInstance((Project)module.getProject())));
        });
    }

    @NotNull
    static Set<Object> getPersistencePackageDependencies(PersistenceFacet facet, List<PersistencePackage> packages) {
        HashSet<Object> dependencies = new HashSet<Object>();
        for (PersistencePackage aPackage : packages) {
            ContainerUtil.addIfNotNull(dependencies, (Object)aPackage.getContainingFile());
        }
        for (ConfigFile descriptor : facet.getDescriptors()) {
            ContainerUtil.addIfNotNull(dependencies, (Object)descriptor.getPsiFile());
        }
        dependencies.add(FacetFinder.getInstance((Project)facet.getModule().getProject()).getAllFacetsOfTypeModificationTracker(JpaFacet.ID));
        HashSet<Object> hashSet = dependencies;
        if (hashSet == null) {
            JpaFacetUtil.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    @NotNull
    static PersistenceMappings getEntityMappings(@NotNull JpaModuleConfiguration configuration, @NotNull PersistencePackage unit) {
        if (configuration == null) {
            JpaFacetUtil.$$$reportNull$$$0(4);
        }
        if (unit == null) {
            JpaFacetUtil.$$$reportNull$$$0(5);
        }
        assert (unit.isValid()) : String.format("Received invalid PersistencePackage [class: %s, name: %s]", unit.getClass(), unit.getName());
        Collection xmlMappings = PersistenceCommonUtil.getDomEntityMappings(EntityMappings.class, (PersistencePackage)unit, (PersistenceFacet)configuration);
        com.intellij.jpa.model.common.persistence.mapping.EntityMappings annoMappings = configuration.getAnnotationEntityMappings(unit);
        if (annoMappings != null && xmlMappings.isEmpty()) {
            com.intellij.jpa.model.common.persistence.mapping.EntityMappings entityMappings = annoMappings;
            if (entityMappings == null) {
                JpaFacetUtil.$$$reportNull$$$0(6);
            }
            return entityMappings;
        }
        ArrayList<PersistenceMappings> allMappings = new ArrayList<PersistenceMappings>(xmlMappings);
        if (annoMappings != null) {
            allMappings.add(0, annoMappings);
        }
        return allMappings.isEmpty() ? (PersistenceMappings)DomManager.getDomManager((Project)configuration.getModule().getProject()).createMockElement(EntityMappings.class, configuration.getModule(), true) : new MergedPersistenceMappings(configuration, allMappings);
    }

    @NotNull
    static List<EntityMappings> getDefaultEntityMappings(@NotNull JpaModuleConfiguration configuration, @NotNull PersistencePackage unit) {
        EntityMappings defORMDescriptor;
        ConfigFile ormDescriptor;
        if (configuration == null) {
            JpaFacetUtil.$$$reportNull$$$0(7);
        }
        if (unit == null) {
            JpaFacetUtil.$$$reportNull$$$0(8);
        }
        if ((ormDescriptor = configuration.getDefaultORMDescriptor()) == null) {
            PsiFile containingFile = unit.getContainingFile();
            VirtualFile xmlVf = containingFile == null ? null : containingFile.getVirtualFile();
            defORMDescriptor = PersistentUnitFileConverterImpl.findEntityMappings(JavaeeUtil.getDefaultDescriptorPath((ConfigFileMetaData)JavaeePersistenceDescriptorsConstants.ORM_XML_META_DATA), xmlVf, PsiManager.getInstance((Project)configuration.getModule().getProject()), configuration.getModule());
        } else {
            defORMDescriptor = (EntityMappings)JamCommonUtil.getRootElement((PsiFile)ormDescriptor.getXmlFile(), EntityMappings.class);
        }
        if (defORMDescriptor != null) {
            List<EntityMappings> list = Collections.singletonList(defORMDescriptor);
            if (list == null) {
                JpaFacetUtil.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<EntityMappings> list = Collections.emptyList();
        if (list == null) {
            JpaFacetUtil.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Nullable
    public static Persistence getMergedPersistenceRoot(@NotNull JpaModuleConfiguration configuration) {
        List<XmlFile> list;
        if (configuration == null) {
            JpaFacetUtil.$$$reportNull$$$0(11);
        }
        if ((list = configuration.getPersistenceXmls()).isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            LinkedHashSet roots = new LinkedHashSet();
            for (XmlFile xmlFile : list) {
                ContainerUtil.addIfNotNull(roots, (Object)((Persistence)JamCommonUtil.getRootElement((PsiFile)xmlFile, Persistence.class)));
            }
            return (Persistence)DomService.getInstance().createModelMerger().mergeModels(Persistence.class, roots);
        }
        return (Persistence)JamCommonUtil.getRootElement((PsiFile)((PsiFile)list.get(0)), Persistence.class);
    }

    @NotNull
    static List<PersistencePackage> getPersistenceUnits(@NotNull JpaModuleConfiguration configuration) {
        if (configuration == null) {
            JpaFacetUtil.$$$reportNull$$$0(12);
        }
        List list = (List)CachedValuesManager.getManager((Project)configuration.getModule().getProject()).getCachedValue((UserDataHolder)configuration, () -> {
            ArrayList<PersistencePackage> packages = new ArrayList<PersistencePackage>();
            packages.addAll(configuration.getExplicitPersistenceUnits());
            packages.addAll(JpaFacetUtil.getExtensionPersistenceUnits(configuration));
            if (packages.isEmpty()) {
                ContainerUtil.addIfNotNull(packages, (Object)((Object)JpaFacetUtil.getImplicitPersistenceUnit(configuration)));
            }
            return CachedValueProvider.Result.create(List.copyOf(packages), JpaFacetUtil.getPersistencePackageDependencies(configuration, packages));
        });
        if (list == null) {
            JpaFacetUtil.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    private static VirtualPersistenceUnit getImplicitPersistenceUnit(@NotNull JpaModuleConfiguration configuration) {
        if (configuration == null) {
            JpaFacetUtil.$$$reportNull$$$0(14);
        }
        return new VirtualPersistenceUnit(configuration);
    }

    @NotNull
    private static List<PersistencePackage> getExtensionPersistenceUnits(@NotNull JpaModuleConfiguration configuration) {
        if (configuration == null) {
            JpaFacetUtil.$$$reportNull$$$0(15);
        }
        List list = ContainerUtil.concat((Iterable)PersistencePackagesProvider.EP_NAME.getExtensionList(), provider -> provider.getPersistencePackages((PersistenceFacet)configuration));
        if (list == null) {
            JpaFacetUtil.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 7, 8, 11, 12, 14, 15 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/facet/JpaFacetUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistenceFacet";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionClasses";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/facet/JpaFacetUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistencePackageDependencies";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntityMappings";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultEntityMappings";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceUnits";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionPersistenceUnits";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPersistencePackageDefaults";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getEntityMappings";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultEntityMappings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMergedPersistenceRoot";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPersistenceUnits";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitPersistenceUnit";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionPersistenceUnits";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 7, 8, 11, 12, 14, 15 -> new IllegalArgumentException(string);
        };
    }
}

