/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.debug.recents;

import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.debug.KubectlDebugMultipleTargetsActionGroup;
import com.intellij.kubernetes.debug.KubectlDebugUtilsKt;
import com.intellij.kubernetes.debug.KubectlDebugWithSpecifiedParamsAction;
import com.intellij.kubernetes.debug.recents.KubectlDebugRecentParametersTemplate;
import com.intellij.kubernetes.debug.recents.KubernetesRecentDebugsParametersService;
import com.intellij.kubernetes.debug.recents.KubernetesRecentEphemeralDebugsActionGroupKt;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObject;
import com.intellij.kubernetes.view.ui.actions.ActionUtilsKt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1Pod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0017\u00a2\u0006\u0002\u0010\u0010J \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/kubernetes/debug/recents/KubernetesRecentEphemeralDebugsActionGroup;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isVisible", "", "getChildren", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "calculateTargetContainers", "", "Lio/kubernetes/client/openapi/models/V1Container;", "selectedContainer", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "selectedPod", "Lio/kubernetes/client/openapi/models/V1Pod;", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesRecentEphemeralDebugsActionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesRecentEphemeralDebugsActionGroup.kt\ncom/intellij/kubernetes/debug/recents/KubernetesRecentEphemeralDebugsActionGroup\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n13#2:119\n1563#3:120\n1634#3,3:121\n1563#3:124\n1634#3,3:125\n1563#3:128\n1634#3,3:129\n37#4,2:132\n1#5:134\n*S KotlinDebug\n*F\n+ 1 KubernetesRecentEphemeralDebugsActionGroup.kt\ncom/intellij/kubernetes/debug/recents/KubernetesRecentEphemeralDebugsActionGroup\n*L\n61#1:119\n71#1:120\n71#1:121,3\n82#1:124\n82#1:125,3\n83#1:128\n83#1:129,3\n101#1:132,2\n*E\n"})
public final class KubernetesRecentEphemeralDebugsActionGroup
extends DefaultActionGroup
implements DumbAware {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!KubectlDebugUtilsKt.isKubectlDebugSupportEnabled()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(this.isVisible(e));
    }

    private final boolean isVisible(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        if (ActionUtilsKt.getBackendApiModel((AnActionEvent)e) == null) {
            return false;
        }
        Pair<V1Pod, KubernetesContainerObject> pair = KubectlDebugUtilsKt.getSelectedPodAndContainer(e);
        V1Pod selectedPod2 = (V1Pod)pair.component1();
        KubernetesContainerObject selectedContainer = (KubernetesContainerObject)pair.component2();
        if (selectedPod2 == null) {
            return false;
        }
        if (selectedContainer != null && KubectlDebugUtilsKt.isEphemeral(selectedContainer)) {
            return false;
        }
        List<V1Container> targetContainers = this.calculateTargetContainers(selectedContainer, selectedPod2);
        if (targetContainers.isEmpty()) {
            return false;
        }
        List<KubectlDebugRecentParametersTemplate> debugParametersTemplates = KubernetesRecentDebugsParametersService.Companion.getInstance(project2).getTemplates();
        return !((Collection)debugParametersTemplates).isEmpty();
    }

    @RequiresBackgroundThread
    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        List list;
        if (e == null) {
            return new AnAction[0];
        }
        Project project = e.getProject();
        if (project == null) {
            return new AnAction[0];
        }
        Project project2 = project;
        KubernetesApiModel kubernetesApiModel = ActionUtilsKt.getBackendApiModel((AnActionEvent)e);
        if (kubernetesApiModel == null) {
            return new AnAction[0];
        }
        KubernetesApiModel apiModel2 = kubernetesApiModel;
        Pair<V1Pod, KubernetesContainerObject> pair = KubectlDebugUtilsKt.getSelectedPodAndContainer(e);
        V1Pod selectedPod2 = (V1Pod)pair.component1();
        KubernetesContainerObject selectedContainer = (KubernetesContainerObject)pair.component2();
        if (selectedPod2 == null) {
            return new AnAction[0];
        }
        List<V1Container> targetContainers = this.calculateTargetContainers(selectedContainer, selectedPod2);
        if (targetContainers.isEmpty()) {
            return new AnAction[0];
        }
        Object object = selectedPod2.getMetadata();
        if (object == null || (object = object.getName()) == null) {
            KubernetesRecentEphemeralDebugsActionGroup $this$getChildren_u24lambda_u240 = this;
            boolean bl = false;
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(KubernetesRecentEphemeralDebugsActionGroup.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("Pod name is not presented (label 1). pod: " + selectedPod2);
            return new AnAction[0];
        }
        Object podName = object;
        Object object2 = selectedPod2.getMetadata();
        if (object2 == null || (object2 = object2.getNamespace()) == null) {
            object2 = "default";
        }
        Object podNamespace = object2;
        List<KubectlDebugRecentParametersTemplate> debugParametersTemplates = KubernetesRecentDebugsParametersService.Companion.getInstance(project2).getTemplates();
        if (targetContainers.size() == 1) {
            String targetName = ((V1Container)CollectionsKt.first(targetContainers)).getName();
            $this$map$iv = debugParametersTemplates;
            $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                KubectlDebugRecentParametersTemplate kubectlDebugRecentParametersTemplate = (KubectlDebugRecentParametersTemplate)item$iv$iv;
                var22_26 = destination$iv$iv;
                boolean bl = false;
                KubernetesApiModelInterface kubernetesApiModelInterface = (KubernetesApiModelInterface)apiModel2;
                Intrinsics.checkNotNull((Object)targetName);
                var22_26.add(new KubectlDebugWithSpecifiedParamsAction(kubernetesApiModelInterface, KubectlDebugUtilsKt.toNormal((KubectlDebugRecentParametersTemplate)template, (String)podNamespace, (String)podName, targetName), template.getName()));
            }
            list = (List)destination$iv$iv;
        } else {
            KubectlDebugRecentParametersTemplate it;
            $this$map$iv = targetContainers;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                template = (V1Container)item$iv$iv;
                var22_26 = destination$iv$iv;
                boolean bl = false;
                var22_26.add(it.getName());
            }
            List targetsNames = (List)destination$iv$iv;
            $this$map$iv = debugParametersTemplates;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (KubectlDebugRecentParametersTemplate)item$iv$iv;
                var22_26 = destination$iv$iv;
                boolean bl = false;
                var22_26.add(new KubectlDebugMultipleTargetsActionGroup((String)podNamespace, (String)podName, targetsNames, template.getImage(), template.getOptionalParameters(), template.getExecutable(), template.getName()));
            }
            list = (List)destination$iv$iv;
        }
        List actions = list;
        if (actions.isEmpty()) {
            return new AnAction[0];
        }
        Separator separator = Separator.create((String)KubernetesBundle.message((String)"separator.Kubernetes.EphemeralContainers.recents.name", (Object[])new Object[0]));
        Intrinsics.checkNotNullExpressionValue((Object)separator, (String)"create(...)");
        Separator separator2 = separator;
        AnAction gotoSettingsAction = ActionManager.getInstance().getAction("Kubernetes.EphemeralContainers.open.recent.debugs.settings");
        Collection $this$toTypedArray$iv = CollectionsKt.toList((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)separator2), (Iterable)actions), (Iterable)CollectionsKt.listOf((Object)gotoSettingsAction)));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new AnAction[0]);
    }

    private final List<V1Container> calculateTargetContainers(KubernetesContainerObject selectedContainer, V1Pod selectedPod2) {
        List list;
        block3: {
            block5: {
                block4: {
                    block2: {
                        if (selectedContainer != null) break block2;
                        list = KubectlDebugUtilsKt.getContainersExceptEphemeral(selectedPod2);
                        break block3;
                    }
                    if (!KubectlDebugUtilsKt.isEphemeral(selectedContainer)) break block4;
                    list = CollectionsKt.emptyList();
                    break block3;
                }
                list = selectedContainer.getContainerSpec();
                if (list == null) break block5;
                List it = list;
                boolean bl = false;
                List list2 = CollectionsKt.listOf((Object)it);
                list = list2;
                if (list2 != null) break block3;
            }
            KubernetesRecentEphemeralDebugsActionGroup $this$calculateTargetContainers_u24lambda_u241 = this;
            boolean bl = false;
            KubernetesRecentEphemeralDebugsActionGroupKt.access$getLOG$p().debug("`null` from `containerSpec` for non-ephemeral KubernetesContainerObject: " + selectedContainer);
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

