/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.directives;

import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.FtlXmlTag;
import com.intellij.freemarker.psi.directives.FtlAssignmentDeclaration;
import com.intellij.freemarker.psi.directives.FtlAssignmentType;
import com.intellij.freemarker.psi.directives.FtlDirective;
import com.intellij.freemarker.psi.directives.FtlNestedDirective;
import com.intellij.freemarker.psi.directives.FtlParameterDeclaration;
import com.intellij.freemarker.psi.directives.FtlSignatureCallableType;
import com.intellij.freemarker.psi.files.FtlFileType;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlCallableVariable;
import com.intellij.freemarker.psi.variables.FtlLightVariable;
import com.intellij.freemarker.psi.variables.FtlSpecialVariableType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FtlSignatureDirective
extends FtlDirective
implements FtlCallableVariable {
    private final NotNullLazyValue<CachedValue<Map<Integer, FtlType>>> myLoopVarsTypes;
    private final FtlLightVariable myLocalsVariable;

    public FtlSignatureDirective(@NotNull ASTNode node) {
        if (node == null) {
            FtlSignatureDirective.$$$reportNull$$$0(0);
        }
        super(node);
        this.myLocalsVariable = new FtlLightVariable(".locals", (PsiElement)this, new FtlSpecialVariableType(this){

            @Override
            public boolean processDeclarations(final @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, ResolveState state) {
                if (processor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (place == null) {
                    1.$$$reportNull$$$0(1);
                }
                return PsiScopesUtil.treeWalkUp((PsiScopeProcessor)new PsiScopeProcessor(){

                    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (state == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return !(element instanceof FtlParameterDeclaration) && !(element instanceof FtlAssignmentDeclaration) || processor.execute(element, state);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "element";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "state";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/freemarker/psi/directives/FtlSignatureDirective$1$1";
                        objectArray[2] = "execute";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }, (PsiElement)place, (PsiElement)PsiTreeUtil.getParentOfType((PsiElement)place, FtlSignatureDirective.class), (ResolveState)FtlAssignmentType.allowAssignments(state, FtlAssignmentType.LOCAL));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "processor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "place";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/freemarker/psi/directives/FtlSignatureDirective$1";
                objectArray[2] = "processDeclarations";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myLoopVarsTypes = NotNullLazyValue.lazy(() -> CachedValuesManager.getManager((Project)this.getManager().getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<Map<Integer, FtlType>>(){

            public CachedValueProvider.Result<Map<Integer, FtlType>> compute() {
                Int2ObjectOpenHashMap result = new Int2ObjectOpenHashMap();
                FtlSignatureDirective.this.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(this, (Int2ObjectMap)result){
                    final /* synthetic */ Int2ObjectMap val$result;
                    {
                        this.val$result = int2ObjectMap;
                    }

                    public void visitElement(@NotNull PsiElement element) {
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (!(element instanceof FtlXmlTag)) {
                            return;
                        }
                        if (element instanceof FtlNestedDirective) {
                            FtlNestedDirective directive = (FtlNestedDirective)element;
                            FtlExpression[] expressions = directive.getExpressions();
                            for (int i = 0; i < expressions.length; ++i) {
                                FtlType type;
                                FtlType newType = expressions[i].getType();
                                if (Comparing.equal((Object)newType, (Object)(type = (FtlType)this.val$result.get(i)))) {
                                    return;
                                }
                                if ((type = FtlPsiUtil.mergeTypes(newType, type)) == null) continue;
                                this.val$result.put(i, (Object)type);
                            }
                        }
                        super.visitElement(element);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/psi/directives/FtlSignatureDirective$2$1", "visitElement"));
                    }
                });
                return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
        }, false));
    }

    public Map<Integer, FtlType> getLoopVariableTypes() {
        return (Map)((CachedValue)this.myLoopVarsTypes.getValue()).getValue();
    }

    @NotNull
    public SearchScope getUseScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)super.getUseScope()), (FileType[])new FileType[]{FtlFileType.INSTANCE});
        if (globalSearchScope == null) {
            FtlSignatureDirective.$$$reportNull$$$0(1);
        }
        return globalSearchScope;
    }

    @Nullable
    public FtlParameterDeclaration findParameter(@NotNull String name) {
        if (name == null) {
            FtlSignatureDirective.$$$reportNull$$$0(2);
        }
        for (FtlParameterDeclaration declaration : this.getParameters()) {
            if (!name.equals(declaration.getName())) continue;
            return declaration;
        }
        return null;
    }

    public int getTextOffset() {
        PsiElement element = this.getNameElement();
        if (element != null) {
            return element.getTextRange().getStartOffset();
        }
        return super.getTextOffset();
    }

    @Nullable
    public PsiElement getNameElement() {
        return this.findChildByType((IElementType)FtlElementTypes.IDENTIFIER);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            FtlSignatureDirective.$$$reportNull$$$0(3);
        }
        if (state == null) {
            FtlSignatureDirective.$$$reportNull$$$0(4);
        }
        if (place == null) {
            FtlSignatureDirective.$$$reportNull$$$0(5);
        }
        if (lastParent != null && !processor.execute((PsiElement)this, state)) {
            return false;
        }
        if (FtlAssignmentType.isAssignmentAllowed(state, FtlAssignmentType.LOCAL)) {
            FtlParameterDeclaration[] parameters = this.getParameters();
            int end = lastParent instanceof FtlParameterDeclaration ? Arrays.asList(parameters).indexOf(lastParent) : parameters.length;
            for (int i = 0; i < end; ++i) {
                if (processor.execute((PsiElement)parameters[i], state)) continue;
                return false;
            }
        }
        return this.processDirectiveDeclarations(processor, state, lastParent, lastParent == null);
    }

    @Override
    public boolean processDirectiveDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, boolean honorAssigns) {
        if (lastParent == null) {
            return true;
        }
        return processor.execute((PsiElement)this.myLocalsVariable, state) && this.processDeclarationsInside(processor, state, lastParent, honorAssigns);
    }

    public boolean processDeclarationsInside(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, boolean honorAssigns) {
        return super.processDirectiveDeclarations(processor, state, lastParent, honorAssigns);
    }

    public FtlParameterDeclaration[] getParameters() {
        return (FtlParameterDeclaration[])this.findChildrenByClass(FtlParameterDeclaration.class);
    }

    @Nullable
    public String getName() {
        PsiElement node = this.getNameElement();
        return node == null ? null : node.getText();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            FtlSignatureDirective.$$$reportNull$$$0(6);
        }
        PsiElement element = FtlPsiUtil.parseFtlExpression(name, this.getProject());
        this.getNode().replaceChild(this.getNameElement().getNode(), element.getNode().getFirstChildNode());
        return this;
    }

    @Override
    public String getPresentableName() {
        return StringUtil.notNullize((String)this.getName());
    }

    public boolean isFunction() {
        return "function".equals(this.getDirectiveName());
    }

    @Override
    public FtlCallableType getType() {
        return new FtlSignatureCallableType(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/psi/directives/FtlSignatureDirective";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/psi/directives/FtlSignatureDirective";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findParameter";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

