/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.javaee.model.CommonListener;
import com.intellij.javaee.web.CommonFilter;
import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.CommonServletMapping;
import com.intellij.javaee.web.WebCommonClassNames;
import com.intellij.javaee.web.WebModel;
import com.intellij.javaee.web.WebModelContributor;
import com.intellij.javaee.web.model.jam.JamFilter;
import com.intellij.javaee.web.model.jam.JamListener;
import com.intellij.javaee.web.model.jam.JamServlet;
import com.intellij.javaee.web.model.xml.WebApp;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class WebModelBase
implements WebModel {
    private final CachedValue<List<CommonServletMapping<CommonServlet>>> myServletMappings;

    public WebModelBase(@NotNull Project project) {
        if (project == null) {
            WebModelBase.$$$reportNull$$$0(0);
        }
        this.myServletMappings = CachedValuesManager.getManager((Project)project).createCachedValue(() -> CachedValueProvider.Result.create(this.findServletMappings(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    public List<CommonServlet> getServlets() {
        return this.getMergedElements(JamServlet.SERVLET_CLASS_META, webApp -> new ArrayList(webApp.getServlets()), (contributor, module) -> contributor.getServlets((Module)module), WebCommonClassNames.ANNOTATION_WEB_SERVLET.all());
    }

    public CommonServlet findServlet(@NotNull String name) {
        if (name == null) {
            WebModelBase.$$$reportNull$$$0(1);
        }
        return (CommonServlet)ContainerUtil.find(this.getServlets(), o -> name.equals(o.getServletName().getStringValue()));
    }

    public CommonFilter findFilter(@NotNull String name) {
        if (name == null) {
            WebModelBase.$$$reportNull$$$0(2);
        }
        return (CommonFilter)ContainerUtil.find(this.getFilters(), o -> name.equals(o.getFilterName().getStringValue()));
    }

    public List<CommonServletMapping<CommonServlet>> getServletMappings() {
        return (List)this.myServletMappings.getValue();
    }

    @NotNull
    private List<CommonServletMapping<CommonServlet>> findServletMappings() {
        List<CommonServletMapping<CommonServlet>> list = this.getMergedElements(JamServlet.SERVLET_CLASS_META, webApp -> new ArrayList(webApp.getServletMappings()), (contributor, module) -> contributor.getServletMappings((Module)module), WebCommonClassNames.ANNOTATION_WEB_SERVLET.all());
        if (list == null) {
            WebModelBase.$$$reportNull$$$0(3);
        }
        return list;
    }

    private <T> List<T> getMergedElements(JamClassMeta<? extends T> servletClassMeta, Function<? super WebApp, ? extends List<T>> webAppFunction, PairFunction<? super WebModelContributor, ? super Module, ? extends List<T>> contributorFunction, String ... annotations) {
        if (DumbService.isDumb((Project)this.getModule().getProject())) {
            return Collections.emptyList();
        }
        Collection<WebApp> models = this.getApps();
        ArrayList result = new ArrayList();
        for (WebApp model : models) {
            result.addAll((Collection)webAppFunction.fun((Object)model));
        }
        for (WebModelContributor webModelContributor : (WebModelContributor[])WebModelContributor.EP_NAME.getExtensions()) {
            result.addAll((Collection)contributorFunction.fun((Object)webModelContributor, (Object)this.getModule()));
        }
        JamService service = JamService.getJamService((Project)this.getModule().getProject());
        GlobalSearchScope scope = GlobalSearchScope.moduleRuntimeScope((Module)this.getModule(), (boolean)false);
        for (String anno : annotations) {
            result.addAll(service.getJamClassElements(servletClassMeta, anno, scope));
        }
        if (result.isEmpty()) {
            return Collections.emptyList();
        }
        return result;
    }

    @NotNull
    protected abstract Module getModule();

    protected abstract Collection<WebApp> getApps();

    public List<CommonFilter> getFilters() {
        return this.getMergedElements(JamFilter.FILTER_CLASS_META, webApp -> new ArrayList(webApp.getFilters()), (contributor, module) -> contributor.getFilters((Module)module), WebCommonClassNames.ANNOTATION_WEB_FILTER.all());
    }

    public List<CommonListener> getListeners() {
        return this.getMergedElements(JamListener.LISTENER_CLASS_META, webApp -> new ArrayList(webApp.getListeners()), (contributor, module) -> contributor.getListeners((Module)module), WebCommonClassNames.ANNOTATION_WEB_LISTENER.all());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/web/WebModelBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/web/WebModelBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findServletMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findServlet";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findFilter";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

