/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.dnd;

import com.intellij.jupyter.core.editor.handlers.CsvDropUtilKt;
import com.intellij.jupyter.core.editor.handlers.TableDataFileDropHandlerContext;
import com.intellij.kotlin.jupyter.core.editor.dnd.AbstractKotlinDataframeDropHandler;
import com.intellij.kotlin.jupyter.core.resources.i18n.KotlinNotebookBundle;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/dnd/KotlinCsvDropHandler;", "Lcom/intellij/kotlin/jupyter/core/editor/dnd/AbstractKotlinDataframeDropHandler;", "<init>", "()V", "generateImportExpression", "", "dataFilePath", "context", "Lcom/intellij/jupyter/core/editor/handlers/TableDataFileDropHandlerContext;", "intellij.kotlin.jupyter.core"})
public final class KotlinCsvDropHandler
extends AbstractKotlinDataframeDropHandler {
    public KotlinCsvDropHandler() {
        Object[] objectArray = new String[]{"csv", "tsv"};
        super(KotlinNotebookBundle.message("kotlin.jupyter.editor.dnd.csv.dataframe.command", new Object[0]), SetsKt.setOf((Object[])objectArray));
    }

    @Override
    @NotNull
    protected String generateImportExpression(@NotNull String dataFilePath, @NotNull TableDataFileDropHandlerContext context) {
        String string;
        String string2;
        Object separatorArg;
        block12: {
            Object object;
            block11: {
                Character csvSeparator;
                Character c;
                Intrinsics.checkNotNullParameter((Object)dataFilePath, (String)"dataFilePath");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                TableDataFileDropHandlerContext.PathData pathData = context.getPathData();
                if (pathData instanceof TableDataFileDropHandlerContext.PathData.FileBased) {
                    Path path2 = ((TableDataFileDropHandlerContext.PathData.FileBased)pathData).getTableDataFile().toPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
                    c = CsvDropUtilKt.guessCsvSeparator((Path)path2);
                } else if (pathData instanceof TableDataFileDropHandlerContext.PathData.Lightweight) {
                    c = null;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                if ((object = (csvSeparator = c)) == null) break block11;
                char separator = ((Character)object).charValue();
                boolean bl = false;
                Object escapedSeparator = separator == '\t' ? "\\t" : Character.valueOf(separator);
                String string3 = ", delimiter = '" + escapedSeparator + "'";
                object = string3;
                if (string3 != null) break block12;
            }
            object = separatorArg = "";
        }
        if (Intrinsics.areEqual((Object)(string2 = context.getFileExtension()), (Object)"csv")) {
            string = "readCsv";
        } else if (Intrinsics.areEqual((Object)string2, (Object)"tsv")) {
            string = "readTsv";
        } else {
            throw new IllegalStateException(("Unexpected file extension: " + context.getFileExtension()).toString());
        }
        String methodName = string;
        return "DataFrame." + methodName + "(\"" + dataFilePath + "\"" + (String)separatorArg + ")";
    }
}

