/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.highlighting.components.document.transformers;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.HighlightingComponent;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.document.topic.DocumentCellsStructureChangedListener;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.document.transformers.RawInputEventTransformer;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.queue.HighlightingEvent;
import com.intellij.kotlin.jupyter.core.util.NotebookChangeEventType;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBus;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\f\u0010\u000b\u001a\u00020\f*\u00020\u0002H\u0002J\f\u0010\r\u001a\u00020\u000e*\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/document/transformers/DocumentChangeEventsTransformer;", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/document/transformers/RawInputEventTransformer;", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/HighlightingComponent;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "transformRawInput", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/queue/HighlightingEvent;", "rawEvent", "identifyEventChangeType", "Lcom/intellij/kotlin/jupyter/core/util/NotebookChangeEventType;", "isNotebookStructureChanged", "", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nDocumentChangeEventsTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentChangeEventsTransformer.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/components/document/transformers/DocumentChangeEventsTransformer\n+ 2 sync.kt\ncom/intellij/kotlin/jupyter/core/util/SyncKt\n*L\n1#1,80:1\n15#2,3:81\n*S KotlinDebug\n*F\n+ 1 DocumentChangeEventsTransformer.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/components/document/transformers/DocumentChangeEventsTransformer\n*L\n32#1:81,3\n*E\n"})
public final class DocumentChangeEventsTransformer
extends HighlightingComponent
implements RawInputEventTransformer<DocumentEvent> {
    @NotNull
    private final Editor editor;

    public DocumentChangeEventsTransformer(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
    }

    @Override
    @Nullable
    public HighlightingEvent transformRawInput(@NotNull DocumentEvent rawEvent) {
        Set changedCells;
        int affectedCellIndex;
        block5: {
            DocumentCellsStructureChangedListener documentCellsStructureChangedListener;
            MessageBus messageBus;
            Project project;
            Object backedDocumentFile;
            Object object;
            Intrinsics.checkNotNullParameter((Object)rawEvent, (String)"rawEvent");
            VirtualFile eventVirtualFile = FileDocumentManager.getInstance().getFile(rawEvent.getDocument());
            if (eventVirtualFile == null) {
                return null;
            }
            BackedNotebookVirtualFile backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.takeBackend(eventVirtualFile);
            boolean $i$f$withReadAccess = false;
            if (ApplicationManager.getApplication().isDispatchThread() || ApplicationManager.getApplication().isReadAccessAllowed()) {
                boolean bl = false;
                object = FileDocumentManager.getInstance().getDocument(backedNotebookVirtualFile.getFile());
            } else {
                object = ReadAction.compute((ThrowableComputable)new ThrowableComputable(backedNotebookVirtualFile){
                    final /* synthetic */ BackedNotebookVirtualFile $backedNotebookVirtualFile$inlined;
                    {
                        this.$backedNotebookVirtualFile$inlined = backedNotebookVirtualFile;
                    }

                    public final T compute() {
                        boolean bl = false;
                        return (T)FileDocumentManager.getInstance().getDocument(this.$backedNotebookVirtualFile$inlined.getFile());
                    }
                });
            }
            if ((backedDocumentFile = object) == null) {
                return null;
            }
            NotebookChangeEventType eventType = this.identifyEventChangeType(rawEvent);
            boolean notebookStructureChanged = this.isNotebookStructureChanged(eventType);
            int documentChangedLineIndex = backedDocumentFile.getLineNumber(RangesKt.coerceAtMost((int)(notebookStructureChanged ? rawEvent.getOffset() + 1 : rawEvent.getOffset()), (int)rawEvent.getDocument().getTextLength()));
            affectedCellIndex = NotebookVisualizationUiUtilKt.getCell((Editor)this.editor, (int)Math.min(documentChangedLineIndex, this.editor.getDocument().getLineCount() - 1)).getOrdinal();
            if (documentChangedLineIndex > backedDocumentFile.getLineCount() - 1) {
                return null;
            }
            changedCells = SetsKt.setOf((Object)affectedCellIndex);
            if (!notebookStructureChanged || (project = this.editor.getProject()) == null || (messageBus = project.getMessageBus()) == null || (documentCellsStructureChangedListener = (DocumentCellsStructureChangedListener)messageBus.syncPublisher(DocumentCellsStructureChangedListener.TOPIC)) == null) break block5;
            documentCellsStructureChangedListener.cellsChanged(this.editor, affectedCellIndex);
        }
        return new HighlightingEvent(affectedCellIndex, null, changedCells, false);
    }

    private final NotebookChangeEventType identifyEventChangeType(DocumentEvent $this$identifyEventChangeType) {
        DocumentEvent event = $this$identifyEventChangeType;
        CharSequence charSequence = event.getOldFragment();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getOldFragment(...)");
        CharSequence oldFragment = charSequence;
        CharSequence charSequence2 = event.getNewFragment();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getNewFragment(...)");
        CharSequence newFragment = charSequence2;
        boolean isNewEmpty = newFragment.length() == 0;
        boolean isOldEmpty = oldFragment.length() == 0;
        return !(!StringsKt.endsWith$default((CharSequence)oldFragment, (CharSequence)" md", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((CharSequence)newFragment, (CharSequence)" md", (boolean)false, (int)2, null) || !isNewEmpty && !isOldEmpty) ? NotebookChangeEventType.MARKDOWN_CONVERSION : (StringsKt.contains$default((CharSequence)newFragment, (CharSequence)"#%%", (boolean)false, (int)2, null) && isOldEmpty ? NotebookChangeEventType.CELL_ADD : (StringsKt.contains$default((CharSequence)oldFragment, (CharSequence)"#%%", (boolean)false, (int)2, null) && isNewEmpty ? NotebookChangeEventType.CELL_DELETE : NotebookChangeEventType.REGULAR));
    }

    private final boolean isNotebookStructureChanged(NotebookChangeEventType $this$isNotebookStructureChanged) {
        return $this$isNotebookStructureChanged == NotebookChangeEventType.CELL_ADD || $this$isNotebookStructureChanged == NotebookChangeEventType.CELL_DELETE;
    }
}

