/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.jupyter.kernel.server.embedded;

import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.DefaultSystemPropertiesKt;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.embedded.EmbeddedKernelClassLoaderHolder;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.embedded.EmbeddedKotlinKernelLoggerFactory;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.embedded.EmbeddedMessageHandler;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.embedded.IdeReplComponentsProvider;
import com.intellij.kotlin.jupyter.core.util.PropertiesKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.embedded.InMemoryReplResultsHolder;
import org.jetbrains.kotlinx.jupyter.execution.JupyterExecutor;
import org.jetbrains.kotlinx.jupyter.execution.JupyterExecutorImpl;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterCommunicationFacility;
import org.jetbrains.kotlinx.jupyter.messaging.JupyterCommunicationFacilityImpl;
import org.jetbrains.kotlinx.jupyter.messaging.MessageFactoryProvider;
import org.jetbrains.kotlinx.jupyter.messaging.MessageFactoryProviderImpl;
import org.jetbrains.kotlinx.jupyter.messaging.MessageHandler;
import org.jetbrains.kotlinx.jupyter.messaging.comms.CommManagerImpl;
import org.jetbrains.kotlinx.jupyter.messaging.comms.CommManagerInternal;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterServerSockets;
import org.jetbrains.kotlinx.jupyter.repl.ReplForJupyter;
import org.jetbrains.kotlinx.jupyter.repl.config.DefaultReplSettings;
import org.jetbrains.kotlinx.jupyter.repl.creating.ProvidersKt;
import org.jetbrains.kotlinx.jupyter.repl.creating.ReplComponentsProvider;
import org.jetbrains.kotlinx.jupyter.repl.creating.ReplFactory;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\u001a6\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u001a\b\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u001c\u0010\u0014\u001a\u00020\u00132\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u0016H\u0002\u00a8\u0006\u0017"}, d2={"createEmbeddedMessageHandler", "Lorg/jetbrains/kotlinx/jupyter/messaging/MessageHandler;", "project", "Lcom/intellij/openapi/project/Project;", "replSettings", "Lorg/jetbrains/kotlinx/jupyter/repl/config/DefaultReplSettings;", "loggerFactory", "Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/embedded/EmbeddedKotlinKernelLoggerFactory;", "socketManager", "Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterServerSockets;", "inMemoryHolder", "Lorg/jetbrains/kotlinx/jupyter/api/embedded/InMemoryReplResultsHolder;", "kernelVersion", "", "getReplFactory", "Lorg/jetbrains/kotlinx/jupyter/repl/creating/ReplFactory;", "replComponentsProvider", "Lorg/jetbrains/kotlinx/jupyter/repl/creating/ReplComponentsProvider;", "updateHomePathProperty", "", "ensureSystemPropertiesSet", "systemProperties", "", "intellij.kotlin.jupyter.core"})
public final class MessageHanderFactoryKt {
    @NotNull
    public static final MessageHandler createEmbeddedMessageHandler(@NotNull Project project, @NotNull DefaultReplSettings replSettings, @NotNull EmbeddedKotlinKernelLoggerFactory loggerFactory, @NotNull JupyterServerSockets socketManager, @NotNull InMemoryReplResultsHolder inMemoryHolder, @NotNull String kernelVersion2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)replSettings, (String)"replSettings");
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        Intrinsics.checkNotNullParameter((Object)socketManager, (String)"socketManager");
        Intrinsics.checkNotNullParameter((Object)inMemoryHolder, (String)"inMemoryHolder");
        Intrinsics.checkNotNullParameter((Object)kernelVersion2, (String)"kernelVersion");
        MessageFactoryProvider messageFactoryProvider = new MessageFactoryProviderImpl();
        JupyterCommunicationFacility communicationFacility = new JupyterCommunicationFacilityImpl(socketManager, messageFactoryProvider);
        JupyterExecutor executor = new JupyterExecutorImpl(loggerFactory);
        CommManagerInternal commManager = new CommManagerImpl(communicationFacility);
        IdeReplComponentsProvider replComponentsProvider = new IdeReplComponentsProvider(replSettings, communicationFacility, commManager, inMemoryHolder, loggerFactory);
        ReplFactory replFactory = MessageHanderFactoryKt.getReplFactory(project, kernelVersion2, replComponentsProvider);
        ReplForJupyter repl = replFactory.createRepl();
        return new EmbeddedMessageHandler(repl, loggerFactory, commManager, messageFactoryProvider, socketManager, executor);
    }

    @RequiresBackgroundThread
    @NotNull
    public static final ReplFactory getReplFactory(@NotNull Project project, @NotNull String kernelVersion2, @NotNull ReplComponentsProvider replComponentsProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)kernelVersion2, (String)"kernelVersion");
        Intrinsics.checkNotNullParameter((Object)replComponentsProvider, (String)"replComponentsProvider");
        ThreadingAssertions.assertBackgroundThread();
        MessageHanderFactoryKt.updateHomePathProperty();
        MessageHanderFactoryKt.ensureSystemPropertiesSet(DefaultSystemPropertiesKt.getDefaultSystemProperties());
        ClassLoader classLoader = EmbeddedKernelClassLoaderHolder.Companion.getInstance(project).getClassLoader(kernelVersion2);
        return ProvidersKt.loadDefaultReplFactory(replComponentsProvider, classLoader);
    }

    private static final void updateHomePathProperty() {
        PropertiesKt.getOrSetSystemProperty("idea.home.path", (Function0<String>)((Function0)MessageHanderFactoryKt::updateHomePathProperty$lambda$0));
    }

    private static final void ensureSystemPropertiesSet(Map<String, String> systemProperties) {
        for (Map.Entry<String, String> entry : systemProperties.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            PropertiesKt.getOrSetSystemProperty(key, (Function0<String>)((Function0)() -> MessageHanderFactoryKt.ensureSystemPropertiesSet$lambda$0(value)));
        }
    }

    private static final String updateHomePathProperty$lambda$0() {
        Path path2 = PathManager.getHomeDir((boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getHomeDir(...)");
        return ((Object)path2).toString();
    }

    private static final String ensureSystemPropertiesSet$lambda$0(String $value) {
        return $value;
    }
}

