/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.scriptingSupport;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.common.CommandsUtilKt;
import org.jetbrains.kotlinx.jupyter.compiler.util.CodeInterval;
import org.jetbrains.kotlinx.jupyter.magics.AbstractMagicsProcessor;
import org.jetbrains.kotlinx.jupyter.magics.MagicsProcessor;
import org.jetbrains.kotlinx.jupyter.magics.NoopMagicsHandler;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterSource;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\fJ$\u0010\r\u001a\u00020\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/kotlin/jupyter/core/scriptingSupport/KotlinCodeRangesProcessor;", "", "<init>", "()V", "magicsProcessor", "Lorg/jetbrains/kotlinx/jupyter/magics/MagicsProcessor;", "getCellCode", "", "cell", "Lcom/intellij/psi/PsiElement;", "codeRanges", "Lcom/intellij/kotlin/jupyter/core/scriptingSupport/KotlinCodeRangesProcessor$CodeRangesResult;", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;", "insertEmptyCodeRange", "", "", "Lcom/intellij/openapi/util/TextRange;", "magicRanges", "", "CodeRangesResult", "CellRanges", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nKotlinCodeRangesProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCodeRangesProcessor.kt\ncom/intellij/kotlin/jupyter/core/scriptingSupport/KotlinCodeRangesProcessor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,81:1\n1163#2,3:82\n*S KotlinDebug\n*F\n+ 1 KotlinCodeRangesProcessor.kt\ncom/intellij/kotlin/jupyter/core/scriptingSupport/KotlinCodeRangesProcessor\n*L\n42#1:82,3\n*E\n"})
public final class KotlinCodeRangesProcessor {
    @NotNull
    public static final KotlinCodeRangesProcessor INSTANCE = new KotlinCodeRangesProcessor();
    @NotNull
    private static final MagicsProcessor magicsProcessor = new MagicsProcessor(NoopMagicsHandler.INSTANCE, true);

    private KotlinCodeRangesProcessor() {
    }

    private final String getCellCode(PsiElement cell) {
        JupyterSource sourceElement;
        JupyterSource jupyterSource = sourceElement = (JupyterSource)PsiTreeUtil.getChildOfType((PsiElement)cell, JupyterSource.class);
        String string = jupyterSource != null ? jupyterSource.getText() : null;
        if (string == null) {
            string = "";
        }
        String source = string;
        return ((Object)StringsKt.trimStart((CharSequence)source)).toString();
    }

    @NotNull
    public final CodeRangesResult codeRanges(@NotNull JupyterPsiCell cell) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        String code = this.getCellCode((PsiElement)cell);
        if (CommandsUtilKt.looksLikeReplCommand(code)) {
            return new CodeRangesResult(new CellRanges(CollectionsKt.emptyList(), CollectionsKt.listOf((Object)new TextRange(0, cell.getTextLength()))), true);
        }
        String text = cell.getText();
        Intrinsics.checkNotNull((Object)text);
        Sequence<CodeInterval> magicIntervals = magicsProcessor.magicsIntervals(text);
        List<TextRange> codeRanges = KotlinCodeRangesProcessor.codeRanges$toRanges((Sequence<CodeInterval>)AbstractMagicsProcessor.codeIntervals$default(magicsProcessor, text, magicIntervals, false, 4, null));
        List<TextRange> magicRanges = KotlinCodeRangesProcessor.codeRanges$toRanges(magicIntervals);
        this.insertEmptyCodeRange(codeRanges, magicRanges);
        return new CodeRangesResult(new CellRanges(codeRanges, magicRanges), false);
    }

    private final void insertEmptyCodeRange(List<TextRange> codeRanges, List<? extends TextRange> magicRanges) {
        TextRange lastCodeRange = (TextRange)CollectionsKt.lastOrNull(codeRanges);
        TextRange lastMagicRange = (TextRange)CollectionsKt.lastOrNull(magicRanges);
        int startOffset = -1;
        if (lastCodeRange == null) {
            TextRange textRange = lastMagicRange;
            startOffset = textRange != null ? textRange.getEndOffset() : 0;
        } else if (lastMagicRange != null && lastCodeRange.getStartOffset() < lastMagicRange.getStartOffset()) {
            startOffset = lastMagicRange.getEndOffset();
        }
        if (startOffset != -1) {
            codeRanges.add(new TextRange(startOffset, startOffset));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<TextRange> codeRanges$toRanges(Sequence<CodeInterval> $this$codeRanges_u24toRanges) {
        void var2_2;
        void $this$mapTo$iv;
        Sequence<CodeInterval> sequence = $this$codeRanges_u24toRanges;
        Collection destination$iv = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            CodeInterval codeInterval = (CodeInterval)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(new TextRange(it.getFrom(), it.getTo()));
        }
        return (List)var2_2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J)\u0010\r\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/intellij/kotlin/jupyter/core/scriptingSupport/KotlinCodeRangesProcessor$CellRanges;", "", "codeRanges", "", "Lcom/intellij/openapi/util/TextRange;", "magicRanges", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "getCodeRanges", "()Ljava/util/List;", "getMagicRanges", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.kotlin.jupyter.core"})
    public static final class CellRanges {
        @NotNull
        private final List<TextRange> codeRanges;
        @NotNull
        private final List<TextRange> magicRanges;

        public CellRanges(@NotNull List<? extends TextRange> codeRanges, @NotNull List<? extends TextRange> magicRanges) {
            Intrinsics.checkNotNullParameter(codeRanges, (String)"codeRanges");
            Intrinsics.checkNotNullParameter(magicRanges, (String)"magicRanges");
            this.codeRanges = codeRanges;
            this.magicRanges = magicRanges;
        }

        @NotNull
        public final List<TextRange> getCodeRanges() {
            return this.codeRanges;
        }

        @NotNull
        public final List<TextRange> getMagicRanges() {
            return this.magicRanges;
        }

        @NotNull
        public final List<TextRange> component1() {
            return this.codeRanges;
        }

        @NotNull
        public final List<TextRange> component2() {
            return this.magicRanges;
        }

        @NotNull
        public final CellRanges copy(@NotNull List<? extends TextRange> codeRanges, @NotNull List<? extends TextRange> magicRanges) {
            Intrinsics.checkNotNullParameter(codeRanges, (String)"codeRanges");
            Intrinsics.checkNotNullParameter(magicRanges, (String)"magicRanges");
            return new CellRanges(codeRanges, magicRanges);
        }

        public static /* synthetic */ CellRanges copy$default(CellRanges cellRanges, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list = cellRanges.codeRanges;
            }
            if ((n & 2) != 0) {
                list2 = cellRanges.magicRanges;
            }
            return cellRanges.copy(list, list2);
        }

        @NotNull
        public String toString() {
            return "CellRanges(codeRanges=" + this.codeRanges + ", magicRanges=" + this.magicRanges + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.codeRanges).hashCode();
            result2 = result2 * 31 + ((Object)this.magicRanges).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CellRanges)) {
                return false;
            }
            CellRanges cellRanges = (CellRanges)other;
            if (!Intrinsics.areEqual(this.codeRanges, cellRanges.codeRanges)) {
                return false;
            }
            return Intrinsics.areEqual(this.magicRanges, cellRanges.magicRanges);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/kotlin/jupyter/core/scriptingSupport/KotlinCodeRangesProcessor$CodeRangesResult;", "", "ranges", "Lcom/intellij/kotlin/jupyter/core/scriptingSupport/KotlinCodeRangesProcessor$CellRanges;", "isCommand", "", "<init>", "(Lcom/intellij/kotlin/jupyter/core/scriptingSupport/KotlinCodeRangesProcessor$CellRanges;Z)V", "getRanges", "()Lcom/intellij/kotlin/jupyter/core/scriptingSupport/KotlinCodeRangesProcessor$CellRanges;", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.kotlin.jupyter.core"})
    public static final class CodeRangesResult {
        @NotNull
        private final CellRanges ranges;
        private final boolean isCommand;

        public CodeRangesResult(@NotNull CellRanges ranges, boolean isCommand) {
            Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
            this.ranges = ranges;
            this.isCommand = isCommand;
        }

        @NotNull
        public final CellRanges getRanges() {
            return this.ranges;
        }

        public final boolean isCommand() {
            return this.isCommand;
        }

        @NotNull
        public final CellRanges component1() {
            return this.ranges;
        }

        public final boolean component2() {
            return this.isCommand;
        }

        @NotNull
        public final CodeRangesResult copy(@NotNull CellRanges ranges, boolean isCommand) {
            Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
            return new CodeRangesResult(ranges, isCommand);
        }

        public static /* synthetic */ CodeRangesResult copy$default(CodeRangesResult codeRangesResult, CellRanges cellRanges, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                cellRanges = codeRangesResult.ranges;
            }
            if ((n & 2) != 0) {
                bl = codeRangesResult.isCommand;
            }
            return codeRangesResult.copy(cellRanges, bl);
        }

        @NotNull
        public String toString() {
            return "CodeRangesResult(ranges=" + this.ranges + ", isCommand=" + this.isCommand + ")";
        }

        public int hashCode() {
            int result2 = this.ranges.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isCommand);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CodeRangesResult)) {
                return false;
            }
            CodeRangesResult codeRangesResult = (CodeRangesResult)other;
            if (!Intrinsics.areEqual((Object)this.ranges, (Object)codeRangesResult.ranges)) {
                return false;
            }
            return this.isCommand == codeRangesResult.isCommand;
        }
    }
}

