/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.javaee.web.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.jsp.javaee.web.formatter.JspTagBlock;
import com.intellij.jsp.javaee.web.formatter.JspTextBlock;
import com.intellij.jsp.lang.jsp.NewJspLanguage;
import com.intellij.jsp.lang.jspx.JspxLanguageImpl;
import com.intellij.jsp.psi.BaseJspElementType;
import com.intellij.jsp.psi.JspTokenType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.jsp.jspXml.JspDeclaration;
import com.intellij.psi.impl.source.jsp.jspXml.JspScriptlet;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTokenType;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspBlock
extends XmlBlock {
    @NonNls
    public static final String JSPX_DECLARATION_TAG_NAME = "jsp:declaration";
    @NonNls
    public static final String JSPX_SCRIPTLET_TAG_NAME = "jsp:scriptlet";
    @NonNls
    protected static final String JSP_TAG_PREFIX = "jsp:";

    public JspBlock(ASTNode node, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy, Indent indent, TextRange textRange) {
        super(node, wrap, alignment, policy, indent, textRange);
    }

    @NotNull
    protected XmlBlock createSimpleChild(@NotNull ASTNode child, @Nullable Indent indent, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable TextRange range) {
        if (child == null) {
            JspBlock.$$$reportNull$$$0(0);
        }
        return new JspBlock(child, wrap, alignment, this.myXmlFormattingPolicy, indent, range);
    }

    protected XmlTagBlock createTagBlock(@NotNull ASTNode child, Indent indent, Wrap wrap, Alignment alignment) {
        if (child == null) {
            JspBlock.$$$reportNull$$$0(1);
        }
        return new JspTagBlock(child, wrap, alignment, this.myXmlFormattingPolicy, indent != null ? indent : Indent.getNoneIndent());
    }

    protected Indent getChildDefaultIndent() {
        if (this.myNode.getElementType() == BaseJspElementType.JSP_SCRIPTLET) {
            return Indent.getNoneIndent();
        }
        if (this.myNode.getElementType() == BaseJspElementType.JSP_DECLARATION) {
            return Indent.getNoneIndent();
        }
        if (this.myNode.getElementType() == BaseJspElementType.JSP_EXPRESSION) {
            return Indent.getNoneIndent();
        }
        return super.getChildDefaultIndent();
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        if (this.myNode.getElementType() == BaseJspElementType.JSP_DECLARATION || this.myNode.getElementType() == BaseJspElementType.JSP_SCRIPTLET) {
            Object e;
            List subBlocks = this.getSubBlocks();
            if (subBlocks.size() == 3 && (e = subBlocks.get(1)) instanceof JspTextBlock) {
                JspTextBlock jspTextBlock = (JspTextBlock)((Object)e);
                if (newChildIndex == 2 && jspTextBlock.isTailIncomplete()) {
                    ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_PREV_CHILD;
                    if (childAttributes == null) {
                        JspBlock.$$$reportNull$$$0(2);
                    }
                    return childAttributes;
                }
                if (newChildIndex == 1 && jspTextBlock.isHeadIncomplete()) {
                    ChildAttributes childAttributes = ChildAttributes.DELEGATE_TO_NEXT_CHILD;
                    if (childAttributes == null) {
                        JspBlock.$$$reportNull$$$0(3);
                    }
                    return childAttributes;
                }
            }
            return new ChildAttributes(Indent.getNormalIndent(), null);
        }
        ChildAttributes childAttributes = super.getChildAttributes(newChildIndex);
        if (childAttributes == null) {
            JspBlock.$$$reportNull$$$0(4);
        }
        return childAttributes;
    }

    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            JspBlock.$$$reportNull$$$0(5);
        }
        if (!(child1 instanceof AbstractBlock) || !(child2 instanceof AbstractBlock)) {
            return null;
        }
        ASTNode node1 = ((AbstractBlock)child1).getNode();
        IElementType type1 = node1.getElementType();
        ASTNode node2 = ((AbstractBlock)child2).getNode();
        IElementType type2 = node2.getElementType();
        if (type1 == JspTokenType.JSP_DECLARATION_START || type1 == JspTokenType.JSP_SCRIPTLET_START) {
            return Spacing.createDependentLFSpacing((int)0, (int)1, (TextRange)node2.getTextRange(), (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        if (type2 == JspTokenType.JSP_DECLARATION_END || type2 == JspTokenType.JSP_SCRIPTLET_END) {
            return Spacing.createDependentLFSpacing((int)0, (int)1, (TextRange)node1.getTextRange(), (boolean)this.myXmlFormattingPolicy.getShouldKeepLineBreaks(), (int)this.myXmlFormattingPolicy.getKeepBlankLines());
        }
        return super.getSpacing(child1, child2);
    }

    protected boolean isJspxJavaContainingNode(ASTNode child) {
        if (child.getElementType() != XmlElementType.XML_TEXT) {
            return false;
        }
        ASTNode treeParent = child.getTreeParent();
        if (treeParent == null) {
            return false;
        }
        if (treeParent.getElementType() != XmlElementType.XML_TAG) {
            return false;
        }
        PsiElement psiElement = SourceTreeToPsiMap.treeElementToPsi((ASTNode)treeParent);
        String name = ((XmlTag)psiElement).getName();
        if (!Objects.equals(name, JSPX_SCRIPTLET_TAG_NAME) && !Objects.equals(name, JSPX_DECLARATION_TAG_NAME)) {
            return false;
        }
        if (child.getText().trim().isEmpty()) {
            return false;
        }
        return JspTextBlock.findPsiRootAt(child, this.myXmlFormattingPolicy.processJavaTree()) != null;
    }

    protected boolean canWrapTagEnd(XmlTag tag) {
        return super.canWrapTagEnd(tag) || StringUtil.startsWithIgnoreCase((String)tag.getName(), (String)JSP_TAG_PREFIX);
    }

    protected XmlTag findXmlTagAt(ASTNode child, int startOffset) {
        return JspTextBlock.findJspTag(child, startOffset);
    }

    protected XmlTag getAnotherTreeTag(ASTNode child) {
        boolean b = !(!this.myXmlFormattingPolicy.processJsp() || JspPsiUtil.getJspFile((PsiElement)this.myNode.getPsi()) == null || !this.isXmlTag(this.myNode) && this.myNode.getElementType() != XmlElementType.HTML_DOCUMENT && !(this.myNode.getPsi() instanceof PsiFile) || child.getElementType() != XmlTokenType.XML_DATA_CHARACTERS && child.getElementType() != BaseJspElementType.JSP_XML_TEXT && !(child.getPsi() instanceof OuterLanguageElement));
        return b ? this.findXmlTagAt(child, child.getStartOffset()) : null;
    }

    protected ASTNode createAnotherTreeNode(List<? super Block> result, ASTNode child, PsiElement tag, Indent indent, Wrap wrap, Alignment alignment) {
        TextRange childRange;
        Indent childIndent = indent;
        if (this.myNode.getElementType() == XmlElementType.HTML_DOCUMENT && tag.getParent() instanceof XmlTag && this.myXmlFormattingPolicy.indentChildrenOf((XmlTag)tag.getParent())) {
            childIndent = Indent.getNormalIndent();
        }
        result.add((Block)this.createAnotherTreeTagBlock(tag, childIndent));
        TextRange tagRange = tag.getTextRange();
        ASTNode currentChild = JspBlock.findChildAfter((ASTNode)child, (int)tagRange.getEndOffset());
        TextRange textRange = childRange = currentChild != null ? currentChild.getTextRange() : null;
        while (currentChild != null && childRange.getEndOffset() > tagRange.getEndOffset()) {
            XmlTag psiElement = this.findXmlTagAt(currentChild, tagRange.getEndOffset());
            if (psiElement != null) {
                if (psiElement.getTextRange().getStartOffset() >= childRange.getStartOffset() && this.containsTag((PsiElement)psiElement) && this.doesNotIntersectSubTagsWith((PsiElement)psiElement)) {
                    result.add((Block)this.createAnotherTreeTagBlock((PsiElement)psiElement, childIndent));
                    currentChild = JspBlock.findChildAfter((ASTNode)currentChild, (int)psiElement.getTextRange().getEndOffset());
                    childRange = currentChild != null ? currentChild.getTextRange() : null;
                    tagRange = psiElement.getTextRange();
                    continue;
                }
                result.add((Block)new JspBlock(currentChild, wrap, alignment, this.myXmlFormattingPolicy, indent, new TextRange(tagRange.getEndOffset(), childRange.getEndOffset())));
                return currentChild;
            }
            result.add((Block)new JspBlock(currentChild, wrap, alignment, this.myXmlFormattingPolicy, indent, new TextRange(tagRange.getEndOffset(), childRange.getEndOffset())));
            return currentChild;
        }
        return currentChild;
    }

    protected Block createAnotherTreeTagBlock(PsiElement tag, Indent childIndent) {
        if (this.isXmlTag(tag)) {
            return new JspTagBlock(tag.getNode(), null, null, this.createPolicyFor(), childIndent);
        }
        return new JspBlock(tag.getNode(), null, null, this.createPolicyFor(), childIndent, tag.getTextRange());
    }

    protected boolean useMyFormatter(@NotNull Language myLanguage, @NotNull Language childLanguage, @NotNull PsiElement childPsi) {
        if (myLanguage == null) {
            JspBlock.$$$reportNull$$$0(6);
        }
        if (childLanguage == null) {
            JspBlock.$$$reportNull$$$0(7);
        }
        if (childPsi == null) {
            JspBlock.$$$reportNull$$$0(8);
        }
        return myLanguage == childLanguage || childLanguage == JavaLanguage.INSTANCE || childLanguage == HTMLLanguage.INSTANCE || childLanguage == XHTMLLanguage.INSTANCE || childLanguage == XMLLanguage.INSTANCE || childLanguage == NewJspLanguage.getInstance() || childLanguage == JspxLanguageImpl.INSTANCE || LanguageFormatting.INSTANCE.forContext(childPsi) == null;
    }

    protected void processSimpleChild(@NotNull ASTNode child, Indent indent, @NotNull List<? super Block> result, Wrap wrap, Alignment alignment) {
        Pair<PsiElement, Language> root;
        if (child == null) {
            JspBlock.$$$reportNull$$$0(9);
        }
        if (result == null) {
            JspBlock.$$$reportNull$$$0(10);
        }
        if (this.myXmlFormattingPolicy.processJsp() && (child.getElementType() == BaseJspElementType.JSP_XML_TEXT || child.getPsi() instanceof OuterLanguageElement) && (root = JspTextBlock.findPsiRootAt(child, this.myXmlFormattingPolicy.processJavaTree())) != null) {
            this.createJspTextNode(result, child, indent);
            return;
        }
        super.processSimpleChild(child, indent, result, wrap, alignment);
    }

    protected void createJspTextNode(List<? super Block> localResult, ASTNode child, Indent indent) {
        localResult.add((Block)new JspTextBlock(child, this.myXmlFormattingPolicy, JspTextBlock.findPsiRootAt(child, this.myXmlFormattingPolicy.processJavaTree()), indent));
    }

    protected boolean isXmlTag(PsiElement psi) {
        return psi instanceof XmlTag && !(psi instanceof JspScriptlet) && !(psi instanceof JspDeclaration);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsp/javaee/web/formatter/JspBlock";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myLanguage";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childLanguage";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childPsi";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsp/javaee/web/formatter/JspBlock";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleChild";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createTagBlock";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "useMyFormatter";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processSimpleChild";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

