/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.structuralsearch;

import com.intellij.jsp.psi.impl.jspXml.JspOuterLanguageElement;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.structuralsearch.SpecialElementExtractor;
import com.intellij.util.SmartList;
import org.jetbrains.annotations.NotNull;

public final class JspXmlTagExtractor
implements SpecialElementExtractor {
    public XmlTag[] extractSpecialElements(@NotNull PsiElement element) {
        if (element == null) {
            JspXmlTagExtractor.$$$reportNull$$$0(0);
        }
        if (!(element instanceof JspOuterLanguageElement)) {
            return XmlTag.EMPTY;
        }
        TextRange textRange = element.getTextRange();
        FileViewProvider viewProvider = element.getContainingFile().getViewProvider();
        PsiFile jspFile = viewProvider.getPsi(viewProvider.getBaseLanguage());
        assert (jspFile != null);
        SmartList tags = new SmartList();
        PsiElement tag = PsiTreeUtil.getParentOfType((PsiElement)jspFile.findElementAt(textRange.getStartOffset()), XmlElement.class, (boolean)true, (Class[])new Class[]{XmlDocument.class});
        while (tag instanceof XmlElement && textRange.contains(tag.getTextRange())) {
            if (tag instanceof XmlTag) {
                tags.add((XmlTag)tag);
            }
            tag = tag.getNextSibling();
        }
        return tags.toArray(XmlTag.EMPTY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsp/structuralsearch/JspXmlTagExtractor", "extractSpecialElements"));
    }
}

