/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.javascript.debugger.JSDebugUtilsKt;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.scripts.RootsDirectoryInfo;
import com.intellij.javascript.debugger.scripts.ScriptDirectoryInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.wip.ScriptUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010\u001c\u001a\u00020\u000eJ\u0006\u0010\u001d\u001a\u00020\u000eJ\b\u0010\u001e\u001a\u00020\u000eH\u0002R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/intellij/javascript/debugger/scripts/SourceTabManager;", "", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "<init>", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;)V", "getDebugProcess", "()Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "root", "Lcom/intellij/javascript/debugger/scripts/ScriptDirectoryInfo;", "getRoot", "()Lcom/intellij/javascript/debugger/scripts/ScriptDirectoryInfo;", "_updateScriptsFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "updateScriptsFlow", "Lkotlinx/coroutines/flow/SharedFlow;", "getUpdateScriptsFlow", "()Lkotlinx/coroutines/flow/SharedFlow;", "addScript", "script", "Lorg/jetbrains/debugger/Script;", "doAddScript", "url", "Lcom/intellij/util/Url;", "suggestRootNode", "removeScript", "doRemoveScript", "updateScripts", "clear", "emitUpdateEvent", "intellij.javascript.debugger.backend"})
public final class SourceTabManager {
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;
    @NotNull
    private final ScriptDirectoryInfo root;
    @NotNull
    private final MutableSharedFlow<Unit> _updateScriptsFlow;
    @NotNull
    private final SharedFlow<Unit> updateScriptsFlow;

    public SourceTabManager(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        this.debugProcess = debugProcess;
        this.root = new ScriptDirectoryInfo("<root>", Urls.newUnparsable((String)""), null, 4, null);
        this._updateScriptsFlow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        this.updateScriptsFlow = FlowKt.asSharedFlow(this._updateScriptsFlow);
    }

    @NotNull
    public final JavaScriptDebugProcess<?> getDebugProcess() {
        return this.debugProcess;
    }

    @NotNull
    public final ScriptDirectoryInfo getRoot() {
        return this.root;
    }

    @NotNull
    public final SharedFlow<Unit> getUpdateScriptsFlow() {
        return this.updateScriptsFlow;
    }

    public final void addScript(@NotNull Script script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        if (!ApplicationManager.getApplication().isInternal() && ScriptUtilsKt.isInternalScriptUrl((Url)script.getUrl())) {
            return;
        }
        if (script.getSourceMap() == null) {
            this.doAddScript(script, script.getUrl());
        } else {
            SourceMap sourceMap = script.getSourceMap();
            Intrinsics.checkNotNull((Object)sourceMap);
            for (Url source : sourceMap.getSources()) {
                this.doAddScript(script, source);
            }
        }
        this.emitUpdateEvent();
    }

    private final void doAddScript(Script script, Url url) {
        this.suggestRootNode(script, url).addChild(script, url);
    }

    private final ScriptDirectoryInfo suggestRootNode(Script script, Url url) {
        ScriptDirectoryInfo child;
        String rootName = null;
        Icon icon = PlatformIcons.FOLDER_ICON;
        int weight = 5;
        if (url.getScheme() == null && !url.isInLocalFileSystem()) {
            String string = JSDebuggerBundle.message("js.scripts.nodes.root.no", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            rootName = string;
        } else if (Intrinsics.areEqual((Object)"vm", (Object)url.getScheme())) {
            String string = JSDebuggerBundle.message("js.scripts.nodes.root.evaluated", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            rootName = string;
            --weight;
        } else if (!JavaScriptDebugProcessKt.hasWebpackScheme(url) && ScriptUtilsKt.isSpecialUrl((Url)url)) {
            String string = JSDebuggerBundle.message("js.scripts.nodes.root.lib", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            rootName = string;
            icon = PlatformIcons.LIBRARY_ICON;
            ++weight;
        } else {
            return this.root;
        }
        Object object = this.root.getChildNameToInfo().get(rootName);
        ScriptDirectoryInfo scriptDirectoryInfo = child = object instanceof ScriptDirectoryInfo ? (ScriptDirectoryInfo)object : null;
        if (child == null) {
            Url url2 = Urls.newUnparsable((String)rootName);
            object = icon;
            Intrinsics.checkNotNull((Object)object);
            child = new RootsDirectoryInfo(rootName, url2, (Icon)object, this.debugProcess, weight);
            this.root.getChildNameToInfo().put(rootName, child);
        }
        return child;
    }

    public final void removeScript(@NotNull Script script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        if (JSDebugUtilsKt.isEvaluatedOneLineScript(script)) {
            return;
        }
        SourceMap sourceMap = script.getSourceMap();
        if (sourceMap != null) {
            SourceMap it = sourceMap;
            boolean bl = false;
            for (Url source : it.getSources()) {
                this.doRemoveScript(script, source);
            }
        }
        this.doRemoveScript(script, script.getUrl());
        this.emitUpdateEvent();
    }

    private final void doRemoveScript(Script script, Url url) {
        ScriptDirectoryInfo directory = this.suggestRootNode(script, url);
        directory.removeChild(url);
        if (directory != this.root && !directory.hasChildren()) {
            this.root.getChildNameToInfo().remove(directory.getName());
        }
    }

    public final void updateScripts() {
        this.emitUpdateEvent();
    }

    public final void clear() {
        this.root.getChildNameToInfo().clear();
        this.emitUpdateEvent();
    }

    private final void emitUpdateEvent() {
        if (!this._updateScriptsFlow.tryEmit((Object)Unit.INSTANCE)) {
            throw new IllegalStateException("Check failed.");
        }
    }
}

