/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.actions;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.actions.DiagramNodeIntentionAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.services.GraphCanvasLocationService;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBList;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.ui.JBUI;
import java.util.ArrayList;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class DiagramIntentionAction
extends DiagramAction {
    private static final Logger LOG = Logger.getInstance(DiagramIntentionAction.class);

    @Override
    public void perform(@NotNull AnActionEvent e) {
        DiagramBuilder builder;
        if (e == null) {
            DiagramIntentionAction.$$$reportNull$$$0(0);
        }
        if ((builder = DiagramIntentionAction.getBuilder(e)) == null) {
            return;
        }
        DiagramNode node = DiagramIntentionAction.getSelectedNodes(e).get(0);
        ArrayList actions = new ArrayList();
        for (DiagramNodeIntentionAction<?> action : builder.getProvider().getNodeIntentionActions()) {
            if (!action.isEnabled(e, builder)) continue;
            actions.add(action);
        }
        JBList list = new JBList(actions);
        list.installCellRenderer(obj -> {
            Presentation presentation = obj.getTemplatePresentation();
            String actionText = presentation.getText();
            LOG.assertTrue(actionText != null, (Object)obj);
            String text = StringUtil.capitalize((String)StringUtil.wordsToBeginFromLowerCase((String)actionText));
            Icon icon = presentation.getIcon();
            JLabel label = new JLabel(text, icon == null ? AllIcons.Actions.IntentionBulb : icon, 2);
            label.setBorder((Border)JBUI.Borders.empty((int)4, (int)4, (int)4, (int)10));
            return label;
        });
        JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setAutoselectOnMouseMove(true).setItemChosenCallback(() -> {
            DiagramNodeIntentionAction value = (DiagramNodeIntentionAction)((Object)((Object)list.getSelectedValue()));
            if (value != null) {
                value.perform(node, builder);
            }
        }).createPopup();
        GraphCanvasLocationService.getInstance().showPopupBeneathNode(popup, builder.getGraphBuilder(), Objects.requireNonNull(builder.getNode(node)));
    }

    @Override
    public boolean isEnabled(@NotNull AnActionEvent e, @NotNull DiagramBuilder b) {
        if (e == null) {
            DiagramIntentionAction.$$$reportNull$$$0(1);
        }
        if (b == null) {
            DiagramIntentionAction.$$$reportNull$$$0(2);
        }
        for (DiagramNodeIntentionAction<?> action : b.getProvider().getNodeIntentionActions()) {
            if (!action.isEnabled(e, b)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            DiagramIntentionAction.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    @Override
    public boolean isUndoable(@NotNull AnActionEvent e) {
        if (e == null) {
            DiagramIntentionAction.$$$reportNull$$$0(4);
        }
        return false;
    }

    @Override
    @NotNull
    public String getActionName() {
        String string = DiagramBundle.message("action.Uml.NodeIntentions.text", new Object[0]);
        if (string == null) {
            DiagramIntentionAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/actions/DiagramIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/actions/DiagramIntentionAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isUndoable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }
}

