/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.registry.node.presentation;

import fleet.rpc.core.FailureInfo;
import fleet.rpc.core.RpcException;
import fleet.rpc.core.RpcFailureKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/registry/node/presentation/ErrorMessageFormatter;", "", "<init>", "()V", "HTTP_ERROR_REGEX", "Lkotlin/text/Regex;", "format", "", "ex", "", "formatRpcException", "Lfleet/rpc/core/RpcException;", "parseHttpError", "Lcom/intellij/docker/registry/node/presentation/ErrorMessageFormatter$ParsedHttpError;", "rawError", "ParsedHttpError", "intellij.clouds.docker.shared"})
@SourceDebugExtension(value={"SMAP\nPlaceholdersNodePresentation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlaceholdersNodePresentation.kt\ncom/intellij/docker/registry/node/presentation/ErrorMessageFormatter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
final class ErrorMessageFormatter {
    @NotNull
    public static final ErrorMessageFormatter INSTANCE = new ErrorMessageFormatter();
    @NotNull
    private static final Regex HTTP_ERROR_REGEX = new Regex("Response code: (\\d+) from url: (.*)}");

    private ErrorMessageFormatter() {
    }

    @NotNull
    public final String format(@NotNull Throwable ex) {
        String string;
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        if (ex instanceof RpcException) {
            string = this.formatRpcException((RpcException)ex);
        } else {
            String string2 = ex.getMessage();
            if (string2 == null) {
                string2 = ex.getClass().getSimpleName();
            }
            String string3 = string2;
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        }
        return string;
    }

    private final String formatRpcException(RpcException ex) {
        String string;
        block4: {
            FailureInfo failure;
            block3: {
                failure = ex.getFailure();
                string = failure.getRequestError();
                if (string == null) break block3;
                String it = string;
                boolean bl = false;
                ParsedHttpError parsedHttpError = INSTANCE.parseHttpError(it);
                String string2 = parsedHttpError != null ? parsedHttpError.toString() : null;
                string = string2;
                if (string2 != null) break block4;
            }
            string = RpcFailureKt.message((FailureInfo)failure);
        }
        return string;
    }

    private final ParsedHttpError parseHttpError(String rawError) {
        ParsedHttpError parsedHttpError;
        MatchResult matchResult = Regex.find$default((Regex)HTTP_ERROR_REGEX, (CharSequence)rawError, (int)0, (int)2, null);
        if (matchResult != null) {
            MatchResult match = matchResult;
            boolean bl = false;
            MatchResult.Destructured destructured = match.getDestructured();
            String statusCode = (String)destructured.getMatch().getGroupValues().get(1);
            String url = (String)destructured.getMatch().getGroupValues().get(2);
            Integer n = StringsKt.toIntOrNull((String)statusCode);
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl2 = false;
                parsedHttpError = new ParsedHttpError(it, url);
            } else {
                parsedHttpError = null;
            }
        } else {
            parsedHttpError = null;
        }
        return parsedHttpError;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\u0005H\u0016J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/docker/registry/node/presentation/ErrorMessageFormatter$ParsedHttpError;", "", "statusCode", "", "url", "", "<init>", "(ILjava/lang/String;)V", "getStatusCode", "()I", "getUrl", "()Ljava/lang/String;", "toString", "component1", "component2", "copy", "equals", "", "other", "hashCode", "intellij.clouds.docker.shared"})
    private static final class ParsedHttpError {
        private final int statusCode;
        @NotNull
        private final String url;

        public ParsedHttpError(int statusCode, @NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.statusCode = statusCode;
            this.url = url;
        }

        public final int getStatusCode() {
            return this.statusCode;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public String toString() {
            return "Response code: " + this.statusCode + " from url: " + this.url;
        }

        public final int component1() {
            return this.statusCode;
        }

        @NotNull
        public final String component2() {
            return this.url;
        }

        @NotNull
        public final ParsedHttpError copy(int statusCode, @NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return new ParsedHttpError(statusCode, url);
        }

        public static /* synthetic */ ParsedHttpError copy$default(ParsedHttpError parsedHttpError, int n, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = parsedHttpError.statusCode;
            }
            if ((n2 & 2) != 0) {
                string = parsedHttpError.url;
            }
            return parsedHttpError.copy(n, string);
        }

        public int hashCode() {
            int result = Integer.hashCode(this.statusCode);
            result = result * 31 + this.url.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParsedHttpError)) {
                return false;
            }
            ParsedHttpError parsedHttpError = (ParsedHttpError)other;
            if (this.statusCode != parsedHttpError.statusCode) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.url, (Object)parsedHttpError.url);
        }
    }
}

