/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.highlighting.checkers;

import com.intellij.beanValidation.highlighting.checkers.BvChecker;
import com.intellij.beanValidation.highlighting.fixes.CreateEnumConstantFix;
import com.intellij.beanValidation.model.xml.Element;
import com.intellij.beanValidation.resources.BVBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.List;

public class CheckAnnotationIsConstraint
implements BvChecker {
    @Override
    public void check(GenericDomValue<?> value, DomElementAnnotationHolder holder) {
        Object obj = value.getValue();
        DomElement parent = value.getParent();
        if (obj instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)obj;
            if (parent instanceof Element) {
                Element element = (Element)parent;
                XmlTag tag = parent.getXmlTag();
                PsiType type = method.getReturnType();
                if (type instanceof PsiArrayType) {
                    PsiType arrayType = ((PsiArrayType)type).getComponentType();
                    List<GenericDomValue<String>> values = element.getValues();
                    for (GenericDomValue<String> domValue : values) {
                        XmlTagValue tagValue = domValue.getXmlTag().getValue();
                        TextRange textRange = TextRange.from((int)0, (int)tagValue.getText().length());
                        CheckAnnotationIsConstraint.checkType(holder, domValue, (String)domValue.getValue(), tagValue.getText(), textRange, arrayType);
                    }
                } else {
                    XmlTagValue tagValue = tag.getValue();
                    TextRange textRange = TextRange.from((int)0, (int)tagValue.getText().length());
                    CheckAnnotationIsConstraint.checkType(holder, element, element.getValue(), tagValue.getText(), textRange, type);
                }
            }
        }
    }

    private static void checkType(DomElementAnnotationHolder holder, DomElement element, String val, String realValue, TextRange textRange, PsiType type) {
        PsiClass psiClass;
        if (PsiTypes.booleanType().equals((Object)type)) {
            if (!"false".equals(val) && !"true".equals(val)) {
                holder.createProblem(element, ProblemHighlightType.ERROR, BVBundle.message("should.be.boolean.value", new Object[0]), textRange, new LocalQuickFix[0]);
            }
        } else if (PsiTypes.byteType().equals((Object)type)) {
            try {
                Byte.parseByte(val);
            }
            catch (Exception e) {
                holder.createProblem(element, ProblemHighlightType.ERROR, BVBundle.message("should.be.number", (byte)-128, (byte)127), textRange, new LocalQuickFix[0]);
            }
        } else if (PsiTypes.shortType().equals((Object)type)) {
            try {
                Short.parseShort(val);
            }
            catch (Exception e) {
                holder.createProblem(element, ProblemHighlightType.ERROR, BVBundle.message("should.be.number", (short)Short.MIN_VALUE, (short)Short.MAX_VALUE), textRange, new LocalQuickFix[0]);
            }
        } else if (PsiTypes.intType().equals((Object)type)) {
            try {
                Integer.parseInt(val);
            }
            catch (Exception e) {
                holder.createProblem(element, ProblemHighlightType.ERROR, BVBundle.message("should.be.number", Integer.MIN_VALUE, Integer.MAX_VALUE), textRange, new LocalQuickFix[0]);
            }
        } else if (PsiTypes.longType().equals((Object)type)) {
            try {
                Long.parseLong(val);
            }
            catch (Exception e) {
                holder.createProblem(element, ProblemHighlightType.ERROR, BVBundle.message("should.be.number", Long.MIN_VALUE, Long.MAX_VALUE), textRange, new LocalQuickFix[0]);
            }
        } else if (PsiTypes.floatType().equals((Object)type)) {
            try {
                Float.parseFloat(val);
            }
            catch (Exception e) {
                holder.createProblem(element, ProblemHighlightType.ERROR, BVBundle.message("cant.parse.float", new Object[0]), textRange, new LocalQuickFix[0]);
            }
        } else if (PsiTypes.doubleType().equals((Object)type)) {
            try {
                Double.parseDouble(val);
            }
            catch (Exception e) {
                holder.createProblem(element, ProblemHighlightType.ERROR, BVBundle.message("cant.parse.double", new Object[0]), textRange, new LocalQuickFix[0]);
            }
        } else if (!"java.lang.Class".equals(type.getCanonicalText()) && type instanceof PsiClassType && (psiClass = ((PsiClassType)type).resolve()) != null && psiClass.isEnum()) {
            if (!PsiNameHelper.getInstance((Project)psiClass.getProject()).isIdentifier(realValue)) {
                holder.createProblem(element, ProblemHighlightType.ERROR, BVBundle.message("is.not.enum.constant.or.extra.spaces.detected", val), textRange, new LocalQuickFix[0]);
            } else {
                for (PsiField field : psiClass.getFields()) {
                    if (!field.getName().equals(val)) continue;
                    return;
                }
                holder.createProblem(element, ProblemHighlightType.ERROR, BVBundle.message("cannot.resolve.enum.constant", val), textRange, new LocalQuickFix[]{new CreateEnumConstantFix(psiClass, val)});
            }
        }
    }
}

