/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.highlighting.checkers;

import com.intellij.beanValidation.highlighting.checkers.BvChecker;
import com.intellij.beanValidation.highlighting.fixes.CreateConstraintParamsFix;
import com.intellij.beanValidation.model.xml.Constraint;
import com.intellij.beanValidation.model.xml.Element;
import com.intellij.beanValidation.resources.BVBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.ArrayList;

public class CheckMissingParameters
implements BvChecker {
    @Override
    public void check(GenericDomValue<?> value, DomElementAnnotationHolder holder) {
        PsiClass psiClass;
        Object o = value.getValue();
        DomElement element = value.getParent();
        if (o instanceof PsiClass && (psiClass = (PsiClass)o).isAnnotationType() && element instanceof Constraint) {
            Constraint constraint = (Constraint)element;
            ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>();
            for (PsiMethod method : psiClass.getMethods()) {
                if (!PsiUtil.isAnnotationMethod((PsiElement)method) || ((PsiAnnotationMethod)method).getDefaultValue() != null) continue;
                methods.add(method);
            }
            if (methods.isEmpty()) {
                return;
            }
            for (Element elem : constraint.getElements()) {
                methods.remove(elem.getName().getValue());
            }
            if (!methods.isEmpty()) {
                holder.createProblem((DomElement)constraint, HighlightSeverity.ERROR, BVBundle.message("annotation.params.missed", new Object[0]), new LocalQuickFix[]{new CreateConstraintParamsFix(constraint, methods)});
            }
        }
    }
}

