/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.ddl;

import com.intellij.jpa.jpb.model.core.CacheKeyStore;
import com.intellij.jpa.jpb.model.core.model.dbtype.Db2Type;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.core.model.dbtype.H2Type;
import com.intellij.jpa.jpb.model.core.model.dbtype.OracleType;
import com.intellij.jpa.jpb.model.db.HibernateSqlType;
import com.intellij.jpa.jpb.model.db.HibernateTypes;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.liquibase.common.config.MappingType;
import com.intellij.liquibase.common.ddl.Db2MappingSettings;
import com.intellij.liquibase.common.ddl.H2MappingSettings;
import com.intellij.liquibase.common.ddl.HsqlMappingSettings;
import com.intellij.liquibase.common.ddl.MssqlMappingSettings;
import com.intellij.liquibase.common.ddl.MysqlMappingSettings;
import com.intellij.liquibase.common.ddl.OracleMappingSettings;
import com.intellij.liquibase.common.ddl.PostgresMappingSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\bf\u0018\u0000 52\u00020\u0001:\u00015J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00052\u0006\u0010\u0012\u001a\u00020\u0004H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\u0018\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0016J1\u0010\u001a\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H&\u00a2\u0006\u0002\u0010\u001eJ1\u0010\u001f\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u001eJ(\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0011H&J1\u0010&\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\b\u0010'\u001a\u0004\u0018\u00010\u00112\b\u0010(\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u0010)J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\"H\u0016J5\u0010-\u001a\u0004\u0018\u00010\u00042\u0006\u0010!\u001a\u00020\"2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00112\b\u0010.\u001a\u0004\u0018\u00010\u00112\b\u0010/\u001a\u0004\u0018\u00010\u0011H\u0016\u00a2\u0006\u0002\u00100J\u0017\u00101\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u00102J\u0010\u00103\u001a\u00020\u00152\u0006\u00104\u001a\u00020\"H\u0016R$\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u001e\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u001e\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u00066\u00c0\u0006\u0001"}, d2={"Lcom/intellij/liquibase/common/ddl/DbMappingSettings;", "", "sqlSynonymTypes", "", "", "", "getSqlSynonymTypes", "()Ljava/util/Map;", "mappingTypes", "Lcom/intellij/jpa/jpb/model/model/Datatypes$BasicDatatype;", "getMappingTypes", "jdbcTypeCodeMappings", "Lcom/intellij/jpa/jpb/model/db/HibernateSqlType;", "getJdbcTypeCodeMappings", "defaultValues", "getDefaultValues", "getMaxVarcharLength", "", "sqlType", "getSqlTypeSynonyms", "isJdbcTypeCodeLengthAvailable", "", "jdbcTypeCode", "isConvertibleType", "attrSqlType", "dbSqlType", "precisionChanged", "attributeColumnSize", "dbColumnSizeInt", "attributeSqlType", "(Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;)Z", "scaleChanged", "typeChanged", "datatype", "Lcom/intellij/jpa/jpb/model/model/Datatype;", "attrMappedSqlType", "dbType", "oldLength", "lengthChanged", "attrColumnSize", "dbColumnSize", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)Z", "getSqlTypeParameter", "Lcom/intellij/liquibase/common/config/MappingType$SqlTypeParameter;", "completedAttrType", "getSqlTypeFor", "length", "decimalDigits", "(Lcom/intellij/jpa/jpb/model/model/Datatype;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/lang/String;", "getSpecificLengthByJdbcTypeCode", "(I)Ljava/lang/Integer;", "isCompatibleStringType", "attrType", "Companion", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nDbMappingSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMappingSettings.kt\ncom/intellij/liquibase/common/ddl/DbMappingSettings\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,1515:1\n12970#2,2:1516\n488#3,7:1518\n488#3,7:1525\n*S KotlinDebug\n*F\n+ 1 DbMappingSettings.kt\ncom/intellij/liquibase/common/ddl/DbMappingSettings\n*L\n86#1:1516,2\n133#1:1518,7\n134#1:1525,7\n*E\n"})
public interface DbMappingSettings {
    @NotNull
    public static final Companion Companion = com.intellij.liquibase.common.ddl.DbMappingSettings$Companion.$$INSTANCE;

    @NotNull
    public Map<String, Collection<String>> getSqlSynonymTypes();

    @NotNull
    public Map<Datatypes.BasicDatatype, String> getMappingTypes();

    @NotNull
    public Map<HibernateSqlType, String> getJdbcTypeCodeMappings();

    @NotNull
    public Map<Datatypes.BasicDatatype, String> getDefaultValues();

    default public int getMaxVarcharLength(@NotNull String sqlType) {
        Intrinsics.checkNotNullParameter((Object)sqlType, (String)"sqlType");
        return Integer.MAX_VALUE;
    }

    @NotNull
    default public Collection<String> getSqlTypeSynonyms(@NotNull String sqlType) {
        Intrinsics.checkNotNullParameter((Object)sqlType, (String)"sqlType");
        Set result = new LinkedHashSet();
        for (Map.Entry<String, Collection<String>> entry : this.getSqlSynonymTypes().entrySet()) {
            String key = entry.getKey();
            Collection<String> value = entry.getValue();
            if (!StringUtil.equalsIgnoreCase((CharSequence)key, (CharSequence)sqlType) && !JpaUtils.containsIgnoreCase(value, (String)sqlType)) continue;
            result.add(key);
            result.addAll(value);
        }
        return result.isEmpty() ? (Collection)SetsKt.setOf((Object)sqlType) : (Collection)result;
    }

    default public boolean isJdbcTypeCodeLengthAvailable(int jdbcTypeCode) {
        boolean bl;
        block1: {
            HibernateSqlType[] hibernateSqlTypeArray = new HibernateSqlType[]{HibernateSqlType.CHAR, HibernateSqlType.VARCHAR, HibernateSqlType.NCHAR, HibernateSqlType.NVARCHAR};
            HibernateSqlType[] $this$any$iv = hibernateSqlTypeArray;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                HibernateSqlType element$iv;
                HibernateSqlType it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!it.equalsByCode(Integer.valueOf(jdbcTypeCode))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    default public boolean isConvertibleType(@NotNull String attrSqlType, @NotNull String dbSqlType) {
        Intrinsics.checkNotNullParameter((Object)attrSqlType, (String)"attrSqlType");
        Intrinsics.checkNotNullParameter((Object)dbSqlType, (String)"dbSqlType");
        return JpaUtils.containsIgnoreCase(this.getSqlTypeSynonyms(dbSqlType), (String)attrSqlType);
    }

    public boolean precisionChanged(@Nullable Integer var1, @Nullable Integer var2, @NotNull String var3, @NotNull String var4);

    default public boolean scaleChanged(@Nullable Integer attributeColumnSize, @Nullable Integer dbColumnSizeInt, @NotNull String attributeSqlType, @NotNull String dbSqlType) {
        Intrinsics.checkNotNullParameter((Object)attributeSqlType, (String)"attributeSqlType");
        Intrinsics.checkNotNullParameter((Object)dbSqlType, (String)"dbSqlType");
        return !Intrinsics.areEqual((Object)attributeColumnSize, (Object)dbColumnSizeInt) && (dbColumnSizeInt != null && dbColumnSizeInt > -84 || attributeColumnSize == null || attributeColumnSize == 0);
    }

    public boolean typeChanged(@NotNull Datatype var1, @NotNull String var2, @NotNull String var3, int var4);

    default public boolean lengthChanged(@NotNull String attrSqlType, @NotNull String dbSqlType, @Nullable Integer attrColumnSize, @Nullable Integer dbColumnSize) {
        Intrinsics.checkNotNullParameter((Object)attrSqlType, (String)"attrSqlType");
        Intrinsics.checkNotNullParameter((Object)dbSqlType, (String)"dbSqlType");
        Integer n = attrColumnSize;
        int actualAttrColumnSize = n != null ? n.intValue() : this.getMaxVarcharLength(dbSqlType);
        Integer n2 = dbColumnSize;
        int actualDbColumnSize = n2 != null ? n2.intValue() : this.getMaxVarcharLength(dbSqlType);
        return actualAttrColumnSize != actualDbColumnSize;
    }

    @Nullable
    default public MappingType.SqlTypeParameter getSqlTypeParameter(@NotNull Datatype completedAttrType) {
        Intrinsics.checkNotNullParameter((Object)completedAttrType, (String)"completedAttrType");
        if (Intrinsics.areEqual((Object)completedAttrType, (Object)HibernateTypes.INSTANCE.getTextType()) || Intrinsics.areEqual((Object)completedAttrType, (Object)HibernateTypes.INSTANCE.getNTextType())) {
            return MappingType.SqlTypeParameter.NOTHING;
        }
        return null;
    }

    @Nullable
    default public String getSqlTypeFor(@NotNull Datatype datatype, @Nullable Integer jdbcTypeCode, @Nullable Integer length, @Nullable Integer decimalDigits) {
        HibernateSqlType it;
        Intrinsics.checkNotNullParameter((Object)datatype, (String)"datatype");
        Map<HibernateSqlType, String> $this$filterKeys$iv = this.getJdbcTypeCodeMappings();
        boolean $i$f$filterKeys = false;
        LinkedHashMap<HibernateSqlType, String> result$iv = new LinkedHashMap<HibernateSqlType, String>();
        for (Map.Entry<HibernateSqlType, String> entry$iv : $this$filterKeys$iv.entrySet()) {
            it = entry$iv.getKey();
            boolean bl = false;
            Integer n = jdbcTypeCode;
            if (!(n != null && it.getSqlCode() == n.intValue())) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        String string = (String)CollectionsKt.firstOrNull((Iterable)((Map)result$iv).values());
        if (string == null) {
            $this$filterKeys$iv = this.getMappingTypes();
            $i$f$filterKeys = false;
            result$iv = new LinkedHashMap();
            for (Map.Entry<HibernateSqlType, String> entry$iv : $this$filterKeys$iv.entrySet()) {
                it = (Datatypes.BasicDatatype)entry$iv.getKey();
                boolean bl = false;
                if (!it.isSame(datatype.getFqn())) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            string = (String)CollectionsKt.firstOrNull((Iterable)((Map)result$iv).values());
        }
        return string;
    }

    @Nullable
    default public Integer getSpecificLengthByJdbcTypeCode(int jdbcTypeCode) {
        return null;
    }

    default public boolean isCompatibleStringType(@NotNull Datatype attrType) {
        Intrinsics.checkNotNullParameter((Object)attrType, (String)"attrType");
        return Datatypes.BasicDatatype.InetAddress.equals((Object)attrType);
    }

    @JvmStatic
    @NotNull
    public static DbMappingSettings getInstance(@NotNull DbType dbType, @NotNull Project project) {
        return Companion.getInstance(dbType, project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/liquibase/common/ddl/DbMappingSettings$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/liquibase/common/ddl/DbMappingSettings;", "dbType", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.liquibase.common"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DbMappingSettings getInstance(@NotNull DbType dbType, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String keyValue = "DbMappingSettings#getInstance:" + dbType.getId();
            Key key = CacheKeyStore.Companion.getInstance(project).getKey((Object)keyValue);
            Object object = CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, key, () -> Companion.getInstance$lambda$0(dbType, project), false);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
            return (DbMappingSettings)object;
        }

        private static final CachedValueProvider.Result getInstance$lambda$0(DbType $dbType, Project $project) {
            Object[] objectArray;
            DbMappingSettings dbMappingSettings;
            if ($dbType == DbType.POSTGRES) {
                dbMappingSettings = new PostgresMappingSettings($project);
            } else {
                objectArray = new DbType[]{DbType.HSQL, DbType.HSQL_INMEMORY, DbType.HSQL_FILE};
                if (CollectionsKt.listOf((Object[])objectArray).contains($dbType)) {
                    dbMappingSettings = new HsqlMappingSettings($project);
                } else {
                    objectArray = new DbType[]{DbType.MYSQL, DbType.MYSQL_51, DbType.MARIA};
                    if (CollectionsKt.listOf((Object[])objectArray).contains($dbType)) {
                        dbMappingSettings = new MysqlMappingSettings($project);
                    } else if ($dbType instanceof H2Type) {
                        dbMappingSettings = new H2MappingSettings($project);
                    } else if ($dbType instanceof Db2Type) {
                        dbMappingSettings = new Db2MappingSettings($project);
                    } else if ($dbType.isMssql()) {
                        dbMappingSettings = new MssqlMappingSettings($project);
                    } else if ($dbType instanceof OracleType) {
                        dbMappingSettings = new OracleMappingSettings($project);
                    } else {
                        throw new RuntimeException("Unsupported database management system:" + $dbType);
                    }
                }
            }
            DbMappingSettings result = dbMappingSettings;
            objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
            return CachedValueProvider.Result.create((Object)result, (Object[])objectArray);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

