/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.database;

import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.jpa.jpb.model.model.CustomDataStore;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0016R\u001a\u0010\t\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/intellij/liquibase/database/IdeaDataStore;", "Lcom/intellij/jpa/jpb/model/model/CustomDataStore;", "project", "Lcom/intellij/openapi/project/Project;", "id", "", "name", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;)V", "dsUniqueId", "getDsUniqueId", "()Ljava/lang/String;", "setDsUniqueId", "(Ljava/lang/String;)V", "implicitSchemaName", "getImplicitSchemaName", "setImplicitSchemaName", "isValid", "", "getLocationString", "intellij.liquibase.database"})
@SourceDebugExtension(value={"SMAP\nIdeaDataStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeaDataStore.kt\ncom/intellij/liquibase/database/IdeaDataStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,30:1\n295#2,2:31\n1761#2,3:33\n*S KotlinDebug\n*F\n+ 1 IdeaDataStore.kt\ncom/intellij/liquibase/database/IdeaDataStore\n*L\n19#1:31,2\n21#1:33,3\n*E\n"})
public final class IdeaDataStore
extends CustomDataStore {
    @NotNull
    private String dsUniqueId;
    @Nullable
    private String implicitSchemaName;

    public IdeaDataStore(@NotNull Project project, @NotNull String id, @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        super(project, id, name);
        this.dsUniqueId = id;
    }

    @NotNull
    public final String getDsUniqueId() {
        return this.dsUniqueId;
    }

    public final void setDsUniqueId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.dsUniqueId = string;
    }

    @Nullable
    public final String getImplicitSchemaName() {
        return this.implicitSchemaName;
    }

    public final void setImplicitSchemaName(@Nullable String string) {
        this.implicitSchemaName = string;
    }

    public boolean isValid() {
        boolean bl;
        block7: {
            Object v1;
            block6: {
                List list = DataSourceStorage.getProjectStorage((Project)this.project).getDataSources();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    LocalDataSource it = (LocalDataSource)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getUniqueId(), (Object)this.dsUniqueId)) continue;
                    v1 = element$iv;
                    break block6;
                }
                v1 = null;
            }
            LocalDataSource localDataSource = v1;
            if (localDataSource == null) {
                return false;
            }
            LocalDataSource dataSource = localDataSource;
            Object object = JdbcDriverManager.getDriverManagerIfCreated((Project)this.project);
            boolean bl3 = object != null && (object = object.getActiveConfigurations(dataSource)) != null ? !((Collection)object).isEmpty() : false;
            if (bl3) {
                return true;
            }
            JBTreeTraverser jBTreeTraverser = DbImplUtilCore.traverseVisibleObjects((DasDataSource)((DasDataSource)dataSource));
            Intrinsics.checkNotNullExpressionValue((Object)jBTreeTraverser, (String)"traverseVisibleObjects(...)");
            Iterable $this$any$iv = (Iterable)jBTreeTraverser;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DasObject it = (DasObject)element$iv;
                    boolean bl4 = false;
                    if (!(it instanceof DasTable)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public String getLocationString() {
        if (Intrinsics.areEqual((Object)this.dsUniqueId, (Object)this.getId())) {
            String string = super.getLocationString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocationString(...)");
            return string;
        }
        return " (currentSchema=" + this.dbProperties.getCurrentSchema() + ")";
    }
}

