/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.diff;

import liquibase.change.Change;
import liquibase.change.core.AddForeignKeyConstraintChange;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.ForeignKey;

public class MissingForeignKeyChangeGenerator
extends liquibase.diff.output.changelog.core.MissingForeignKeyChangeGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (ForeignKey.class.isAssignableFrom(objectType)) {
            return 50;
        }
        return -1;
    }

    public Change[] fixMissing(DatabaseObject missingObject, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        Change[] changes;
        for (Change change : changes = super.fixMissing(missingObject, control, referenceDatabase, comparisonDatabase, chain)) {
            if (!(change instanceof AddForeignKeyConstraintChange)) continue;
            AddForeignKeyConstraintChange fkChange = (AddForeignKeyConstraintChange)change;
            if (Boolean.FALSE.equals(fkChange.getDeferrable())) {
                fkChange.setDeferrable(null);
            }
            if (Boolean.FALSE.equals(fkChange.getInitiallyDeferred())) {
                fkChange.setInitiallyDeferred(null);
            }
            if (Boolean.TRUE.equals(fkChange.getValidate())) {
                fkChange.setValidate(null);
            }
            fkChange.setReferencedTableCatalogName(null);
            fkChange.setBaseTableCatalogName(null);
        }
        return changes;
    }
}

