/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.server;

import com.intellij.javaee.appServers.deployment.DeploymentMethod;
import com.intellij.javaee.appServers.deployment.ExternalFileDeploymentProvider;
import com.intellij.javaee.appServers.deployment.ExternalFileDeploymentProviderImpl;
import com.intellij.javaee.appServers.deployment.JavaeeDeploymentUtil;
import com.intellij.javaee.oss.jboss.JBossBundle;
import com.intellij.javaee.oss.jboss.server.JBossExtensions;
import com.intellij.javaee.oss.server.JavaeeDeploymentProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.impl.artifacts.JarArtifactType;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;

public class JBossDeploymentProvider
extends JavaeeDeploymentProvider {
    private static final Logger LOG = Logger.getInstance(JBossDeploymentProvider.class);
    public static final DeploymentMethod STAGING = new DeploymentMethod(JBossBundle.getText("JBossDeploymentProvider.method.staging", new Object[0]), false, true);
    public static final DeploymentMethod NATIVE = new DeploymentMethod(JBossBundle.getText("JBossDeploymentProvider.method.native", new Object[0]), false, true);
    private static final DeploymentMethod[] ourDeploymentMethods = new DeploymentMethod[]{STAGING, NATIVE};

    public DeploymentMethod[] getAvailableMethods() {
        return ourDeploymentMethods;
    }

    public Collection<? extends ArtifactType> getSupportedArtifactTypes() {
        ArrayList<JarArtifactType> result = new ArrayList<JarArtifactType>(super.getSupportedArtifactTypes());
        result.add(JarArtifactType.getInstance());
        return result;
    }

    public ExternalFileDeploymentProvider getExternalFileDeploymentProvider() {
        ExternalFileDeploymentProvider commonProvider = super.getExternalFileDeploymentProvider();
        LOG.assertTrue(commonProvider != null);
        ExternalFileDeploymentProvider specificProvider = JavaeeDeploymentUtil.getInstance().createExternalFileDeploymentProvider(true, JBossExtensions.SPECIFIC_EXTENSIONS);
        boolean directoriesAllowed = commonProvider.areDirectoriesAllowed() || specificProvider.areDirectoriesAllowed();
        String[] extensions = ArrayUtil.mergeArrays((String[])commonProvider.getAllowedExtensions(), (String[])specificProvider.getAllowedExtensions());
        return new ExternalFileDeploymentProviderImpl(directoriesAllowed, extensions);
    }

    public boolean isDeployOrderMatter() {
        return true;
    }

    public boolean isNeedUndeployOnDisconnect() {
        return true;
    }
}

