/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleSegment;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.observable.property.Property;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.algorithms.AdaptiveResampler;
import org.jetbrains.letsPlot.commons.intern.util.ArrowSupport;
import org.jetbrains.letsPlot.commons.intern.util.CurveKt;
import org.jetbrains.letsPlot.commons.intern.util.PaddingKt;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.aes.AesScaling;
import org.jetbrains.letsPlot.core.plot.base.aes.AestheticsUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.DimensionUnit;
import org.jetbrains.letsPlot.core.plot.base.geom.util.ArrowSpec;
import org.jetbrains.letsPlot.core.plot.base.render.svg.PathUtilKt;
import org.jetbrains.letsPlot.core.plot.base.render.svg.StrokeDashArraySupport;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgCircleElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgColors;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGraphicsElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgLineElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathData;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathDataBuilder;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgPathElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgShape;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgUtils;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimShape;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 (2\u00020\u0001:\u0002()B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J(\u0010\u000f\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u001c\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00190\u001dJ \u0010\u001e\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0013J1\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\"2\u0014\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\"H\u0000\u00a2\u0006\u0002\b$J&\u0010%\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0012\u001a\u00020\u00132\u0014\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\"J-\u0010&\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0014\u0010#\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00100\"H\u0000\u00a2\u0006\u0002\b'R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006*"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "(Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;)V", "getCoord", "()Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "getCtx$plot_base", "()Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "getPos", "()Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "adjust", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "r", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "location", "createSvgElementHelper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper$SvgElementHelper;", "getUnitResolution", "", "unit", "Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;", "axisAes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "toClient", "x", "y", "toClientLocation", "Lkotlin/Function1;", "aesMapper", "toClientLocation$plot_base", "toClientPoint", "toClientRect", "toClientRect$plot_base", "Companion", "SvgElementHelper", "plot-base"})
public class GeomHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PositionAdjustment pos;
    @NotNull
    private final CoordinateSystem coord;
    @NotNull
    private final GeomContext ctx;

    public GeomHelper(@NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        this.pos = pos;
        this.coord = coord;
        this.ctx = ctx2;
    }

    @NotNull
    protected final PositionAdjustment getPos() {
        return this.pos;
    }

    @NotNull
    protected final CoordinateSystem getCoord() {
        return this.coord;
    }

    @NotNull
    public final GeomContext getCtx$plot_base() {
        return this.ctx;
    }

    @Nullable
    public final DoubleVector toClient(@NotNull DoubleVector location2, @NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.coord.toClient(this.adjust(location2, p, this.pos, this.ctx));
    }

    @Nullable
    public final DoubleVector toClient(double x2, double y2, @NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        DoubleVector location2 = new DoubleVector(x2, y2);
        return this.coord.toClient(this.adjust(location2, p, this.pos, this.ctx));
    }

    @Nullable
    public final DoubleRectangle toClient(@NotNull DoubleRectangle r, @NotNull DataPointAesthetics p) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        DoubleRectangle clientRect = this.coord.toClient(this.adjust(r, p, this.pos, this.ctx));
        if (clientRect == null) {
            return null;
        }
        if (clientRect.getWidth() == 0.0) {
            clientRect = new DoubleRectangle(clientRect.getOrigin().getX(), clientRect.getOrigin().getY(), 0.1, clientRect.getHeight());
        }
        if (clientRect.getHeight() == 0.0) {
            clientRect = new DoubleRectangle(clientRect.getOrigin().getX(), clientRect.getOrigin().getY(), clientRect.getWidth(), 0.1);
        }
        return clientRect;
    }

    private final DoubleVector adjust(DoubleVector location2, DataPointAesthetics p, PositionAdjustment pos, GeomContext ctx2) {
        return pos.translate(location2, p, ctx2);
    }

    @Nullable
    public final DoubleVector toClientPoint(@NotNull DataPointAesthetics p, @NotNull Function1<? super DataPointAesthetics, DoubleVector> aesMapper) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(aesMapper, (String)"aesMapper");
        DoubleVector doubleVector = (DoubleVector)aesMapper.invoke((Object)p);
        if (doubleVector == null) {
            return null;
        }
        DoubleVector location2 = doubleVector;
        return this.toClient(location2, p);
    }

    @Nullable
    public final DoubleRectangle toClientRect$plot_base(@NotNull DataPointAesthetics p, @NotNull Function1<? super DataPointAesthetics, DoubleRectangle> aesMapper) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(aesMapper, (String)"aesMapper");
        DoubleRectangle doubleRectangle = (DoubleRectangle)aesMapper.invoke((Object)p);
        if (doubleRectangle == null) {
            return null;
        }
        DoubleRectangle r = doubleRectangle;
        return this.toClient(r, p);
    }

    private final DoubleRectangle adjust(DoubleRectangle r, DataPointAesthetics p, PositionAdjustment pos, GeomContext ctx2) {
        DoubleVector leftTop = pos.translate(r.getOrigin(), p, ctx2);
        DoubleVector rightBottom = pos.translate(r.getOrigin().add(r.getDimension()), p, ctx2);
        return DoubleRectangle.Companion.span(leftTop, rightBottom);
    }

    @NotNull
    public final Function1<DataPointAesthetics, DoubleVector> toClientLocation$plot_base(@NotNull Function1<? super DataPointAesthetics, DoubleVector> aesMapper) {
        Intrinsics.checkNotNullParameter(aesMapper, (String)"aesMapper");
        return (Function1)new Function1<DataPointAesthetics, DoubleVector>(aesMapper, this){
            final /* synthetic */ Function1<DataPointAesthetics, DoubleVector> $aesMapper;
            final /* synthetic */ GeomHelper this$0;
            {
                this.$aesMapper = $aesMapper;
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final DoubleVector invoke(@NotNull DataPointAesthetics aes2) {
                DoubleVector doubleVector;
                Intrinsics.checkNotNullParameter((Object)aes2, (String)"aes");
                DoubleVector doubleVector2 = (DoubleVector)this.$aesMapper.invoke((Object)aes2);
                if (doubleVector2 != null) {
                    DoubleVector doubleVector3 = doubleVector2;
                    GeomHelper geomHelper = this.this$0;
                    DoubleVector location2 = doubleVector3;
                    boolean bl = false;
                    doubleVector = geomHelper.toClient(location2, aes2);
                } else {
                    doubleVector = null;
                }
                return doubleVector;
            }
        };
    }

    @NotNull
    public final SvgElementHelper createSvgElementHelper() {
        return new SvgElementHelper((Function2<? super DoubleVector, ? super DataPointAesthetics, DoubleVector>)((Function2)new Function2<DoubleVector, DataPointAesthetics, DoubleVector>((Object)this){

            @Nullable
            public final DoubleVector invoke(@NotNull DoubleVector p0, @NotNull DataPointAesthetics p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((GeomHelper)this.receiver).toClient(p0, p1);
            }
        }));
    }

    public final double getUnitResolution(@NotNull DimensionUnit unit, @NotNull Aes<Double> axisAes) {
        double d;
        double d2;
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Intrinsics.checkNotNullParameter(axisAes, (String)"axisAes");
        Aes<Double> aes2 = axisAes;
        if (Intrinsics.areEqual(aes2, Aes.Companion.getX())) {
            d2 = this.coord.unitSize(new DoubleVector(1.0, 0.0)).getX();
        } else if (Intrinsics.areEqual(aes2, Aes.Companion.getY())) {
            d2 = this.coord.unitSize(new DoubleVector(0.0, 1.0)).getY();
        } else {
            throw new IllegalStateException(("Unsupported axis aes: " + axisAes).toString());
        }
        double unitSize = d2;
        switch (WhenMappings.$EnumSwitchMapping$0[unit.ordinal()]) {
            case 1: {
                d = this.ctx.getResolution(axisAes);
                break;
            }
            case 2: {
                d = 1.0;
                break;
            }
            case 3: {
                d = 2.2 / unitSize;
                break;
            }
            case 4: {
                d = 1.0 / unitSize;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J@\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\f2\b\b\u0002\u0010\u000e\u001a\u00020\nJ'\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper$Companion;", "", "()V", "decorate", "", "shape", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgShape;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "applyAlphaToAll", "", "strokeScaler", "Lkotlin/Function1;", "", "filled", "decorateSlimShape", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/slim/SvgSlimShape;", "decorateSlimShape$plot_base", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public final void decorate(@NotNull SvgShape shape, @NotNull DataPointAesthetics p, boolean applyAlphaToAll, @NotNull Function1<? super DataPointAesthetics, Double> strokeScaler, boolean filled) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter(strokeScaler, (String)"strokeScaler");
            AestheticsUtil.INSTANCE.updateStroke(shape, p, applyAlphaToAll);
            if (filled) {
                AestheticsUtil.INSTANCE.updateFill(shape, p);
            } else {
                shape.fill().set(SvgColors.NONE);
            }
            double strokeWidth = ((Number)strokeScaler.invoke((Object)p)).doubleValue();
            shape.strokeWidth().set(strokeWidth);
            StrokeDashArraySupport.INSTANCE.apply(shape, strokeWidth, p.lineType());
        }

        public static /* synthetic */ void decorate$default(Companion companion, SvgShape svgShape, DataPointAesthetics dataPointAesthetics, boolean bl, Function1 function1, boolean bl2, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                function1 = (Function1)new Function1<DataPointAesthetics, Double>((Object)AesScaling.INSTANCE){

                    @NotNull
                    public final Double invoke(@NotNull DataPointAesthetics p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((AesScaling)this.receiver).strokeWidth(p0);
                    }
                };
            }
            if ((n & 0x10) != 0) {
                bl2 = true;
            }
            companion.decorate(svgShape, dataPointAesthetics, bl, (Function1<? super DataPointAesthetics, Double>)function1, bl2);
        }

        public final void decorateSlimShape$plot_base(@NotNull SvgSlimShape shape, @NotNull DataPointAesthetics p, boolean applyAlphaToAll) {
            Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Color color = p.color();
            Intrinsics.checkNotNull((Object)color);
            Color stroke2 = color;
            double strokeAlpha = applyAlphaToAll ? AestheticsUtil.INSTANCE.alpha(stroke2, p) : SvgUtils.INSTANCE.alpha2opacity(stroke2.getAlpha());
            Color color2 = p.fill();
            Intrinsics.checkNotNull((Object)color2);
            Color fill2 = color2;
            double fillAlpha = AestheticsUtil.INSTANCE.alpha(fill2, p);
            shape.setFill(fill2, fillAlpha);
            shape.setStroke(stroke2, strokeAlpha);
            shape.setStrokeWidth(AesScaling.INSTANCE.strokeWidth(p));
            StrokeDashArraySupport.INSTANCE.apply(shape, AesScaling.INSTANCE.strokeWidth(p), p.lineType());
        }

        public static /* synthetic */ void decorateSlimShape$plot_base$default(Companion companion, SvgSlimShape svgSlimShape, DataPointAesthetics dataPointAesthetics, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            companion.decorateSlimShape$plot_base(svgSlimShape, dataPointAesthetics, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001b\u0018\u00002\u00020\u0001B#\u0012\u001c\b\u0002\u0010\u0002\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\nH\u0002J`\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001a\u0018\u00010\u00182\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00052\u0014\b\u0002\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110#J@\u0010$\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001a\u0018\u00010\u00182\u0006\u0010%\u001a\u00020&2\u0006\u0010!\u001a\u00020\u00052\u0014\b\u0002\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110#JH\u0010$\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001a\u0018\u00010\u00182\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u00052\u0014\b\u0002\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110#J&\u0010'\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001a2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a2\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J(\u0010'\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0005H\u0002J@\u0010)\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001a\u0018\u00010\u00182\u0006\u0010*\u001a\u00020+2\u0006\u0010!\u001a\u00020\u00052\u0014\b\u0002\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110#JX\u0010,\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u001a\u0018\u00010\u00182\u0006\u0010-\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010.\u001a\u00020\u00112\u0006\u0010/\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u00052\u0014\b\u0002\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110#J\u000e\u00100\u001a\u00020\u00002\u0006\u00101\u001a\u00020\nJ\u000e\u00102\u001a\u00020\u00002\u0006\u00101\u001a\u00020\nJ\u0006\u00103\u001a\u00020\u0000J,\u00104\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a2\u0006\u0010!\u001a\u00020\u00052\u0006\u00106\u001a\u00020\nH\u0002J4\u00107\u001a\u0004\u0018\u00010\u00192\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a2\u0006\u0010!\u001a\u00020\u00052\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110#H\u0002J<\u00108\u001a\u0004\u0018\u00010\u00192\u0006\u0010!\u001a\u00020\u00052\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110#2\u0006\u00109\u001a\u00020\nH\u0002J\u0010\u0010:\u001a\u00020\u00002\b\u0010;\u001a\u0004\u0018\u00010\bJ\u000e\u0010<\u001a\u00020\u00002\u0006\u0010=\u001a\u00020\rJ\u000e\u0010>\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\nJ\u000e\u0010@\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\u0011J\u000e\u0010B\u001a\u00020\u00002\u0006\u0010C\u001a\u00020\u0011J\u000e\u0010D\u001a\u00020\u00002\u0006\u0010?\u001a\u00020\nJ$\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a2\u0006\u0010!\u001a\u00020\u0005H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0002\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper$SvgElementHelper;", "", "toClient", "Lkotlin/Function2;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "(Lkotlin/jvm/functions/Function2;)V", "myArrowSpec", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/ArrowSpec;", "myDebugRendering", "", "myGeometryWithPadding", "myInterpolation", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgPathDataBuilder$Interpolation;", "myNoSvg", "myResamplingEnabled", "myResamplingPrecision", "", "mySpacer", "myStrokeAlphaEnabled", "arrowPadding", "aes", "atStart", "createCurve", "Lkotlin/Pair;", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "", "start", "end", "curvature", "angle", "ncp", "", "p", "strokeScaler", "Lkotlin/Function1;", "createLine", "segment", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleSegment;", "createLineGeometry", "points", "createRectangle", "rect", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "createSpoke", "base", "radius", "pivot", "debugRendering", "value", "geometryWithPadding", "noSvg", "padLineString", "lineString", "padArrow", "renderArrowHead", "renderSvgElement", "filled", "setArrowSpec", "arrowSpec", "setInterpolation", "interpolation", "setResamplingEnabled", "b", "setResamplingPrecision", "precision", "setSpacer", "spacer", "setStrokeAlphaEnabled", "takeGeometry", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nGeomHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeomHelper.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper$SvgElementHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,422:1\n1#2:423\n1549#3:424\n1620#3,3:425\n1549#3:428\n1620#3,3:429\n*S KotlinDebug\n*F\n+ 1 GeomHelper.kt\norg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper$SvgElementHelper\n*L\n220#1:424\n220#1:425,3\n281#1:428\n281#1:429,3\n*E\n"})
    public static final class SvgElementHelper {
        @NotNull
        private final Function2<DoubleVector, DataPointAesthetics, DoubleVector> toClient;
        private boolean myGeometryWithPadding;
        private boolean myNoSvg;
        @Nullable
        private SvgPathDataBuilder.Interpolation myInterpolation;
        @Nullable
        private ArrowSpec myArrowSpec;
        private boolean myStrokeAlphaEnabled;
        private boolean myResamplingEnabled;
        private double myResamplingPrecision;
        private double mySpacer;
        private boolean myDebugRendering;

        public SvgElementHelper(@NotNull Function2<? super DoubleVector, ? super DataPointAesthetics, DoubleVector> toClient) {
            Intrinsics.checkNotNullParameter(toClient, (String)"toClient");
            this.toClient = toClient;
            this.myGeometryWithPadding = true;
            this.myResamplingPrecision = 0.95;
        }

        public /* synthetic */ SvgElementHelper(Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                function2 = 1.INSTANCE;
            }
            this((Function2<? super DoubleVector, ? super DataPointAesthetics, DoubleVector>)function2);
        }

        @NotNull
        public final SvgElementHelper setStrokeAlphaEnabled(boolean b2) {
            SvgElementHelper svgElementHelper;
            SvgElementHelper $this$setStrokeAlphaEnabled_u24lambda_u240 = svgElementHelper = this;
            boolean bl = false;
            $this$setStrokeAlphaEnabled_u24lambda_u240.myStrokeAlphaEnabled = b2;
            return svgElementHelper;
        }

        @NotNull
        public final SvgElementHelper setResamplingEnabled(boolean b2) {
            SvgElementHelper svgElementHelper;
            SvgElementHelper $this$setResamplingEnabled_u24lambda_u241 = svgElementHelper = this;
            boolean bl = false;
            $this$setResamplingEnabled_u24lambda_u241.myResamplingEnabled = b2;
            return svgElementHelper;
        }

        @NotNull
        public final SvgElementHelper setArrowSpec(@Nullable ArrowSpec arrowSpec) {
            SvgElementHelper svgElementHelper;
            SvgElementHelper $this$setArrowSpec_u24lambda_u242 = svgElementHelper = this;
            boolean bl = false;
            $this$setArrowSpec_u24lambda_u242.myArrowSpec = arrowSpec;
            return svgElementHelper;
        }

        @NotNull
        public final SvgElementHelper setSpacer(double spacer) {
            SvgElementHelper svgElementHelper;
            SvgElementHelper $this$setSpacer_u24lambda_u243 = svgElementHelper = this;
            boolean bl = false;
            $this$setSpacer_u24lambda_u243.mySpacer = spacer;
            return svgElementHelper;
        }

        @NotNull
        public final SvgElementHelper setInterpolation(@NotNull SvgPathDataBuilder.Interpolation interpolation) {
            SvgElementHelper svgElementHelper;
            Intrinsics.checkNotNullParameter((Object)((Object)interpolation), (String)"interpolation");
            SvgElementHelper $this$setInterpolation_u24lambda_u244 = svgElementHelper = this;
            boolean bl = false;
            $this$setInterpolation_u24lambda_u244.myInterpolation = interpolation;
            return svgElementHelper;
        }

        @NotNull
        public final SvgElementHelper setResamplingPrecision(double precision) {
            SvgElementHelper svgElementHelper;
            SvgElementHelper $this$setResamplingPrecision_u24lambda_u245 = svgElementHelper = this;
            boolean bl = false;
            $this$setResamplingPrecision_u24lambda_u245.myResamplingPrecision = precision;
            return svgElementHelper;
        }

        @NotNull
        public final SvgElementHelper noSvg() {
            SvgElementHelper svgElementHelper;
            SvgElementHelper $this$noSvg_u24lambda_u246 = svgElementHelper = this;
            boolean bl = false;
            $this$noSvg_u24lambda_u246.myNoSvg = true;
            return svgElementHelper;
        }

        @NotNull
        public final SvgElementHelper debugRendering(boolean value) {
            SvgElementHelper svgElementHelper;
            SvgElementHelper $this$debugRendering_u24lambda_u247 = svgElementHelper = this;
            boolean bl = false;
            $this$debugRendering_u24lambda_u247.myDebugRendering = value;
            return svgElementHelper;
        }

        @NotNull
        public final SvgElementHelper geometryWithPadding(boolean value) {
            SvgElementHelper svgElementHelper;
            SvgElementHelper $this$geometryWithPadding_u24lambda_u248 = svgElementHelper = this;
            boolean bl = false;
            $this$geometryWithPadding_u24lambda_u248.myGeometryWithPadding = value;
            return svgElementHelper;
        }

        @Nullable
        public final Pair<SvgNode, List<DoubleVector>> createRectangle(@NotNull DoubleRectangle rect2, @NotNull DataPointAesthetics p, @NotNull Function1<? super DataPointAesthetics, Double> strokeScaler) {
            Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter(strokeScaler, (String)"strokeScaler");
            List<DoubleVector> list2 = this.createLineGeometry(rect2.getPoints(), p);
            if (list2 == null) {
                return null;
            }
            List<DoubleVector> lineString = list2;
            SvgNode svgNode = this.renderSvgElement(p, lineString, strokeScaler, true);
            if (svgNode == null) {
                return null;
            }
            SvgNode svgElement = svgNode;
            List<DoubleVector> geometry = this.takeGeometry(lineString, p);
            return TuplesKt.to((Object)svgElement, geometry);
        }

        public static /* synthetic */ Pair createRectangle$default(SvgElementHelper svgElementHelper, DoubleRectangle doubleRectangle, DataPointAesthetics dataPointAesthetics, Function1 function1, int n, Object object) {
            if ((n & 4) != 0) {
                function1 = (Function1)new Function1<DataPointAesthetics, Double>((Object)AesScaling.INSTANCE){

                    @NotNull
                    public final Double invoke(@NotNull DataPointAesthetics p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((AesScaling)this.receiver).strokeWidth(p0);
                    }
                };
            }
            return svgElementHelper.createRectangle(doubleRectangle, dataPointAesthetics, (Function1<? super DataPointAesthetics, Double>)function1);
        }

        @Nullable
        public final Pair<SvgNode, List<DoubleVector>> createCurve(@NotNull DoubleVector start2, @NotNull DoubleVector end, double curvature, double angle, int ncp, @NotNull DataPointAesthetics p, @NotNull Function1<? super DataPointAesthetics, Double> strokeScaler) {
            Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter(strokeScaler, (String)"strokeScaler");
            if (Intrinsics.areEqual((Object)start2, (Object)end)) {
                return null;
            }
            DoubleVector doubleVector = (DoubleVector)this.toClient.invoke((Object)start2, (Object)p);
            if (doubleVector == null) {
                return null;
            }
            DoubleVector start3 = doubleVector;
            DoubleVector doubleVector2 = (DoubleVector)this.toClient.invoke((Object)end, (Object)p);
            if (doubleVector2 == null) {
                return null;
            }
            DoubleVector end2 = doubleVector2;
            List<DoubleVector> lineString = CurveKt.curve(start3, end2, curvature, angle, ncp);
            SvgNode svgNode = this.renderSvgElement(p, lineString, strokeScaler, false);
            if (svgNode == null) {
                return null;
            }
            SvgNode svgElement = svgNode;
            List<DoubleVector> geometry = this.takeGeometry(lineString, p);
            return TuplesKt.to((Object)svgElement, geometry);
        }

        public static /* synthetic */ Pair createCurve$default(SvgElementHelper svgElementHelper, DoubleVector doubleVector, DoubleVector doubleVector2, double d, double d2, int n, DataPointAesthetics dataPointAesthetics, Function1 function1, int n2, Object object) {
            if ((n2 & 0x40) != 0) {
                function1 = (Function1)new Function1<DataPointAesthetics, Double>((Object)AesScaling.INSTANCE){

                    @NotNull
                    public final Double invoke(@NotNull DataPointAesthetics p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((AesScaling)this.receiver).strokeWidth(p0);
                    }
                };
            }
            return svgElementHelper.createCurve(doubleVector, doubleVector2, d, d2, n, dataPointAesthetics, (Function1<? super DataPointAesthetics, Double>)function1);
        }

        @Nullable
        public final Pair<SvgNode, List<DoubleVector>> createLine(@NotNull DoubleSegment segment2, @NotNull DataPointAesthetics p, @NotNull Function1<? super DataPointAesthetics, Double> strokeScaler) {
            Intrinsics.checkNotNullParameter((Object)segment2, (String)"segment");
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter(strokeScaler, (String)"strokeScaler");
            return this.createLine(segment2.getStart(), segment2.getEnd(), p, strokeScaler);
        }

        public static /* synthetic */ Pair createLine$default(SvgElementHelper svgElementHelper, DoubleSegment doubleSegment, DataPointAesthetics dataPointAesthetics, Function1 function1, int n, Object object) {
            if ((n & 4) != 0) {
                function1 = (Function1)new Function1<DataPointAesthetics, Double>((Object)AesScaling.INSTANCE){

                    @NotNull
                    public final Double invoke(@NotNull DataPointAesthetics p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((AesScaling)this.receiver).strokeWidth(p0);
                    }
                };
            }
            return svgElementHelper.createLine(doubleSegment, dataPointAesthetics, (Function1<? super DataPointAesthetics, Double>)function1);
        }

        @Nullable
        public final Pair<SvgNode, List<DoubleVector>> createLine(@NotNull DoubleVector start2, @NotNull DoubleVector end, @NotNull DataPointAesthetics p, @NotNull Function1<? super DataPointAesthetics, Double> strokeScaler) {
            Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter(strokeScaler, (String)"strokeScaler");
            List<DoubleVector> list2 = this.createLineGeometry(start2, end, p);
            if (list2 == null) {
                return null;
            }
            List<DoubleVector> lineString = list2;
            SvgNode svgNode = this.renderSvgElement(p, lineString, strokeScaler, false);
            if (svgNode == null) {
                return null;
            }
            SvgNode svgElement = svgNode;
            List<DoubleVector> geometry = this.takeGeometry(lineString, p);
            return TuplesKt.to((Object)svgElement, geometry);
        }

        public static /* synthetic */ Pair createLine$default(SvgElementHelper svgElementHelper, DoubleVector doubleVector, DoubleVector doubleVector2, DataPointAesthetics dataPointAesthetics, Function1 function1, int n, Object object) {
            if ((n & 8) != 0) {
                function1 = (Function1)new Function1<DataPointAesthetics, Double>((Object)AesScaling.INSTANCE){

                    @NotNull
                    public final Double invoke(@NotNull DataPointAesthetics p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((AesScaling)this.receiver).strokeWidth(p0);
                    }
                };
            }
            return svgElementHelper.createLine(doubleVector, doubleVector2, dataPointAesthetics, (Function1<? super DataPointAesthetics, Double>)function1);
        }

        @Nullable
        public final Pair<SvgNode, List<DoubleVector>> createSpoke(@NotNull DoubleVector base, double angle, double radius, double pivot, @NotNull DataPointAesthetics p, @NotNull Function1<? super DataPointAesthetics, Double> strokeScaler) {
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter(strokeScaler, (String)"strokeScaler");
            DoubleVector spoke = new DoubleVector(radius * Math.cos(angle), radius * Math.sin(angle));
            DoubleVector start2 = base.subtract(spoke.mul(pivot));
            DoubleVector end = base.add(spoke.mul(1.0 - pivot));
            return this.createLine(start2, end, p, strokeScaler);
        }

        public static /* synthetic */ Pair createSpoke$default(SvgElementHelper svgElementHelper, DoubleVector doubleVector, double d, double d2, double d3, DataPointAesthetics dataPointAesthetics, Function1 function1, int n, Object object) {
            if ((n & 0x20) != 0) {
                function1 = (Function1)new Function1<DataPointAesthetics, Double>((Object)AesScaling.INSTANCE){

                    @NotNull
                    public final Double invoke(@NotNull DataPointAesthetics p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((AesScaling)this.receiver).strokeWidth(p0);
                    }
                };
            }
            return svgElementHelper.createSpoke(doubleVector, d, d2, d3, dataPointAesthetics, (Function1<? super DataPointAesthetics, Double>)function1);
        }

        private final List<DoubleVector> createLineGeometry(DoubleVector start2, DoubleVector end, DataPointAesthetics aes2) {
            Object[] objectArray = new DoubleVector[]{start2, end};
            return this.createLineGeometry(CollectionsKt.listOf((Object[])objectArray), aes2);
        }

        /*
         * WARNING - void declaration
         */
        private final List<DoubleVector> createLineGeometry(List<DoubleVector> points2, DataPointAesthetics aes2) {
            void $this$mapTo$iv$iv;
            if (this.myResamplingEnabled) {
                return AdaptiveResampler.Companion.resample(points2, this.myResamplingPrecision, (Function1<? super DoubleVector, DoubleVector>)((Function1)new Function1<DoubleVector, DoubleVector>(this, aes2){
                    final /* synthetic */ SvgElementHelper this$0;
                    final /* synthetic */ DataPointAesthetics $aes;
                    {
                        this.this$0 = $receiver;
                        this.$aes = $aes;
                        super(1);
                    }

                    @Nullable
                    public final DoubleVector invoke(@NotNull DoubleVector it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return (DoubleVector)SvgElementHelper.access$getToClient$p(this.this$0).invoke((Object)it, (Object)this.$aes);
                    }
                }));
            }
            Iterable $this$map$iv = points2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DoubleVector doubleVector = (DoubleVector)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                DoubleVector doubleVector2 = (DoubleVector)this.toClient.invoke((Object)it, (Object)aes2);
                if (doubleVector2 == null) {
                    return null;
                }
                collection.add(doubleVector2);
            }
            return (List)destination$iv$iv;
        }

        private final List<DoubleVector> takeGeometry(List<DoubleVector> lineString, DataPointAesthetics p) {
            return this.myGeometryWithPadding ? this.padLineString(lineString, p, false) : lineString;
        }

        /*
         * WARNING - void declaration
         */
        private final SvgNode renderSvgElement(DataPointAesthetics p, List<DoubleVector> lineString, Function1<? super DataPointAesthetics, Double> strokeScaler, boolean filled) {
            SvgNode svgNode;
            List debugPoints;
            List list2;
            Object arrowElements;
            Object object;
            Object startHeadSvg;
            Object arrowSpec;
            SvgGraphicsElement lineElement;
            List<DoubleVector> lineStringAfterPadding;
            block15: {
                Object object2;
                block14: {
                    SvgGraphicsElement svgGraphicsElement;
                    SvgGraphicsElement svgGraphicsElement2;
                    if (this.myNoSvg) {
                        return new SvgGElement();
                    }
                    if (lineString.isEmpty() || lineString.size() == 1) {
                        return null;
                    }
                    lineStringAfterPadding = this.padLineString(lineString, p, true);
                    if (lineStringAfterPadding.size() == 2) {
                        SvgGraphicsElement $this$renderSvgElement_u24lambda_u2410 = svgGraphicsElement2 = new SvgLineElement();
                        boolean bl = false;
                        ((SvgLineElement)$this$renderSvgElement_u24lambda_u2410).x1().set(((DoubleVector)CollectionsKt.first(lineStringAfterPadding)).getX());
                        ((SvgLineElement)$this$renderSvgElement_u24lambda_u2410).y1().set(((DoubleVector)CollectionsKt.first(lineStringAfterPadding)).getY());
                        ((SvgLineElement)$this$renderSvgElement_u24lambda_u2410).x2().set(((DoubleVector)CollectionsKt.last(lineStringAfterPadding)).getX());
                        ((SvgLineElement)$this$renderSvgElement_u24lambda_u2410).y2().set(((DoubleVector)CollectionsKt.last(lineStringAfterPadding)).getY());
                        svgGraphicsElement = svgGraphicsElement2;
                    } else {
                        SvgPathData svgPathData;
                        SvgGraphicsElement $this$renderSvgElement_u24lambda_u2411 = svgGraphicsElement2 = new SvgPathElement();
                        boolean bl = false;
                        Property<SvgPathData> property2 = ((SvgPathElement)$this$renderSvgElement_u24lambda_u2411).d();
                        if (this.myInterpolation != null) {
                            SvgPathDataBuilder svgPathDataBuilder = new SvgPathDataBuilder(false, 1, null).moveTo((DoubleVector)CollectionsKt.first(lineStringAfterPadding));
                            Collection collection = lineStringAfterPadding;
                            SvgPathDataBuilder.Interpolation interpolation = this.myInterpolation;
                            Intrinsics.checkNotNull((Object)((Object)interpolation));
                            svgPathData = svgPathDataBuilder.interpolatePoints(collection, interpolation).build();
                        } else {
                            svgPathData = PathUtilKt.lineString(new SvgPathDataBuilder(false, 1, null), lineStringAfterPadding).build();
                        }
                        property2.set(svgPathData);
                        svgGraphicsElement = svgGraphicsElement2;
                    }
                    lineElement = svgGraphicsElement;
                    Companion.decorate((SvgShape)((Object)lineElement), p, this.myStrokeAlphaEnabled, strokeScaler, filled);
                    object2 = this.myArrowSpec;
                    if (object2 == null) break block14;
                    arrowSpec = object2;
                    boolean bl = false;
                    Pair<List<DoubleVector>, List<DoubleVector>> pair2 = ArrowSupport.INSTANCE.createArrowHeads(lineStringAfterPadding, ((ArrowSpec)arrowSpec).getAngle(), ((ArrowSpec)arrowSpec).getLength(), ((ArrowSpec)arrowSpec).isOnFirstEnd(), ((ArrowSpec)arrowSpec).isOnLastEnd(), ((ArrowSpec)arrowSpec).getType() == ArrowSpec.Type.CLOSED, 10.0, 5.0);
                    List startHead = (List)pair2.component1();
                    List endHead = (List)pair2.component2();
                    startHeadSvg = this.renderArrowHead(startHead, p, strokeScaler);
                    SvgNode endHeadSvg = this.renderArrowHead(endHead, p, strokeScaler);
                    object = new SvgNode[]{startHeadSvg, endHeadSvg};
                    List list3 = CollectionsKt.listOfNotNull((Object[])object);
                    object2 = list3;
                    if (list3 != null) break block15;
                }
                object2 = arrowElements = CollectionsKt.emptyList();
            }
            if (this.myDebugRendering) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = lineStringAfterPadding;
                boolean $i$f$map = false;
                arrowSpec = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    startHeadSvg = (DoubleVector)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Object $this$renderSvgElement_u24lambda_u2414_u24lambda_u2413 = object = new SvgCircleElement(it.getX(), it.getY(), 1.0);
                    boolean bl2 = false;
                    ((SvgCircleElement)$this$renderSvgElement_u24lambda_u2414_u24lambda_u2413).fillColor().set(Color.Companion.getLIGHT_GREEN());
                    ((SvgCircleElement)$this$renderSvgElement_u24lambda_u2414_u24lambda_u2413).strokeColor().set(Color.Companion.getGREEN());
                    collection.add(object);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = debugPoints = CollectionsKt.emptyList();
            }
            if (arrowElements.isEmpty() && debugPoints.isEmpty()) {
                svgNode = lineElement;
            } else {
                SvgGElement svgGElement;
                SvgGElement $this$renderSvgElement_u24lambda_u2415 = svgGElement = new SvgGElement();
                boolean bl = false;
                $this$renderSvgElement_u24lambda_u2415.children().add(lineElement);
                $this$renderSvgElement_u24lambda_u2415.children().addAll((Collection)arrowElements);
                $this$renderSvgElement_u24lambda_u2415.children().addAll(debugPoints);
                svgNode = svgGElement;
            }
            return svgNode;
        }

        /*
         * WARNING - void declaration
         */
        private final SvgNode renderArrowHead(List<DoubleVector> points2, DataPointAesthetics p, Function1<? super DataPointAesthetics, Double> strokeScaler) {
            SvgPathDataBuilder svgPathDataBuilder;
            SvgPathElement svgPathElement;
            if (points2.size() < 2) {
                return null;
            }
            ArrowSpec arrowSpec = this.myArrowSpec;
            if (arrowSpec == null) {
                return null;
            }
            ArrowSpec arrowSpec2 = arrowSpec;
            SvgPathElement $this$renderArrowHead_u24lambda_u2417 = svgPathElement = new SvgPathElement();
            boolean bl = false;
            $this$renderArrowHead_u24lambda_u2417.strokeMiterLimit().set(ArrowSupport.INSTANCE.miterLength(arrowSpec2.getAngle(), AesScaling.INSTANCE.strokeWidth(p)) * (double)2);
            SvgPathDataBuilder svgPathDataBuilder2 = svgPathDataBuilder = PathUtilKt.lineString(new SvgPathDataBuilder(false, 1, null), points2);
            Property<SvgPathData> property2 = $this$renderArrowHead_u24lambda_u2417.d();
            boolean bl2 = false;
            if (arrowSpec2.getType() == ArrowSpec.Type.CLOSED) {
                void it;
                it.closePath();
            }
            property2.set(svgPathDataBuilder.build());
            SvgPathElement arrowSvg = svgPathElement;
            Companion.decorate(arrowSvg, ArrowSpec.Companion.toArrowAes$plot_base(arrowSpec2, p), this.myStrokeAlphaEnabled, strokeScaler, arrowSpec2.getType() == ArrowSpec.Type.CLOSED);
            return arrowSvg;
        }

        private final List<DoubleVector> padLineString(List<DoubleVector> lineString, DataPointAesthetics p, boolean padArrow) {
            double startPadding = this.mySpacer + AesScaling.INSTANCE.targetStartSize(p) + (padArrow ? this.arrowPadding(p, true) : 0.0);
            double endPadding = this.mySpacer + AesScaling.INSTANCE.targetEndSize(p) + (padArrow ? this.arrowPadding(p, false) : 0.0);
            return PaddingKt.padLineString(lineString, startPadding, endPadding);
        }

        private final double arrowPadding(DataPointAesthetics aes2, boolean atStart) {
            boolean hasArrow;
            ArrowSpec arrowSpec = this.myArrowSpec;
            if (arrowSpec == null) {
                return 0.0;
            }
            ArrowSpec arrowSpec2 = arrowSpec;
            double newVer = ArrowSupport.INSTANCE.arrowPadding(arrowSpec2.getAngle(), arrowSpec2.isOnFirstEnd(), arrowSpec2.isOnLastEnd(), atStart, AesScaling.INSTANCE.strokeWidth(aes2));
            boolean bl = hasArrow = atStart ? arrowSpec2.isOnFirstEnd() : arrowSpec2.isOnLastEnd();
            if (!hasArrow) {
                return 0.0;
            }
            return newVer;
        }

        public SvgElementHelper() {
            this(null, 1, null);
        }

        public static final /* synthetic */ Function2 access$getToClient$p(SvgElementHelper $this) {
            return $this.toClient;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DimensionUnit.values().length];
            try {
                nArray[DimensionUnit.RESOLUTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DimensionUnit.IDENTITY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DimensionUnit.SIZE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DimensionUnit.PIXEL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

