/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.scale.breaks;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.scale.BreaksGenerator;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.scale.breaks.TimeBreaksHelper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001c\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/breaks/TimeBreaksGen;", "Lorg/jetbrains/letsPlot/core/plot/base/scale/BreaksGenerator;", "providedFormatter", "Lkotlin/Function1;", "", "", "(Lkotlin/jvm/functions/Function1;)V", "defaultFormatter", "domain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "targetCount", "", "generateBreaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "plot-base"})
public final class TimeBreaksGen
implements BreaksGenerator {
    @Nullable
    private final Function1<Object, String> providedFormatter;

    public TimeBreaksGen(@Nullable Function1<Object, String> providedFormatter) {
        this.providedFormatter = providedFormatter;
    }

    public /* synthetic */ TimeBreaksGen(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        this((Function1<Object, String>)function1);
    }

    @Override
    @NotNull
    public ScaleBreaks generateBreaks(@NotNull DoubleSpan domain, int targetCount) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        TimeBreaksHelper helper2 = new TimeBreaksHelper(domain.getLowerEnd(), domain.getUpperEnd(), targetCount, this.providedFormatter);
        List<Double> ticks = helper2.getBreaks();
        List<String> labels = helper2.formatBreaks(ticks);
        return ScaleBreaks.ContinuousFlex.INSTANCE.noTransform(ticks, helper2.getFormatter(), labels);
    }

    @Override
    @NotNull
    public Function1<Object, String> defaultFormatter(@NotNull DoubleSpan domain, int targetCount) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        return new TimeBreaksHelper(domain.getLowerEnd(), domain.getUpperEnd(), targetCount, null).getFormatter();
    }

    public TimeBreaksGen() {
        this(null, 1, null);
    }
}

