/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.ext.awt.image.rendered;

import java.util.ArrayList;

public class TileBlock {
    int occX;
    int occY;
    int occW;
    int occH;
    int xOff;
    int yOff;
    int w;
    int h;
    int benefit;
    boolean[] occupied;

    TileBlock(int occX, int occY, int occW, int occH, boolean[] occupied, int xOff, int yOff, int w, int h) {
        this.occX = occX;
        this.occY = occY;
        this.occW = occW;
        this.occH = occH;
        this.xOff = xOff;
        this.yOff = yOff;
        this.w = w;
        this.h = h;
        this.occupied = occupied;
        for (int y2 = 0; y2 < h; ++y2) {
            for (int x2 = 0; x2 < w; ++x2) {
                if (occupied[x2 + xOff + occW * (y2 + yOff)]) continue;
                ++this.benefit;
            }
        }
    }

    public String toString() {
        String ret = "";
        for (int y2 = 0; y2 < this.occH; ++y2) {
            for (int x2 = 0; x2 < this.occW + 1; ++x2) {
                ret = x2 == this.xOff || x2 == this.xOff + this.w ? (y2 == this.yOff || y2 == this.yOff + this.h - 1 ? ret + "+" : (y2 > this.yOff && y2 < this.yOff + this.h - 1 ? ret + "|" : ret + " ")) : (y2 == this.yOff && x2 > this.xOff && x2 < this.xOff + this.w ? ret + "-" : (y2 == this.yOff + this.h - 1 && x2 > this.xOff && x2 < this.xOff + this.w ? ret + "_" : ret + " "));
                if (x2 == this.occW) continue;
                ret = this.occupied[x2 + y2 * this.occW] ? ret + "*" : ret + ".";
            }
            ret = ret + "\n";
        }
        return ret;
    }

    int getXLoc() {
        return this.occX + this.xOff;
    }

    int getYLoc() {
        return this.occY + this.yOff;
    }

    int getWidth() {
        return this.w;
    }

    int getHeight() {
        return this.h;
    }

    int getBenefit() {
        return this.benefit;
    }

    int getWork() {
        return this.w * this.h + 1;
    }

    static int getWork(TileBlock[] blocks) {
        int ret = 0;
        for (TileBlock block : blocks) {
            ret += block.getWork();
        }
        return ret;
    }

    TileBlock[] getBestSplit() {
        if (this.simplify()) {
            return null;
        }
        if (this.benefit == this.w * this.h) {
            return new TileBlock[]{this};
        }
        return this.splitOneGo();
    }

    public TileBlock[] splitOneGo() {
        boolean[] filled = (boolean[])this.occupied.clone();
        ArrayList<TileBlock> items = new ArrayList<TileBlock>();
        for (int y2 = this.yOff; y2 < this.yOff + this.h; ++y2) {
            for (int x2 = this.xOff; x2 < this.xOff + this.w; ++x2) {
                if (filled[x2 + y2 * this.occW]) continue;
                int cw = this.xOff + this.w - x2;
                for (int cx = x2; cx < x2 + cw; ++cx) {
                    if (filled[cx + y2 * this.occW]) {
                        cw = cx - x2;
                        continue;
                    }
                    filled[cx + y2 * this.occW] = true;
                }
                int ch = 1;
                for (int cy = y2 + 1; cy < this.yOff + this.h; ++cy) {
                    int cx;
                    for (cx = x2; cx < x2 + cw && !filled[cx + cy * this.occW]; ++cx) {
                    }
                    if (cx != x2 + cw) break;
                    for (cx = x2; cx < x2 + cw; ++cx) {
                        filled[cx + cy * this.occW] = true;
                    }
                    ++ch;
                }
                items.add(new TileBlock(this.occX, this.occY, this.occW, this.occH, this.occupied, x2, y2, cw, ch));
                x2 += cw - 1;
            }
        }
        TileBlock[] ret = new TileBlock[items.size()];
        items.toArray(ret);
        return ret;
    }

    public boolean simplify() {
        int y2;
        int x2;
        int x3;
        int y3;
        boolean[] workOccupied = this.occupied;
        for (y3 = 0; y3 < this.h; ++y3) {
            for (x3 = 0; x3 < this.w && workOccupied[x3 + this.xOff + this.occW * (y3 + this.yOff)]; ++x3) {
            }
            if (x3 != this.w) break;
            ++this.yOff;
            --y3;
            --this.h;
        }
        if (this.h == 0) {
            return true;
        }
        for (y3 = this.h - 1; y3 >= 0; --y3) {
            for (x3 = 0; x3 < this.w && workOccupied[x3 + this.xOff + this.occW * (y3 + this.yOff)]; ++x3) {
            }
            if (x3 != this.w) break;
            --this.h;
        }
        for (x2 = 0; x2 < this.w; ++x2) {
            for (y2 = 0; y2 < this.h && workOccupied[x2 + this.xOff + this.occW * (y2 + this.yOff)]; ++y2) {
            }
            if (y2 != this.h) break;
            ++this.xOff;
            --x2;
            --this.w;
        }
        for (x2 = this.w - 1; x2 >= 0; --x2) {
            for (y2 = 0; y2 < this.h && workOccupied[x2 + this.xOff + this.occW * (y2 + this.yOff)]; ++y2) {
            }
            if (y2 != this.h) break;
            --this.w;
        }
        return false;
    }
}

