/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.model.typed;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.model.VueDirective;
import org.jetbrains.vuejs.model.VueDirectiveModifier;
import org.jetbrains.vuejs.model.VueMode;
import org.jetbrains.vuejs.model.typed.VueTypedContainer;
import org.jetbrains.vuejs.model.typed.VueTypedDirectives;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00000\u0019H\u0016J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006 "}, d2={"Lorg/jetbrains/vuejs/model/typed/VueTypedDirective;", "Lorg/jetbrains/vuejs/model/typed/VueTypedContainer;", "Lorg/jetbrains/vuejs/model/VueDirective;", "source", "Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptPropertySignature;", "defaultName", "", "<init>", "(Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptPropertySignature;Ljava/lang/String;)V", "getSource", "()Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptPropertySignature;", "getDefaultName", "()Ljava/lang/String;", "jsType", "Lcom/intellij/lang/javascript/psi/JSType;", "getJsType", "()Lcom/intellij/lang/javascript/psi/JSType;", "thisType", "getThisType", "modifiers", "", "Lorg/jetbrains/vuejs/model/VueDirectiveModifier;", "getModifiers", "()Ljava/util/List;", "createPointer", "Lcom/intellij/model/Pointer;", "equals", "", "other", "", "hashCode", "", "intellij.vuejs.backend"})
public final class VueTypedDirective
extends VueTypedContainer
implements VueDirective {
    @NotNull
    private final TypeScriptPropertySignature source;
    @NotNull
    private final String defaultName;

    public VueTypedDirective(@NotNull TypeScriptPropertySignature source, @NotNull String defaultName) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)defaultName, (String)"defaultName");
        super((PsiElement)source);
        this.source = source;
        this.defaultName = defaultName;
    }

    @NotNull
    public TypeScriptPropertySignature getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public String getDefaultName() {
        return this.defaultName;
    }

    @Override
    @Nullable
    public JSType getJsType() {
        return this.getSource().getJSType();
    }

    @Override
    @NotNull
    public JSType getThisType() {
        JSAnyType.JSAnyTypeImpl jSAnyTypeImpl = JSAnyType.getWithLanguage((JSTypeSource.SourceLanguage)JSTypeSource.SourceLanguage.TS);
        Intrinsics.checkNotNullExpressionValue((Object)jSAnyTypeImpl, (String)"getWithLanguage(...)");
        return (JSType)jSAnyTypeImpl;
    }

    @Override
    @NotNull
    public List<VueDirectiveModifier> getModifiers() {
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)this.getSource()), () -> VueTypedDirective._get_modifiers_$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    @NotNull
    public Pointer<VueTypedDirective> createPointer() {
        SmartPsiElementPointer sourcePtr = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)this.getSource()));
        String defaultName = this.getDefaultName();
        return () -> VueTypedDirective.createPointer$lambda$0(sourcePtr, defaultName);
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof VueTypedDirective && Intrinsics.areEqual((Object)((VueTypedDirective)other).getSource(), (Object)this.getSource());
    }

    public int hashCode() {
        return this.getSource().hashCode();
    }

    private static final CachedValueProvider.Result _get_modifiers_$lambda$0(VueTypedDirective this$0) {
        List<VueDirectiveModifier> list = VueTypedDirectives.INSTANCE.getDirectiveModifiers(this$0.getSource(), VueMode.CLASSIC);
        Object[] objectArray = new Object[2];
        Project project = this$0.getSource().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        objectArray[0] = DumbService.Companion.getInstance(project).getModificationTracker();
        objectArray[1] = PsiModificationTracker.MODIFICATION_COUNT;
        return CachedValueProvider.Result.create(list, (Object[])objectArray);
    }

    private static final VueTypedDirective createPointer$lambda$0(SmartPsiElementPointer $sourcePtr, String $defaultName) {
        TypeScriptPropertySignature typeScriptPropertySignature = (TypeScriptPropertySignature)$sourcePtr.dereference();
        if (typeScriptPropertySignature == null) {
            return null;
        }
        TypeScriptPropertySignature source = typeScriptPropertySignature;
        return new VueTypedDirective(source, $defaultName);
    }
}

