/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.inspections;

import com.intellij.css.util.CssPsiUtilCore;
import com.intellij.lang.Language;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssFunctionDescriptor;
import com.intellij.psi.css.descriptor.CssFunctionDescriptorStub;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptor;
import com.intellij.psi.css.descriptor.CssPseudoSelectorDescriptorStub;
import com.intellij.psi.css.descriptor.value.CssValueDescriptor;
import com.intellij.psi.css.descriptor.value.CssValueValidator;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.descriptor.value.CssNameValue;
import com.intellij.psi.css.impl.descriptor.value.CssValueValidatorImpl;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorFactory2;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorProviderImpl;
import com.intellij.psi.css.resolve.CssStyleReferenceStub;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSLanguage;
import org.jetbrains.plugins.scss.SASSSCSSLangUtil;
import org.jetbrains.plugins.scss.SCSSLanguage;
import org.jetbrains.plugins.scss.psi.SCSSInterpolationImpl;
import org.jetbrains.plugins.scss.psi.SassScssMixinDeclaration;
import org.jetbrains.plugins.scss.psi.SassScssPropertyRuleset;
import org.jetbrains.plugins.scss.psi.SassScssVariableImpl;
import org.jetbrains.plugins.scss.references.SassScssFunctionReference;

public class SassScssElementDescriptorProvider
extends CssElementDescriptorProviderImpl {
    private static final CssPseudoSelectorDescriptor EXPORT_PSEUDO_SELECTOR_DESCRIPTOR = new CssPseudoSelectorDescriptorStub("export");
    private final CssValueValidatorImpl SASS_VALUE_VALIDATOR = new CssValueValidatorImpl(this, (CssElementDescriptorProvider)this){

        public boolean isValid(@Nullable PsiElement term, @NotNull CssValueDescriptor valueDescriptor) {
            if (valueDescriptor == null) {
                1.$$$reportNull$$$0(0);
            }
            if (term instanceof CssTermList && ((CssTermList)term).getTerms().length == 1) {
                term = (PsiElement)ArrayUtil.getFirstElement((Object[])((CssTermList)term).getTerms());
            }
            if (valueDescriptor instanceof CssNameValue && term != null && term.getTextLength() == 1 && "&".equals(term.getText())) {
                return true;
            }
            if (term instanceof CssTerm && ((CssTerm)term).getTermType() == CssTermTypes.TOGGLE) {
                return super.isValid(term, valueDescriptor);
            }
            if (term != null && (term instanceof SassScssVariableImpl || term.getFirstChild() instanceof SassScssVariableImpl || term instanceof SCSSInterpolationImpl)) {
                return true;
            }
            boolean result = super.isValid(term, valueDescriptor);
            if (!result && term != null) {
                PsiElement firstChild = term.getFirstChild();
                if (firstChild instanceof CssFunction) {
                    term = firstChild;
                }
                if (term instanceof CssFunction) {
                    CssFunction functionTerm = (CssFunction)term;
                    return 1.isValidCssFunctionTerm(functionTerm);
                }
            }
            return result;
        }

        private static boolean isValidCssFunctionTerm(CssFunction functionTerm) {
            boolean isNotStandardCssFunction = CssElementDescriptorFactory2.getInstance().findFunction(functionTerm.getName()).isEmpty();
            if (isNotStandardCssFunction) {
                return true;
            }
            if (DumbService.isDumb((Project)functionTerm.getProject())) {
                return false;
            }
            ResolveResult[] results = SassScssFunctionReference.resolveByName(functionTerm.getName(), (PsiElement)functionTerm, false);
            return results.length > 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueDescriptor", "org/jetbrains/plugins/scss/inspections/SassScssElementDescriptorProvider$1", "isValid"));
        }
    };

    @NotNull
    public Collection<? extends CssFunctionDescriptor> findFunctionDescriptors(@NotNull String functionName, @Nullable PsiElement context) {
        Object[] results;
        if (functionName == null) {
            SassScssElementDescriptorProvider.$$$reportNull$$$0(0);
        }
        if (context != null && !DumbService.isDumb((Project)context.getProject()) && (results = SassScssFunctionReference.resolveByName(functionName, context, false)).length > 0) {
            List list = ContainerUtil.map((Object[])results, result -> new CssFunctionDescriptorStub(functionName, (CssValueDescriptor)CssElementDescriptorFactory2.getInstance().createAnyValueDescriptor(0, -1, null)));
            if (list == null) {
                SassScssElementDescriptorProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        Collection collection = super.findFunctionDescriptors(functionName, context);
        if (collection == null) {
            SassScssElementDescriptorProvider.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public Collection<? extends CssPseudoSelectorDescriptor> findPseudoSelectorDescriptors(@NotNull String name, @Nullable PsiElement context) {
        if (name == null) {
            SassScssElementDescriptorProvider.$$$reportNull$$$0(3);
        }
        Collection<Object> collection = name.equals("export") ? Collections.singletonList(EXPORT_PSEUDO_SELECTOR_DESCRIPTOR) : super.findPseudoSelectorDescriptors(name, context);
        if (collection == null) {
            SassScssElementDescriptorProvider.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public Collection<? extends CssPseudoSelectorDescriptor> getAllPseudoSelectorDescriptors(@Nullable PsiElement context) {
        if (PsiTreeUtil.getParentOfType((PsiElement)context, SassScssPropertyRuleset.class) != null) {
            List list = Collections.emptyList();
            if (list == null) {
                SassScssElementDescriptorProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        CssContextType contextType = this.getCssContextType(context);
        if (contextType == CssContextType.NONAME) {
            ArrayList<CssPseudoSelectorDescriptor> result = new ArrayList<CssPseudoSelectorDescriptor>(super.getAllPseudoSelectorDescriptors(context));
            result.add(EXPORT_PSEUDO_SELECTOR_DESCRIPTOR);
            ArrayList<CssPseudoSelectorDescriptor> arrayList = result;
            if (arrayList == null) {
                SassScssElementDescriptorProvider.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        Collection collection = super.getAllPseudoSelectorDescriptors(context);
        if (collection == null) {
            SassScssElementDescriptorProvider.$$$reportNull$$$0(7);
        }
        return collection;
    }

    public boolean isMyContext(@Nullable PsiElement context) {
        Language stylesheetLanguage = CssPsiUtilCore.getStylesheetLanguage((PsiElement)context);
        return SASSLanguage.INSTANCE.is(stylesheetLanguage) || SCSSLanguage.INSTANCE.is(stylesheetLanguage);
    }

    @NotNull
    public String restoreFullPropertyName(@NotNull String propertyName, @Nullable PsiElement context) {
        if (propertyName == null) {
            SassScssElementDescriptorProvider.$$$reportNull$$$0(8);
        }
        String string = SASSSCSSLangUtil.restoreFullPropertyName(propertyName, context);
        if (string == null) {
            SassScssElementDescriptorProvider.$$$reportNull$$$0(9);
        }
        return string;
    }

    public CssPropertyDescriptor getPropertyDescriptor(@NotNull String propertyName, @Nullable PsiElement context) {
        if (propertyName == null) {
            SassScssElementDescriptorProvider.$$$reportNull$$$0(10);
        }
        propertyName = this.restoreFullPropertyName(propertyName, context);
        return super.getPropertyDescriptor(propertyName, context);
    }

    @NotNull
    public Collection<? extends CssPropertyDescriptor> findPropertyDescriptors(@NotNull String propertyName, @Nullable PsiElement context) {
        if (propertyName == null) {
            SassScssElementDescriptorProvider.$$$reportNull$$$0(11);
        }
        Collection collection = super.findPropertyDescriptors(this.restoreFullPropertyName(propertyName, context), context);
        if (collection == null) {
            SassScssElementDescriptorProvider.$$$reportNull$$$0(12);
        }
        return collection;
    }

    public PsiElement @NotNull [] getDeclarationsForSimpleSelector(@NotNull CssSimpleSelector selector) {
        if (selector == null) {
            SassScssElementDescriptorProvider.$$$reportNull$$$0(13);
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            SassScssElementDescriptorProvider.$$$reportNull$$$0(14);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public boolean providesClassicCss() {
        return false;
    }

    public CssContextType getCssContextType(@Nullable PsiElement context) {
        SassScssMixinDeclaration mixin;
        CssContextType ruleType = super.getCssContextType(context);
        if (ruleType == CssContextType.NONE && (mixin = (SassScssMixinDeclaration)PsiTreeUtil.getParentOfType((PsiElement)context, SassScssMixinDeclaration.class)) != null) {
            return CssContextType.ANY;
        }
        return ruleType;
    }

    public boolean skipCssPropertyCheck(@NotNull CssDeclaration declaration) {
        if (declaration == null) {
            SassScssElementDescriptorProvider.$$$reportNull$$$0(15);
        }
        if (declaration.getParent() instanceof CssBlock && declaration.getParent().getParent() instanceof CssRuleset) {
            CssSelector[] selectors = ((CssRuleset)declaration.getParent().getParent()).getSelectors();
            CssSimpleSelector[] simpleSelectors = selectors.length == 1 ? selectors[0].getSimpleSelectors() : CssSimpleSelector.EMPTY_ARRAY;
            CssSelectorSuffix[] suffixes = simpleSelectors.length == 1 ? simpleSelectors[0].getSelectorSuffixes() : CssSelectorSuffix.EMPTY_ARRAY;
            return suffixes.length == 1 && suffixes[0].getType() == CssSelectorSuffixType.UNKNOWN && selectors[0].getText().equals(":export");
        }
        return super.skipCssPropertyCheck(declaration);
    }

    @NotNull
    public PsiReference getStyleReference(PsiElement element, int start, int end, boolean caseSensitive) {
        return new CssStyleReferenceStub(element, TextRange.create((int)start, (int)end));
    }

    @NotNull
    public CssValueValidator getValueValidator() {
        CssValueValidatorImpl cssValueValidatorImpl = this.SASS_VALUE_VALIDATOR;
        if (cssValueValidatorImpl == null) {
            SassScssElementDescriptorProvider.$$$reportNull$$$0(16);
        }
        return cssValueValidatorImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 6, 7, 9, 12, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/scss/inspections/SassScssElementDescriptorProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/scss/inspections/SassScssElementDescriptorProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findFunctionDescriptors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findPseudoSelectorDescriptors";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPseudoSelectorDescriptors";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "restoreFullPropertyName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findPropertyDescriptors";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationsForSimpleSelector";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueValidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFunctionDescriptors";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findPseudoSelectorDescriptors";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "restoreFullPropertyName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyDescriptor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findPropertyDescriptors";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationsForSimpleSelector";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "skipCssPropertyCheck";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 6, 7, 9, 12, 14, 16 -> new IllegalStateException(string);
        };
    }
}

