/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.config;

import com.intellij.codeInsight.TailType;
import com.intellij.microservices.jvm.config.ConfigKeyPathContext;
import com.intellij.microservices.jvm.config.ConfigKeyPathReference;
import com.intellij.microservices.jvm.config.ConfigKeyPathReferenceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigKeyPathUtils {
    public static final Key<TailType> TAIL_TYPE_KEY = Key.create((String)"ConfigKeyPathTailType");

    private ConfigKeyPathUtils() {
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static PsiType unwrapIndexed(@Nullable PsiType type) {
        if (type == null) {
            return null;
        }
        if (type instanceof PsiArrayType) {
            return ((PsiArrayType)type).getComponentType();
        }
        PsiType parameterType = ConfigKeyPathUtils.getTypeParameter(type, "java.util.List", 0);
        if (parameterType == null) {
            parameterType = ConfigKeyPathUtils.getTypeParameter(type, "java.util.Set", 0);
        }
        return parameterType != null ? ConfigKeyPathUtils.unwrapIndexed(parameterType) : type;
    }

    public static boolean stopResolvingProperty(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ConfigKeyPathUtils.$$$reportNull$$$0(0);
        }
        return psiClass.getQualifiedName() == null || psiClass.getQualifiedName().startsWith("java.lang.") || psiClass.isEnum();
    }

    @Nullable
    public static PsiType getTypeParameter(@Nullable PsiType type, @NotNull String requiredBaseClass, int index) {
        if (requiredBaseClass == null) {
            ConfigKeyPathUtils.$$$reportNull$$$0(1);
        }
        if (type instanceof PsiClassType && InheritanceUtil.isInheritor((PsiType)type, (String)requiredBaseClass)) {
            PsiType[] parameters = ((PsiClassType)type).getParameters();
            if (parameters.length == 0) {
                return ConfigKeyPathUtils.getObjectType(type.getResolveScope());
            }
            if (parameters.length < index + 1) {
                return null;
            }
            return parameters[index];
        }
        return null;
    }

    public static PsiType getObjectType(@NotNull GlobalSearchScope scope) {
        Project project;
        if (scope == null) {
            ConfigKeyPathUtils.$$$reportNull$$$0(2);
        }
        if ((project = scope.getProject()) == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)project).getElementFactory().createTypeByFQClassName("java.lang.Object", scope);
    }

    @Nullable
    public static PsiType getMapKeyType(@Nullable PsiType psiType) {
        return ConfigKeyPathUtils.getTypeParameter(psiType, "java.util.Map", 0);
    }

    @Nullable
    public static PsiType getMapValueType(@Nullable PsiType psiType) {
        return ConfigKeyPathUtils.getTypeParameter(psiType, "java.util.Map", 1);
    }

    @NotNull
    public static ConfigKeyPathReference getNext(@NotNull PsiElement element, @NotNull ConfigKeyPathContext context) {
        if (element == null) {
            ConfigKeyPathUtils.$$$reportNull$$$0(3);
        }
        if (context == null) {
            ConfigKeyPathUtils.$$$reportNull$$$0(4);
        }
        return new ConfigKeyPathReferenceImpl(element, context);
    }

    @Nullable
    public static PsiClass getPsiClass(@Nullable PsiType psiType) {
        if (psiType instanceof PsiWildcardType) {
            PsiWildcardType wildcardType = (PsiWildcardType)psiType;
            psiType = wildcardType.getExtendsBound();
        }
        return PsiTypesUtil.getPsiClass((PsiType)psiType);
    }

    @NotNull
    public static List<String> getEnumReferenceVariants(@NotNull String value) {
        if (value == null) {
            ConfigKeyPathUtils.$$$reportNull$$$0(5);
        }
        List<String> list = List.of(value, value.replace("-", "_"), value.replace("-", ""));
        if (list == null) {
            ConfigKeyPathUtils.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    public static PsiElement resolveEnumReference(@NotNull List<String> variants, @NotNull PsiClass psiClass, boolean ignoreCase) {
        if (variants == null) {
            ConfigKeyPathUtils.$$$reportNull$$$0(7);
        }
        if (psiClass == null) {
            ConfigKeyPathUtils.$$$reportNull$$$0(8);
        }
        return (PsiElement)ContainerUtil.find((Object[])psiClass.getFields(), field -> field instanceof PsiEnumConstant && ContainerUtil.or((Iterable)variants, name -> ignoreCase ? name.equalsIgnoreCase(field.getName()) : name.equals(field.getName())));
    }

    public static boolean hasIndexedAccess(@NotNull String value) {
        if (value == null) {
            ConfigKeyPathUtils.$$$reportNull$$$0(9);
        }
        return StringUtil.endsWithChar((CharSequence)value, (char)']') && StringUtil.containsChar((String)value, (char)'[');
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredBaseClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/microservices/jvm/config/ConfigKeyPathUtils";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/microservices/jvm/config/ConfigKeyPathUtils";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumReferenceVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "stopResolvingProperty";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameter";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getObjectType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNext";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getEnumReferenceVariants";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveEnumReference";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasIndexedAccess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

