/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.intellij.lang.xpath.XPath2ElementTypes;
import org.intellij.lang.xpath.XPath2Parser;
import org.intellij.lang.xpath.XPath2TokenTypes;
import org.intellij.lang.xpath.XPathFile;
import org.intellij.lang.xpath.XPathFileType;
import org.intellij.lang.xpath.XPathLexer;
import org.intellij.lang.xpath.XPathParserDefinition;
import org.intellij.lang.xpath.psi.impl.XPath2CastImpl;
import org.intellij.lang.xpath.psi.impl.XPath2CastableImpl;
import org.intellij.lang.xpath.psi.impl.XPath2ForImpl;
import org.intellij.lang.xpath.psi.impl.XPath2IfImpl;
import org.intellij.lang.xpath.psi.impl.XPath2InstanceOfImpl;
import org.intellij.lang.xpath.psi.impl.XPath2QuantifiedExprImpl;
import org.intellij.lang.xpath.psi.impl.XPath2RangeExpressionImpl;
import org.intellij.lang.xpath.psi.impl.XPath2SequenceImpl;
import org.intellij.lang.xpath.psi.impl.XPath2TreatAsImpl;
import org.intellij.lang.xpath.psi.impl.XPath2TypeElementImpl;
import org.intellij.lang.xpath.psi.impl.XPath2VariableDeclarationImpl;
import org.intellij.lang.xpath.psi.impl.XPath2VariableImpl;
import org.intellij.lang.xpath.psi.impl.XPathStepImpl;
import org.jetbrains.annotations.NotNull;

public class XPath2ParserDefinition
extends XPathParserDefinition {
    public static final IFileElementType FILE = new IFileElementType("XPATH2_FILE", XPathFileType.XPATH2.getLanguage());

    @Override
    @NotNull
    public Lexer createLexer(Project project) {
        Lexer lexer = XPathLexer.create(true);
        if (lexer == null) {
            XPath2ParserDefinition.$$$reportNull$$$0(0);
        }
        return lexer;
    }

    @Override
    @NotNull
    public IFileElementType getFileNodeType() {
        IFileElementType iFileElementType = FILE;
        if (iFileElementType == null) {
            XPath2ParserDefinition.$$$reportNull$$$0(1);
        }
        return iFileElementType;
    }

    @Override
    @NotNull
    public PsiParser createParser(Project project) {
        return new XPath2Parser();
    }

    @Override
    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{XPath2TokenTypes.COMMENT});
        if (tokenSet == null) {
            XPath2ParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @Override
    protected PsiElement createElement(IElementType type, ASTNode node) {
        PsiElement element = super.createElement(type, node);
        if (element != null) {
            return element;
        }
        if (type == XPath2ElementTypes.VARIABLE_DECL) {
            return new XPath2VariableImpl(node);
        }
        if (type == XPath2ElementTypes.CONTEXT_ITEM) {
            return new XPathStepImpl(node);
        }
        if (type == XPath2ElementTypes.IF) {
            return new XPath2IfImpl(node);
        }
        if (type == XPath2ElementTypes.QUANTIFIED) {
            return new XPath2QuantifiedExprImpl(node);
        }
        if (type == XPath2ElementTypes.FOR) {
            return new XPath2ForImpl(node);
        }
        if (type == XPath2ElementTypes.BINDING_SEQ) {
            return new XPath2VariableDeclarationImpl(node);
        }
        if (type == XPath2ElementTypes.SEQUENCE) {
            return new XPath2SequenceImpl(node);
        }
        if (type == XPath2ElementTypes.RANGE_EXPRESSION) {
            return new XPath2RangeExpressionImpl(node);
        }
        if (type == XPath2ElementTypes.CASTABLE_AS) {
            return new XPath2CastableImpl(node);
        }
        if (type == XPath2ElementTypes.CAST_AS) {
            return new XPath2CastImpl(node);
        }
        if (type == XPath2ElementTypes.INSTANCE_OF) {
            return new XPath2InstanceOfImpl(node);
        }
        if (type == XPath2ElementTypes.TREAT_AS) {
            return new XPath2TreatAsImpl(node);
        }
        if (XPath2ElementTypes.TYPE_ELEMENTS.contains(type)) {
            return new XPath2TypeElementImpl(node);
        }
        return null;
    }

    @Override
    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            XPath2ParserDefinition.$$$reportNull$$$0(3);
        }
        return new XPathFile(viewProvider, XPathFileType.XPATH2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/XPath2ParserDefinition";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNodeType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/XPath2ParserDefinition";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3 -> new IllegalArgumentException(string);
        };
    }
}

