/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.completion;

import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import org.intellij.lang.xpath.completion.AbstractLookup;
import org.intellij.lang.xpath.completion.FunctionLookup;
import org.intellij.lang.xpath.completion.NamespaceLookup;
import org.jetbrains.annotations.NotNull;

final class XPathInsertHandler {
    private static final Logger LOG = Logger.getInstance((String)XPathInsertHandler.class.getName());

    XPathInsertHandler() {
    }

    static void handleInsert(@NotNull InsertionContext context, @NotNull AbstractLookup item) {
        if (context == null) {
            XPathInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            XPathInsertHandler.$$$reportNull$$$0(1);
        }
        Object object = item.getObject();
        LOG.debug("object = " + String.valueOf(object));
        XPathInsertHandler.handleInsertImpl(context, item, context.getCompletionChar());
        Editor editor = context.getEditor();
        CharSequence charsSequence = editor.getDocument().getCharsSequence();
        CaretModel caretModel = editor.getCaretModel();
        int offset = caretModel.getOffset();
        if (item instanceof FunctionLookup) {
            if (XPathInsertHandler.charAt(charsSequence, offset) != '(') {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"()");
                if (((FunctionLookup)item).hasParameters()) {
                    caretModel.moveCaretRelatively(-1, 0, false, false, true);
                }
            } else {
                caretModel.moveCaretRelatively(1, 0, false, false, true);
            }
        } else if (item instanceof NamespaceLookup && XPathInsertHandler.charAt(charsSequence, offset) != ':') {
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)":");
            return;
        }
        if (context.getCompletionChar() == '\t') {
            if (XPathInsertHandler.charAt(charsSequence, offset) == ',') {
                caretModel.moveCaretRelatively(1, 0, false, false, true);
                while (true) {
                    int n = ++offset;
                    ++offset;
                    if (XPathInsertHandler.charAt(charsSequence, n) == ' ') {
                        caretModel.moveCaretRelatively(1, 0, false, false, true);
                        continue;
                    }
                    break;
                }
            } else if (XPathInsertHandler.isIdentifier(XPathInsertHandler.charAt(charsSequence, offset)) && XPathInsertHandler.isIdentifier(XPathInsertHandler.charAt(charsSequence, offset - 1))) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)" ");
            } else if (XPathInsertHandler.charAt(charsSequence, offset) == ':') {
                caretModel.moveCaretRelatively(1, 0, false, false, true);
            }
        }
    }

    private static char charAt(CharSequence charsSequence, int offset) {
        return charsSequence.length() > offset ? charsSequence.charAt(offset) : (char)'\u0000';
    }

    public static void handleInsertImpl(InsertionContext context, LookupElement item, char c) {
        boolean isOverwrite;
        XPathInsertHandler.adjustIdentifierEnd(context, item);
        int idEndOffset = context.getOffsetMap().getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET);
        boolean bl = isOverwrite = c == '\t';
        if (idEndOffset != context.getSelectionEndOffset() && isOverwrite) {
            context.getEditor().getDocument().deleteString(context.getSelectionEndOffset(), idEndOffset);
        }
    }

    private static void adjustIdentifierEnd(InsertionContext context, LookupElement item) {
        char c;
        int x;
        boolean isNamespace = item.getObject() instanceof NamespaceLookup;
        CharSequence charsSequence = context.getEditor().getDocument().getCharsSequence();
        int textLength = context.getEditor().getDocument().getTextLength();
        for (x = context.getSelectionEndOffset(); x < textLength && (XPathInsertHandler.isIdentifier(c = XPathInsertHandler.charAt(charsSequence, x)) || c == '*' || c == ':' && !isNamespace); ++x) {
        }
        context.getOffsetMap().addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, x);
    }

    private static boolean isIdentifier(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '-' || c == '.' || c == '_' || c == '$';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "item";
                break;
            }
        }
        objectArray[1] = "org/intellij/lang/xpath/completion/XPathInsertHandler";
        objectArray[2] = "handleInsert";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

