/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 125898393910378L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-17563380 - -28772, 17563380 - 27572, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-17563380 - -28773, 17563380 - 13865, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 53620242630984L;
                thread = Thread.currentThread();
                String string = SshAgentIpcService.n();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (string != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-1870893180 + -11060, -1870893180 + -21403, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-1870893180 + -11059, 1870893180 + 2118, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-1870893180 + -11054, -1870893180 + -17552, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                String string;
                l2 = 32232821846064L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    string = SshAgentIpcService.n();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(907790820 - (char)-13131, 907659750 + (char)-4180, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(907790820 - (char)-13128, 907790820 - (char)-5228, (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(907790820 - (char)-13129, -907790820 - -((char)-1121), (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (string != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(907790820 - (char)-13118, 907790820 - (char)-4575, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(907790820 - (char)-13119, -907659750 + -((char)-10335), (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(907790820 - (char)-13116, 907790820 - (char)-6146, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(907790820 - (char)-13118, 907790820 - (char)-4575, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(907790820 - (char)-13117, -907790820 - -((char)-7405), (int)l2));
            if (ActionTimestamp.n() != null) {
                SshAgentIpcService.n("okC9Gc");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                String string;
                block6: {
                    long l2 = 77697744981767L;
                    string = SshAgentIpcService.n();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (string != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (string != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        String string;
        long l2;
        block27: {
            block28: {
                l2 = 47720087993518L;
                String string2 = SshAgentIpcService.n();
                this.assertConnectionThread();
                string = string2;
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (string != null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1293660900 - (char)-32468, 1293660900 - 19621, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1293660900 - (char)-32472, 1293660900 - (char)-25721, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1293660900 - (char)-32469, -1293660900 - -29339, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string3 = WindowsNamedPipeAgentIpc.b(1293660900 - (char)-32472, 1293660900 - (char)-25721, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1293660900 - (char)-32470, 1293660900 - 24599, (int)l2) + this.state;
                        throw new IllegalArgumentException(string3.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1293660900 - (char)-32468, 1293660900 - 19621, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1293660900 - (char)-32472, 1293660900 - (char)-25721, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1293660900 - (char)-32471, -1293660900 - -20657, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (string != null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1293660900 - (char)-32468, 1293660900 - 19621, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1293660900 - (char)-32472, 1293660900 - (char)-25721, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1293660900 - (char)-32448, -1293660900 - -22745, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(1293660900 - (char)-32472, 1293660900 - (char)-25721, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1293660900 - (char)-32449, -1293660900 - -18316, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (string != null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string4 = WindowsNamedPipeAgentIpc.b(1293660900 - (char)-32472, 1293660900 - (char)-25721, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1293660900 - (char)-32470, 1293660900 - 24599, (int)l2) + this.state;
                throw new IllegalArgumentException(string4.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1293660900 - (char)-32468, 1293660900 - 19621, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1293660900 - (char)-32472, 1293660900 - (char)-25721, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1293660900 - (char)-32450, 1293660900 - (char)-25397, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 55855310230026L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-739496940 - -22442, 739496940 - (char)-12502, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 45161823088151L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(241955220 + (char)-29170, 241955220 + 20676, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "U\u001ax\u00df\u0097\u00bea\u0080\u00e8\u0098J\u00e3A\u009d\u0010\u0011\u0007\u00fbM\u0014:\u0088\u0095\u008b1\u00f6\u00c8\f_\u000fy\u00c5\u00e5\u00a0E=@\u00b8\u00a2\u0080";
                        var4_3 = "U\u001ax\u00df\u0097\u00bea\u0080\u00e8\u0098J\u00e3A\u009d\u0010\u0011\u0007\u00fbM\u0014:\u0088\u0095\u008b1\u00f6\u00c8\f_\u000fy\u00c5\u00e5\u00a0E=@\u00b8\u00a2\u0080".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 5;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 54;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 108;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 101;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 52;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 102;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 118;
                                        break;
                                    }
                                    default: {
                                        v11 = 44;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x51B4) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 153;
                            case 1 -> 69;
                            case 2 -> 185;
                            case 3 -> 83;
                            case 4 -> 218;
                            case 5 -> 131;
                            case 6 -> 156;
                            case 7 -> 216;
                            case 8 -> 2;
                            case 9 -> 232;
                            case 10 -> 6;
                            case 11 -> 116;
                            case 12 -> 220;
                            case 13 -> 146;
                            case 14 -> 95;
                            case 15 -> 4;
                            case 16 -> 181;
                            case 17 -> 117;
                            case 18 -> 180;
                            case 19 -> 74;
                            case 20 -> 255;
                            case 21 -> 25;
                            case 22 -> 195;
                            case 23 -> 136;
                            case 24 -> 3;
                            case 25 -> 106;
                            case 26 -> 86;
                            case 27 -> 26;
                            case 28 -> 141;
                            case 29 -> 203;
                            case 30 -> 147;
                            case 31 -> 22;
                            case 32 -> 75;
                            case 33 -> 222;
                            case 34 -> 154;
                            case 35 -> 87;
                            case 36 -> 193;
                            case 37 -> 210;
                            case 38 -> 251;
                            case 39 -> 72;
                            case 40 -> 23;
                            case 41 -> 14;
                            case 42 -> 19;
                            case 43 -> 239;
                            case 44 -> 178;
                            case 45 -> 196;
                            case 46 -> 97;
                            case 47 -> 244;
                            case 48 -> 63;
                            case 49 -> 225;
                            case 50 -> 211;
                            case 51 -> 84;
                            case 52 -> 126;
                            case 53 -> 164;
                            case 54 -> 212;
                            case 55 -> 125;
                            case 56 -> 49;
                            case 57 -> 62;
                            case 58 -> 176;
                            case 59 -> 122;
                            case 60 -> 250;
                            case 61 -> 67;
                            case 62 -> 188;
                            case 63 -> 76;
                            case 64 -> 40;
                            case 65 -> 73;
                            case 66 -> 182;
                            case 67 -> 103;
                            case 68 -> 35;
                            case 69 -> 82;
                            case 70 -> 13;
                            case 71 -> 171;
                            case 72 -> 135;
                            case 73 -> 36;
                            case 74 -> 31;
                            case 75 -> 32;
                            case 76 -> 223;
                            case 77 -> 21;
                            case 78 -> 10;
                            case 79 -> 214;
                            case 80 -> 139;
                            case 81 -> 165;
                            case 82 -> 201;
                            case 83 -> 7;
                            case 84 -> 110;
                            case 85 -> 43;
                            case 86 -> 96;
                            case 87 -> 66;
                            case 88 -> 213;
                            case 89 -> 190;
                            case 90 -> 42;
                            case 91 -> 194;
                            case 92 -> 65;
                            case 93 -> 202;
                            case 94 -> 102;
                            case 95 -> 119;
                            case 96 -> 38;
                            case 97 -> 47;
                            case 98 -> 241;
                            case 99 -> 114;
                            case 100 -> 17;
                            case 101 -> 54;
                            case 102 -> 192;
                            case 103 -> 189;
                            case 104 -> 209;
                            case 105 -> 230;
                            case 106 -> 118;
                            case 107 -> 81;
                            case 108 -> 56;
                            case 109 -> 224;
                            case 110 -> 99;
                            case 111 -> 100;
                            case 112 -> 37;
                            case 113 -> 12;
                            case 114 -> 148;
                            case 115 -> 187;
                            case 116 -> 5;
                            case 117 -> 172;
                            case 118 -> 41;
                            case 119 -> 0;
                            case 120 -> 152;
                            case 121 -> 163;
                            case 122 -> 159;
                            case 123 -> 151;
                            case 124 -> 101;
                            case 125 -> 1;
                            case 126 -> 235;
                            case 127 -> 174;
                            case 128 -> 231;
                            case 129 -> 207;
                            case 130 -> 175;
                            case 131 -> 142;
                            case 132 -> 111;
                            case 133 -> 77;
                            case 134 -> 166;
                            case 135 -> 104;
                            case 136 -> 51;
                            case 137 -> 199;
                            case 138 -> 60;
                            case 139 -> 145;
                            case 140 -> 80;
                            case 141 -> 64;
                            case 142 -> 107;
                            case 143 -> 78;
                            case 144 -> 221;
                            case 145 -> 124;
                            case 146 -> 143;
                            case 147 -> 120;
                            case 148 -> 92;
                            case 149 -> 18;
                            case 150 -> 252;
                            case 151 -> 108;
                            case 152 -> 149;
                            case 153 -> 238;
                            case 154 -> 247;
                            case 155 -> 33;
                            case 156 -> 133;
                            case 157 -> 169;
                            case 158 -> 173;
                            case 159 -> 27;
                            case 160 -> 186;
                            case 161 -> 200;
                            case 162 -> 144;
                            case 163 -> 128;
                            case 164 -> 246;
                            case 165 -> 57;
                            case 166 -> 236;
                            case 167 -> 79;
                            case 168 -> 129;
                            case 169 -> 20;
                            case 170 -> 158;
                            case 171 -> 71;
                            case 172 -> 94;
                            case 173 -> 226;
                            case 174 -> 138;
                            case 175 -> 183;
                            case 176 -> 85;
                            case 177 -> 8;
                            case 178 -> 157;
                            case 179 -> 127;
                            case 180 -> 53;
                            case 181 -> 90;
                            case 182 -> 59;
                            case 183 -> 93;
                            case 184 -> 44;
                            case 185 -> 112;
                            case 186 -> 11;
                            case 187 -> 61;
                            case 188 -> 170;
                            case 189 -> 162;
                            case 190 -> 109;
                            case 191 -> 234;
                            case 192 -> 98;
                            case 193 -> 68;
                            case 194 -> 58;
                            case 195 -> 179;
                            case 196 -> 217;
                            case 197 -> 245;
                            case 198 -> 34;
                            case 199 -> 160;
                            case 200 -> 15;
                            case 201 -> 228;
                            case 202 -> 28;
                            case 203 -> 155;
                            case 204 -> 121;
                            case 205 -> 204;
                            case 206 -> 91;
                            case 207 -> 215;
                            case 208 -> 9;
                            case 209 -> 105;
                            case 210 -> 137;
                            case 211 -> 46;
                            case 212 -> 177;
                            case 213 -> 197;
                            case 214 -> 198;
                            case 215 -> 140;
                            case 216 -> 233;
                            case 217 -> 115;
                            case 218 -> 48;
                            case 219 -> 208;
                            case 220 -> 55;
                            case 221 -> 253;
                            case 222 -> 206;
                            case 223 -> 161;
                            case 224 -> 70;
                            case 225 -> 52;
                            case 226 -> 16;
                            case 227 -> 45;
                            case 228 -> 88;
                            case 229 -> 134;
                            case 230 -> 249;
                            case 231 -> 30;
                            case 232 -> 229;
                            case 233 -> 240;
                            case 234 -> 248;
                            case 235 -> 132;
                            case 236 -> 242;
                            case 237 -> 24;
                            case 238 -> 89;
                            case 239 -> 243;
                            case 240 -> 123;
                            case 241 -> 167;
                            case 242 -> 254;
                            case 243 -> 184;
                            case 244 -> 227;
                            case 245 -> 205;
                            case 246 -> 29;
                            case 247 -> 168;
                            case 248 -> 39;
                            case 249 -> 130;
                            case 250 -> 219;
                            case 251 -> 50;
                            case 252 -> 113;
                            case 253 -> 191;
                            case 254 -> 150;
                            default -> 237;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (string != null) {
                ActionTimestamp.n(new int[5]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 130004429524315L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String string = SshAgentIpcService.n();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (string != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-64486440 - -((char)-17291), -64486440 - -((char)-27662), (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-64486440 - -((char)-17295), -64486440 - -((char)-7472), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-64486440 - -((char)-17286), 64486440 - (char)-15669, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-64486440 - -((char)-17291), -64486440 - -((char)-27662), (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-64486440 - -((char)-17295), -64486440 - -((char)-7472), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-64486440 - -((char)-17283), -64486440 - -31869, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String string2;
                    block13: {
                        long l2 = 33456685061167L;
                        String string3 = SshAgentIpcService.n();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(1110162900 - 9396, -1110162900 + -9855, (int)l2));
                        string2 = string3;
                        try {
                            try {
                                try {
                                    try {
                                        if (string2 != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string4 = object.toString();
                                string = string4;
                                object = string4;
                                if (string2 != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(1110162900 - 9393, 1110162900 - 13919, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (string2 != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String string;
        long l2;
        block25: {
            block26: {
                l2 = 85665179183922L;
                String string2 = SshAgentIpcService.n();
                this.assertConnectionThread();
                Object object2 = this.lock;
                string = string2;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (string != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (string != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2056488300 - -11152, -2056488300 - -30479, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-2056488300 - -11148, -2056488300 - -1581, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2056488300 - -11179, -2056488300 - -9224, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string3 = WindowsNamedPipeAgentIpc.b(-2056488300 - -11148, -2056488300 - -1581, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2056488300 - -11154, -2056488300 - -19133, (int)l2) + this.state;
                        throw new IllegalArgumentException(string3.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2056488300 - -11152, -2056488300 - -30479, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-2056488300 - -11148, -2056488300 - -1581, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2056488300 - -11164, -2056488300 - -19666, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (string != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2056488300 - -11152, -2056488300 - -30479, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-2056488300 - -11148, -2056488300 - -1581, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2056488300 - -11165, 2056488300 - 2240, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (string != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2056488300 - -11152, -2056488300 - -30479, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-2056488300 - -11148, -2056488300 - -1581, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2056488300 - -11166, 2056488300 - 11249, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String string;
                block16: {
                    l2 = 117990550699992L;
                    Object object = this.lock;
                    string = SshAgentIpcService.n();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (string != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(790876380 + 8690, 790876380 - 11155, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(790876380 + 8686, 790876380 + 847, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(790876380 + 8701, 790876380 - 13968, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(790876380 + 8706, -790876380 - -4505, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(790876380 + 8690, 790876380 - 11155, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(790876380 + 8686, 790876380 + 847, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(790876380 + 8707, 790876380 - 6966, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (string != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (string != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(790876380 + 8690, 790876380 - 11155, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(790876380 + 8686, 790876380 + 847, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(790876380 + 8704, 790876380 - 18705, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(790876380 + 8690, 790876380 - 11155, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(790876380 + 8686, 790876380 + 847, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(790876380 + 8705, -790876380 - -19304, (int)l2));
                    if (string != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(790876380 + 8690, 790876380 - 11155, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(790876380 + 8686, 790876380 + 847, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(790876380 + 8710, 790876380 + 4614, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(790876380 + 8711, 790876380 - 4133, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00cc@\u00fe# E\u00de\u00f8\u0014\u00c2\u00f8\u0007\u00d3\u00e1\u00d3I0\u00ff\u009a\u00fa\u00af\u001d\u0088L\u00f8\u0015\u00c5O\u00b1\u0006_\u00c1\u008c\u0013\u0004\u0002\u00183eYP\u00a8fbFR)@\u00a9,\u00b78\u009d2\u0000\u0085\u0094\u00f9\u008d\u00f3,\t\u00a69ujF\u00be\u00a7\u0015\u00d6\u0005\n`&'K\b\u00d8\u00f8|E\"\u00af\u0098G\u0014\r\u00be\u0086\u0080\u00bc\u00b1\u00d7\u00ebB<\u00e6\u00cf\u00d4'\u00ce\u00e0W\u0015\u00fe\u00e9\u0005\u00bb\"\u0010o\u008d\u001e\u00cb~\u000b\u0080s\u00b8\u00bb\u00e7\u00cc\t\u00d8*s\u00e7q\u00f3\u00fa\\N\u00eb,ME\u00f9\u00fafIk\u0012\u0080\u0010\u00e6\u00f1J\u00b4\f\f\u00a2\u0088\u0092V\u009e<\u00bdp\u0007\u009e\t\u0096>\u00a5\u009b\u000f\u00a7\u00a8\u00a9\u00d9\u0010\u00af\\c\u0001)\u00ba\u0006^\u0006\u008c\fg\u00ef\u001bM\u00f3?\u00e5\u0081\u00c6\u007f\u00c7N\u00a8U\u00df\u008e\u00ff!(p'8\u00f5@\u00d2\u00ad1\u00d7\u009d\u00cc\u00f1(%\u0016\u00a8y\u00fbs\f\u00b8=\u0002g\u00c2\u0095\u00aa\u00b4\n)V-\u00e3\u00b8\"A\u00aa=\u0012\u00c7\u00ec\u00cc96\u00ed\u00ff\u00cb\u00a0\u00d8'\b\u00e3,\u001b\u00df\u00ce\u00fc\u0005-\f\u00e3\u007f\u000b\u00ae\u00d1\u00b0\b\u00a3\u00ee{C\u009dF\u00b8\u00a8`T\u00bc\u00ef\u00a5H[\n\u00ffw\u00be\u00b2\u00eaF\u00b0\u00e8z\u00176\u00d2~^\u00bbQ\u009f2@\u00d4\u00dc\u00fa\u00d4?\u00e4\u00d3\u0086\u00b5\u0002\u0080\u00d5Z\u008e\u00a7\u0007X\u00a9(\u0084\u0013\u00e3\u008f\u00f3\u00c9\\\u0086\u00bbn\u00d8\u0007w(\u0081\u009aJ\u009e\u00da\u0083\u00f8\u00a5\u001f\u00f0\u00c4l\u00d7\u009fR&\u00ba\u007f\u00a2\u00ae_\u00bdT\u00a34\u00dbL\u0017#\u00cc\u00d4\u008ea\u00e2\u00a5]\u00df\u008d\u00e7g\u000b\u00d3\u0094\r\u00d3\u0011\u001f\u0010V\u00ed\u00c9)\u0015Gc\u009f.D\u00c8V\u00d1\u001b\u00d9?\u00fb1l/e\u00b1\u00f2\u0087\u008d\u00e8)n\u00fb\u00bf0\u00e5\u00aei%\u0096Q\u0093!\u001e\u0091I\u0089\u00d9s\u008ccO\u00a48w[.\u00bd\u00d6\u00be2\u0083\u0018\u00c1\u00c6 a\u0000\u00feY@\u001d\u0007\u00ee1\u00a5s\u0082\u009b\u001e\u0007\u00efn\u00e1\u00f4\u00ed\u0084\u00e5(\u00da\u00c0ev\u000e\f\u00e2V\u0097\u00e8\u0099 |0G>\u001f(\u00faK\u00e0\u009f\u00a2\u00db\u0098\u0007s\u0088P\u0099\u0085t\u00fa \u00d9\u0010\u0085\u00adz\u00d9\u000f\u00bd\u0097\u00c7\u00b5\u00b2\u0018\u00d0\u0017\u00a4M^\u00c5$\u00d8\u00d2\"\u001a\u00111m4\u0005SP\u00d1\u00ff{\u00f4\u0000'\u00ee\u0091\u00c6Y\u00e5d\u0088D`;\u00c3\u00f3c\u00b3A\u00ac\u00de\u00ccD\u00af\u000e\u00cb\u00b2\t\u0011k\u008c\u00eb\u0085\u00c3\u001f\u00b2\u008f\u00b5\u009b\u001b\r\u0080\u00d6RkQ~b&d\u0083\u00e1\u00c3`\u00b0o\u00a5,4V\u008963\u00d3\u00e2\u0083\u0012\n\u0083\u00a1\u00c3q\u00dd\u00d1{X-A\u0018[E\u001c\u00e73[T}}N*;Oh\u00ddO\u007f)\u00b8\u008f`FU\u008e)\u00e9\u0090O]\u00fb\u0003\u00aa\u0090\u00ee\u00e7\u009c\u00f7\u00fbBj\u0088\u00c3&\u0010\f\u00e6YD\u00c4\u00a1\u00ca\u007f\u00a6\u00b5`Y\u00c3\u00bfc:A\u009d\u00de\u00eaDk\t\u00bd\u00b0\u00c0T\u00a9\u0091*44";
                var4_3 = "\u00cc@\u00fe# E\u00de\u00f8\u0014\u00c2\u00f8\u0007\u00d3\u00e1\u00d3I0\u00ff\u009a\u00fa\u00af\u001d\u0088L\u00f8\u0015\u00c5O\u00b1\u0006_\u00c1\u008c\u0013\u0004\u0002\u00183eYP\u00a8fbFR)@\u00a9,\u00b78\u009d2\u0000\u0085\u0094\u00f9\u008d\u00f3,\t\u00a69ujF\u00be\u00a7\u0015\u00d6\u0005\n`&'K\b\u00d8\u00f8|E\"\u00af\u0098G\u0014\r\u00be\u0086\u0080\u00bc\u00b1\u00d7\u00ebB<\u00e6\u00cf\u00d4'\u00ce\u00e0W\u0015\u00fe\u00e9\u0005\u00bb\"\u0010o\u008d\u001e\u00cb~\u000b\u0080s\u00b8\u00bb\u00e7\u00cc\t\u00d8*s\u00e7q\u00f3\u00fa\\N\u00eb,ME\u00f9\u00fafIk\u0012\u0080\u0010\u00e6\u00f1J\u00b4\f\f\u00a2\u0088\u0092V\u009e<\u00bdp\u0007\u009e\t\u0096>\u00a5\u009b\u000f\u00a7\u00a8\u00a9\u00d9\u0010\u00af\\c\u0001)\u00ba\u0006^\u0006\u008c\fg\u00ef\u001bM\u00f3?\u00e5\u0081\u00c6\u007f\u00c7N\u00a8U\u00df\u008e\u00ff!(p'8\u00f5@\u00d2\u00ad1\u00d7\u009d\u00cc\u00f1(%\u0016\u00a8y\u00fbs\f\u00b8=\u0002g\u00c2\u0095\u00aa\u00b4\n)V-\u00e3\u00b8\"A\u00aa=\u0012\u00c7\u00ec\u00cc96\u00ed\u00ff\u00cb\u00a0\u00d8'\b\u00e3,\u001b\u00df\u00ce\u00fc\u0005-\f\u00e3\u007f\u000b\u00ae\u00d1\u00b0\b\u00a3\u00ee{C\u009dF\u00b8\u00a8`T\u00bc\u00ef\u00a5H[\n\u00ffw\u00be\u00b2\u00eaF\u00b0\u00e8z\u00176\u00d2~^\u00bbQ\u009f2@\u00d4\u00dc\u00fa\u00d4?\u00e4\u00d3\u0086\u00b5\u0002\u0080\u00d5Z\u008e\u00a7\u0007X\u00a9(\u0084\u0013\u00e3\u008f\u00f3\u00c9\\\u0086\u00bbn\u00d8\u0007w(\u0081\u009aJ\u009e\u00da\u0083\u00f8\u00a5\u001f\u00f0\u00c4l\u00d7\u009fR&\u00ba\u007f\u00a2\u00ae_\u00bdT\u00a34\u00dbL\u0017#\u00cc\u00d4\u008ea\u00e2\u00a5]\u00df\u008d\u00e7g\u000b\u00d3\u0094\r\u00d3\u0011\u001f\u0010V\u00ed\u00c9)\u0015Gc\u009f.D\u00c8V\u00d1\u001b\u00d9?\u00fb1l/e\u00b1\u00f2\u0087\u008d\u00e8)n\u00fb\u00bf0\u00e5\u00aei%\u0096Q\u0093!\u001e\u0091I\u0089\u00d9s\u008ccO\u00a48w[.\u00bd\u00d6\u00be2\u0083\u0018\u00c1\u00c6 a\u0000\u00feY@\u001d\u0007\u00ee1\u00a5s\u0082\u009b\u001e\u0007\u00efn\u00e1\u00f4\u00ed\u0084\u00e5(\u00da\u00c0ev\u000e\f\u00e2V\u0097\u00e8\u0099 |0G>\u001f(\u00faK\u00e0\u009f\u00a2\u00db\u0098\u0007s\u0088P\u0099\u0085t\u00fa \u00d9\u0010\u0085\u00adz\u00d9\u000f\u00bd\u0097\u00c7\u00b5\u00b2\u0018\u00d0\u0017\u00a4M^\u00c5$\u00d8\u00d2\"\u001a\u00111m4\u0005SP\u00d1\u00ff{\u00f4\u0000'\u00ee\u0091\u00c6Y\u00e5d\u0088D`;\u00c3\u00f3c\u00b3A\u00ac\u00de\u00ccD\u00af\u000e\u00cb\u00b2\t\u0011k\u008c\u00eb\u0085\u00c3\u001f\u00b2\u008f\u00b5\u009b\u001b\r\u0080\u00d6RkQ~b&d\u0083\u00e1\u00c3`\u00b0o\u00a5,4V\u008963\u00d3\u00e2\u0083\u0012\n\u0083\u00a1\u00c3q\u00dd\u00d1{X-A\u0018[E\u001c\u00e73[T}}N*;Oh\u00ddO\u007f)\u00b8\u008f`FU\u008e)\u00e9\u0090O]\u00fb\u0003\u00aa\u0090\u00ee\u00e7\u009c\u00f7\u00fbBj\u0088\u00c3&\u0010\f\u00e6YD\u00c4\u00a1\u00ca\u007f\u00a6\u00b5`Y\u00c3\u00bfc:A\u009d\u00de\u00eaDk\t\u00bd\u00b0\u00c0T\u00a9\u0091*44".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 53;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "/\u00d0\u008fM\u00fb\u0019\u00b2\u00cb\u00f5\u0094\u00e7\u0081\u008c\u0094\u009cJ\u0005j\u0080\u0019\u00b9\u00dcD\u00b2\u0012\u0000\u0080\u00a2\u00c2\u0014\u00fd\u00c2\u00f8\u008c\u0006 \u00adV{Nr-\u0014\u00c0u\u00e9*\u00ff\u00b0\u00ee";
                    var4_3 = "/\u00d0\u008fM\u00fb\u0019\u00b2\u00cb\u00f5\u0094\u00e7\u0081\u008c\u0094\u009cJ\u0005j\u0080\u0019\u00b9\u00dcD\u00b2\u0012\u0000\u0080\u00a2\u00c2\u0014\u00fd\u00c2\u00f8\u008c\u0006 \u00adV{Nr-\u0014\u00c0u\u00e9*\u00ff\u00b0\u00ee".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 103;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 69;
                            break;
                        }
                        case 1: {
                            v15 = 13;
                            break;
                        }
                        case 2: {
                            v15 = 82;
                            break;
                        }
                        case 3: {
                            v15 = 56;
                            break;
                        }
                        case 4: {
                            v15 = 8;
                            break;
                        }
                        case 5: {
                            v15 = 29;
                            break;
                        }
                        default: {
                            v15 = 102;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFF8D1A) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 183;
                case 1 -> 198;
                case 2 -> 70;
                case 3 -> 196;
                case 4 -> 69;
                case 5 -> 228;
                case 6 -> 240;
                case 7 -> 178;
                case 8 -> 91;
                case 9 -> 210;
                case 10 -> 101;
                case 11 -> 246;
                case 12 -> 216;
                case 13 -> 3;
                case 14 -> 141;
                case 15 -> 32;
                case 16 -> 0;
                case 17 -> 127;
                case 18 -> 49;
                case 19 -> 132;
                case 20 -> 18;
                case 21 -> 220;
                case 22 -> 219;
                case 23 -> 11;
                case 24 -> 247;
                case 25 -> 111;
                case 26 -> 21;
                case 27 -> 182;
                case 28 -> 224;
                case 29 -> 71;
                case 30 -> 234;
                case 31 -> 163;
                case 32 -> 129;
                case 33 -> 131;
                case 34 -> 95;
                case 35 -> 114;
                case 36 -> 124;
                case 37 -> 160;
                case 38 -> 155;
                case 39 -> 213;
                case 40 -> 242;
                case 41 -> 252;
                case 42 -> 241;
                case 43 -> 109;
                case 44 -> 27;
                case 45 -> 212;
                case 46 -> 116;
                case 47 -> 66;
                case 48 -> 150;
                case 49 -> 197;
                case 50 -> 176;
                case 51 -> 57;
                case 52 -> 215;
                case 53 -> 185;
                case 54 -> 60;
                case 55 -> 249;
                case 56 -> 235;
                case 57 -> 191;
                case 58 -> 92;
                case 59 -> 227;
                case 60 -> 151;
                case 61 -> 40;
                case 62 -> 6;
                case 63 -> 81;
                case 64 -> 25;
                case 65 -> 29;
                case 66 -> 135;
                case 67 -> 39;
                case 68 -> 138;
                case 69 -> 128;
                case 70 -> 82;
                case 71 -> 24;
                case 72 -> 17;
                case 73 -> 236;
                case 74 -> 34;
                case 75 -> 226;
                case 76 -> 193;
                case 77 -> 90;
                case 78 -> 175;
                case 79 -> 15;
                case 80 -> 157;
                case 81 -> 64;
                case 82 -> 118;
                case 83 -> 26;
                case 84 -> 159;
                case 85 -> 146;
                case 86 -> 65;
                case 87 -> 143;
                case 88 -> 188;
                case 89 -> 45;
                case 90 -> 172;
                case 91 -> 204;
                case 92 -> 59;
                case 93 -> 61;
                case 94 -> 20;
                case 95 -> 158;
                case 96 -> 38;
                case 97 -> 97;
                case 98 -> 104;
                case 99 -> 168;
                case 100 -> 147;
                case 101 -> 50;
                case 102 -> 63;
                case 103 -> 218;
                case 104 -> 207;
                case 105 -> 231;
                case 106 -> 78;
                case 107 -> 254;
                case 108 -> 8;
                case 109 -> 126;
                case 110 -> 4;
                case 111 -> 122;
                case 112 -> 253;
                case 113 -> 85;
                case 114 -> 211;
                case 115 -> 164;
                case 116 -> 75;
                case 117 -> 174;
                case 118 -> 46;
                case 119 -> 100;
                case 120 -> 16;
                case 121 -> 173;
                case 122 -> 152;
                case 123 -> 84;
                case 124 -> 115;
                case 125 -> 77;
                case 126 -> 54;
                case 127 -> 89;
                case 128 -> 76;
                case 129 -> 203;
                case 130 -> 162;
                case 131 -> 72;
                case 132 -> 79;
                case 133 -> 136;
                case 134 -> 251;
                case 135 -> 107;
                case 136 -> 96;
                case 137 -> 190;
                case 138 -> 139;
                case 139 -> 189;
                case 140 -> 113;
                case 141 -> 53;
                case 142 -> 80;
                case 143 -> 48;
                case 144 -> 140;
                case 145 -> 62;
                case 146 -> 9;
                case 147 -> 186;
                case 148 -> 103;
                case 149 -> 106;
                case 150 -> 229;
                case 151 -> 154;
                case 152 -> 239;
                case 153 -> 112;
                case 154 -> 184;
                case 155 -> 232;
                case 156 -> 2;
                case 157 -> 179;
                case 158 -> 148;
                case 159 -> 110;
                case 160 -> 120;
                case 161 -> 225;
                case 162 -> 37;
                case 163 -> 30;
                case 164 -> 31;
                case 165 -> 202;
                case 166 -> 144;
                case 167 -> 1;
                case 168 -> 206;
                case 169 -> 28;
                case 170 -> 36;
                case 171 -> 205;
                case 172 -> 145;
                case 173 -> 248;
                case 174 -> 13;
                case 175 -> 14;
                case 176 -> 245;
                case 177 -> 238;
                case 178 -> 166;
                case 179 -> 47;
                case 180 -> 243;
                case 181 -> 156;
                case 182 -> 171;
                case 183 -> 108;
                case 184 -> 195;
                case 185 -> 119;
                case 186 -> 51;
                case 187 -> 200;
                case 188 -> 94;
                case 189 -> 130;
                case 190 -> 244;
                case 191 -> 58;
                case 192 -> 221;
                case 193 -> 125;
                case 194 -> 192;
                case 195 -> 167;
                case 196 -> 137;
                case 197 -> 7;
                case 198 -> 250;
                case 199 -> 35;
                case 200 -> 105;
                case 201 -> 208;
                case 202 -> 121;
                case 203 -> 56;
                case 204 -> 230;
                case 205 -> 93;
                case 206 -> 187;
                case 207 -> 42;
                case 208 -> 237;
                case 209 -> 68;
                case 210 -> 98;
                case 211 -> 43;
                case 212 -> 165;
                case 213 -> 142;
                case 214 -> 194;
                case 215 -> 87;
                case 216 -> 55;
                case 217 -> 161;
                case 218 -> 209;
                case 219 -> 201;
                case 220 -> 222;
                case 221 -> 73;
                case 222 -> 170;
                case 223 -> 217;
                case 224 -> 153;
                case 225 -> 52;
                case 226 -> 83;
                case 227 -> 5;
                case 228 -> 199;
                case 229 -> 22;
                case 230 -> 67;
                case 231 -> 19;
                case 232 -> 23;
                case 233 -> 86;
                case 234 -> 44;
                case 235 -> 41;
                case 236 -> 117;
                case 237 -> 255;
                case 238 -> 223;
                case 239 -> 177;
                case 240 -> 74;
                case 241 -> 133;
                case 242 -> 149;
                case 243 -> 134;
                case 244 -> 12;
                case 245 -> 102;
                case 246 -> 123;
                case 247 -> 88;
                case 248 -> 181;
                case 249 -> 33;
                case 250 -> 214;
                case 251 -> 180;
                case 252 -> 10;
                case 253 -> 233;
                case 254 -> 99;
                default -> 169;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 22388111760495L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1552786290 - 30895, 1552786290 - 26882, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String string;
                        block4: {
                            l2 = 139747663538724L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            string = SshAgentIpcService.n();
                            try {
                                hANDLE2 = hANDLE;
                                if (string != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (string != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1982302680 + (char)-27983, 1982302680 + (char)-20966, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1982302680 + (char)-27982, -1982302680 + -((char)-24135), (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1982302680 + (char)-27981, 1982302680 + 31990, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u0081\u009a\u0096\u0090:o^v\u0010\u00d8\u0088Ls\u00db\u00a8\u009b\u00d7\u00ea|yn\u001d\u00f9\u00d8\u00f0";
                    var4_3 = "\u0081\u009a\u0096\u0090:o^v\u0010\u00d8\u0088Ls\u00db\u00a8\u009b\u00d7\u00ea|yn\u001d\u00f9\u00d8\u00f0".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 66;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "e0_\u0090&5\u0013\\\u0086q\u00cf\u0084T\u00ac1\u00fd\u00c5\u00cb(\u00f2.N^\u00farb\u00af5\u00e8P\u0083V}e\u00ad-\u001e\u0003\u000e\u0003\u00ef\u00aa\u00f2i\u00de\u00f6d8:\u00f2\u008e!|\u00e1\u00fb\u00bas\u00a1\u00f6";
                        var4_3 = "e0_\u0090&5\u0013\\\u0086q\u00cf\u0084T\u00ac1\u00fd\u00c5\u00cb(\u00f2.N^\u00farb\u00af5\u00e8P\u0083V}e\u00ad-\u001e\u0003\u000e\u0003\u00ef\u00aa\u00f2i\u00de\u00f6d8:\u00f2\u008e!|\u00e1\u00fb\u00bas\u00a1\u00f6".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 113;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 126;
                                break;
                            }
                            case 1: {
                                v15 = 37;
                                break;
                            }
                            case 2: {
                                v15 = 109;
                                break;
                            }
                            case 3: {
                                v15 = 76;
                                break;
                            }
                            case 4: {
                                v15 = 97;
                                break;
                            }
                            case 5: {
                                v15 = 86;
                                break;
                            }
                            default: {
                                v15 = 17;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFF6AC) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 199;
                    case 1 -> 207;
                    case 2 -> 60;
                    case 3 -> 33;
                    case 4 -> 40;
                    case 5 -> 130;
                    case 6 -> 58;
                    case 7 -> 17;
                    case 8 -> 223;
                    case 9 -> 155;
                    case 10 -> 195;
                    case 11 -> 186;
                    case 12 -> 103;
                    case 13 -> 250;
                    case 14 -> 67;
                    case 15 -> 179;
                    case 16 -> 194;
                    case 17 -> 187;
                    case 18 -> 59;
                    case 19 -> 122;
                    case 20 -> 202;
                    case 21 -> 5;
                    case 22 -> 185;
                    case 23 -> 115;
                    case 24 -> 198;
                    case 25 -> 120;
                    case 26 -> 51;
                    case 27 -> 116;
                    case 28 -> 196;
                    case 29 -> 188;
                    case 30 -> 200;
                    case 31 -> 191;
                    case 32 -> 79;
                    case 33 -> 192;
                    case 34 -> 32;
                    case 35 -> 204;
                    case 36 -> 99;
                    case 37 -> 203;
                    case 38 -> 171;
                    case 39 -> 248;
                    case 40 -> 145;
                    case 41 -> 255;
                    case 42 -> 141;
                    case 43 -> 76;
                    case 44 -> 48;
                    case 45 -> 63;
                    case 46 -> 251;
                    case 47 -> 182;
                    case 48 -> 37;
                    case 49 -> 3;
                    case 50 -> 126;
                    case 51 -> 232;
                    case 52 -> 158;
                    case 53 -> 146;
                    case 54 -> 178;
                    case 55 -> 124;
                    case 56 -> 39;
                    case 57 -> 61;
                    case 58 -> 118;
                    case 59 -> 81;
                    case 60 -> 132;
                    case 61 -> 108;
                    case 62 -> 161;
                    case 63 -> 149;
                    case 64 -> 234;
                    case 65 -> 137;
                    case 66 -> 135;
                    case 67 -> 233;
                    case 68 -> 166;
                    case 69 -> 89;
                    case 70 -> 12;
                    case 71 -> 64;
                    case 72 -> 152;
                    case 73 -> 54;
                    case 74 -> 15;
                    case 75 -> 90;
                    case 76 -> 216;
                    case 77 -> 236;
                    case 78 -> 7;
                    case 79 -> 13;
                    case 80 -> 167;
                    case 81 -> 246;
                    case 82 -> 228;
                    case 83 -> 183;
                    case 84 -> 70;
                    case 85 -> 148;
                    case 86 -> 78;
                    case 87 -> 87;
                    case 88 -> 73;
                    case 89 -> 245;
                    case 90 -> 25;
                    case 91 -> 168;
                    case 92 -> 128;
                    case 93 -> 4;
                    case 94 -> 205;
                    case 95 -> 47;
                    case 96 -> 28;
                    case 97 -> 238;
                    case 98 -> 6;
                    case 99 -> 38;
                    case 100 -> 229;
                    case 101 -> 117;
                    case 102 -> 93;
                    case 103 -> 138;
                    case 104 -> 144;
                    case 105 -> 222;
                    case 106 -> 49;
                    case 107 -> 153;
                    case 108 -> 18;
                    case 109 -> 239;
                    case 110 -> 97;
                    case 111 -> 98;
                    case 112 -> 224;
                    case 113 -> 218;
                    case 114 -> 42;
                    case 115 -> 62;
                    case 116 -> 88;
                    case 117 -> 85;
                    case 118 -> 109;
                    case 119 -> 121;
                    case 120 -> 123;
                    case 121 -> 10;
                    case 122 -> 24;
                    case 123 -> 150;
                    case 124 -> 111;
                    case 125 -> 140;
                    case 126 -> 215;
                    case 127 -> 201;
                    case 128 -> 41;
                    case 129 -> 75;
                    case 130 -> 101;
                    case 131 -> 23;
                    case 132 -> 14;
                    case 133 -> 8;
                    case 134 -> 68;
                    case 135 -> 244;
                    case 136 -> 214;
                    case 137 -> 35;
                    case 138 -> 220;
                    case 139 -> 165;
                    case 140 -> 65;
                    case 141 -> 34;
                    case 142 -> 55;
                    case 143 -> 66;
                    case 144 -> 113;
                    case 145 -> 221;
                    case 146 -> 242;
                    case 147 -> 142;
                    case 148 -> 104;
                    case 149 -> 92;
                    case 150 -> 208;
                    case 151 -> 162;
                    case 152 -> 86;
                    case 153 -> 0;
                    case 154 -> 20;
                    case 155 -> 206;
                    case 156 -> 243;
                    case 157 -> 254;
                    case 158 -> 226;
                    case 159 -> 175;
                    case 160 -> 230;
                    case 161 -> 180;
                    case 162 -> 52;
                    case 163 -> 50;
                    case 164 -> 69;
                    case 165 -> 133;
                    case 166 -> 114;
                    case 167 -> 112;
                    case 168 -> 212;
                    case 169 -> 107;
                    case 170 -> 26;
                    case 171 -> 231;
                    case 172 -> 46;
                    case 173 -> 169;
                    case 174 -> 77;
                    case 175 -> 170;
                    case 176 -> 177;
                    case 177 -> 227;
                    case 178 -> 9;
                    case 179 -> 159;
                    case 180 -> 56;
                    case 181 -> 119;
                    case 182 -> 71;
                    case 183 -> 247;
                    case 184 -> 45;
                    case 185 -> 72;
                    case 186 -> 129;
                    case 187 -> 1;
                    case 188 -> 172;
                    case 189 -> 82;
                    case 190 -> 189;
                    case 191 -> 102;
                    case 192 -> 127;
                    case 193 -> 131;
                    case 194 -> 156;
                    case 195 -> 136;
                    case 196 -> 237;
                    case 197 -> 217;
                    case 198 -> 176;
                    case 199 -> 94;
                    case 200 -> 27;
                    case 201 -> 21;
                    case 202 -> 100;
                    case 203 -> 160;
                    case 204 -> 252;
                    case 205 -> 184;
                    case 206 -> 235;
                    case 207 -> 197;
                    case 208 -> 36;
                    case 209 -> 53;
                    case 210 -> 163;
                    case 211 -> 209;
                    case 212 -> 22;
                    case 213 -> 19;
                    case 214 -> 147;
                    case 215 -> 84;
                    case 216 -> 96;
                    case 217 -> 213;
                    case 218 -> 31;
                    case 219 -> 211;
                    case 220 -> 125;
                    case 221 -> 134;
                    case 222 -> 143;
                    case 223 -> 91;
                    case 224 -> 151;
                    case 225 -> 219;
                    case 226 -> 80;
                    case 227 -> 57;
                    case 228 -> 83;
                    case 229 -> 30;
                    case 230 -> 190;
                    case 231 -> 253;
                    case 232 -> 173;
                    case 233 -> 29;
                    case 234 -> 241;
                    case 235 -> 43;
                    case 236 -> 164;
                    case 237 -> 174;
                    case 238 -> 139;
                    case 239 -> 95;
                    case 240 -> 154;
                    case 241 -> 110;
                    case 242 -> 44;
                    case 243 -> 240;
                    case 244 -> 74;
                    case 245 -> 210;
                    case 246 -> 193;
                    case 247 -> 105;
                    case 248 -> 11;
                    case 249 -> 181;
                    case 250 -> 2;
                    case 251 -> 225;
                    case 252 -> 249;
                    case 253 -> 16;
                    case 254 -> 106;
                    default -> 157;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 552888191660L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "\u0004PJ\u000bm0u]\t\u0003ZY\u0001 rhA\u001c";
                    var5_4 = "\u0004PJ\u000bm0u]\t\u0003ZY\u0001 rhA\u001c".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 102;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 9;
                                    break;
                                }
                                case 1: {
                                    v11 = 83;
                                    break;
                                }
                                case 2: {
                                    v11 = 94;
                                    break;
                                }
                                case 3: {
                                    v11 = 3;
                                    break;
                                }
                                case 4: {
                                    v11 = 110;
                                    break;
                                }
                                case 5: {
                                    v11 = 58;
                                    break;
                                }
                                default: {
                                    v11 = 32;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 29713031148301L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "mxVR\u0001tI\u0004kfZH\ngyQH\rvQMxX\tgyQH\rvQAr\r`\u007fLE\u0007{KAuKO\u0006r";
                    var5_4 = "mxVR\u0001tI\u0004kfZH\ngyQH\rvQMxX\tgyQH\rvQAr\r`\u007fLE\u0007{KAuKO\u0006r".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 92;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "\u0017\n %q\u000b2\u0006\u0017\n %}\u0001";
                        var5_4 = "\u0017\n %q\u000b2\u0006\u0017\n %}\u0001".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 44;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 120;
                                break;
                            }
                            case 1: {
                                v15 = 74;
                                break;
                            }
                            case 2: {
                                v15 = 99;
                                break;
                            }
                            case 3: {
                                v15 = 122;
                                break;
                            }
                            case 4: {
                                v15 = 52;
                                break;
                            }
                            case 5: {
                                v15 = 73;
                                break;
                            }
                            default: {
                                v15 = 121;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 18277606245942L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(-1774556730 + -22125, -1774556730 + -8572, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 87138599796119L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00d2c\u008b(\u00fd\u0003H\u00fbl\u0005v\u00ff9\u007fH\r\u00e4\u00b0]\u00dc1\u00ac\u00ae\u000f\u0017\u00b2f\r|\u0010\u00057\u00a6\u00c7qZ\u008d\u00ec\u00baJ0_P\u009c\u0014\u00ce\u0005\u00c5cO\u00ec\u00863}\u001bI\u0094Yt\u00b8=a\u008d\u00c0\u008e\u0088\u00f7#\u00bc\u00cb\u00a9\u00159\u00f2h\u00e2w\u001f\u008f6\u001eJ1\u00d9\u00cb\u0095\u008dj \u007f~\u00c9\u00bc*=\u00d2\u00a7\u00e6\u00ef\u00bd#\\\u00e2\u00b0";
                    var4_3 = "\u00d2c\u008b(\u00fd\u0003H\u00fbl\u0005v\u00ff9\u007fH\r\u00e4\u00b0]\u00dc1\u00ac\u00ae\u000f\u0017\u00b2f\r|\u0010\u00057\u00a6\u00c7qZ\u008d\u00ec\u00baJ0_P\u009c\u0014\u00ce\u0005\u00c5cO\u00ec\u00863}\u001bI\u0094Yt\u00b8=a\u008d\u00c0\u008e\u0088\u00f7#\u00bc\u00cb\u00a9\u00159\u00f2h\u00e2w\u001f\u008f6\u001eJ1\u00d9\u00cb\u0095\u008dj \u007f~\u00c9\u00bc*=\u00d2\u00a7\u00e6\u00ef\u00bd#\\\u00e2\u00b0".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 80;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "1\u0005\u00910&\u0015\u00d6\u00b4`\u00f0\u00da\u00b9\u00bc\u00f18\u00d2Lq\u0003n:\u00f3\u009c\u0002\u00ebs\u0088\u0014\u000fk\u00a9Q\u00a01J\u0004\u0002\t\u00da\u00062\u0011}c7\u00ab\u00ec\u00bb\u00aex~\u0017\u00f3Sk\u00c7\u00c9l\u00dfd7\u0094\u0092\u0089\u0005\u0099\u00a3Q\u00a3\u007fR\u00ad-\u0001\u00c7\u00f7\u00ad\u00c4\u00e52I5\u00c5\u00d5\u00d89\u00a8MP]k\u0084\u00b1";
                        var4_3 = "1\u0005\u00910&\u0015\u00d6\u00b4`\u00f0\u00da\u00b9\u00bc\u00f18\u00d2Lq\u0003n:\u00f3\u009c\u0002\u00ebs\u0088\u0014\u000fk\u00a9Q\u00a01J\u0004\u0002\t\u00da\u00062\u0011}c7\u00ab\u00ec\u00bb\u00aex~\u0017\u00f3Sk\u00c7\u00c9l\u00dfd7\u0094\u0092\u0089\u0005\u0099\u00a3Q\u00a3\u007fR\u00ad-\u0001\u00c7\u00f7\u00ad\u00c4\u00e52I5\u00c5\u00d5\u00d89\u00a8MP]k\u0084\u00b1".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 46;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 5;
                                break;
                            }
                            case 1: {
                                v15 = 44;
                                break;
                            }
                            case 2: {
                                v15 = 3;
                                break;
                            }
                            case 3: {
                                v15 = 126;
                                break;
                            }
                            case 4: {
                                v15 = 11;
                                break;
                            }
                            case 5: {
                                v15 = 36;
                                break;
                            }
                            default: {
                                v15 = 79;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x556F) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 121;
                    case 1 -> 96;
                    case 2 -> 15;
                    case 3 -> 98;
                    case 4 -> 77;
                    case 5 -> 56;
                    case 6 -> 172;
                    case 7 -> 38;
                    case 8 -> 70;
                    case 9 -> 128;
                    case 10 -> 111;
                    case 11 -> 144;
                    case 12 -> 127;
                    case 13 -> 195;
                    case 14 -> 255;
                    case 15 -> 68;
                    case 16 -> 125;
                    case 17 -> 6;
                    case 18 -> 115;
                    case 19 -> 126;
                    case 20 -> 187;
                    case 21 -> 223;
                    case 22 -> 135;
                    case 23 -> 248;
                    case 24 -> 37;
                    case 25 -> 110;
                    case 26 -> 194;
                    case 27 -> 250;
                    case 28 -> 184;
                    case 29 -> 57;
                    case 30 -> 217;
                    case 31 -> 25;
                    case 32 -> 48;
                    case 33 -> 167;
                    case 34 -> 141;
                    case 35 -> 196;
                    case 36 -> 237;
                    case 37 -> 122;
                    case 38 -> 11;
                    case 39 -> 230;
                    case 40 -> 65;
                    case 41 -> 99;
                    case 42 -> 59;
                    case 43 -> 72;
                    case 44 -> 16;
                    case 45 -> 97;
                    case 46 -> 14;
                    case 47 -> 88;
                    case 48 -> 200;
                    case 49 -> 157;
                    case 50 -> 117;
                    case 51 -> 84;
                    case 52 -> 12;
                    case 53 -> 26;
                    case 54 -> 7;
                    case 55 -> 28;
                    case 56 -> 146;
                    case 57 -> 235;
                    case 58 -> 20;
                    case 59 -> 114;
                    case 60 -> 162;
                    case 61 -> 5;
                    case 62 -> 27;
                    case 63 -> 75;
                    case 64 -> 112;
                    case 65 -> 228;
                    case 66 -> 185;
                    case 67 -> 52;
                    case 68 -> 42;
                    case 69 -> 131;
                    case 70 -> 133;
                    case 71 -> 183;
                    case 72 -> 129;
                    case 73 -> 2;
                    case 74 -> 101;
                    case 75 -> 231;
                    case 76 -> 91;
                    case 77 -> 71;
                    case 78 -> 30;
                    case 79 -> 36;
                    case 80 -> 225;
                    case 81 -> 160;
                    case 82 -> 76;
                    case 83 -> 81;
                    case 84 -> 192;
                    case 85 -> 209;
                    case 86 -> 193;
                    case 87 -> 106;
                    case 88 -> 142;
                    case 89 -> 191;
                    case 90 -> 218;
                    case 91 -> 197;
                    case 92 -> 149;
                    case 93 -> 118;
                    case 94 -> 151;
                    case 95 -> 64;
                    case 96 -> 247;
                    case 97 -> 208;
                    case 98 -> 53;
                    case 99 -> 152;
                    case 100 -> 173;
                    case 101 -> 9;
                    case 102 -> 55;
                    case 103 -> 40;
                    case 104 -> 147;
                    case 105 -> 221;
                    case 106 -> 243;
                    case 107 -> 45;
                    case 108 -> 105;
                    case 109 -> 58;
                    case 110 -> 123;
                    case 111 -> 119;
                    case 112 -> 66;
                    case 113 -> 113;
                    case 114 -> 43;
                    case 115 -> 163;
                    case 116 -> 4;
                    case 117 -> 132;
                    case 118 -> 170;
                    case 119 -> 166;
                    case 120 -> 104;
                    case 121 -> 139;
                    case 122 -> 95;
                    case 123 -> 254;
                    case 124 -> 206;
                    case 125 -> 210;
                    case 126 -> 18;
                    case 127 -> 176;
                    case 128 -> 134;
                    case 129 -> 219;
                    case 130 -> 44;
                    case 131 -> 138;
                    case 132 -> 153;
                    case 133 -> 252;
                    case 134 -> 215;
                    case 135 -> 150;
                    case 136 -> 107;
                    case 137 -> 232;
                    case 138 -> 159;
                    case 139 -> 67;
                    case 140 -> 22;
                    case 141 -> 213;
                    case 142 -> 87;
                    case 143 -> 227;
                    case 144 -> 61;
                    case 145 -> 165;
                    case 146 -> 236;
                    case 147 -> 207;
                    case 148 -> 47;
                    case 149 -> 180;
                    case 150 -> 171;
                    case 151 -> 8;
                    case 152 -> 234;
                    case 153 -> 240;
                    case 154 -> 177;
                    case 155 -> 211;
                    case 156 -> 13;
                    case 157 -> 249;
                    case 158 -> 136;
                    case 159 -> 199;
                    case 160 -> 73;
                    case 161 -> 33;
                    case 162 -> 201;
                    case 163 -> 198;
                    case 164 -> 39;
                    case 165 -> 239;
                    case 166 -> 120;
                    case 167 -> 3;
                    case 168 -> 156;
                    case 169 -> 41;
                    case 170 -> 24;
                    case 171 -> 51;
                    case 172 -> 69;
                    case 173 -> 103;
                    case 174 -> 178;
                    case 175 -> 10;
                    case 176 -> 86;
                    case 177 -> 241;
                    case 178 -> 80;
                    case 179 -> 93;
                    case 180 -> 233;
                    case 181 -> 212;
                    case 182 -> 108;
                    case 183 -> 188;
                    case 184 -> 94;
                    case 185 -> 174;
                    case 186 -> 245;
                    case 187 -> 253;
                    case 188 -> 124;
                    case 189 -> 181;
                    case 190 -> 62;
                    case 191 -> 179;
                    case 192 -> 203;
                    case 193 -> 242;
                    case 194 -> 92;
                    case 195 -> 222;
                    case 196 -> 1;
                    case 197 -> 190;
                    case 198 -> 161;
                    case 199 -> 224;
                    case 200 -> 21;
                    case 201 -> 46;
                    case 202 -> 158;
                    case 203 -> 78;
                    case 204 -> 202;
                    case 205 -> 145;
                    case 206 -> 63;
                    case 207 -> 32;
                    case 208 -> 79;
                    case 209 -> 49;
                    case 210 -> 220;
                    case 211 -> 140;
                    case 212 -> 109;
                    case 213 -> 74;
                    case 214 -> 17;
                    case 215 -> 31;
                    case 216 -> 175;
                    case 217 -> 229;
                    case 218 -> 155;
                    case 219 -> 205;
                    case 220 -> 182;
                    case 221 -> 168;
                    case 222 -> 186;
                    case 223 -> 164;
                    case 224 -> 85;
                    case 225 -> 54;
                    case 226 -> 34;
                    case 227 -> 214;
                    case 228 -> 154;
                    case 229 -> 226;
                    case 230 -> 238;
                    case 231 -> 244;
                    case 232 -> 90;
                    case 233 -> 216;
                    case 234 -> 100;
                    case 235 -> 169;
                    case 236 -> 19;
                    case 237 -> 251;
                    case 238 -> 116;
                    case 239 -> 143;
                    case 240 -> 189;
                    case 241 -> 60;
                    case 242 -> 83;
                    case 243 -> 89;
                    case 244 -> 148;
                    case 245 -> 35;
                    case 246 -> 0;
                    case 247 -> 246;
                    case 248 -> 23;
                    case 249 -> 29;
                    case 250 -> 137;
                    case 251 -> 130;
                    case 252 -> 204;
                    case 253 -> 82;
                    case 254 -> 102;
                    default -> 50;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 65872266470622L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(353102580 - (char)-30238, -353102580 - -((char)-21923), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 25446773622866L;
                    String string = SshAgentIpcService.n();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-907528680 + -((char)-6023), 907659750 - (char)-9284, (int)l2));
                    String string2 = string;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (string2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 118136456942104L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "P>l\u00d9\u00ba\u0003\u0081~\u0000";
                var4_3 = "P>l\u00d9\u00ba\u0003\u0081~\u0000".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 68;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 85;
                                break;
                            }
                            case 1: {
                                v11 = 25;
                                break;
                            }
                            case 2: {
                                v11 = 40;
                                break;
                            }
                            case 3: {
                                v11 = 20;
                                break;
                            }
                            case 4: {
                                v11 = 67;
                                break;
                            }
                            case 5: {
                                v11 = 77;
                                break;
                            }
                            default: {
                                v11 = 100;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x45CC) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 202;
                    case 1 -> 63;
                    case 2 -> 221;
                    case 3 -> 93;
                    case 4 -> 194;
                    case 5 -> 41;
                    case 6 -> 237;
                    case 7 -> 79;
                    case 8 -> 76;
                    case 9 -> 141;
                    case 10 -> 136;
                    case 11 -> 223;
                    case 12 -> 138;
                    case 13 -> 32;
                    case 14 -> 199;
                    case 15 -> 80;
                    case 16 -> 61;
                    case 17 -> 239;
                    case 18 -> 225;
                    case 19 -> 85;
                    case 20 -> 240;
                    case 21 -> 172;
                    case 22 -> 211;
                    case 23 -> 81;
                    case 24 -> 159;
                    case 25 -> 255;
                    case 26 -> 214;
                    case 27 -> 127;
                    case 28 -> 116;
                    case 29 -> 133;
                    case 30 -> 105;
                    case 31 -> 57;
                    case 32 -> 82;
                    case 33 -> 52;
                    case 34 -> 152;
                    case 35 -> 162;
                    case 36 -> 34;
                    case 37 -> 158;
                    case 38 -> 43;
                    case 39 -> 150;
                    case 40 -> 83;
                    case 41 -> 193;
                    case 42 -> 187;
                    case 43 -> 22;
                    case 44 -> 206;
                    case 45 -> 126;
                    case 46 -> 88;
                    case 47 -> 60;
                    case 48 -> 168;
                    case 49 -> 171;
                    case 50 -> 29;
                    case 51 -> 3;
                    case 52 -> 197;
                    case 53 -> 109;
                    case 54 -> 35;
                    case 55 -> 107;
                    case 56 -> 1;
                    case 57 -> 135;
                    case 58 -> 47;
                    case 59 -> 210;
                    case 60 -> 33;
                    case 61 -> 222;
                    case 62 -> 209;
                    case 63 -> 139;
                    case 64 -> 192;
                    case 65 -> 151;
                    case 66 -> 64;
                    case 67 -> 74;
                    case 68 -> 114;
                    case 69 -> 8;
                    case 70 -> 176;
                    case 71 -> 121;
                    case 72 -> 10;
                    case 73 -> 169;
                    case 74 -> 186;
                    case 75 -> 36;
                    case 76 -> 189;
                    case 77 -> 86;
                    case 78 -> 146;
                    case 79 -> 170;
                    case 80 -> 17;
                    case 81 -> 65;
                    case 82 -> 161;
                    case 83 -> 23;
                    case 84 -> 184;
                    case 85 -> 243;
                    case 86 -> 92;
                    case 87 -> 42;
                    case 88 -> 245;
                    case 89 -> 143;
                    case 90 -> 182;
                    case 91 -> 122;
                    case 92 -> 246;
                    case 93 -> 244;
                    case 94 -> 173;
                    case 95 -> 18;
                    case 96 -> 9;
                    case 97 -> 157;
                    case 98 -> 50;
                    case 99 -> 4;
                    case 100 -> 183;
                    case 101 -> 191;
                    case 102 -> 215;
                    case 103 -> 102;
                    case 104 -> 123;
                    case 105 -> 112;
                    case 106 -> 220;
                    case 107 -> 46;
                    case 108 -> 166;
                    case 109 -> 156;
                    case 110 -> 71;
                    case 111 -> 89;
                    case 112 -> 229;
                    case 113 -> 120;
                    case 114 -> 68;
                    case 115 -> 175;
                    case 116 -> 165;
                    case 117 -> 0;
                    case 118 -> 153;
                    case 119 -> 185;
                    case 120 -> 111;
                    case 121 -> 117;
                    case 122 -> 131;
                    case 123 -> 228;
                    case 124 -> 104;
                    case 125 -> 181;
                    case 126 -> 40;
                    case 127 -> 28;
                    case 128 -> 73;
                    case 129 -> 90;
                    case 130 -> 180;
                    case 131 -> 179;
                    case 132 -> 30;
                    case 133 -> 6;
                    case 134 -> 200;
                    case 135 -> 110;
                    case 136 -> 26;
                    case 137 -> 37;
                    case 138 -> 235;
                    case 139 -> 204;
                    case 140 -> 119;
                    case 141 -> 250;
                    case 142 -> 69;
                    case 143 -> 154;
                    case 144 -> 149;
                    case 145 -> 27;
                    case 146 -> 241;
                    case 147 -> 5;
                    case 148 -> 97;
                    case 149 -> 31;
                    case 150 -> 48;
                    case 151 -> 242;
                    case 152 -> 20;
                    case 153 -> 98;
                    case 154 -> 77;
                    case 155 -> 233;
                    case 156 -> 100;
                    case 157 -> 232;
                    case 158 -> 251;
                    case 159 -> 231;
                    case 160 -> 115;
                    case 161 -> 205;
                    case 162 -> 163;
                    case 163 -> 21;
                    case 164 -> 208;
                    case 165 -> 234;
                    case 166 -> 247;
                    case 167 -> 207;
                    case 168 -> 201;
                    case 169 -> 118;
                    case 170 -> 238;
                    case 171 -> 96;
                    case 172 -> 54;
                    case 173 -> 2;
                    case 174 -> 14;
                    case 175 -> 58;
                    case 176 -> 124;
                    case 177 -> 147;
                    case 178 -> 217;
                    case 179 -> 140;
                    case 180 -> 212;
                    case 181 -> 55;
                    case 182 -> 24;
                    case 183 -> 142;
                    case 184 -> 178;
                    case 185 -> 108;
                    case 186 -> 249;
                    case 187 -> 94;
                    case 188 -> 236;
                    case 189 -> 66;
                    case 190 -> 134;
                    case 191 -> 19;
                    case 192 -> 224;
                    case 193 -> 95;
                    case 194 -> 13;
                    case 195 -> 160;
                    case 196 -> 99;
                    case 197 -> 253;
                    case 198 -> 12;
                    case 199 -> 177;
                    case 200 -> 226;
                    case 201 -> 72;
                    case 202 -> 203;
                    case 203 -> 230;
                    case 204 -> 148;
                    case 205 -> 167;
                    case 206 -> 155;
                    case 207 -> 62;
                    case 208 -> 45;
                    case 209 -> 15;
                    case 210 -> 16;
                    case 211 -> 248;
                    case 212 -> 59;
                    case 213 -> 216;
                    case 214 -> 128;
                    case 215 -> 56;
                    case 216 -> 51;
                    case 217 -> 218;
                    case 218 -> 11;
                    case 219 -> 103;
                    case 220 -> 190;
                    case 221 -> 129;
                    case 222 -> 125;
                    case 223 -> 198;
                    case 224 -> 144;
                    case 225 -> 213;
                    case 226 -> 91;
                    case 227 -> 44;
                    case 228 -> 195;
                    case 229 -> 188;
                    case 230 -> 53;
                    case 231 -> 227;
                    case 232 -> 39;
                    case 233 -> 7;
                    case 234 -> 67;
                    case 235 -> 137;
                    case 236 -> 130;
                    case 237 -> 219;
                    case 238 -> 252;
                    case 239 -> 164;
                    case 240 -> 145;
                    case 241 -> 75;
                    case 242 -> 254;
                    case 243 -> 84;
                    case 244 -> 49;
                    case 245 -> 101;
                    case 246 -> 70;
                    case 247 -> 78;
                    case 248 -> 174;
                    case 249 -> 132;
                    case 250 -> 25;
                    case 251 -> 38;
                    case 252 -> 196;
                    case 253 -> 113;
                    case 254 -> 87;
                    default -> 106;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

