/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.ClassEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.jetbrains.plugins.remotesdk.RemoteSdkUsagesProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RemoteSdkTypeUsagesCollector {
    static final EventLogGroup GROUP = new EventLogGroup("remote.sdk.type", 5);
    private static final StringEventField LEVEL = EventFields.String((String)"level", List.of("ide", "project"));
    private static final ClassEventField SDK_TYPE = EventFields.Class((String)"sdk_type");
    private static final VarargEventId CONFIGURED_SDK = GROUP.registerVarargEvent("configured.sdk", new EventField[]{EventFields.Language, EventFields.Count, LEVEL, SDK_TYPE});
    private static final ExtensionPointName<RemoteSdkUsagesProvider> EP_NAME = new ExtensionPointName("com.jetbrains.plugins.remotesdk.usagesProvider");

    RemoteSdkTypeUsagesCollector() {
    }

    @NotNull
    private static Set<MetricEvent> collectUsages(@Nullable Project project) {
        HashSet<MetricEvent> usages = new HashSet<MetricEvent>();
        for (RemoteSdkUsagesProvider provider : EP_NAME.getExtensionList()) {
            Map collected = provider.getRemoteSdkTypes(project).stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            ArrayList<EventPair> data = new ArrayList<EventPair>();
            data.add(EventFields.Language.with((Object)provider.getLanguage()));
            data.add(LEVEL.with((Object)(project == null ? "ide" : "project")));
            for (Map.Entry entry : collected.entrySet()) {
                Class klass = (Class)entry.getKey();
                data.add(SDK_TYPE.with((Object)klass));
                int count = entry.getValue() > Integer.MAX_VALUE ? Integer.MAX_VALUE : entry.getValue().intValue();
                data.add(EventFields.Count.with((Object)count));
                usages.add(CONFIGURED_SDK.metric(data));
            }
        }
        HashSet<MetricEvent> hashSet = usages;
        if (hashSet == null) {
            RemoteSdkTypeUsagesCollector.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkTypeUsagesCollector", "collectUsages"));
    }

    static final class ProjectCollector
    extends ProjectUsagesCollector {
        ProjectCollector() {
        }

        public EventLogGroup getGroup() {
            return GROUP;
        }

        @NotNull
        public Set<MetricEvent> getMetrics(@NotNull Project project) {
            if (project == null) {
                ProjectCollector.$$$reportNull$$$0(0);
            }
            Set<MetricEvent> set = RemoteSdkTypeUsagesCollector.collectUsages(project);
            if (set == null) {
                ProjectCollector.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/remotesdk/RemoteSdkTypeUsagesCollector$ProjectCollector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/remotesdk/RemoteSdkTypeUsagesCollector$ProjectCollector";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetrics";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getMetrics";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    static final class AppCollector
    extends ApplicationUsagesCollector {
        AppCollector() {
        }

        public EventLogGroup getGroup() {
            return GROUP;
        }

        @NotNull
        public Set<MetricEvent> getMetrics() {
            Set<MetricEvent> set = RemoteSdkTypeUsagesCollector.collectUsages(null);
            if (set == null) {
                AppCollector.$$$reportNull$$$0(0);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkTypeUsagesCollector$AppCollector", "getMetrics"));
        }
    }
}

