import React, { useState, useEffect, useContext } from 'react';
import { Href, CollapseButton, Markdown, Extensions } from './index';
import { SchemaHelpers } from '../helpers';
var SchemaContext = React.createContext({
    reverse: false,
    deepExpanded: false,
});
export var Schema = function (_a) {
    var _b, _c, _d, _e, _f, _g;
    var schemaName = _a.schemaName, schema = _a.schema, _h = _a.required, required = _h === void 0 ? false : _h, _j = _a.isPatternProperty, isPatternProperty = _j === void 0 ? false : _j, _k = _a.isProperty, isProperty = _k === void 0 ? false : _k, _l = _a.isCircular, isCircular = _l === void 0 ? false : _l, dependentRequired = _a.dependentRequired, _m = _a.expanded, propExpanded = _m === void 0 ? false : _m, _o = _a.onlyTitle, onlyTitle = _o === void 0 ? false : _o, _p = _a.isArray, isArray = _p === void 0 ? false : _p;
    var _q = useContext(SchemaContext), reverse = _q.reverse, deepExpanded = _q.deepExpanded;
    var _r = useState(propExpanded || isArray), expanded = _r[0], setExpanded = _r[1];
    var _s = useState(false), deepExpand = _s[0], setDeepExpand = _s[1];
    useEffect(function () {
        if (!isArray) {
            setDeepExpand(deepExpanded);
        }
    }, [isArray, deepExpanded, setDeepExpand]);
    useEffect(function () {
        if (!isArray) {
            setExpanded(deepExpand);
        }
    }, [isArray, deepExpand, setExpanded]);
    if (!schema ||
        (typeof schemaName === 'string' &&
            ((schemaName === null || schemaName === void 0 ? void 0 : schemaName.startsWith('x-parser-')) ||
                (schemaName === null || schemaName === void 0 ? void 0 : schemaName.startsWith('x-schema-private-'))))) {
        return null;
    }
    var dependentSchemas = SchemaHelpers.getDependentSchemas(schema);
    var constraints = SchemaHelpers.humanizeConstraints(schema);
    var externalDocs = schema.externalDocs();
    var rawValueExt = schema.extensions().get(SchemaHelpers.extRawValue);
    var rawValue = (rawValueExt === null || rawValueExt === void 0 ? void 0 : rawValueExt.value()) === true;
    var parameterLocationExt = schema
        .extensions()
        .get(SchemaHelpers.extParameterLocation);
    var parameterLocation = (parameterLocationExt === null || parameterLocationExt === void 0 ? void 0 : parameterLocationExt.value()) === true;
    var schemaType = SchemaHelpers.toSchemaType(schema);
    var isExpandable = SchemaHelpers.isExpandable(schema) || dependentSchemas;
    isCircular = isCircular || schema.isCircular() || false;
    var uid = schema.$id();
    var styledSchemaName = isProperty ? 'italic' : '';
    var renderedSchemaName = typeof schemaName === 'string' ? (React.createElement("span", { className: "break-anywhere text-sm ".concat(styledSchemaName) }, schemaName)) : (schemaName);
    return (React.createElement(SchemaContext.Provider, { value: { reverse: !reverse, deepExpanded: deepExpand } },
        React.createElement("div", null,
            React.createElement("div", { className: "flex py-2" },
                React.createElement("div", { className: "".concat(onlyTitle ? '' : 'min-w-1/4', " mr-2") },
                    isExpandable && !isCircular && !isArray ? (React.createElement(React.Fragment, null,
                        React.createElement(CollapseButton, { onClick: function () { return setExpanded(function (prev) { return !prev; }); }, expanded: expanded }, renderedSchemaName),
                        React.createElement("button", { type: "button", onClick: function () { return setDeepExpand(function (prev) { return !prev; }); }, className: "ml-1 text-sm text-gray-500" }, deepExpand ? 'Collapse all' : 'Expand all'))) : (React.createElement("span", { className: "break-anywhere text-sm ".concat(isProperty ? 'italic' : '') }, schemaName)),
                    isPatternProperty && (React.createElement("div", { className: "text-gray-500 text-xs italic" }, "(pattern property)")),
                    required && React.createElement("div", { className: "text-red-600 text-xs" }, "required"),
                    dependentRequired && (React.createElement(React.Fragment, null,
                        React.createElement("div", { className: "text-gray-500 text-xs" }, "required when defined:"),
                        React.createElement("div", { className: "text-red-600 text-xs" }, dependentRequired.join(', ')))),
                    schema.deprecated() && (React.createElement("div", { className: "text-red-600 text-xs" }, "deprecated")),
                    schema.writeOnly() && (React.createElement("div", { className: "text-gray-500 text-xs" }, "write-only")),
                    schema.readOnly() && (React.createElement("div", { className: "text-gray-500 text-xs" }, "read-only"))),
                rawValue ? (React.createElement("div", null,
                    React.createElement("div", { className: "text-sm" }, SchemaHelpers.prettifyValue(schema.const(), false)))) : (React.createElement("div", null,
                    React.createElement("div", null,
                        React.createElement("div", { className: "capitalize text-sm text-teal-500 font-bold inline-block mr-2" }, isCircular ? "".concat(schemaType, " [CIRCULAR]") : schemaType),
                        React.createElement("div", { className: "inline-block" },
                            schema.format() && (React.createElement("strong", { className: "bg-yellow-600 no-underline text-white rounded lowercase mr-2 p-1 text-xs" },
                                "format: ",
                                schema.format())),
                            schema.pattern() !== undefined && (React.createElement("strong", { className: "bg-yellow-600 no-underline text-white rounded mr-2 p-1 text-xs" },
                                "must match: ",
                                schema.pattern())),
                            schema.contentMediaType() !== undefined && (React.createElement("strong", { className: "bg-yellow-600 no-underline text-white rounded lowercase mr-2 p-1 text-xs" },
                                "media type: ",
                                schema.contentMediaType())),
                            schema.contentEncoding() !== undefined && (React.createElement("strong", { className: "bg-yellow-600 no-underline text-white rounded lowercase mr-2 p-1 text-xs" },
                                "encoding: ",
                                schema.contentEncoding())),
                            !!constraints.length &&
                                constraints.map(function (c) { return (React.createElement("strong", { className: "bg-purple-600 no-underline text-white rounded lowercase mr-2 p-1 text-xs", key: c }, c)); }),
                            uid && !uid.startsWith('<anonymous-') && (React.createElement("span", { className: "border text-orange-600 rounded mr-2 p-1 text-xs" },
                                "uid: ",
                                uid))),
                        schema.description() !== undefined && (React.createElement("div", null,
                            React.createElement(Markdown, null, schema.description()))),
                        schema.default() !== undefined && (React.createElement("div", { className: "text-xs" },
                            "Default value:",
                            React.createElement("span", { className: "inline-block bg-orange-600 text-white rounded ml-1 py-0 px-2" }, SchemaHelpers.prettifyValue(schema.default())))),
                        schema.const() !== undefined && (React.createElement("div", { className: "text-xs" },
                            "Const:",
                            React.createElement("span", { className: "inline-block bg-orange-600 text-white rounded ml-1 py-0 px-2" }, SchemaHelpers.prettifyValue(schema.const())))),
                        schema.enum() && (React.createElement("ul", { className: "text-xs" },
                            "Allowed values:",
                            ' ', (_b = schema.enum()) === null || _b === void 0 ? void 0 :
                            _b.map(function (e, idx) { return (React.createElement("li", { key: idx, className: "inline-block bg-orange-600 text-white rounded ml-1 py-0 px-2" },
                                React.createElement("span", null, SchemaHelpers.prettifyValue(e)))); }))),
                        parameterLocation && (React.createElement("div", { className: "text-xs" },
                            "Parameter location:",
                            ' ',
                            React.createElement("span", { className: "border text-orange-600 rounded mr-2 p-1 text-xs" }, parameterLocation))),
                        externalDocs && (React.createElement("strong", { className: "border border-solid border-orange-300 hover:bg-orange-300 hover:text-orange-600 text-orange-500 no-underline text-xs uppercase rounded px-2 py-0" },
                            React.createElement(Href, { href: externalDocs.url(), title: (_c = externalDocs.description()) !== null && _c !== void 0 ? _c : '' }, "Documentation"))),
                        schema.examples() && (React.createElement("ul", { className: "text-xs" },
                            "Examples values:",
                            ' ', (_d = schema.examples()) === null || _d === void 0 ? void 0 :
                            _d.map(function (e, idx) { return (React.createElement("li", { key: idx, className: "inline-block bg-orange-600 text-white rounded ml-1 py-0 px-2 break-all" },
                                React.createElement("span", null, SchemaHelpers.prettifyValue(e)))); }))))))),
            isCircular || !isExpandable ? null : (React.createElement("div", { className: "rounded p-4 py-2 border bg-gray-100 ".concat(reverse ? 'bg-gray-200' : '', " ").concat(expanded ? 'block' : 'hidden') },
                React.createElement(SchemaProperties, { schema: schema }),
                React.createElement(SchemaItems, { schema: schema }), (_e = schema
                .oneOf()) === null || _e === void 0 ? void 0 :
                _e.map(function (s, idx) {
                    var _a;
                    return (React.createElement(Schema, { key: idx, schema: s, schemaName: SchemaHelpers.applicatorSchemaName(idx, 'Adheres to', 'Or to', (_a = s.title()) !== null && _a !== void 0 ? _a : s.id()) }));
                }), (_f = schema
                .anyOf()) === null || _f === void 0 ? void 0 :
                _f.map(function (s, idx) {
                    var _a;
                    return (React.createElement(Schema, { key: idx, schema: s, schemaName: SchemaHelpers.applicatorSchemaName(idx, 'Can adhere to', 'Or to', (_a = s.title()) !== null && _a !== void 0 ? _a : s.id()) }));
                }), (_g = schema
                .allOf()) === null || _g === void 0 ? void 0 :
                _g.map(function (s, idx) {
                    var _a;
                    return (React.createElement(Schema, { key: idx, schema: s, schemaName: SchemaHelpers.applicatorSchemaName(idx, 'Consists of', 'And of', (_a = s.title()) !== null && _a !== void 0 ? _a : s.id()) }));
                }),
                schema.not() && (React.createElement(Schema, { schema: schema.not(), schemaName: "Cannot adhere to:" })),
                schema.propertyNames() && (React.createElement(Schema, { schema: schema.propertyNames(), schemaName: "Property names must adhere to:" })),
                schema.contains() && (React.createElement(Schema, { schema: schema.contains(), schemaName: "Array must contain at least one of:" })),
                schema.if() && (React.createElement(Schema, { schema: schema.if(), schemaName: "If schema adheres to:" })),
                schema.then() && (React.createElement(Schema, { schema: schema.then(), schemaName: "Then must adhere to:" })),
                schema.else() && (React.createElement(Schema, { schema: schema.else(), schemaName: "Otherwise:" })),
                dependentSchemas && (React.createElement(Schema, { schema: dependentSchemas, schemaName: "Dependent schemas:" })),
                React.createElement(Extensions, { item: schema }),
                React.createElement(AdditionalProperties, { schema: schema }),
                React.createElement(AdditionalItems, { schema: schema }))))));
};
var SchemaProperties = function (_a) {
    var _b;
    var schema = _a.schema;
    var properties = schema.properties();
    if (properties === undefined || !Object.keys(properties)) {
        return null;
    }
    var required = (_b = schema.required()) !== null && _b !== void 0 ? _b : [];
    var patternProperties = schema.patternProperties();
    return (React.createElement(React.Fragment, null,
        Object.entries(properties).map(function (_a) {
            var propertyName = _a[0], property = _a[1];
            return (React.createElement(Schema, { schema: property, schemaName: propertyName, required: required.includes(propertyName), isProperty: true, isCircular: property.isCircular(), dependentRequired: SchemaHelpers.getDependentRequired(propertyName, schema), key: propertyName }));
        }),
        Object.entries(patternProperties !== null && patternProperties !== void 0 ? patternProperties : {}).map(function (_a) {
            var propertyName = _a[0], property = _a[1];
            return (React.createElement(Schema, { schema: property, schemaName: propertyName, isPatternProperty: true, isProperty: true, isCircular: property.isCircular(), key: propertyName }));
        })));
};
var AdditionalProperties = function (_a) {
    var _b;
    var schema = _a.schema;
    if (((_b = schema.extensions().get(SchemaHelpers.extRenderAdditionalInfo)) === null || _b === void 0 ? void 0 : _b.value()) ===
        false) {
        return null;
    }
    var type = schema.type();
    if (!(type === null || type === void 0 ? void 0 : type.includes('object'))) {
        return null;
    }
    var additionalProperties = schema.additionalProperties();
    if (additionalProperties === true || additionalProperties === undefined) {
        return (React.createElement("p", { className: "mt-2 text-xs text-gray-700" }, "Additional properties are allowed."));
    }
    if (additionalProperties === false) {
        return (React.createElement("p", { className: "mt-2 text-xs text-gray-700" },
            "Additional properties are ",
            React.createElement("strong", null, "NOT"),
            " allowed."));
    }
    return (React.createElement(Schema, { schemaName: "Additional properties:", schema: additionalProperties }));
};
var SchemaItems = function (_a) {
    var _b;
    var schema = _a.schema;
    var type = schema.type();
    if (!(type === null || type === void 0 ? void 0 : type.includes('array'))) {
        return null;
    }
    var items = schema.items();
    if (items &&
        !Array.isArray(items) &&
        Object.keys((_b = items.properties()) !== null && _b !== void 0 ? _b : {}).length) {
        return React.createElement(Schema, { schema: items, isArray: true });
    }
    else if (Array.isArray(items)) {
        return (React.createElement(React.Fragment, null, items.map(function (item, idx) { return (React.createElement(Schema, { schema: item, isArray: true, schemaName: "".concat(idx + 1, " item:"), key: idx })); })));
    }
    return React.createElement(Schema, { schema: items, isArray: true, schemaName: "Items:" });
};
var AdditionalItems = function (_a) {
    var _b;
    var schema = _a.schema;
    if (((_b = schema.extensions().get(SchemaHelpers.extRenderAdditionalInfo)) === null || _b === void 0 ? void 0 : _b.value()) ===
        false) {
        return null;
    }
    var type = schema.type();
    if (!(type === null || type === void 0 ? void 0 : type.includes('array'))) {
        return null;
    }
    if (!Array.isArray(schema.items())) {
        return null;
    }
    var additionalItems = schema.additionalItems();
    if (additionalItems === true || additionalItems === undefined) {
        return (React.createElement("p", { className: "mt-2 text-xs text-gray-700" }, "Additional items are allowed."));
    }
    if (additionalItems === false) {
        return (React.createElement("p", { className: "mt-2 text-xs text-gray-700" },
            "Additional items are ",
            React.createElement("strong", null, "NOT"),
            " allowed."));
    }
    return React.createElement(Schema, { schemaName: "Additional items:", schema: additionalItems });
};
//# sourceMappingURL=Schema.js.map