---
title: "Internxt Drive"
description: "Rclone docs for Internxt Drive"
versionIntroduced: "v1.73"
---

# {{< icon "fas fa-cloud" >}} Internxt Drive

[Internxt Drive](https://internxt.com) is a zero-knowledge encrypted cloud storage service.

Paths are specified as `remote:path`

Paths may be as deep as required, e.g. `remote:directory/subdirectory`.

## Limitations

**Note:** The Internxt backend may not work with all account types. Please refer to [Internxt plan details](https://internxt.com/pricing) or contact [Internxt support](https://help.internxt.com) to verify rclone compatibility with your subscription.

## Configuration

Here is an example of how to make a remote called `internxt`. Run `rclone config` and follow the prompts:

```
No remotes found, make a new one?
n) New remote
s) Set configuration password
q) Quit config
n/s/q> n
name> internxt
Type of storage to configure.
Choose a number from below, or type in your own value
[snip]
XX / Internxt Drive
   \ "internxt"
[snip]
Storage> internxt

Option email.
Email of your Internxt account.
Enter a value.
email> user@example.com

Option pass.
Password.
Enter a value.
password>

Edit advanced config?
y) Yes
n) No (default)
y/n> n

Configuration complete.
Options:
- type: internxt
- email: user@example.com
- pass: *** ENCRYPTED ***
Keep this "internxt" remote?
y) Yes this is OK (default)
e) Edit this remote
d) Delete this remote
y/e/d> y
```

If you have two-factor authentication enabled on your Internxt account, you will be prompted to enter the code during login.

### Security Considerations

The authentication process stores your password and mnemonic in the rclone configuration file. It is **strongly recommended** to encrypt your rclone config to protect these sensitive credentials:

```
rclone config password
```

This will prompt you to set a password that encrypts your entire configuration file.

### Usage Examples

```
# List files
rclone ls internxt:

# Copy files to Internxt
rclone copy /local/path internxt:remote/path

# Sync local directory to Internxt
rclone sync /local/path internxt:remote/path

# Mount Internxt Drive as a local filesystem
rclone mount internxt: /path/to/mountpoint

# Check storage usage
rclone about internxt:
```

### Modification times and hashes

The Internxt backend does not support hashes.

Modification times are read from the server but cannot be set. The backend reports `ModTimeNotSupported` precision, so modification times will not be used for sync comparisons.

### Restricted filename characters

The Internxt backend replaces the [default restricted characters
set](/overview/#restricted-characters).

<!-- autogenerated options start - DO NOT EDIT - instead edit fs.RegInfo in backend/internxt/internxt.go and run make backenddocs to verify --> <!-- markdownlint-disable-line line-length -->
### Standard options

Here are the Standard options specific to internxt (Internxt Drive).

#### --internxt-email

Email of your Internxt account.

Properties:

- Config:      email
- Env Var:     RCLONE_INTERNXT_EMAIL
- Type:        string
- Required:    true

#### --internxt-pass

Password.

**NB** Input to this must be obscured - see [rclone obscure](/commands/rclone_obscure/).

Properties:

- Config:      pass
- Env Var:     RCLONE_INTERNXT_PASS
- Type:        string
- Required:    true

### Advanced options

Here are the Advanced options specific to internxt (Internxt Drive).

#### --internxt-mnemonic

Mnemonic (internal use only)

Properties:

- Config:      mnemonic
- Env Var:     RCLONE_INTERNXT_MNEMONIC
- Type:        string
- Required:    false

#### --internxt-skip-hash-validation

Skip hash validation when downloading files.

By default, hash validation is disabled. Set this to false to enable validation.

Properties:

- Config:      skip_hash_validation
- Env Var:     RCLONE_INTERNXT_SKIP_HASH_VALIDATION
- Type:        bool
- Default:     true

#### --internxt-encoding

The encoding for the backend.

See the [encoding section in the overview](/overview/#encoding) for more info.

Properties:

- Config:      encoding
- Env Var:     RCLONE_INTERNXT_ENCODING
- Type:        Encoding
- Default:     Slash,BackSlash,CrLf,RightPeriod,InvalidUtf8,Dot

#### --internxt-description

Description of the remote.

Properties:

- Config:      description
- Env Var:     RCLONE_INTERNXT_DESCRIPTION
- Type:        string
- Required:    false

<!-- autogenerated options stop -->
