//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// This is the type of a reference to an object that represents
/// a network interface.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/scnetworkinterface?language=objc)
#[doc(alias = "SCNetworkInterfaceRef")]
#[repr(C)]
pub struct SCNetworkInterface {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl SCNetworkInterface {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__SCNetworkInterface"> for SCNetworkInterface {}
);

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscnetworkinterfacetype6to4?language=objc)
    pub static kSCNetworkInterfaceType6to4: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscnetworkinterfacetypebluetooth?language=objc)
    pub static kSCNetworkInterfaceTypeBluetooth: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscnetworkinterfacetypebond?language=objc)
    pub static kSCNetworkInterfaceTypeBond: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscnetworkinterfacetypeethernet?language=objc)
    pub static kSCNetworkInterfaceTypeEthernet: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscnetworkinterfacetypefirewire?language=objc)
    pub static kSCNetworkInterfaceTypeFireWire: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscnetworkinterfacetypeieee80211?language=objc)
    pub static kSCNetworkInterfaceTypeIEEE80211: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscnetworkinterfacetypeipsec?language=objc)
    pub static kSCNetworkInterfaceTypeIPSec: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscnetworkinterfacetypeirda?language=objc)
    #[deprecated = "No longer supported"]
    pub static kSCNetworkInterfaceTypeIrDA: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscnetworkinterfacetypel2tp?language=objc)
    pub static kSCNetworkInterfaceTypeL2TP: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscnetworkinterfacetypemodem?language=objc)
    pub static kSCNetworkInterfaceTypeModem: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscnetworkinterfacetypeppp?language=objc)
    pub static kSCNetworkInterfaceTypePPP: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscnetworkinterfacetypepptp?language=objc)
    #[deprecated = "No longer supported"]
    pub static kSCNetworkInterfaceTypePPTP: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscnetworkinterfacetypeserial?language=objc)
    pub static kSCNetworkInterfaceTypeSerial: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscnetworkinterfacetypevlan?language=objc)
    pub static kSCNetworkInterfaceTypeVLAN: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscnetworkinterfacetypewwan?language=objc)
    pub static kSCNetworkInterfaceTypeWWAN: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscnetworkinterfacetypeipv4?language=objc)
    pub static kSCNetworkInterfaceTypeIPv4: &'static CFString;
}

extern "C" {
    /// A network interface that can used for layering other
    /// interfaces (e.g. 6to4, IPSec, PPTP, L2TP) over an existing
    /// IPv4 network.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscnetworkinterfaceipv4?language=objc)
    pub static kSCNetworkInterfaceIPv4: &'static SCNetworkInterface;
}

/// This is the type of a reference to an object that represents
/// an Ethernet Bond interface.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/scbondinterface?language=objc)
#[doc(alias = "SCBondInterfaceRef")]
pub type SCBondInterface = SCNetworkInterface;

/// This is the type of a reference to an object that represents
/// the status of an Ethernet Bond interface.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/scbondstatus?language=objc)
#[doc(alias = "SCBondStatusRef")]
#[repr(C)]
pub struct SCBondStatus {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl SCBondStatus {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__SCBondStatus"> for SCBondStatus {}
);

/// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscbondstatusok?language=objc)
pub const kSCBondStatusOK: c_uint = 0;
/// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscbondstatuslinkinvalid?language=objc)
pub const kSCBondStatusLinkInvalid: c_uint = 1;
/// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscbondstatusnopartner?language=objc)
pub const kSCBondStatusNoPartner: c_uint = 2;
/// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscbondstatusnotinactivegroup?language=objc)
pub const kSCBondStatusNotInActiveGroup: c_uint = 3;
/// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscbondstatusunknown?language=objc)
pub const kSCBondStatusUnknown: c_uint = 999;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscbondstatusdeviceaggregationstatus?language=objc)
    pub static kSCBondStatusDeviceAggregationStatus: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscbondstatusdevicecollecting?language=objc)
    pub static kSCBondStatusDeviceCollecting: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscbondstatusdevicedistributing?language=objc)
    pub static kSCBondStatusDeviceDistributing: &'static CFString;
}

/// This is the type of a reference to an object that represents
/// a Virtual LAN (VLAN) interface.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/scvlaninterface?language=objc)
#[doc(alias = "SCVLANInterfaceRef")]
pub type SCVLANInterface = SCNetworkInterface;

/// This is the type of a reference to an object that represents
/// a network protocol.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/scnetworkprotocol?language=objc)
#[doc(alias = "SCNetworkProtocolRef")]
#[repr(C)]
pub struct SCNetworkProtocol {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl SCNetworkProtocol {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__SCNetworkProtocol"> for SCNetworkProtocol {}
);

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscnetworkprotocoltypedns?language=objc)
    pub static kSCNetworkProtocolTypeDNS: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscnetworkprotocoltypeipv4?language=objc)
    pub static kSCNetworkProtocolTypeIPv4: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscnetworkprotocoltypeipv6?language=objc)
    pub static kSCNetworkProtocolTypeIPv6: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscnetworkprotocoltypeproxies?language=objc)
    pub static kSCNetworkProtocolTypeProxies: &'static CFString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/kscnetworkprotocoltypesmb?language=objc)
    pub static kSCNetworkProtocolTypeSMB: &'static CFString;
}

/// This is the type of a reference to an object that represents
/// a network service.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/scnetworkservice?language=objc)
#[doc(alias = "SCNetworkServiceRef")]
#[repr(C)]
pub struct SCNetworkService {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl SCNetworkService {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__SCNetworkService"> for SCNetworkService {}
);

/// This is the type of a reference to an object that represents
/// a network set.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/systemconfiguration/scnetworkset?language=objc)
#[doc(alias = "SCNetworkSetRef")]
#[repr(C)]
pub struct SCNetworkSet {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl SCNetworkSet {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__SCNetworkSet"> for SCNetworkSet {}
);

unsafe impl ConcreteType for SCNetworkInterface {
    /// Returns the type identifier of all SCNetworkInterface instances.
    #[doc(alias = "SCNetworkInterfaceGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn SCNetworkInterfaceGetTypeID() -> CFTypeID;
        }
        unsafe { SCNetworkInterfaceGetTypeID() }
    }
}

impl SCNetworkInterface {
    /// Returns all network capable interfaces on the system.
    ///
    /// Returns: The list of interfaces on the system.
    /// You must release the returned value.
    #[doc(alias = "SCNetworkInterfaceCopyAll")]
    #[inline]
    pub fn all() -> CFRetained<CFArray> {
        extern "C-unwind" {
            fn SCNetworkInterfaceCopyAll() -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { SCNetworkInterfaceCopyAll() };
        let ret =
            ret.expect("function was marked as returning non-null, but actually returned NULL");
        unsafe { CFRetained::from_raw(ret) }
    }

    /// Identify all of the network interface types (e.g. PPP) that
    /// can be layered on top of this interface.
    ///
    /// Parameter `interface`: The network interface.
    ///
    /// Returns: The list of SCNetworkInterface types supported by the interface;
    /// NULL if no interface types are supported.
    #[doc(alias = "SCNetworkInterfaceGetSupportedInterfaceTypes")]
    #[inline]
    pub fn supported_interface_types(&self) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn SCNetworkInterfaceGetSupportedInterfaceTypes(
                interface: &SCNetworkInterface,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { SCNetworkInterfaceGetSupportedInterfaceTypes(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Identify all of the network protocol types (e.g. IPv4, IPv6) that
    /// can be layered on top of this interface.
    ///
    /// Parameter `interface`: The network interface.
    ///
    /// Returns: The list of SCNetworkProtocol types supported by the interface;
    /// NULL if no protocol types are supported.
    #[doc(alias = "SCNetworkInterfaceGetSupportedProtocolTypes")]
    #[inline]
    pub fn supported_protocol_types(&self) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn SCNetworkInterfaceGetSupportedProtocolTypes(
                interface: &SCNetworkInterface,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { SCNetworkInterfaceGetSupportedProtocolTypes(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Create a new network interface layered on top of another.  For
    /// example, this function would be used to create a "PPP" interface
    /// on top of a "modem".
    ///
    /// Parameter `interface`: The network interface.
    ///
    /// Parameter `interfaceType`: The type of SCNetworkInterface to be layered on
    /// top of the provided interface.
    ///
    /// Returns: A reference to the new SCNetworkInterface.
    /// You must release the returned value.
    #[doc(alias = "SCNetworkInterfaceCreateWithInterface")]
    #[inline]
    pub fn with_interface(
        &self,
        interface_type: &CFString,
    ) -> Option<CFRetained<SCNetworkInterface>> {
        extern "C-unwind" {
            fn SCNetworkInterfaceCreateWithInterface(
                interface: &SCNetworkInterface,
                interface_type: &CFString,
            ) -> Option<NonNull<SCNetworkInterface>>;
        }
        let ret = unsafe { SCNetworkInterfaceCreateWithInterface(self, interface_type) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns the BSD interface (en0) or device name (modem)
    /// for the interface.
    ///
    /// Parameter `interface`: The network interface.
    ///
    /// Returns: The BSD name associated with the interface (e.g. "en0");
    /// NULL if no BSD name is available.
    #[doc(alias = "SCNetworkInterfaceGetBSDName")]
    #[inline]
    pub fn bsd_name(&self) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn SCNetworkInterfaceGetBSDName(
                interface: &SCNetworkInterface,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { SCNetworkInterfaceGetBSDName(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Returns the configuration settings associated with a interface.
    ///
    /// Parameter `interface`: The network interface.
    ///
    /// Returns: The configuration settings associated with the interface;
    /// NULL if no configuration settings are associated with the interface
    /// or an error was encountered.
    #[doc(alias = "SCNetworkInterfaceGetConfiguration")]
    #[inline]
    pub fn configuration(&self) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn SCNetworkInterfaceGetConfiguration(
                interface: &SCNetworkInterface,
            ) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { SCNetworkInterfaceGetConfiguration(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Returns the configuration settings associated with a interface.
    ///
    /// Parameter `interface`: The network interface.
    ///
    /// Parameter `extendedType`: A string representing the type of extended information (e.g. EAPOL).
    ///
    /// Returns: The configuration settings associated with the interface;
    /// NULL if no configuration settings are associated with the interface
    /// or an error was encountered.
    #[doc(alias = "SCNetworkInterfaceGetExtendedConfiguration")]
    #[inline]
    pub fn extended_configuration(
        &self,
        extended_type: &CFString,
    ) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn SCNetworkInterfaceGetExtendedConfiguration(
                interface: &SCNetworkInterface,
                extended_type: &CFString,
            ) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { SCNetworkInterfaceGetExtendedConfiguration(self, extended_type) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Returns a displayable link layer address for the interface.
    ///
    /// Parameter `interface`: The network interface.
    ///
    /// Returns: A string representing the hardware (MAC) address for the interface.
    #[doc(alias = "SCNetworkInterfaceGetHardwareAddressString")]
    #[inline]
    pub fn hardware_address_string(&self) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn SCNetworkInterfaceGetHardwareAddressString(
                interface: &SCNetworkInterface,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { SCNetworkInterfaceGetHardwareAddressString(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// For layered network interfaces, return the underlying interface.
    ///
    /// Parameter `interface`: The network interface.
    ///
    /// Returns: The underlying network interface;
    /// NULL if this is a leaf interface.
    #[doc(alias = "SCNetworkInterfaceGetInterface")]
    #[inline]
    pub fn interface(&self) -> Option<CFRetained<SCNetworkInterface>> {
        extern "C-unwind" {
            fn SCNetworkInterfaceGetInterface(
                interface: &SCNetworkInterface,
            ) -> Option<NonNull<SCNetworkInterface>>;
        }
        let ret = unsafe { SCNetworkInterfaceGetInterface(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Returns the associated network interface type.
    ///
    /// Parameter `interface`: The network interface.
    ///
    /// Returns: The interface type.
    #[doc(alias = "SCNetworkInterfaceGetInterfaceType")]
    #[inline]
    pub fn interface_type(&self) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn SCNetworkInterfaceGetInterfaceType(
                interface: &SCNetworkInterface,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { SCNetworkInterfaceGetInterfaceType(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Returns the localized name (e.g. "Ethernet", "FireWire") for
    /// the interface.
    ///
    /// Parameter `interface`: The network interface.
    ///
    /// Returns: A localized, display name for the interface;
    /// NULL if no name is available.
    #[doc(alias = "SCNetworkInterfaceGetLocalizedDisplayName")]
    #[inline]
    pub fn localized_display_name(&self) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn SCNetworkInterfaceGetLocalizedDisplayName(
                interface: &SCNetworkInterface,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { SCNetworkInterfaceGetLocalizedDisplayName(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Stores the configuration settings for the interface.
    ///
    /// Parameter `interface`: The network interface.
    ///
    /// Parameter `config`: The configuration settings to associate with this interface.
    ///
    /// Returns: TRUE if the configuration was stored; FALSE if an error was encountered.
    ///
    /// # Safety
    ///
    /// `config` generics must be of the correct type.
    #[doc(alias = "SCNetworkInterfaceSetConfiguration")]
    #[inline]
    pub unsafe fn set_configuration(&self, config: Option<&CFDictionary>) -> bool {
        extern "C-unwind" {
            fn SCNetworkInterfaceSetConfiguration(
                interface: &SCNetworkInterface,
                config: Option<&CFDictionary>,
            ) -> Boolean;
        }
        let ret = unsafe { SCNetworkInterfaceSetConfiguration(self, config) };
        ret != 0
    }

    /// Stores the configuration settings for the interface.
    ///
    /// Parameter `interface`: The network interface.
    ///
    /// Parameter `config`: The configuration settings to associate with this interface.
    ///
    /// Returns: TRUE if the configuration was stored; FALSE if an error was encountered.
    ///
    /// # Safety
    ///
    /// `config` generics must be of the correct type.
    #[doc(alias = "SCNetworkInterfaceSetExtendedConfiguration")]
    #[inline]
    pub unsafe fn set_extended_configuration(
        &self,
        extended_type: &CFString,
        config: Option<&CFDictionary>,
    ) -> bool {
        extern "C-unwind" {
            fn SCNetworkInterfaceSetExtendedConfiguration(
                interface: &SCNetworkInterface,
                extended_type: &CFString,
                config: Option<&CFDictionary>,
            ) -> Boolean;
        }
        let ret =
            unsafe { SCNetworkInterfaceSetExtendedConfiguration(self, extended_type, config) };
        ret != 0
    }

    /// For the specified network interface, returns information
    /// about the currently requested media options, the active media
    /// options, and the media options which are available.
    ///
    /// Parameter `interface`: The desired network interface.
    ///
    /// Parameter `current`: A pointer to memory that will be filled with a CFDictionaryRef
    /// representing the currently requested media options (subtype, options).
    /// If NULL, the current options will not be returned.
    ///
    /// Parameter `active`: A pointer to memory that will be filled with a CFDictionaryRef
    /// representing the active media options (subtype, options).
    /// If NULL, the active options will not be returned.
    ///
    /// Parameter `available`: A pointer to memory that will be filled with a CFArrayRef
    /// representing the possible media options (subtype, options).
    /// If NULL, the available options will not be returned.
    ///
    /// Parameter `filter`: A boolean indicating whether the available options should be
    /// filtered to exclude those options which would not normally be
    /// requested by a user/admin (e.g. hw-loopback).
    ///
    /// Returns: TRUE if requested information has been returned.
    ///
    /// # Safety
    ///
    /// - `current` must be a valid pointer or null.
    /// - `active` must be a valid pointer or null.
    /// - `available` must be a valid pointer or null.
    #[doc(alias = "SCNetworkInterfaceCopyMediaOptions")]
    #[inline]
    pub unsafe fn media_options(
        &self,
        current: *mut *const CFDictionary,
        active: *mut *const CFDictionary,
        available: *mut *const CFArray,
        filter: bool,
    ) -> bool {
        extern "C-unwind" {
            fn SCNetworkInterfaceCopyMediaOptions(
                interface: &SCNetworkInterface,
                current: *mut *const CFDictionary,
                active: *mut *const CFDictionary,
                available: *mut *const CFArray,
                filter: Boolean,
            ) -> Boolean;
        }
        let ret = unsafe {
            SCNetworkInterfaceCopyMediaOptions(self, current, active, available, filter as _)
        };
        ret != 0
    }

    /// For the provided interface configuration options, return a list
    /// of available media subtypes.
    ///
    /// Parameter `available`: The available options as returned by the
    /// SCNetworkInterfaceCopyMediaOptions function.
    ///
    /// Returns: An array of available media subtypes CFString's (e.g. 10BaseT/UTP,
    /// 100baseTX, etc).  NULL if no subtypes are available.
    #[doc(alias = "SCNetworkInterfaceCopyMediaSubTypes")]
    #[inline]
    pub fn media_sub_types(available: &CFArray) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn SCNetworkInterfaceCopyMediaSubTypes(available: &CFArray)
                -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { SCNetworkInterfaceCopyMediaSubTypes(available) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// For the provided interface configuration options and specific
    /// subtype, return a list of available media options.
    ///
    /// Parameter `available`: The available options as returned by the
    /// SCNetworkInterfaceCopyMediaOptions function.
    ///
    /// Parameter `subType`: The subtype
    ///
    /// Returns: An array of available media options.  Each of the available options
    /// is returned as an array of CFString's (e.g.
    /// <half
    /// -duplex>,
    /// <full
    /// -duplex,flow-control>).  NULL if no options are available.
    #[doc(alias = "SCNetworkInterfaceCopyMediaSubTypeOptions")]
    #[inline]
    pub fn media_sub_type_options(
        available: &CFArray,
        sub_type: &CFString,
    ) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn SCNetworkInterfaceCopyMediaSubTypeOptions(
                available: &CFArray,
                sub_type: &CFString,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { SCNetworkInterfaceCopyMediaSubTypeOptions(available, sub_type) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// For the specified network interface, returns information
    /// about the currently MTU setting and the range of allowable
    /// values.
    ///
    /// Parameter `interface`: The desired network interface.
    ///
    /// Parameter `mtu_cur`: A pointer to memory that will be filled with the current
    /// MTU setting for the interface.
    ///
    /// Parameter `mtu_min`: A pointer to memory that will be filled with the minimum
    /// MTU setting for the interface.  If negative, the minimum setting
    /// could not be determined.
    ///
    /// Parameter `mtu_max`: A pointer to memory that will be filled with the maximum
    /// MTU setting for the interface.  If negative, the maximum setting
    /// could not be determined.
    ///
    /// Returns: TRUE if requested information has been returned.
    ///
    /// # Safety
    ///
    /// - `mtu_cur` must be a valid pointer or null.
    /// - `mtu_min` must be a valid pointer or null.
    /// - `mtu_max` must be a valid pointer or null.
    #[doc(alias = "SCNetworkInterfaceCopyMTU")]
    #[inline]
    pub unsafe fn mtu(
        &self,
        mtu_cur: *mut c_int,
        mtu_min: *mut c_int,
        mtu_max: *mut c_int,
    ) -> bool {
        extern "C-unwind" {
            fn SCNetworkInterfaceCopyMTU(
                interface: &SCNetworkInterface,
                mtu_cur: *mut c_int,
                mtu_min: *mut c_int,
                mtu_max: *mut c_int,
            ) -> Boolean;
        }
        let ret = unsafe { SCNetworkInterfaceCopyMTU(self, mtu_cur, mtu_min, mtu_max) };
        ret != 0
    }

    /// For the specified network interface, sets the requested
    /// media subtype and options.
    ///
    /// Parameter `interface`: The desired network interface.
    ///
    /// Parameter `subtype`: The desired media subtype (e.g. "autoselect", "100baseTX", ...).
    /// If NULL, no specific media subtype will be requested.
    ///
    /// Parameter `options`: The desired media options (e.g. "half-duplex", "full-duplex", ...).
    /// If NULL, no specific media options will be requested.
    ///
    /// Returns: TRUE if the configuration was updated; FALSE if an error was encountered.
    #[doc(alias = "SCNetworkInterfaceSetMediaOptions")]
    #[inline]
    pub fn set_media_options(&self, subtype: Option<&CFString>, options: Option<&CFArray>) -> bool {
        extern "C-unwind" {
            fn SCNetworkInterfaceSetMediaOptions(
                interface: &SCNetworkInterface,
                subtype: Option<&CFString>,
                options: Option<&CFArray>,
            ) -> Boolean;
        }
        let ret = unsafe { SCNetworkInterfaceSetMediaOptions(self, subtype, options) };
        ret != 0
    }

    /// For the specified network interface, sets the
    /// requested MTU setting.
    ///
    /// Parameter `interface`: The desired network interface.
    ///
    /// Parameter `mtu`: The desired MTU setting for the interface.
    /// If zero, the interface will use the default MTU setting.
    ///
    /// Returns: TRUE if the configuration was updated; FALSE if an error was encountered.
    #[doc(alias = "SCNetworkInterfaceSetMTU")]
    #[inline]
    pub fn set_mtu(&self, mtu: c_int) -> bool {
        extern "C-unwind" {
            fn SCNetworkInterfaceSetMTU(interface: &SCNetworkInterface, mtu: c_int) -> Boolean;
        }
        let ret = unsafe { SCNetworkInterfaceSetMTU(self, mtu) };
        ret != 0
    }

    /// Sends a notification to interested network configuration
    /// agents to immediately retry their configuration. For example,
    /// calling this function will cause the DHCP client to contact
    /// the DHCP server immediately rather than waiting until its
    /// timeout has expired.  The utility of this function is to
    /// allow the caller to give a hint to the system that the
    /// network infrastructure or configuration has changed.
    ///
    /// Note: This function requires root (euid==0) privilege or,
    /// alternatively, you may pass an SCNetworkInterface which
    /// is derived from a sequence of calls to :
    ///
    /// SCPreferencesCreateWithAuthorization
    /// SCNetworkSetCopy...
    /// SCNetworkServiceGetInterface
    ///
    /// Parameter `interface`: The desired network interface.
    ///
    /// Returns: Returns TRUE if the notification was sent; FALSE otherwise.
    #[doc(alias = "SCNetworkInterfaceForceConfigurationRefresh")]
    #[inline]
    pub fn force_configuration_refresh(&self) -> bool {
        extern "C-unwind" {
            fn SCNetworkInterfaceForceConfigurationRefresh(
                interface: &SCNetworkInterface,
            ) -> Boolean;
        }
        let ret = unsafe { SCNetworkInterfaceForceConfigurationRefresh(self) };
        ret != 0
    }
}

/// Returns all Ethernet Bond interfaces on the system.
///
/// Parameter `prefs`: The "preferences" session.
///
/// Returns: The list of Ethernet Bond interfaces on the system.
/// You must release the returned value.
#[cfg(feature = "SCPreferences")]
#[inline]
pub extern "C-unwind" fn SCBondInterfaceCopyAll(prefs: &SCPreferences) -> CFRetained<CFArray> {
    extern "C-unwind" {
        fn SCBondInterfaceCopyAll(prefs: &SCPreferences) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { SCBondInterfaceCopyAll(prefs) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

/// Returns all network capable devices on the system
/// that can be added to an Ethernet Bond interface.
///
/// Parameter `prefs`: The "preferences" session.
///
/// Returns: The list of interfaces.
/// You must release the returned value.
#[cfg(feature = "SCPreferences")]
#[inline]
pub extern "C-unwind" fn SCBondInterfaceCopyAvailableMemberInterfaces(
    prefs: &SCPreferences,
) -> CFRetained<CFArray> {
    extern "C-unwind" {
        fn SCBondInterfaceCopyAvailableMemberInterfaces(
            prefs: &SCPreferences,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { SCBondInterfaceCopyAvailableMemberInterfaces(prefs) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

/// Create a new SCBondInterface interface.
///
/// Parameter `prefs`: The "preferences" session.
///
/// Returns: A reference to the new SCBondInterface.
/// You must release the returned value.
#[cfg(feature = "SCPreferences")]
#[inline]
pub extern "C-unwind" fn SCBondInterfaceCreate(
    prefs: &SCPreferences,
) -> Option<CFRetained<SCBondInterface>> {
    extern "C-unwind" {
        fn SCBondInterfaceCreate(prefs: &SCPreferences) -> Option<NonNull<SCBondInterface>>;
    }
    let ret = unsafe { SCBondInterfaceCreate(prefs) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// Removes the SCBondInterface from the configuration.
///
/// Parameter `bond`: The SCBondInterface interface.
///
/// Returns: TRUE if the interface was removed; FALSE if an error was encountered.
#[inline]
pub extern "C-unwind" fn SCBondInterfaceRemove(bond: &SCBondInterface) -> bool {
    extern "C-unwind" {
        fn SCBondInterfaceRemove(bond: &SCBondInterface) -> Boolean;
    }
    let ret = unsafe { SCBondInterfaceRemove(bond) };
    ret != 0
}

/// Returns the member interfaces for the specified Ethernet Bond interface.
///
/// Parameter `bond`: The SCBondInterface interface.
///
/// Returns: The list of interfaces.
#[inline]
pub extern "C-unwind" fn SCBondInterfaceGetMemberInterfaces(
    bond: &SCBondInterface,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn SCBondInterfaceGetMemberInterfaces(bond: &SCBondInterface) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { SCBondInterfaceGetMemberInterfaces(bond) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

/// Returns the configuration settings associated with a Ethernet Bond interface.
///
/// Parameter `bond`: The SCBondInterface interface.
///
/// Returns: The configuration settings associated with the Ethernet Bond interface;
/// NULL if no changes to the default configuration have been saved.
#[inline]
pub extern "C-unwind" fn SCBondInterfaceGetOptions(
    bond: &SCBondInterface,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn SCBondInterfaceGetOptions(bond: &SCBondInterface) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { SCBondInterfaceGetOptions(bond) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

/// Sets the member interfaces for the specified Ethernet Bond interface.
///
/// Parameter `bond`: The SCBondInterface interface.
///
/// Parameter `members`: The desired member interfaces.
///
/// Returns: TRUE if the configuration was stored; FALSE if an error was encountered.
///
/// # Safety
///
/// `members` generic must be of the correct type.
#[inline]
pub unsafe extern "C-unwind" fn SCBondInterfaceSetMemberInterfaces(
    bond: &SCBondInterface,
    members: &CFArray,
) -> bool {
    extern "C-unwind" {
        fn SCBondInterfaceSetMemberInterfaces(bond: &SCBondInterface, members: &CFArray)
            -> Boolean;
    }
    let ret = unsafe { SCBondInterfaceSetMemberInterfaces(bond, members) };
    ret != 0
}

/// Sets the localized display name for the specified Ethernet Bond interface.
///
/// Parameter `bond`: The SCBondInterface interface.
///
/// Parameter `newName`: The new display name.
///
/// Returns: TRUE if the configuration was stored; FALSE if an error was encountered.
#[inline]
pub extern "C-unwind" fn SCBondInterfaceSetLocalizedDisplayName(
    bond: &SCBondInterface,
    new_name: &CFString,
) -> bool {
    extern "C-unwind" {
        fn SCBondInterfaceSetLocalizedDisplayName(
            bond: &SCBondInterface,
            new_name: &CFString,
        ) -> Boolean;
    }
    let ret = unsafe { SCBondInterfaceSetLocalizedDisplayName(bond, new_name) };
    ret != 0
}

/// Sets the configuration settings for the specified Ethernet Bond interface.
///
/// Parameter `bond`: The SCBondInterface interface.
///
/// Parameter `newOptions`: The new configuration settings.
///
/// Returns: TRUE if the configuration was stored; FALSE if an error was encountered.
///
/// # Safety
///
/// `new_options` generics must be of the correct type.
#[inline]
pub unsafe extern "C-unwind" fn SCBondInterfaceSetOptions(
    bond: &SCBondInterface,
    new_options: &CFDictionary,
) -> bool {
    extern "C-unwind" {
        fn SCBondInterfaceSetOptions(bond: &SCBondInterface, new_options: &CFDictionary)
            -> Boolean;
    }
    let ret = unsafe { SCBondInterfaceSetOptions(bond, new_options) };
    ret != 0
}

/// Returns the status of the specified Ethernet Bond interface.
///
/// Parameter `bond`: The SCBondInterface interface.
///
/// Returns: The status associated with the interface.
/// You must release the returned value.
#[inline]
pub extern "C-unwind" fn SCBondInterfaceCopyStatus(
    bond: &SCBondInterface,
) -> Option<CFRetained<SCBondStatus>> {
    extern "C-unwind" {
        fn SCBondInterfaceCopyStatus(bond: &SCBondInterface) -> Option<NonNull<SCBondStatus>>;
    }
    let ret = unsafe { SCBondInterfaceCopyStatus(bond) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

unsafe impl ConcreteType for SCBondStatus {
    /// Returns the type identifier of all SCBondStatus instances.
    #[doc(alias = "SCBondStatusGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn SCBondStatusGetTypeID() -> CFTypeID;
        }
        unsafe { SCBondStatusGetTypeID() }
    }
}

impl SCBondStatus {
    /// Returns the member interfaces that are represented with the
    /// Ethernet Bond interface.
    ///
    /// Parameter `bondStatus`: The Ethernet Bond status.
    ///
    /// Returns: The list of interfaces.
    #[doc(alias = "SCBondStatusGetMemberInterfaces")]
    #[inline]
    pub fn member_interfaces(&self) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn SCBondStatusGetMemberInterfaces(
                bond_status: &SCBondStatus,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { SCBondStatusGetMemberInterfaces(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Returns the status of a specific member interface of an
    /// Ethernet Bond or the status of the bond as a whole.
    ///
    /// Parameter `bondStatus`: The Ethernet Bond status.
    ///
    /// Parameter `interface`: The specific member interface; NULL if you want the
    /// status of the Ethernet Bond.
    ///
    /// Returns: The interface status.
    ///
    /// Note: at present, no information about the status of the Ethernet
    /// Bond is returned.  As long as one member interface is active
    /// then the bond should be operational.
    #[doc(alias = "SCBondStatusGetInterfaceStatus")]
    #[inline]
    pub fn interface_status(
        &self,
        interface: Option<&SCNetworkInterface>,
    ) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn SCBondStatusGetInterfaceStatus(
                bond_status: &SCBondStatus,
                interface: Option<&SCNetworkInterface>,
            ) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { SCBondStatusGetInterfaceStatus(self, interface) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }
}

/// Returns all VLAN interfaces on the system.
///
/// Returns: The list of VLAN interfaces on the system.
/// You must release the returned value.
#[cfg(feature = "SCPreferences")]
#[inline]
pub extern "C-unwind" fn SCVLANInterfaceCopyAll(prefs: &SCPreferences) -> CFRetained<CFArray> {
    extern "C-unwind" {
        fn SCVLANInterfaceCopyAll(prefs: &SCPreferences) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { SCVLANInterfaceCopyAll(prefs) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

/// Returns the network capable devices on the system
/// that can be associated with a VLAN interface.
///
/// Returns: The list of interfaces.
/// You must release the returned value.
#[inline]
pub extern "C-unwind" fn SCVLANInterfaceCopyAvailablePhysicalInterfaces() -> CFRetained<CFArray> {
    extern "C-unwind" {
        fn SCVLANInterfaceCopyAvailablePhysicalInterfaces() -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { SCVLANInterfaceCopyAvailablePhysicalInterfaces() };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

/// Create a new SCVLANInterface interface.
///
/// Parameter `prefs`: The "preferences" session.
///
/// Parameter `physical`: The physical interface to associate with the VLAN.
///
/// Parameter `tag`: The tag to associate with the VLAN.
///
/// Returns: A reference to the new SCVLANInterface.
/// You must release the returned value.
///
/// Note: the tag must be in the range (1
/// <
/// = tag
/// <
/// = 4094)
#[cfg(feature = "SCPreferences")]
#[inline]
pub extern "C-unwind" fn SCVLANInterfaceCreate(
    prefs: &SCPreferences,
    physical: &SCNetworkInterface,
    tag: &CFNumber,
) -> Option<CFRetained<SCVLANInterface>> {
    extern "C-unwind" {
        fn SCVLANInterfaceCreate(
            prefs: &SCPreferences,
            physical: &SCNetworkInterface,
            tag: &CFNumber,
        ) -> Option<NonNull<SCVLANInterface>>;
    }
    let ret = unsafe { SCVLANInterfaceCreate(prefs, physical, tag) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

/// Removes the SCVLANInterface from the configuration.
///
/// Parameter `vlan`: The SCVLANInterface interface.
///
/// Returns: TRUE if the interface was removed; FALSE if an error was encountered.
#[inline]
pub extern "C-unwind" fn SCVLANInterfaceRemove(vlan: &SCVLANInterface) -> bool {
    extern "C-unwind" {
        fn SCVLANInterfaceRemove(vlan: &SCVLANInterface) -> Boolean;
    }
    let ret = unsafe { SCVLANInterfaceRemove(vlan) };
    ret != 0
}

/// Returns the physical interface for the specified VLAN interface.
///
/// Parameter `vlan`: The SCVLANInterface interface.
///
/// Returns: The list of interfaces.
#[inline]
pub extern "C-unwind" fn SCVLANInterfaceGetPhysicalInterface(
    vlan: &SCVLANInterface,
) -> Option<CFRetained<SCNetworkInterface>> {
    extern "C-unwind" {
        fn SCVLANInterfaceGetPhysicalInterface(
            vlan: &SCVLANInterface,
        ) -> Option<NonNull<SCNetworkInterface>>;
    }
    let ret = unsafe { SCVLANInterfaceGetPhysicalInterface(vlan) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

/// Returns the tag for the specified VLAN interface.
///
/// Parameter `vlan`: The SCVLANInterface interface.
///
/// Returns: The tag.
#[inline]
pub extern "C-unwind" fn SCVLANInterfaceGetTag(
    vlan: &SCVLANInterface,
) -> Option<CFRetained<CFNumber>> {
    extern "C-unwind" {
        fn SCVLANInterfaceGetTag(vlan: &SCVLANInterface) -> Option<NonNull<CFNumber>>;
    }
    let ret = unsafe { SCVLANInterfaceGetTag(vlan) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

/// Returns the configuration settings associated with the VLAN interface.
///
/// Parameter `vlan`: The SCVLANInterface interface.
///
/// Returns: The configuration settings associated with the VLAN interface;
/// NULL if no changes to the default configuration have been saved.
#[inline]
pub extern "C-unwind" fn SCVLANInterfaceGetOptions(
    vlan: &SCVLANInterface,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn SCVLANInterfaceGetOptions(vlan: &SCVLANInterface) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { SCVLANInterfaceGetOptions(vlan) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

/// Updates the specified VLAN interface.
///
/// Parameter `vlan`: The SCVLANInterface interface.
///
/// Parameter `physical`: The physical interface to associate with the VLAN.
///
/// Parameter `tag`: The tag to associate with the VLAN.
///
/// Returns: TRUE if the configuration was stored; FALSE if an error was encountered.
///
/// Note: the tag must be in the range (1
/// <
/// = tag
/// <
/// = 4094)
#[inline]
pub extern "C-unwind" fn SCVLANInterfaceSetPhysicalInterfaceAndTag(
    vlan: &SCVLANInterface,
    physical: &SCNetworkInterface,
    tag: &CFNumber,
) -> bool {
    extern "C-unwind" {
        fn SCVLANInterfaceSetPhysicalInterfaceAndTag(
            vlan: &SCVLANInterface,
            physical: &SCNetworkInterface,
            tag: &CFNumber,
        ) -> Boolean;
    }
    let ret = unsafe { SCVLANInterfaceSetPhysicalInterfaceAndTag(vlan, physical, tag) };
    ret != 0
}

/// Sets the localized display name for the specified VLAN interface.
///
/// Parameter `vlan`: The SCVLANInterface interface.
///
/// Parameter `newName`: The new display name.
///
/// Returns: TRUE if the configuration was stored; FALSE if an error was encountered.
#[inline]
pub extern "C-unwind" fn SCVLANInterfaceSetLocalizedDisplayName(
    vlan: &SCVLANInterface,
    new_name: &CFString,
) -> bool {
    extern "C-unwind" {
        fn SCVLANInterfaceSetLocalizedDisplayName(
            vlan: &SCVLANInterface,
            new_name: &CFString,
        ) -> Boolean;
    }
    let ret = unsafe { SCVLANInterfaceSetLocalizedDisplayName(vlan, new_name) };
    ret != 0
}

/// Sets the configuration settings for the specified VLAN interface.
///
/// Parameter `vlan`: The SCVLANInterface interface.
///
/// Parameter `newOptions`: The new configuration settings.
///
/// Returns: TRUE if the configuration was stored; FALSE if an error was encountered.
///
/// # Safety
///
/// `new_options` generics must be of the correct type.
#[inline]
pub unsafe extern "C-unwind" fn SCVLANInterfaceSetOptions(
    vlan: &SCVLANInterface,
    new_options: &CFDictionary,
) -> bool {
    extern "C-unwind" {
        fn SCVLANInterfaceSetOptions(vlan: &SCVLANInterface, new_options: &CFDictionary)
            -> Boolean;
    }
    let ret = unsafe { SCVLANInterfaceSetOptions(vlan, new_options) };
    ret != 0
}

unsafe impl ConcreteType for SCNetworkProtocol {
    /// Returns the type identifier of all SCNetworkProtocol instances.
    #[doc(alias = "SCNetworkProtocolGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn SCNetworkProtocolGetTypeID() -> CFTypeID;
        }
        unsafe { SCNetworkProtocolGetTypeID() }
    }
}

impl SCNetworkProtocol {
    /// Returns the configuration settings associated with the protocol.
    ///
    /// Parameter `protocol`: The network protocol.
    ///
    /// Returns: The configuration settings associated with the protocol;
    /// NULL if no configuration settings are associated with the protocol
    /// or an error was encountered.
    #[doc(alias = "SCNetworkProtocolGetConfiguration")]
    #[inline]
    pub fn configuration(&self) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn SCNetworkProtocolGetConfiguration(
                protocol: &SCNetworkProtocol,
            ) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { SCNetworkProtocolGetConfiguration(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Returns whether this protocol has been enabled.
    ///
    /// Parameter `protocol`: The network protocol.
    ///
    /// Returns: TRUE if the protocol is enabled.
    #[doc(alias = "SCNetworkProtocolGetEnabled")]
    #[inline]
    pub fn enabled(&self) -> bool {
        extern "C-unwind" {
            fn SCNetworkProtocolGetEnabled(protocol: &SCNetworkProtocol) -> Boolean;
        }
        let ret = unsafe { SCNetworkProtocolGetEnabled(self) };
        ret != 0
    }

    /// Returns the associated network protocol type.
    ///
    /// Parameter `protocol`: The network protocol.
    ///
    /// Returns: The protocol type.
    #[doc(alias = "SCNetworkProtocolGetProtocolType")]
    #[inline]
    pub fn protocol_type(&self) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn SCNetworkProtocolGetProtocolType(
                protocol: &SCNetworkProtocol,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { SCNetworkProtocolGetProtocolType(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Stores the configuration settings for the protocol.
    ///
    /// Parameter `protocol`: The network protocol.
    ///
    /// Parameter `config`: The configuration settings to associate with this protocol.
    ///
    /// Returns: TRUE if the configuration was stored; FALSE if an error was encountered.
    ///
    /// # Safety
    ///
    /// `config` generics must be of the correct type.
    #[doc(alias = "SCNetworkProtocolSetConfiguration")]
    #[inline]
    pub unsafe fn set_configuration(&self, config: Option<&CFDictionary>) -> bool {
        extern "C-unwind" {
            fn SCNetworkProtocolSetConfiguration(
                protocol: &SCNetworkProtocol,
                config: Option<&CFDictionary>,
            ) -> Boolean;
        }
        let ret = unsafe { SCNetworkProtocolSetConfiguration(self, config) };
        ret != 0
    }

    /// Enables or disables the protocol.
    ///
    /// Parameter `protocol`: The network protocol.
    ///
    /// Parameter `enabled`: TRUE if the protocol should be enabled.
    ///
    /// Returns: TRUE if the enabled status was saved; FALSE if an error was encountered.
    #[doc(alias = "SCNetworkProtocolSetEnabled")]
    #[inline]
    pub fn set_enabled(&self, enabled: bool) -> bool {
        extern "C-unwind" {
            fn SCNetworkProtocolSetEnabled(
                protocol: &SCNetworkProtocol,
                enabled: Boolean,
            ) -> Boolean;
        }
        let ret = unsafe { SCNetworkProtocolSetEnabled(self, enabled as _) };
        ret != 0
    }
}

unsafe impl ConcreteType for SCNetworkService {
    /// Returns the type identifier of all SCNetworkService instances.
    #[doc(alias = "SCNetworkServiceGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn SCNetworkServiceGetTypeID() -> CFTypeID;
        }
        unsafe { SCNetworkServiceGetTypeID() }
    }
}

impl SCNetworkService {
    /// Adds a network protocol of the specified type to the
    /// service.  The protocol configuration is set to default values
    /// that are appropriate for the interface associated with the
    /// service.
    ///
    /// Parameter `service`: The network service.
    ///
    /// Parameter `protocolType`: The type of SCNetworkProtocol to be added to the service.
    ///
    /// Returns: TRUE if the protocol was added to the service; FALSE if the
    /// protocol was already present or an error was encountered.
    #[doc(alias = "SCNetworkServiceAddProtocolType")]
    #[inline]
    pub fn add_protocol_type(&self, protocol_type: &CFString) -> bool {
        extern "C-unwind" {
            fn SCNetworkServiceAddProtocolType(
                service: &SCNetworkService,
                protocol_type: &CFString,
            ) -> Boolean;
        }
        let ret = unsafe { SCNetworkServiceAddProtocolType(self, protocol_type) };
        ret != 0
    }

    /// Returns all available network services for the specified preferences.
    ///
    /// Parameter `prefs`: The "preferences" session.
    ///
    /// Returns: The list of SCNetworkService services associated with the preferences.
    /// You must release the returned value.
    #[doc(alias = "SCNetworkServiceCopyAll")]
    #[cfg(feature = "SCPreferences")]
    #[inline]
    pub fn all(prefs: &SCPreferences) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn SCNetworkServiceCopyAll(prefs: &SCPreferences) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { SCNetworkServiceCopyAll(prefs) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns all network protocols associated with the service.
    ///
    /// Parameter `service`: The network service.
    ///
    /// Returns: The list of SCNetworkProtocol protocols associated with the service.
    /// You must release the returned value.
    #[doc(alias = "SCNetworkServiceCopyProtocols")]
    #[inline]
    pub fn protocols(&self) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn SCNetworkServiceCopyProtocols(
                service: &SCNetworkService,
            ) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { SCNetworkServiceCopyProtocols(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Create a new network service for the specified interface in the
    /// configuration.
    ///
    /// Parameter `prefs`: The "preferences" session.
    ///
    /// Returns: A reference to the new SCNetworkService.
    /// You must release the returned value.
    #[doc(alias = "SCNetworkServiceCreate")]
    #[cfg(feature = "SCPreferences")]
    #[inline]
    pub fn new(
        prefs: &SCPreferences,
        interface: &SCNetworkInterface,
    ) -> Option<CFRetained<SCNetworkService>> {
        extern "C-unwind" {
            fn SCNetworkServiceCreate(
                prefs: &SCPreferences,
                interface: &SCNetworkInterface,
            ) -> Option<NonNull<SCNetworkService>>;
        }
        let ret = unsafe { SCNetworkServiceCreate(prefs, interface) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns the network service with the specified identifier.
    ///
    /// Parameter `prefs`: The "preferences" session.
    ///
    /// Parameter `serviceID`: The unique identifier for the service.
    ///
    /// Returns: A reference to the SCNetworkService from the associated preferences;
    /// NULL if the serviceID does not exist in the preferences or if an
    /// error was encountered.
    /// You must release the returned value.
    #[doc(alias = "SCNetworkServiceCopy")]
    #[cfg(feature = "SCPreferences")]
    #[inline]
    pub fn copy(
        prefs: &SCPreferences,
        service_id: &CFString,
    ) -> Option<CFRetained<SCNetworkService>> {
        extern "C-unwind" {
            fn SCNetworkServiceCopy(
                prefs: &SCPreferences,
                service_id: &CFString,
            ) -> Option<NonNull<SCNetworkService>>;
        }
        let ret = unsafe { SCNetworkServiceCopy(prefs, service_id) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Establishes the "default" configuration for a network
    /// service.  This configuration includes the addition of
    /// network protocols for the service (with "default"
    /// configuration options).
    ///
    /// Parameter `service`: The network service.
    ///
    /// Returns: TRUE if the configuration was updated; FALSE if an error was encountered.
    #[doc(alias = "SCNetworkServiceEstablishDefaultConfiguration")]
    #[inline]
    pub fn establish_default_configuration(&self) -> bool {
        extern "C-unwind" {
            fn SCNetworkServiceEstablishDefaultConfiguration(service: &SCNetworkService)
                -> Boolean;
        }
        let ret = unsafe { SCNetworkServiceEstablishDefaultConfiguration(self) };
        ret != 0
    }

    /// Returns whether this service has been enabled.
    ///
    /// Parameter `service`: The network service.
    ///
    /// Returns: TRUE if the service is enabled.
    #[doc(alias = "SCNetworkServiceGetEnabled")]
    #[inline]
    pub fn enabled(&self) -> bool {
        extern "C-unwind" {
            fn SCNetworkServiceGetEnabled(service: &SCNetworkService) -> Boolean;
        }
        let ret = unsafe { SCNetworkServiceGetEnabled(self) };
        ret != 0
    }

    /// Returns the network interface associated with the service.
    ///
    /// Parameter `service`: The network service.
    ///
    /// Returns: A reference to the SCNetworkInterface associated with the service;
    /// NULL if an error was encountered.
    #[doc(alias = "SCNetworkServiceGetInterface")]
    #[inline]
    pub fn interface(&self) -> Option<CFRetained<SCNetworkInterface>> {
        extern "C-unwind" {
            fn SCNetworkServiceGetInterface(
                service: &SCNetworkService,
            ) -> Option<NonNull<SCNetworkInterface>>;
        }
        let ret = unsafe { SCNetworkServiceGetInterface(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Returns the [user specified] name associated with the service.
    ///
    /// Parameter `service`: The network service.
    ///
    /// Returns: The [user specified] name.
    #[doc(alias = "SCNetworkServiceGetName")]
    #[inline]
    pub fn name(&self) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn SCNetworkServiceGetName(service: &SCNetworkService) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { SCNetworkServiceGetName(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Returns the network protocol of the specified type for
    /// the service.
    ///
    /// Parameter `service`: The network service.
    ///
    /// Returns: A reference to the SCNetworkProtocol associated with the service;
    /// NULL if this protocol has not been added or if an error was encountered.
    /// You must release the returned value.
    #[doc(alias = "SCNetworkServiceCopyProtocol")]
    #[inline]
    pub fn protocol(&self, protocol_type: &CFString) -> Option<CFRetained<SCNetworkProtocol>> {
        extern "C-unwind" {
            fn SCNetworkServiceCopyProtocol(
                service: &SCNetworkService,
                protocol_type: &CFString,
            ) -> Option<NonNull<SCNetworkProtocol>>;
        }
        let ret = unsafe { SCNetworkServiceCopyProtocol(self, protocol_type) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns the identifier for the service.
    ///
    /// Parameter `service`: The network service.
    ///
    /// Returns: The service identifier.
    #[doc(alias = "SCNetworkServiceGetServiceID")]
    #[inline]
    pub fn service_id(&self) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn SCNetworkServiceGetServiceID(
                service: &SCNetworkService,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { SCNetworkServiceGetServiceID(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Removes the network service from the configuration.
    ///
    /// Parameter `service`: The network service.
    ///
    /// Returns: TRUE if the service was removed; FALSE if an error was encountered.
    #[doc(alias = "SCNetworkServiceRemove")]
    #[inline]
    pub fn remove(&self) -> bool {
        extern "C-unwind" {
            fn SCNetworkServiceRemove(service: &SCNetworkService) -> Boolean;
        }
        let ret = unsafe { SCNetworkServiceRemove(self) };
        ret != 0
    }

    /// Removes the network protocol of the specified type from the service.
    ///
    /// Parameter `service`: The network service.
    ///
    /// Parameter `protocolType`: The type of SCNetworkProtocol to be removed from the service.
    ///
    /// Returns: TRUE if the protocol was removed to the service; FALSE if the
    /// protocol was not configured or an error was encountered.
    #[doc(alias = "SCNetworkServiceRemoveProtocolType")]
    #[inline]
    pub fn remove_protocol_type(&self, protocol_type: &CFString) -> bool {
        extern "C-unwind" {
            fn SCNetworkServiceRemoveProtocolType(
                service: &SCNetworkService,
                protocol_type: &CFString,
            ) -> Boolean;
        }
        let ret = unsafe { SCNetworkServiceRemoveProtocolType(self, protocol_type) };
        ret != 0
    }

    /// Enables or disables the service.
    ///
    /// Parameter `service`: The network service.
    ///
    /// Parameter `enabled`: TRUE if the service should be enabled.
    ///
    /// Returns: TRUE if the enabled status was saved; FALSE if an error was encountered.
    #[doc(alias = "SCNetworkServiceSetEnabled")]
    #[inline]
    pub fn set_enabled(&self, enabled: bool) -> bool {
        extern "C-unwind" {
            fn SCNetworkServiceSetEnabled(service: &SCNetworkService, enabled: Boolean) -> Boolean;
        }
        let ret = unsafe { SCNetworkServiceSetEnabled(self, enabled as _) };
        ret != 0
    }

    /// Stores the [user specified] name for the service.
    ///
    /// Parameter `service`: The network service.
    ///
    /// Parameter `name`: The [user defined] name to associate with the service.
    ///
    /// Returns: TRUE if the name was saved; FALSE if an error was encountered.
    ///
    /// Note: although not technically required, the [user specified] names
    /// for all services within any given set should be unique.  As such, an
    /// error will be returned if you attemp to name two services with the
    /// same string.
    #[doc(alias = "SCNetworkServiceSetName")]
    #[inline]
    pub fn set_name(&self, name: Option<&CFString>) -> bool {
        extern "C-unwind" {
            fn SCNetworkServiceSetName(
                service: &SCNetworkService,
                name: Option<&CFString>,
            ) -> Boolean;
        }
        let ret = unsafe { SCNetworkServiceSetName(self, name) };
        ret != 0
    }
}

unsafe impl ConcreteType for SCNetworkSet {
    /// Returns the type identifier of all SCNetworkSet instances.
    #[doc(alias = "SCNetworkSetGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn SCNetworkSetGetTypeID() -> CFTypeID;
        }
        unsafe { SCNetworkSetGetTypeID() }
    }
}

impl SCNetworkSet {
    /// Adds the network service to the set.
    ///
    /// Parameter `set`: The network set.
    ///
    /// Parameter `service`: The service to be added.
    ///
    /// Returns: TRUE if the service was added to the set; FALSE if the
    /// service was already present or an error was encountered.
    ///
    /// Note: prior to Mac OS X 10.5, the Network Preferences UI
    /// did not support having a single service being a member of
    /// more than one set.  An error will be returned if you attempt
    /// to add a service to more than one set on a pre-10.5 system.
    #[doc(alias = "SCNetworkSetAddService")]
    #[inline]
    pub fn add_service(&self, service: &SCNetworkService) -> bool {
        extern "C-unwind" {
            fn SCNetworkSetAddService(set: &SCNetworkSet, service: &SCNetworkService) -> Boolean;
        }
        let ret = unsafe { SCNetworkSetAddService(self, service) };
        ret != 0
    }

    /// Checks if an interface is represented by at least one
    /// network service in the specified set.
    ///
    /// Parameter `set`: The network set.
    ///
    /// Parameter `interface`: The network interface.
    ///
    /// Returns: TRUE if the interface is represented in the set; FALSE if not.
    #[doc(alias = "SCNetworkSetContainsInterface")]
    #[inline]
    pub fn contains_interface(&self, interface: &SCNetworkInterface) -> bool {
        extern "C-unwind" {
            fn SCNetworkSetContainsInterface(
                set: &SCNetworkSet,
                interface: &SCNetworkInterface,
            ) -> Boolean;
        }
        let ret = unsafe { SCNetworkSetContainsInterface(self, interface) };
        ret != 0
    }

    /// Returns all available sets for the specified preferences.
    ///
    /// Parameter `prefs`: The "preferences" session.
    ///
    /// Returns: The list of SCNetworkSet sets associated with the preferences.
    /// You must release the returned value.
    #[doc(alias = "SCNetworkSetCopyAll")]
    #[cfg(feature = "SCPreferences")]
    #[inline]
    pub fn all(prefs: &SCPreferences) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn SCNetworkSetCopyAll(prefs: &SCPreferences) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { SCNetworkSetCopyAll(prefs) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns the "current" set.
    ///
    /// Parameter `prefs`: The "preferences" session.
    ///
    /// Returns: The current set; NULL if no current set has been defined.
    #[doc(alias = "SCNetworkSetCopyCurrent")]
    #[cfg(feature = "SCPreferences")]
    #[inline]
    pub fn current(prefs: &SCPreferences) -> Option<CFRetained<SCNetworkSet>> {
        extern "C-unwind" {
            fn SCNetworkSetCopyCurrent(prefs: &SCPreferences) -> Option<NonNull<SCNetworkSet>>;
        }
        let ret = unsafe { SCNetworkSetCopyCurrent(prefs) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns all network services associated with the set.
    ///
    /// Parameter `set`: The network set.
    ///
    /// Returns: The list of SCNetworkService services associated with the set.
    /// You must release the returned value.
    #[doc(alias = "SCNetworkSetCopyServices")]
    #[inline]
    pub fn services(&self) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn SCNetworkSetCopyServices(set: &SCNetworkSet) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { SCNetworkSetCopyServices(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Create a new set in the configuration.
    ///
    /// Parameter `prefs`: The "preferences" session.
    ///
    /// Returns: A reference to the new SCNetworkSet.
    /// You must release the returned value.
    #[doc(alias = "SCNetworkSetCreate")]
    #[cfg(feature = "SCPreferences")]
    #[inline]
    pub fn new(prefs: &SCPreferences) -> Option<CFRetained<SCNetworkSet>> {
        extern "C-unwind" {
            fn SCNetworkSetCreate(prefs: &SCPreferences) -> Option<NonNull<SCNetworkSet>>;
        }
        let ret = unsafe { SCNetworkSetCreate(prefs) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns the set with the specified identifier.
    ///
    /// Parameter `prefs`: The "preferences" session.
    ///
    /// Parameter `setID`: The unique identifier for the set.
    ///
    /// Returns: A reference to the SCNetworkSet from the associated preferences;
    /// NULL if the setID does not exist in the preferences or if an
    /// error was encountered.
    /// You must release the returned value.
    #[doc(alias = "SCNetworkSetCopy")]
    #[cfg(feature = "SCPreferences")]
    #[inline]
    pub fn copy(prefs: &SCPreferences, set_id: &CFString) -> Option<CFRetained<SCNetworkSet>> {
        extern "C-unwind" {
            fn SCNetworkSetCopy(
                prefs: &SCPreferences,
                set_id: &CFString,
            ) -> Option<NonNull<SCNetworkSet>>;
        }
        let ret = unsafe { SCNetworkSetCopy(prefs, set_id) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns the [user specified] name associated with the set.
    ///
    /// Parameter `set`: The network set.
    ///
    /// Returns: The [user specified] name.
    #[doc(alias = "SCNetworkSetGetName")]
    #[inline]
    pub fn name(&self) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn SCNetworkSetGetName(set: &SCNetworkSet) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { SCNetworkSetGetName(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Returns the identifier for the set.
    ///
    /// Parameter `set`: The network set.
    ///
    /// Returns: The set identifier.
    #[doc(alias = "SCNetworkSetGetSetID")]
    #[inline]
    pub fn set_id(&self) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn SCNetworkSetGetSetID(set: &SCNetworkSet) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { SCNetworkSetGetSetID(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Returns the [user specified] ordering of network services
    /// within the set.
    ///
    /// Parameter `set`: The network set.
    ///
    /// Returns: The ordered list of CFStringRef service identifiers associated
    /// with the set;
    /// NULL if no service order has been specified or if an error
    /// was encountered.
    #[doc(alias = "SCNetworkSetGetServiceOrder")]
    #[inline]
    pub fn service_order(&self) -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn SCNetworkSetGetServiceOrder(set: &SCNetworkSet) -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { SCNetworkSetGetServiceOrder(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    /// Removes the set from the configuration.
    ///
    /// Parameter `set`: The network set.
    ///
    /// Returns: TRUE if the set was removed; FALSE if an error was encountered.
    #[doc(alias = "SCNetworkSetRemove")]
    #[inline]
    pub fn remove(&self) -> bool {
        extern "C-unwind" {
            fn SCNetworkSetRemove(set: &SCNetworkSet) -> Boolean;
        }
        let ret = unsafe { SCNetworkSetRemove(self) };
        ret != 0
    }

    /// Removes the network service from the set.
    ///
    /// Parameter `set`: The network set.
    ///
    /// Parameter `service`: The service to be removed.
    ///
    /// Returns: TRUE if the service was removed from the set; FALSE if the
    /// service was not already present or an error was encountered.
    #[doc(alias = "SCNetworkSetRemoveService")]
    #[inline]
    pub fn remove_service(&self, service: &SCNetworkService) -> bool {
        extern "C-unwind" {
            fn SCNetworkSetRemoveService(set: &SCNetworkSet, service: &SCNetworkService)
                -> Boolean;
        }
        let ret = unsafe { SCNetworkSetRemoveService(self, service) };
        ret != 0
    }

    /// Specifies the set that should be the "current" set.
    ///
    /// Parameter `set`: The network set.
    ///
    /// Returns: TRUE if the current set was updated;
    /// FALSE if an error was encountered.
    #[doc(alias = "SCNetworkSetSetCurrent")]
    #[inline]
    pub fn set_current(&self) -> bool {
        extern "C-unwind" {
            fn SCNetworkSetSetCurrent(set: &SCNetworkSet) -> Boolean;
        }
        let ret = unsafe { SCNetworkSetSetCurrent(self) };
        ret != 0
    }

    /// Stores the [user specified] name for the set.
    ///
    /// Parameter `set`: The network set.
    ///
    /// Parameter `name`: The [user defined] name to associate with the set.
    ///
    /// Returns: TRUE if the name was saved; FALSE if an error was encountered.
    ///
    /// Note: although not technically required, the [user specified] names
    /// for all set should be unique.  As such, an error will be returned if
    /// you attemp to name two sets with the same string.
    #[doc(alias = "SCNetworkSetSetName")]
    #[inline]
    pub fn set_name(&self, name: Option<&CFString>) -> bool {
        extern "C-unwind" {
            fn SCNetworkSetSetName(set: &SCNetworkSet, name: Option<&CFString>) -> Boolean;
        }
        let ret = unsafe { SCNetworkSetSetName(self, name) };
        ret != 0
    }

    /// Stores the [user specified] ordering of network services for the set.
    ///
    /// Parameter `set`: The network set.
    ///
    /// Parameter `newOrder`: The ordered list of CFStringRef service identifiers for the set.
    ///
    /// Returns: TRUE if the new service order was saved; FALSE if an error was encountered.
    ///
    /// # Safety
    ///
    /// `new_order` generic must be of the correct type.
    #[doc(alias = "SCNetworkSetSetServiceOrder")]
    #[inline]
    pub unsafe fn set_service_order(&self, new_order: &CFArray) -> bool {
        extern "C-unwind" {
            fn SCNetworkSetSetServiceOrder(set: &SCNetworkSet, new_order: &CFArray) -> Boolean;
        }
        let ret = unsafe { SCNetworkSetSetServiceOrder(self, new_order) };
        ret != 0
    }
}

#[deprecated = "renamed to `SCNetworkInterface::all`"]
#[inline]
pub extern "C-unwind" fn SCNetworkInterfaceCopyAll() -> CFRetained<CFArray> {
    extern "C-unwind" {
        fn SCNetworkInterfaceCopyAll() -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { SCNetworkInterfaceCopyAll() };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

#[deprecated = "renamed to `SCNetworkInterface::supported_interface_types`"]
#[inline]
pub extern "C-unwind" fn SCNetworkInterfaceGetSupportedInterfaceTypes(
    interface: &SCNetworkInterface,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn SCNetworkInterfaceGetSupportedInterfaceTypes(
            interface: &SCNetworkInterface,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { SCNetworkInterfaceGetSupportedInterfaceTypes(interface) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `SCNetworkInterface::supported_protocol_types`"]
#[inline]
pub extern "C-unwind" fn SCNetworkInterfaceGetSupportedProtocolTypes(
    interface: &SCNetworkInterface,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn SCNetworkInterfaceGetSupportedProtocolTypes(
            interface: &SCNetworkInterface,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { SCNetworkInterfaceGetSupportedProtocolTypes(interface) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `SCNetworkInterface::with_interface`"]
#[inline]
pub extern "C-unwind" fn SCNetworkInterfaceCreateWithInterface(
    interface: &SCNetworkInterface,
    interface_type: &CFString,
) -> Option<CFRetained<SCNetworkInterface>> {
    extern "C-unwind" {
        fn SCNetworkInterfaceCreateWithInterface(
            interface: &SCNetworkInterface,
            interface_type: &CFString,
        ) -> Option<NonNull<SCNetworkInterface>>;
    }
    let ret = unsafe { SCNetworkInterfaceCreateWithInterface(interface, interface_type) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `SCNetworkInterface::bsd_name`"]
#[inline]
pub extern "C-unwind" fn SCNetworkInterfaceGetBSDName(
    interface: &SCNetworkInterface,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn SCNetworkInterfaceGetBSDName(
            interface: &SCNetworkInterface,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { SCNetworkInterfaceGetBSDName(interface) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `SCNetworkInterface::configuration`"]
#[inline]
pub extern "C-unwind" fn SCNetworkInterfaceGetConfiguration(
    interface: &SCNetworkInterface,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn SCNetworkInterfaceGetConfiguration(
            interface: &SCNetworkInterface,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { SCNetworkInterfaceGetConfiguration(interface) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `SCNetworkInterface::extended_configuration`"]
#[inline]
pub extern "C-unwind" fn SCNetworkInterfaceGetExtendedConfiguration(
    interface: &SCNetworkInterface,
    extended_type: &CFString,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn SCNetworkInterfaceGetExtendedConfiguration(
            interface: &SCNetworkInterface,
            extended_type: &CFString,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { SCNetworkInterfaceGetExtendedConfiguration(interface, extended_type) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `SCNetworkInterface::hardware_address_string`"]
#[inline]
pub extern "C-unwind" fn SCNetworkInterfaceGetHardwareAddressString(
    interface: &SCNetworkInterface,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn SCNetworkInterfaceGetHardwareAddressString(
            interface: &SCNetworkInterface,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { SCNetworkInterfaceGetHardwareAddressString(interface) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `SCNetworkInterface::interface`"]
#[inline]
pub extern "C-unwind" fn SCNetworkInterfaceGetInterface(
    interface: &SCNetworkInterface,
) -> Option<CFRetained<SCNetworkInterface>> {
    extern "C-unwind" {
        fn SCNetworkInterfaceGetInterface(
            interface: &SCNetworkInterface,
        ) -> Option<NonNull<SCNetworkInterface>>;
    }
    let ret = unsafe { SCNetworkInterfaceGetInterface(interface) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `SCNetworkInterface::interface_type`"]
#[inline]
pub extern "C-unwind" fn SCNetworkInterfaceGetInterfaceType(
    interface: &SCNetworkInterface,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn SCNetworkInterfaceGetInterfaceType(
            interface: &SCNetworkInterface,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { SCNetworkInterfaceGetInterfaceType(interface) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `SCNetworkInterface::localized_display_name`"]
#[inline]
pub extern "C-unwind" fn SCNetworkInterfaceGetLocalizedDisplayName(
    interface: &SCNetworkInterface,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn SCNetworkInterfaceGetLocalizedDisplayName(
            interface: &SCNetworkInterface,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { SCNetworkInterfaceGetLocalizedDisplayName(interface) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `SCNetworkInterface::set_configuration`"]
#[inline]
pub unsafe extern "C-unwind" fn SCNetworkInterfaceSetConfiguration(
    interface: &SCNetworkInterface,
    config: Option<&CFDictionary>,
) -> bool {
    extern "C-unwind" {
        fn SCNetworkInterfaceSetConfiguration(
            interface: &SCNetworkInterface,
            config: Option<&CFDictionary>,
        ) -> Boolean;
    }
    let ret = unsafe { SCNetworkInterfaceSetConfiguration(interface, config) };
    ret != 0
}

#[deprecated = "renamed to `SCNetworkInterface::set_extended_configuration`"]
#[inline]
pub unsafe extern "C-unwind" fn SCNetworkInterfaceSetExtendedConfiguration(
    interface: &SCNetworkInterface,
    extended_type: &CFString,
    config: Option<&CFDictionary>,
) -> bool {
    extern "C-unwind" {
        fn SCNetworkInterfaceSetExtendedConfiguration(
            interface: &SCNetworkInterface,
            extended_type: &CFString,
            config: Option<&CFDictionary>,
        ) -> Boolean;
    }
    let ret =
        unsafe { SCNetworkInterfaceSetExtendedConfiguration(interface, extended_type, config) };
    ret != 0
}

#[deprecated = "renamed to `SCNetworkInterface::media_options`"]
#[inline]
pub unsafe extern "C-unwind" fn SCNetworkInterfaceCopyMediaOptions(
    interface: &SCNetworkInterface,
    current: *mut *const CFDictionary,
    active: *mut *const CFDictionary,
    available: *mut *const CFArray,
    filter: bool,
) -> bool {
    extern "C-unwind" {
        fn SCNetworkInterfaceCopyMediaOptions(
            interface: &SCNetworkInterface,
            current: *mut *const CFDictionary,
            active: *mut *const CFDictionary,
            available: *mut *const CFArray,
            filter: Boolean,
        ) -> Boolean;
    }
    let ret = unsafe {
        SCNetworkInterfaceCopyMediaOptions(interface, current, active, available, filter as _)
    };
    ret != 0
}

#[deprecated = "renamed to `SCNetworkInterface::media_sub_types`"]
#[inline]
pub extern "C-unwind" fn SCNetworkInterfaceCopyMediaSubTypes(
    available: &CFArray,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn SCNetworkInterfaceCopyMediaSubTypes(available: &CFArray) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { SCNetworkInterfaceCopyMediaSubTypes(available) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `SCNetworkInterface::media_sub_type_options`"]
#[inline]
pub extern "C-unwind" fn SCNetworkInterfaceCopyMediaSubTypeOptions(
    available: &CFArray,
    sub_type: &CFString,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn SCNetworkInterfaceCopyMediaSubTypeOptions(
            available: &CFArray,
            sub_type: &CFString,
        ) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { SCNetworkInterfaceCopyMediaSubTypeOptions(available, sub_type) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `SCNetworkInterface::mtu`"]
#[inline]
pub unsafe extern "C-unwind" fn SCNetworkInterfaceCopyMTU(
    interface: &SCNetworkInterface,
    mtu_cur: *mut c_int,
    mtu_min: *mut c_int,
    mtu_max: *mut c_int,
) -> bool {
    extern "C-unwind" {
        fn SCNetworkInterfaceCopyMTU(
            interface: &SCNetworkInterface,
            mtu_cur: *mut c_int,
            mtu_min: *mut c_int,
            mtu_max: *mut c_int,
        ) -> Boolean;
    }
    let ret = unsafe { SCNetworkInterfaceCopyMTU(interface, mtu_cur, mtu_min, mtu_max) };
    ret != 0
}

#[deprecated = "renamed to `SCNetworkInterface::set_media_options`"]
#[inline]
pub extern "C-unwind" fn SCNetworkInterfaceSetMediaOptions(
    interface: &SCNetworkInterface,
    subtype: Option<&CFString>,
    options: Option<&CFArray>,
) -> bool {
    extern "C-unwind" {
        fn SCNetworkInterfaceSetMediaOptions(
            interface: &SCNetworkInterface,
            subtype: Option<&CFString>,
            options: Option<&CFArray>,
        ) -> Boolean;
    }
    let ret = unsafe { SCNetworkInterfaceSetMediaOptions(interface, subtype, options) };
    ret != 0
}

#[deprecated = "renamed to `SCNetworkInterface::set_mtu`"]
#[inline]
pub extern "C-unwind" fn SCNetworkInterfaceSetMTU(
    interface: &SCNetworkInterface,
    mtu: c_int,
) -> bool {
    extern "C-unwind" {
        fn SCNetworkInterfaceSetMTU(interface: &SCNetworkInterface, mtu: c_int) -> Boolean;
    }
    let ret = unsafe { SCNetworkInterfaceSetMTU(interface, mtu) };
    ret != 0
}

#[deprecated = "renamed to `SCNetworkInterface::force_configuration_refresh`"]
#[inline]
pub extern "C-unwind" fn SCNetworkInterfaceForceConfigurationRefresh(
    interface: &SCNetworkInterface,
) -> bool {
    extern "C-unwind" {
        fn SCNetworkInterfaceForceConfigurationRefresh(interface: &SCNetworkInterface) -> Boolean;
    }
    let ret = unsafe { SCNetworkInterfaceForceConfigurationRefresh(interface) };
    ret != 0
}

#[deprecated = "renamed to `SCBondStatus::member_interfaces`"]
#[inline]
pub extern "C-unwind" fn SCBondStatusGetMemberInterfaces(
    bond_status: &SCBondStatus,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn SCBondStatusGetMemberInterfaces(bond_status: &SCBondStatus) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { SCBondStatusGetMemberInterfaces(bond_status) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `SCBondStatus::interface_status`"]
#[inline]
pub extern "C-unwind" fn SCBondStatusGetInterfaceStatus(
    bond_status: &SCBondStatus,
    interface: Option<&SCNetworkInterface>,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn SCBondStatusGetInterfaceStatus(
            bond_status: &SCBondStatus,
            interface: Option<&SCNetworkInterface>,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { SCBondStatusGetInterfaceStatus(bond_status, interface) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `SCNetworkProtocol::configuration`"]
#[inline]
pub extern "C-unwind" fn SCNetworkProtocolGetConfiguration(
    protocol: &SCNetworkProtocol,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn SCNetworkProtocolGetConfiguration(
            protocol: &SCNetworkProtocol,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { SCNetworkProtocolGetConfiguration(protocol) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `SCNetworkProtocol::enabled`"]
#[inline]
pub extern "C-unwind" fn SCNetworkProtocolGetEnabled(protocol: &SCNetworkProtocol) -> bool {
    extern "C-unwind" {
        fn SCNetworkProtocolGetEnabled(protocol: &SCNetworkProtocol) -> Boolean;
    }
    let ret = unsafe { SCNetworkProtocolGetEnabled(protocol) };
    ret != 0
}

#[deprecated = "renamed to `SCNetworkProtocol::protocol_type`"]
#[inline]
pub extern "C-unwind" fn SCNetworkProtocolGetProtocolType(
    protocol: &SCNetworkProtocol,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn SCNetworkProtocolGetProtocolType(
            protocol: &SCNetworkProtocol,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { SCNetworkProtocolGetProtocolType(protocol) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `SCNetworkProtocol::set_configuration`"]
#[inline]
pub unsafe extern "C-unwind" fn SCNetworkProtocolSetConfiguration(
    protocol: &SCNetworkProtocol,
    config: Option<&CFDictionary>,
) -> bool {
    extern "C-unwind" {
        fn SCNetworkProtocolSetConfiguration(
            protocol: &SCNetworkProtocol,
            config: Option<&CFDictionary>,
        ) -> Boolean;
    }
    let ret = unsafe { SCNetworkProtocolSetConfiguration(protocol, config) };
    ret != 0
}

#[deprecated = "renamed to `SCNetworkProtocol::set_enabled`"]
#[inline]
pub extern "C-unwind" fn SCNetworkProtocolSetEnabled(
    protocol: &SCNetworkProtocol,
    enabled: bool,
) -> bool {
    extern "C-unwind" {
        fn SCNetworkProtocolSetEnabled(protocol: &SCNetworkProtocol, enabled: Boolean) -> Boolean;
    }
    let ret = unsafe { SCNetworkProtocolSetEnabled(protocol, enabled as _) };
    ret != 0
}

#[deprecated = "renamed to `SCNetworkService::add_protocol_type`"]
#[inline]
pub extern "C-unwind" fn SCNetworkServiceAddProtocolType(
    service: &SCNetworkService,
    protocol_type: &CFString,
) -> bool {
    extern "C-unwind" {
        fn SCNetworkServiceAddProtocolType(
            service: &SCNetworkService,
            protocol_type: &CFString,
        ) -> Boolean;
    }
    let ret = unsafe { SCNetworkServiceAddProtocolType(service, protocol_type) };
    ret != 0
}

#[cfg(feature = "SCPreferences")]
#[deprecated = "renamed to `SCNetworkService::all`"]
#[inline]
pub extern "C-unwind" fn SCNetworkServiceCopyAll(
    prefs: &SCPreferences,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn SCNetworkServiceCopyAll(prefs: &SCPreferences) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { SCNetworkServiceCopyAll(prefs) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `SCNetworkService::protocols`"]
#[inline]
pub extern "C-unwind" fn SCNetworkServiceCopyProtocols(
    service: &SCNetworkService,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn SCNetworkServiceCopyProtocols(service: &SCNetworkService) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { SCNetworkServiceCopyProtocols(service) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "SCPreferences")]
#[deprecated = "renamed to `SCNetworkService::new`"]
#[inline]
pub extern "C-unwind" fn SCNetworkServiceCreate(
    prefs: &SCPreferences,
    interface: &SCNetworkInterface,
) -> Option<CFRetained<SCNetworkService>> {
    extern "C-unwind" {
        fn SCNetworkServiceCreate(
            prefs: &SCPreferences,
            interface: &SCNetworkInterface,
        ) -> Option<NonNull<SCNetworkService>>;
    }
    let ret = unsafe { SCNetworkServiceCreate(prefs, interface) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "SCPreferences")]
#[deprecated = "renamed to `SCNetworkService::copy`"]
#[inline]
pub extern "C-unwind" fn SCNetworkServiceCopy(
    prefs: &SCPreferences,
    service_id: &CFString,
) -> Option<CFRetained<SCNetworkService>> {
    extern "C-unwind" {
        fn SCNetworkServiceCopy(
            prefs: &SCPreferences,
            service_id: &CFString,
        ) -> Option<NonNull<SCNetworkService>>;
    }
    let ret = unsafe { SCNetworkServiceCopy(prefs, service_id) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `SCNetworkService::establish_default_configuration`"]
#[inline]
pub extern "C-unwind" fn SCNetworkServiceEstablishDefaultConfiguration(
    service: &SCNetworkService,
) -> bool {
    extern "C-unwind" {
        fn SCNetworkServiceEstablishDefaultConfiguration(service: &SCNetworkService) -> Boolean;
    }
    let ret = unsafe { SCNetworkServiceEstablishDefaultConfiguration(service) };
    ret != 0
}

#[deprecated = "renamed to `SCNetworkService::enabled`"]
#[inline]
pub extern "C-unwind" fn SCNetworkServiceGetEnabled(service: &SCNetworkService) -> bool {
    extern "C-unwind" {
        fn SCNetworkServiceGetEnabled(service: &SCNetworkService) -> Boolean;
    }
    let ret = unsafe { SCNetworkServiceGetEnabled(service) };
    ret != 0
}

#[deprecated = "renamed to `SCNetworkService::interface`"]
#[inline]
pub extern "C-unwind" fn SCNetworkServiceGetInterface(
    service: &SCNetworkService,
) -> Option<CFRetained<SCNetworkInterface>> {
    extern "C-unwind" {
        fn SCNetworkServiceGetInterface(
            service: &SCNetworkService,
        ) -> Option<NonNull<SCNetworkInterface>>;
    }
    let ret = unsafe { SCNetworkServiceGetInterface(service) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `SCNetworkService::name`"]
#[inline]
pub extern "C-unwind" fn SCNetworkServiceGetName(
    service: &SCNetworkService,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn SCNetworkServiceGetName(service: &SCNetworkService) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { SCNetworkServiceGetName(service) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `SCNetworkService::protocol`"]
#[inline]
pub extern "C-unwind" fn SCNetworkServiceCopyProtocol(
    service: &SCNetworkService,
    protocol_type: &CFString,
) -> Option<CFRetained<SCNetworkProtocol>> {
    extern "C-unwind" {
        fn SCNetworkServiceCopyProtocol(
            service: &SCNetworkService,
            protocol_type: &CFString,
        ) -> Option<NonNull<SCNetworkProtocol>>;
    }
    let ret = unsafe { SCNetworkServiceCopyProtocol(service, protocol_type) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `SCNetworkService::service_id`"]
#[inline]
pub extern "C-unwind" fn SCNetworkServiceGetServiceID(
    service: &SCNetworkService,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn SCNetworkServiceGetServiceID(service: &SCNetworkService) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { SCNetworkServiceGetServiceID(service) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `SCNetworkService::remove`"]
#[inline]
pub extern "C-unwind" fn SCNetworkServiceRemove(service: &SCNetworkService) -> bool {
    extern "C-unwind" {
        fn SCNetworkServiceRemove(service: &SCNetworkService) -> Boolean;
    }
    let ret = unsafe { SCNetworkServiceRemove(service) };
    ret != 0
}

#[deprecated = "renamed to `SCNetworkService::remove_protocol_type`"]
#[inline]
pub extern "C-unwind" fn SCNetworkServiceRemoveProtocolType(
    service: &SCNetworkService,
    protocol_type: &CFString,
) -> bool {
    extern "C-unwind" {
        fn SCNetworkServiceRemoveProtocolType(
            service: &SCNetworkService,
            protocol_type: &CFString,
        ) -> Boolean;
    }
    let ret = unsafe { SCNetworkServiceRemoveProtocolType(service, protocol_type) };
    ret != 0
}

#[deprecated = "renamed to `SCNetworkService::set_enabled`"]
#[inline]
pub extern "C-unwind" fn SCNetworkServiceSetEnabled(
    service: &SCNetworkService,
    enabled: bool,
) -> bool {
    extern "C-unwind" {
        fn SCNetworkServiceSetEnabled(service: &SCNetworkService, enabled: Boolean) -> Boolean;
    }
    let ret = unsafe { SCNetworkServiceSetEnabled(service, enabled as _) };
    ret != 0
}

#[deprecated = "renamed to `SCNetworkService::set_name`"]
#[inline]
pub extern "C-unwind" fn SCNetworkServiceSetName(
    service: &SCNetworkService,
    name: Option<&CFString>,
) -> bool {
    extern "C-unwind" {
        fn SCNetworkServiceSetName(service: &SCNetworkService, name: Option<&CFString>) -> Boolean;
    }
    let ret = unsafe { SCNetworkServiceSetName(service, name) };
    ret != 0
}

#[deprecated = "renamed to `SCNetworkSet::add_service`"]
#[inline]
pub extern "C-unwind" fn SCNetworkSetAddService(
    set: &SCNetworkSet,
    service: &SCNetworkService,
) -> bool {
    extern "C-unwind" {
        fn SCNetworkSetAddService(set: &SCNetworkSet, service: &SCNetworkService) -> Boolean;
    }
    let ret = unsafe { SCNetworkSetAddService(set, service) };
    ret != 0
}

#[deprecated = "renamed to `SCNetworkSet::contains_interface`"]
#[inline]
pub extern "C-unwind" fn SCNetworkSetContainsInterface(
    set: &SCNetworkSet,
    interface: &SCNetworkInterface,
) -> bool {
    extern "C-unwind" {
        fn SCNetworkSetContainsInterface(
            set: &SCNetworkSet,
            interface: &SCNetworkInterface,
        ) -> Boolean;
    }
    let ret = unsafe { SCNetworkSetContainsInterface(set, interface) };
    ret != 0
}

#[cfg(feature = "SCPreferences")]
#[deprecated = "renamed to `SCNetworkSet::all`"]
#[inline]
pub extern "C-unwind" fn SCNetworkSetCopyAll(prefs: &SCPreferences) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn SCNetworkSetCopyAll(prefs: &SCPreferences) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { SCNetworkSetCopyAll(prefs) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "SCPreferences")]
#[deprecated = "renamed to `SCNetworkSet::current`"]
#[inline]
pub extern "C-unwind" fn SCNetworkSetCopyCurrent(
    prefs: &SCPreferences,
) -> Option<CFRetained<SCNetworkSet>> {
    extern "C-unwind" {
        fn SCNetworkSetCopyCurrent(prefs: &SCPreferences) -> Option<NonNull<SCNetworkSet>>;
    }
    let ret = unsafe { SCNetworkSetCopyCurrent(prefs) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `SCNetworkSet::services`"]
#[inline]
pub extern "C-unwind" fn SCNetworkSetCopyServices(
    set: &SCNetworkSet,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn SCNetworkSetCopyServices(set: &SCNetworkSet) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { SCNetworkSetCopyServices(set) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "SCPreferences")]
#[deprecated = "renamed to `SCNetworkSet::new`"]
#[inline]
pub extern "C-unwind" fn SCNetworkSetCreate(
    prefs: &SCPreferences,
) -> Option<CFRetained<SCNetworkSet>> {
    extern "C-unwind" {
        fn SCNetworkSetCreate(prefs: &SCPreferences) -> Option<NonNull<SCNetworkSet>>;
    }
    let ret = unsafe { SCNetworkSetCreate(prefs) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "SCPreferences")]
#[deprecated = "renamed to `SCNetworkSet::copy`"]
#[inline]
pub extern "C-unwind" fn SCNetworkSetCopy(
    prefs: &SCPreferences,
    set_id: &CFString,
) -> Option<CFRetained<SCNetworkSet>> {
    extern "C-unwind" {
        fn SCNetworkSetCopy(
            prefs: &SCPreferences,
            set_id: &CFString,
        ) -> Option<NonNull<SCNetworkSet>>;
    }
    let ret = unsafe { SCNetworkSetCopy(prefs, set_id) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `SCNetworkSet::name`"]
#[inline]
pub extern "C-unwind" fn SCNetworkSetGetName(set: &SCNetworkSet) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn SCNetworkSetGetName(set: &SCNetworkSet) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { SCNetworkSetGetName(set) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `SCNetworkSet::set_id`"]
#[inline]
pub extern "C-unwind" fn SCNetworkSetGetSetID(set: &SCNetworkSet) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn SCNetworkSetGetSetID(set: &SCNetworkSet) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { SCNetworkSetGetSetID(set) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `SCNetworkSet::service_order`"]
#[inline]
pub extern "C-unwind" fn SCNetworkSetGetServiceOrder(
    set: &SCNetworkSet,
) -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn SCNetworkSetGetServiceOrder(set: &SCNetworkSet) -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { SCNetworkSetGetServiceOrder(set) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `SCNetworkSet::remove`"]
#[inline]
pub extern "C-unwind" fn SCNetworkSetRemove(set: &SCNetworkSet) -> bool {
    extern "C-unwind" {
        fn SCNetworkSetRemove(set: &SCNetworkSet) -> Boolean;
    }
    let ret = unsafe { SCNetworkSetRemove(set) };
    ret != 0
}

#[deprecated = "renamed to `SCNetworkSet::remove_service`"]
#[inline]
pub extern "C-unwind" fn SCNetworkSetRemoveService(
    set: &SCNetworkSet,
    service: &SCNetworkService,
) -> bool {
    extern "C-unwind" {
        fn SCNetworkSetRemoveService(set: &SCNetworkSet, service: &SCNetworkService) -> Boolean;
    }
    let ret = unsafe { SCNetworkSetRemoveService(set, service) };
    ret != 0
}

#[deprecated = "renamed to `SCNetworkSet::set_current`"]
#[inline]
pub extern "C-unwind" fn SCNetworkSetSetCurrent(set: &SCNetworkSet) -> bool {
    extern "C-unwind" {
        fn SCNetworkSetSetCurrent(set: &SCNetworkSet) -> Boolean;
    }
    let ret = unsafe { SCNetworkSetSetCurrent(set) };
    ret != 0
}

#[deprecated = "renamed to `SCNetworkSet::set_name`"]
#[inline]
pub extern "C-unwind" fn SCNetworkSetSetName(set: &SCNetworkSet, name: Option<&CFString>) -> bool {
    extern "C-unwind" {
        fn SCNetworkSetSetName(set: &SCNetworkSet, name: Option<&CFString>) -> Boolean;
    }
    let ret = unsafe { SCNetworkSetSetName(set, name) };
    ret != 0
}

#[deprecated = "renamed to `SCNetworkSet::set_service_order`"]
#[inline]
pub unsafe extern "C-unwind" fn SCNetworkSetSetServiceOrder(
    set: &SCNetworkSet,
    new_order: &CFArray,
) -> bool {
    extern "C-unwind" {
        fn SCNetworkSetSetServiceOrder(set: &SCNetworkSet, new_order: &CFArray) -> Boolean;
    }
    let ret = unsafe { SCNetworkSetSetServiceOrder(set, new_order) };
    ret != 0
}
