//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;
#[cfg(feature = "objc2-symbols")]
use objc2_symbols::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uibarbuttonitemstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIBarButtonItemStyle(pub NSInteger);
impl UIBarButtonItemStyle {
    #[doc(alias = "UIBarButtonItemStylePlain")]
    pub const Plain: Self = Self(0);
    #[doc(alias = "UIBarButtonItemStyleBordered")]
    #[deprecated]
    pub const Bordered: Self = Self(1);
    #[doc(alias = "UIBarButtonItemStyleDone")]
    pub const Done: Self = Self(2);
}

unsafe impl Encode for UIBarButtonItemStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIBarButtonItemStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uibarbuttonsystemitem?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIBarButtonSystemItem(pub NSInteger);
impl UIBarButtonSystemItem {
    #[doc(alias = "UIBarButtonSystemItemDone")]
    pub const Done: Self = Self(0);
    #[doc(alias = "UIBarButtonSystemItemCancel")]
    pub const Cancel: Self = Self(1);
    #[doc(alias = "UIBarButtonSystemItemEdit")]
    pub const Edit: Self = Self(2);
    #[doc(alias = "UIBarButtonSystemItemSave")]
    pub const Save: Self = Self(3);
    #[doc(alias = "UIBarButtonSystemItemAdd")]
    pub const Add: Self = Self(4);
    #[doc(alias = "UIBarButtonSystemItemFlexibleSpace")]
    pub const FlexibleSpace: Self = Self(5);
    #[doc(alias = "UIBarButtonSystemItemFixedSpace")]
    pub const FixedSpace: Self = Self(6);
    #[doc(alias = "UIBarButtonSystemItemCompose")]
    pub const Compose: Self = Self(7);
    #[doc(alias = "UIBarButtonSystemItemReply")]
    pub const Reply: Self = Self(8);
    #[doc(alias = "UIBarButtonSystemItemAction")]
    pub const Action: Self = Self(9);
    #[doc(alias = "UIBarButtonSystemItemOrganize")]
    pub const Organize: Self = Self(10);
    #[doc(alias = "UIBarButtonSystemItemBookmarks")]
    pub const Bookmarks: Self = Self(11);
    #[doc(alias = "UIBarButtonSystemItemSearch")]
    pub const Search: Self = Self(12);
    #[doc(alias = "UIBarButtonSystemItemRefresh")]
    pub const Refresh: Self = Self(13);
    #[doc(alias = "UIBarButtonSystemItemStop")]
    pub const Stop: Self = Self(14);
    #[doc(alias = "UIBarButtonSystemItemCamera")]
    pub const Camera: Self = Self(15);
    #[doc(alias = "UIBarButtonSystemItemTrash")]
    pub const Trash: Self = Self(16);
    #[doc(alias = "UIBarButtonSystemItemPlay")]
    pub const Play: Self = Self(17);
    #[doc(alias = "UIBarButtonSystemItemPause")]
    pub const Pause: Self = Self(18);
    #[doc(alias = "UIBarButtonSystemItemRewind")]
    pub const Rewind: Self = Self(19);
    #[doc(alias = "UIBarButtonSystemItemFastForward")]
    pub const FastForward: Self = Self(20);
    #[doc(alias = "UIBarButtonSystemItemUndo")]
    pub const Undo: Self = Self(21);
    #[doc(alias = "UIBarButtonSystemItemRedo")]
    pub const Redo: Self = Self(22);
    #[doc(alias = "UIBarButtonSystemItemPageCurl")]
    #[deprecated]
    pub const PageCurl: Self = Self(23);
    #[doc(alias = "UIBarButtonSystemItemClose")]
    pub const Close: Self = Self(24);
    #[doc(alias = "UIBarButtonSystemItemWritingTools")]
    pub const WritingTools: Self = Self(25);
}

unsafe impl Encode for UIBarButtonSystemItem {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIBarButtonSystemItem {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uibarbuttonitem?language=objc)
    #[unsafe(super(UIBarItem, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "UIBarItem")]
    pub struct UIBarButtonItem;
);

#[cfg(feature = "UIBarItem")]
extern_conformance!(
    unsafe impl NSCoding for UIBarButtonItem {}
);

#[cfg(feature = "UIBarItem")]
extern_conformance!(
    unsafe impl NSObjectProtocol for UIBarButtonItem {}
);

#[cfg(all(feature = "UIAppearance", feature = "UIBarItem"))]
extern_conformance!(
    unsafe impl UIAppearance for UIBarButtonItem {}
);

#[cfg(feature = "UIBarItem")]
impl UIBarButtonItem {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "UIImage")]
        #[unsafe(method(initWithImage:style:target:action:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithImage_style_target_action(
            this: Allocated<Self>,
            image: Option<&UIImage>,
            style: UIBarButtonItemStyle,
            target: Option<&AnyObject>,
            action: Option<Sel>,
        ) -> Retained<Self>;

        #[cfg(feature = "UIImage")]
        #[unsafe(method(initWithImage:landscapeImagePhone:style:target:action:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithImage_landscapeImagePhone_style_target_action(
            this: Allocated<Self>,
            image: Option<&UIImage>,
            landscape_image_phone: Option<&UIImage>,
            style: UIBarButtonItemStyle,
            target: Option<&AnyObject>,
            action: Option<Sel>,
        ) -> Retained<Self>;

        #[unsafe(method(initWithTitle:style:target:action:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithTitle_style_target_action(
            this: Allocated<Self>,
            title: Option<&NSString>,
            style: UIBarButtonItemStyle,
            target: Option<&AnyObject>,
            action: Option<Sel>,
        ) -> Retained<Self>;

        #[unsafe(method(initWithBarButtonSystemItem:target:action:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithBarButtonSystemItem_target_action(
            this: Allocated<Self>,
            system_item: UIBarButtonSystemItem,
            target: Option<&AnyObject>,
            action: Option<Sel>,
        ) -> Retained<Self>;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[unsafe(method(initWithCustomView:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCustomView(
            this: Allocated<Self>,
            custom_view: &UIView,
        ) -> Retained<Self>;

        #[cfg(all(feature = "UIAction", feature = "UIMenuElement"))]
        /// Creates a bar button item for the given systemItem. The primaryAction is copied, and its title
        /// &
        /// image are ignored.
        #[unsafe(method(initWithBarButtonSystemItem:primaryAction:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithBarButtonSystemItem_primaryAction(
            this: Allocated<Self>,
            system_item: UIBarButtonSystemItem,
            primary_action: Option<&UIAction>,
        ) -> Retained<Self>;

        #[cfg(all(feature = "UIAction", feature = "UIMenuElement"))]
        /// Creates a plain-style bar button item from the properties of primaryAction. primaryAction is copied.
        #[unsafe(method(initWithPrimaryAction:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithPrimaryAction(
            this: Allocated<Self>,
            primary_action: Option<&UIAction>,
        ) -> Retained<Self>;

        #[cfg(all(feature = "UIMenu", feature = "UIMenuElement"))]
        /// Creates a bar button item for the given systemItem. The constructed item will present the menu immediately when touched.
        #[unsafe(method(initWithBarButtonSystemItem:menu:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithBarButtonSystemItem_menu(
            this: Allocated<Self>,
            system_item: UIBarButtonSystemItem,
            menu: Option<&UIMenu>,
        ) -> Retained<Self>;

        #[cfg(all(feature = "UIMenu", feature = "UIMenuElement"))]
        /// Creates a plain-style bar button item with the given title. The constructed item will present the menu immediately when touched.
        #[unsafe(method(initWithTitle:menu:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithTitle_menu(
            this: Allocated<Self>,
            title: Option<&NSString>,
            menu: Option<&UIMenu>,
        ) -> Retained<Self>;

        #[cfg(all(feature = "UIImage", feature = "UIMenu", feature = "UIMenuElement"))]
        /// Creates a plain-style bar button item with the given image. The constructed item will present the menu immediately when touched.
        #[unsafe(method(initWithImage:menu:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithImage_menu(
            this: Allocated<Self>,
            image: Option<&UIImage>,
            menu: Option<&UIMenu>,
        ) -> Retained<Self>;

        #[cfg(all(feature = "UIAction", feature = "UIMenu", feature = "UIMenuElement"))]
        /// Creates a plain-style bar button item from the properties of primaryAction. primaryAction is copied.
        #[unsafe(method(initWithPrimaryAction:menu:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithPrimaryAction_menu(
            this: Allocated<Self>,
            primary_action: Option<&UIAction>,
            menu: Option<&UIMenu>,
        ) -> Retained<Self>;

        #[cfg(all(feature = "UIAction", feature = "UIMenu", feature = "UIMenuElement"))]
        /// Creates a bar button item for the given systemItem. The primaryAction is copied, and its title
        /// &
        /// image are ignored.
        #[unsafe(method(initWithBarButtonSystemItem:primaryAction:menu:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithBarButtonSystemItem_primaryAction_menu(
            this: Allocated<Self>,
            system_item: UIBarButtonSystemItem,
            primary_action: Option<&UIAction>,
            menu: Option<&UIMenu>,
        ) -> Retained<Self>;

        #[cfg(all(feature = "UIImage", feature = "UIMenu", feature = "UIMenuElement"))]
        /// Creates a plain-style bar button item with the given title and image.
        #[unsafe(method(initWithTitle:image:target:action:menu:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithTitle_image_target_action_menu(
            this: Allocated<Self>,
            title: Option<&NSString>,
            image: Option<&UIImage>,
            target: Option<&AnyObject>,
            action: Option<Sel>,
            menu: Option<&UIMenu>,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Construct a new fixed space item with the given width.
        #[unsafe(method(fixedSpaceItemOfWidth:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fixedSpaceItemOfWidth(
            width: CGFloat,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        /// Construct a new flexible space item.
        #[unsafe(method(flexibleSpaceItem))]
        #[unsafe(method_family = none)]
        pub unsafe fn flexibleSpaceItem(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(style))]
        #[unsafe(method_family = none)]
        pub unsafe fn style(&self) -> UIBarButtonItemStyle;

        /// Setter for [`style`][Self::style].
        #[unsafe(method(setStyle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setStyle(&self, style: UIBarButtonItemStyle);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(width))]
        #[unsafe(method_family = none)]
        pub unsafe fn width(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`width`][Self::width].
        #[unsafe(method(setWidth:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setWidth(&self, width: CGFloat);

        #[unsafe(method(possibleTitles))]
        #[unsafe(method_family = none)]
        pub unsafe fn possibleTitles(&self) -> Option<Retained<NSSet<NSString>>>;

        /// Setter for [`possibleTitles`][Self::possibleTitles].
        #[unsafe(method(setPossibleTitles:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPossibleTitles(&self, possible_titles: Option<&NSSet<NSString>>);

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        #[unsafe(method(customView))]
        #[unsafe(method_family = none)]
        pub unsafe fn customView(&self) -> Option<Retained<UIView>>;

        #[cfg(all(feature = "UIResponder", feature = "UIView"))]
        /// Setter for [`customView`][Self::customView].
        #[unsafe(method(setCustomView:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCustomView(&self, custom_view: Option<&UIView>);

        #[unsafe(method(action))]
        #[unsafe(method_family = none)]
        pub unsafe fn action(&self) -> Option<Sel>;

        /// Setter for [`action`][Self::action].
        #[unsafe(method(setAction:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAction(&self, action: Option<Sel>);

        #[unsafe(method(target))]
        #[unsafe(method_family = none)]
        pub unsafe fn target(&self) -> Option<Retained<AnyObject>>;

        /// This is a [weak property][objc2::topics::weak_property].
        /// Setter for [`target`][Self::target].
        #[unsafe(method(setTarget:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTarget(&self, target: Option<&AnyObject>);

        #[cfg(all(feature = "UIAction", feature = "UIMenuElement"))]
        /// Set the primaryAction on this item, updating the title
        /// &
        /// image of the item if appropriate (primaryAction is non-nil, and this is not a system item). When primaryAction is non-nil, the target
        /// &
        /// action properties are ignored. If primaryAction is set to nil, the title
        /// &
        /// image properties are left unchanged.
        #[unsafe(method(primaryAction))]
        #[unsafe(method_family = none)]
        pub unsafe fn primaryAction(&self) -> Option<Retained<UIAction>>;

        #[cfg(all(feature = "UIAction", feature = "UIMenuElement"))]
        /// Setter for [`primaryAction`][Self::primaryAction].
        #[unsafe(method(setPrimaryAction:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPrimaryAction(&self, primary_action: Option<&UIAction>);

        #[cfg(all(feature = "UIMenu", feature = "UIMenuElement"))]
        /// When non-nil the menu is presented, the gesture used to trigger the menu is based on if the bar button item would normally trigger an action when tapped.
        #[unsafe(method(menu))]
        #[unsafe(method_family = none)]
        pub unsafe fn menu(&self) -> Option<Retained<UIMenu>>;

        #[cfg(all(feature = "UIMenu", feature = "UIMenuElement"))]
        /// Setter for [`menu`][Self::menu].
        #[unsafe(method(setMenu:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMenu(&self, menu: Option<&UIMenu>);

        #[cfg(feature = "UIContextMenuConfiguration")]
        /// Preferred menu element ordering strategy for menus displayed by this button.
        #[unsafe(method(preferredMenuElementOrder))]
        #[unsafe(method_family = none)]
        pub unsafe fn preferredMenuElementOrder(&self) -> UIContextMenuConfigurationElementOrder;

        #[cfg(feature = "UIContextMenuConfiguration")]
        /// Setter for [`preferredMenuElementOrder`][Self::preferredMenuElementOrder].
        #[unsafe(method(setPreferredMenuElementOrder:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPreferredMenuElementOrder(
            &self,
            preferred_menu_element_order: UIContextMenuConfigurationElementOrder,
        );

        /// Indicates if the button changes selection as its primary action.
        /// This shows the menu as options for selection if a menu is populated and no action when tapped is enabled.
        /// If no menu is provided and no action is enabled when tapped, the item is toggled on and off for the primary action.
        #[unsafe(method(changesSelectionAsPrimaryAction))]
        #[unsafe(method_family = none)]
        pub unsafe fn changesSelectionAsPrimaryAction(&self) -> bool;

        /// Setter for [`changesSelectionAsPrimaryAction`][Self::changesSelectionAsPrimaryAction].
        #[unsafe(method(setChangesSelectionAsPrimaryAction:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setChangesSelectionAsPrimaryAction(
            &self,
            changes_selection_as_primary_action: bool,
        );

        #[unsafe(method(isSelected))]
        #[unsafe(method_family = none)]
        pub unsafe fn isSelected(&self) -> bool;

        /// Setter for [`isSelected`][Self::isSelected].
        #[unsafe(method(setSelected:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSelected(&self, selected: bool);

        /// If the item should be hidden from display.
        #[unsafe(method(isHidden))]
        #[unsafe(method_family = none)]
        pub unsafe fn isHidden(&self) -> bool;

        /// Setter for [`isHidden`][Self::isHidden].
        #[unsafe(method(setHidden:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setHidden(&self, hidden: bool);

        /// Whether or not symbol animations are enabled for this bar button item.
        #[unsafe(method(isSymbolAnimationEnabled))]
        #[unsafe(method_family = none)]
        pub unsafe fn isSymbolAnimationEnabled(&self) -> bool;

        /// Setter for [`isSymbolAnimationEnabled`][Self::isSymbolAnimationEnabled].
        #[unsafe(method(setSymbolAnimationEnabled:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSymbolAnimationEnabled(&self, symbol_animation_enabled: bool);

        #[cfg(feature = "UIMenuElement")]
        /// A UIMenuElement that should substitute for the UIBarButtonItem when displayed in a menu.
        #[unsafe(method(menuRepresentation))]
        #[unsafe(method_family = none)]
        pub unsafe fn menuRepresentation(&self) -> Option<Retained<UIMenuElement>>;

        #[cfg(feature = "UIMenuElement")]
        /// Setter for [`menuRepresentation`][Self::menuRepresentation].
        #[unsafe(method(setMenuRepresentation:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMenuRepresentation(&self, menu_representation: Option<&UIMenuElement>);

        #[cfg(feature = "UIBarButtonItemGroup")]
        /// Create a fixed group containing this bar button item. UIBarButtonItems may only be in a single UIBarButtonItemGroup at a time, adding a bar button item to a group removes it from any previous group.
        #[unsafe(method(creatingFixedGroup))]
        #[unsafe(method_family = none)]
        pub unsafe fn creatingFixedGroup(&self) -> Retained<UIBarButtonItemGroup>;

        #[cfg(feature = "UIBarButtonItemGroup")]
        /// Create a movable group containing this bar button item. UIBarButtonItems may only be in a single UIBarButtonItemGroup at a time, adding a bar button item to a group removes it from any previous group.
        #[unsafe(method(creatingMovableGroupWithCustomizationIdentifier:))]
        #[unsafe(method_family = none)]
        pub unsafe fn creatingMovableGroupWithCustomizationIdentifier(
            &self,
            customization_identifier: &NSString,
        ) -> Retained<UIBarButtonItemGroup>;

        #[cfg(feature = "UIBarButtonItemGroup")]
        /// Create an optional group containing this bar button item. UIBarButtonItems may only be in a single UIBarButtonItemGroup at a time, adding a bar button item to a group removes it from any previous group.
        #[unsafe(method(creatingOptionalGroupWithCustomizationIdentifier:inDefaultCustomization:))]
        #[unsafe(method_family = none)]
        pub unsafe fn creatingOptionalGroupWithCustomizationIdentifier_inDefaultCustomization(
            &self,
            customization_identifier: &NSString,
            in_default_customization: bool,
        ) -> Retained<UIBarButtonItemGroup>;

        #[cfg(all(feature = "UIBarCommon", feature = "UIControl", feature = "UIImage"))]
        #[unsafe(method(setBackgroundImage:forState:barMetrics:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBackgroundImage_forState_barMetrics(
            &self,
            background_image: Option<&UIImage>,
            state: UIControlState,
            bar_metrics: UIBarMetrics,
        );

        #[cfg(all(feature = "UIBarCommon", feature = "UIControl", feature = "UIImage"))]
        #[unsafe(method(backgroundImageForState:barMetrics:))]
        #[unsafe(method_family = none)]
        pub unsafe fn backgroundImageForState_barMetrics(
            &self,
            state: UIControlState,
            bar_metrics: UIBarMetrics,
        ) -> Option<Retained<UIImage>>;

        #[cfg(all(feature = "UIBarCommon", feature = "UIControl", feature = "UIImage"))]
        #[unsafe(method(setBackgroundImage:forState:style:barMetrics:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBackgroundImage_forState_style_barMetrics(
            &self,
            background_image: Option<&UIImage>,
            state: UIControlState,
            style: UIBarButtonItemStyle,
            bar_metrics: UIBarMetrics,
        );

        #[cfg(all(feature = "UIBarCommon", feature = "UIControl", feature = "UIImage"))]
        #[unsafe(method(backgroundImageForState:style:barMetrics:))]
        #[unsafe(method_family = none)]
        pub unsafe fn backgroundImageForState_style_barMetrics(
            &self,
            state: UIControlState,
            style: UIBarButtonItemStyle,
            bar_metrics: UIBarMetrics,
        ) -> Option<Retained<UIImage>>;

        #[cfg(feature = "UIColor")]
        #[unsafe(method(tintColor))]
        #[unsafe(method_family = none)]
        pub unsafe fn tintColor(&self) -> Option<Retained<UIColor>>;

        #[cfg(feature = "UIColor")]
        /// Setter for [`tintColor`][Self::tintColor].
        #[unsafe(method(setTintColor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTintColor(&self, tint_color: Option<&UIColor>);

        #[cfg(all(feature = "UIBarCommon", feature = "objc2-core-foundation"))]
        #[unsafe(method(setBackgroundVerticalPositionAdjustment:forBarMetrics:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBackgroundVerticalPositionAdjustment_forBarMetrics(
            &self,
            adjustment: CGFloat,
            bar_metrics: UIBarMetrics,
        );

        #[cfg(all(feature = "UIBarCommon", feature = "objc2-core-foundation"))]
        #[unsafe(method(backgroundVerticalPositionAdjustmentForBarMetrics:))]
        #[unsafe(method_family = none)]
        pub unsafe fn backgroundVerticalPositionAdjustmentForBarMetrics(
            &self,
            bar_metrics: UIBarMetrics,
        ) -> CGFloat;

        #[cfg(all(
            feature = "UIBarCommon",
            feature = "UIGeometry",
            feature = "objc2-core-foundation"
        ))]
        #[unsafe(method(setTitlePositionAdjustment:forBarMetrics:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTitlePositionAdjustment_forBarMetrics(
            &self,
            adjustment: UIOffset,
            bar_metrics: UIBarMetrics,
        );

        #[cfg(all(
            feature = "UIBarCommon",
            feature = "UIGeometry",
            feature = "objc2-core-foundation"
        ))]
        #[unsafe(method(titlePositionAdjustmentForBarMetrics:))]
        #[unsafe(method_family = none)]
        pub unsafe fn titlePositionAdjustmentForBarMetrics(
            &self,
            bar_metrics: UIBarMetrics,
        ) -> UIOffset;

        #[cfg(all(feature = "UIBarCommon", feature = "UIControl", feature = "UIImage"))]
        #[unsafe(method(setBackButtonBackgroundImage:forState:barMetrics:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBackButtonBackgroundImage_forState_barMetrics(
            &self,
            background_image: Option<&UIImage>,
            state: UIControlState,
            bar_metrics: UIBarMetrics,
        );

        #[cfg(all(feature = "UIBarCommon", feature = "UIControl", feature = "UIImage"))]
        #[unsafe(method(backButtonBackgroundImageForState:barMetrics:))]
        #[unsafe(method_family = none)]
        pub unsafe fn backButtonBackgroundImageForState_barMetrics(
            &self,
            state: UIControlState,
            bar_metrics: UIBarMetrics,
        ) -> Option<Retained<UIImage>>;

        #[cfg(all(
            feature = "UIBarCommon",
            feature = "UIGeometry",
            feature = "objc2-core-foundation"
        ))]
        #[unsafe(method(setBackButtonTitlePositionAdjustment:forBarMetrics:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBackButtonTitlePositionAdjustment_forBarMetrics(
            &self,
            adjustment: UIOffset,
            bar_metrics: UIBarMetrics,
        );

        #[cfg(all(
            feature = "UIBarCommon",
            feature = "UIGeometry",
            feature = "objc2-core-foundation"
        ))]
        #[unsafe(method(backButtonTitlePositionAdjustmentForBarMetrics:))]
        #[unsafe(method_family = none)]
        pub unsafe fn backButtonTitlePositionAdjustmentForBarMetrics(
            &self,
            bar_metrics: UIBarMetrics,
        ) -> UIOffset;

        #[cfg(all(feature = "UIBarCommon", feature = "objc2-core-foundation"))]
        #[unsafe(method(setBackButtonBackgroundVerticalPositionAdjustment:forBarMetrics:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBackButtonBackgroundVerticalPositionAdjustment_forBarMetrics(
            &self,
            adjustment: CGFloat,
            bar_metrics: UIBarMetrics,
        );

        #[cfg(all(feature = "UIBarCommon", feature = "objc2-core-foundation"))]
        #[unsafe(method(backButtonBackgroundVerticalPositionAdjustmentForBarMetrics:))]
        #[unsafe(method_family = none)]
        pub unsafe fn backButtonBackgroundVerticalPositionAdjustmentForBarMetrics(
            &self,
            bar_metrics: UIBarMetrics,
        ) -> CGFloat;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "UIBarItem")]
impl UIBarButtonItem {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

/// SpringLoading.
#[cfg(feature = "UIBarItem")]
impl UIBarButtonItem {
    extern_methods!();
}

#[cfg(all(feature = "UIBarItem", feature = "UISpringLoadedInteractionSupporting"))]
extern_conformance!(
    unsafe impl UISpringLoadedInteractionSupporting for UIBarButtonItem {}
);

#[cfg(feature = "UIBarItem")]
impl UIBarButtonItem {
    extern_methods!(
        #[cfg(feature = "objc2-symbols")]
        /// Adds a symbol effect to the bar button item with default options and animation.
        /// Only a subset of symbol effects are supported; Appear and Disappear effects, for example, are unsupported, and will assert.
        #[unsafe(method(addSymbolEffect:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addSymbolEffect(&self, symbol_effect: &NSSymbolEffect);

        #[cfg(feature = "objc2-symbols")]
        /// Adds a symbol effect to the bar button item with specified options and default animation.
        /// Only a subset of symbol effects are supported; Appear and Disappear effects, for example, are unsupported, and will assert.
        #[unsafe(method(addSymbolEffect:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addSymbolEffect_options(
            &self,
            symbol_effect: &NSSymbolEffect,
            options: &NSSymbolEffectOptions,
        );

        #[cfg(feature = "objc2-symbols")]
        /// Adds a symbol effect to the bar button item with specified options and animation.
        /// Only a subset of symbol effects are supported; Appear and Disappear effects, for example, are unsupported, and will assert.
        #[unsafe(method(addSymbolEffect:options:animated:))]
        #[unsafe(method_family = none)]
        pub unsafe fn addSymbolEffect_options_animated(
            &self,
            symbol_effect: &NSSymbolEffect,
            options: &NSSymbolEffectOptions,
            animated: bool,
        );

        #[cfg(feature = "objc2-symbols")]
        /// Removes from the bar button item the symbol effect matching the type of effect passed in, with default options and animation.
        #[unsafe(method(removeSymbolEffectOfType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeSymbolEffectOfType(&self, symbol_effect: &NSSymbolEffect);

        #[cfg(feature = "objc2-symbols")]
        /// Removes from the bar button item the symbol effect matching the type of effect passed in, with specified options and default animation.
        #[unsafe(method(removeSymbolEffectOfType:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeSymbolEffectOfType_options(
            &self,
            symbol_effect: &NSSymbolEffect,
            options: &NSSymbolEffectOptions,
        );

        #[cfg(feature = "objc2-symbols")]
        /// Removes from the bar button item the symbol effect matching the type of effect passed in, with specified options and animation.
        #[unsafe(method(removeSymbolEffectOfType:options:animated:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeSymbolEffectOfType_options_animated(
            &self,
            symbol_effect: &NSSymbolEffect,
            options: &NSSymbolEffectOptions,
            animated: bool,
        );

        /// Removes all symbol effects from the bar button item with default options and animation.
        #[unsafe(method(removeAllSymbolEffects))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeAllSymbolEffects(&self);

        #[cfg(feature = "objc2-symbols")]
        /// Removes all symbol effects from the bar button item with specified options and default animation.
        #[unsafe(method(removeAllSymbolEffectsWithOptions:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeAllSymbolEffectsWithOptions(&self, options: &NSSymbolEffectOptions);

        #[cfg(feature = "objc2-symbols")]
        /// Removes all symbol effects from the bar button item with specified options and animation.
        #[unsafe(method(removeAllSymbolEffectsWithOptions:animated:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeAllSymbolEffectsWithOptions_animated(
            &self,
            options: &NSSymbolEffectOptions,
            animated: bool,
        );

        #[cfg(all(feature = "UIImage", feature = "objc2-symbols"))]
        /// Sets the symbol image on the bar button item with a symbol content transition and default options.
        /// Passing in a non-symbol image will result in undefined behavior.
        #[unsafe(method(setSymbolImage:withContentTransition:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSymbolImage_withContentTransition(
            &self,
            symbol_image: &UIImage,
            transition: &NSSymbolContentTransition,
        );

        #[cfg(all(feature = "UIImage", feature = "objc2-symbols"))]
        /// Sets the symbol image on the bar button item with a symbol content transition and specified options.
        /// Passing in a non-symbol image will result in undefined behavior.
        #[unsafe(method(setSymbolImage:withContentTransition:options:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSymbolImage_withContentTransition_options(
            &self,
            symbol_image: &UIImage,
            transition: &NSSymbolContentTransition,
            options: &NSSymbolEffectOptions,
        );
    );
}
