/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.text.TPTextDocument;
import org.jkiss.dbeaver.model.text.TPTextRegion;

public class SQLTextDocumentAdapter
implements TPTextDocument {
    private static final Log log = Log.getLog(SQLTextDocumentAdapter.class);
    private final IDocument document;

    public SQLTextDocumentAdapter(IDocument document) {
        this.document = document;
    }

    public char getChar(int offset) {
        try {
            return this.document.getChar(offset);
        }
        catch (BadLocationException e) {
            log.debug((Object)e);
            return ' ';
        }
    }

    public int getLength() {
        return this.document.getLength();
    }

    @NotNull
    public String get() {
        return this.document.get();
    }

    @NotNull
    public String get(int offset, int length) {
        try {
            return this.document.get(offset, length);
        }
        catch (BadLocationException e) {
            log.debug((Object)e);
            return "";
        }
    }

    public void set(@NotNull String text) {
        this.document.set(text);
    }

    public void replace(int offset, int length, @NotNull String text) {
        try {
            this.document.replace(offset, length, text);
        }
        catch (BadLocationException e) {
            log.debug((Object)e);
        }
    }

    @NotNull
    public String[] getLegalLineDelimiters() {
        return this.document.getLegalLineDelimiters();
    }

    @NotNull
    public String getLineDelimiter(int line) {
        try {
            return this.document.getLineDelimiter(line);
        }
        catch (BadLocationException e) {
            log.debug((Object)e);
            return "\n";
        }
    }

    public int getLineOfOffset(int offset) {
        try {
            return this.document.getLineOfOffset(offset);
        }
        catch (BadLocationException e) {
            log.debug((Object)e);
            return 0;
        }
    }

    public int getLineOffset(int line) {
        try {
            return this.document.getLineOffset(line);
        }
        catch (BadLocationException e) {
            log.debug((Object)e);
            return 0;
        }
    }

    @NotNull
    public TPTextRegion getLineInformation(int line) {
        try {
            IRegion region = this.document.getLineInformation(line);
            return new TPTextRegion(region.getOffset(), region.getLength());
        }
        catch (BadLocationException e) {
            log.debug((Object)e);
            return new TPTextRegion(0, 0);
        }
    }

    @NotNull
    public TPTextRegion getLineInformationOfOffset(int offset) {
        try {
            IRegion region = this.document.getLineInformationOfOffset(offset);
            return new TPTextRegion(region.getOffset(), region.getLength());
        }
        catch (BadLocationException e) {
            log.debug((Object)e);
            return new TPTextRegion(0, 0);
        }
    }

    public int getNumberOfLines() {
        return this.document.getNumberOfLines();
    }
}

