/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.internal.function.simplify;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import tech.units.indriya.function.AbstractConverter;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.function.ConverterCompositionHandler;
import tech.units.indriya.function.PowerOfIntConverter;
import tech.units.indriya.internal.function.simplify.CompositionTask;

public class UnitCompositionHandlerYieldingNormalForm
implements ConverterCompositionHandler {
    private final Map<Class<? extends AbstractConverter>, Integer> normalFormOrder = Calculus.getNormalFormOrder();

    @Override
    public AbstractConverter compose(AbstractConverter a, AbstractConverter b, BiPredicate<AbstractConverter, AbstractConverter> canReduce, BinaryOperator<AbstractConverter> doReduce) {
        if (a.isIdentity()) {
            if (b.isIdentity()) {
                return this.isNormalFormOrderWhenIdentity(a, b) ? a : b;
            }
            return b;
        }
        if (b.isIdentity()) {
            return a;
        }
        if (canReduce.test(a, b)) {
            return (AbstractConverter)doReduce.apply(a, b);
        }
        boolean commutative = a.isLinear() && b.isLinear();
        boolean swap = commutative && !this.isNormalFormOrderWhenCommutative(a, b);
        AbstractConverter.Pair nonSimplifiedForm = swap ? new AbstractConverter.Pair(b, a) : new AbstractConverter.Pair(a, b);
        return new CompositionTask(this::isNormalFormOrderWhenIdentity, this::isNormalFormOrderWhenCommutative, canReduce, doReduce).reduceToNormalForm(nonSimplifiedForm.getConversionSteps());
    }

    private boolean isNormalFormOrderWhenIdentity(AbstractConverter a, AbstractConverter b) {
        if (a.getClass().equals(b.getClass())) {
            return true;
        }
        return this.normalFormOrder.get(a.getClass()) <= this.normalFormOrder.get(b.getClass());
    }

    private boolean isNormalFormOrderWhenCommutative(AbstractConverter a, AbstractConverter b) {
        if (a.getClass().equals(b.getClass())) {
            if (a instanceof PowerOfIntConverter) {
                return ((PowerOfIntConverter)a).getBase() <= ((PowerOfIntConverter)b).getBase();
            }
            return true;
        }
        Integer orderA = Objects.requireNonNull(this.normalFormOrder.get(a.getClass()), () -> String.format("no normal-form order defined for class '%s'", a.getClass().getName()));
        Integer orderB = Objects.requireNonNull(this.normalFormOrder.get(b.getClass()), () -> String.format("no normal-form order defined for class '%s'", b.getClass().getName()));
        return orderA <= orderB;
    }
}

