/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts.propertySources;

import com.intellij.jam.JamBaseElement;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.semantic.SemKey;
import com.intellij.spring.model.jam.converters.PropertiesFileConverter;
import com.intellij.spring.model.jam.stereotype.SpringPropertySource;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringTestPropertySource
extends JamBaseElement<PsiClass>
implements SpringPropertySource {
    private static final SemKey<SpringTestPropertySource> SPRING_TEST_PROPERTY_SOURCE_JAM_KEY = PROPERTY_SOURCE_JAM_KEY.subKey("SpringTestPropertySource", new SemKey[0]);
    private static final JamStringAttributeMeta.Collection<Set<PropertiesFile>> VALUE_ATTR_META = JamAttributeMeta.collectionString((String)"value", (JamConverter)new PropertiesFileConverter());
    private static final JamStringAttributeMeta.Collection<Set<PropertiesFile>> LOCATIONS_ATTR_META = JamAttributeMeta.collectionString((String)"locations", (JamConverter)new PropertiesFileConverter());
    static final JamAnnotationMeta ANNO_META = new JamAnnotationMeta("org.springframework.test.context.TestPropertySource");
    public static final JamClassMeta<SpringTestPropertySource> META = new JamClassMeta(null, SpringTestPropertySource::new, SPRING_TEST_PROPERTY_SOURCE_JAM_KEY);
    private final PsiElementRef<PsiAnnotation> myPsiAnnotation;

    private SpringTestPropertySource(@NotNull PsiElementRef<?> psiRef) {
        if (psiRef == null) {
            SpringTestPropertySource.$$$reportNull$$$0(0);
        }
        super(psiRef);
        PsiClass psiClass = (PsiClass)Objects.requireNonNull(psiRef.getPsiElement());
        this.myPsiAnnotation = ANNO_META.getAnnotationRef((PsiModifierListOwner)psiClass);
    }

    @Override
    @Nullable
    public PsiAnnotation getAnnotation() {
        return ANNO_META.getAnnotation((PsiModifierListOwner)this.getPsiElement());
    }

    @Override
    @NotNull
    public List<JamStringAttributeElement<Set<PropertiesFile>>> getLocationElements() {
        List list = ContainerUtil.concat(this.getLocationsAttr(), this.getValueAttr());
        if (list == null) {
            SpringTestPropertySource.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public boolean isIgnoreResourceNotFound() {
        return false;
    }

    @Override
    public Set<PropertiesFile> getPropertiesFiles() {
        LinkedHashSet<PropertiesFile> propertiesFiles = new LinkedHashSet<PropertiesFile>();
        if (this.getValueAttr().isEmpty() && this.getLocationsAttr().isEmpty()) {
            PropertiesFile propertiesFile = this.getDefaultPropertiesFile();
            if (propertiesFile != null) {
                return Collections.singleton(propertiesFile);
            }
        } else {
            SpringTestPropertySource.addPropertiesFiles(propertiesFiles, this.getValueAttr());
            SpringTestPropertySource.addPropertiesFiles(propertiesFiles, this.getLocationsAttr());
        }
        return propertiesFiles;
    }

    @Override
    public boolean isPsiValid() {
        return this.isValid();
    }

    @NotNull
    private List<JamStringAttributeElement<Set<PropertiesFile>>> getLocationsAttr() {
        List list = LOCATIONS_ATTR_META.getJam(this.myPsiAnnotation);
        if (list == null) {
            SpringTestPropertySource.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    private List<JamStringAttributeElement<Set<PropertiesFile>>> getValueAttr() {
        List list = VALUE_ATTR_META.getJam(this.myPsiAnnotation);
        if (list == null) {
            SpringTestPropertySource.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static void addPropertiesFiles(@NotNull Set<PropertiesFile> propertiesFiles, @NotNull List<JamStringAttributeElement<Set<PropertiesFile>>> attributeValues) {
        if (propertiesFiles == null) {
            SpringTestPropertySource.$$$reportNull$$$0(4);
        }
        if (attributeValues == null) {
            SpringTestPropertySource.$$$reportNull$$$0(5);
        }
        for (JamStringAttributeElement<Set<PropertiesFile>> attributeElement : attributeValues) {
            Set value = (Set)attributeElement.getValue();
            if (value == null) continue;
            propertiesFiles.addAll(value);
        }
    }

    @Nullable
    private PropertiesFile getDefaultPropertiesFile() {
        String propertiesFileName = this.getDefaultPropertiesFileName();
        PsiDirectory containingDirectory = ((PsiClass)this.getPsiElement()).getContainingFile().getContainingDirectory();
        if (containingDirectory != null) {
            PsiFile file = containingDirectory.findFile(propertiesFileName);
            if (file instanceof PropertiesFile) {
                return (PropertiesFile)file;
            }
            PsiPackage psiPackage = JavaDirectoryService.getInstance().getPackage(containingDirectory);
            if (psiPackage != null) {
                for (PsiDirectory psiDirectory : psiPackage.getDirectories()) {
                    file = psiDirectory.findFile(propertiesFileName);
                    if (!(file instanceof PropertiesFile)) continue;
                    return (PropertiesFile)file;
                }
            }
        }
        return null;
    }

    private String getDefaultPropertiesFileName() {
        return ((PsiClass)this.getPsiElement()).getName() + ".properties";
    }

    static {
        META.addAnnotation(ANNO_META);
        ANNO_META.addAttribute(VALUE_ATTR_META);
        ANNO_META.addAttribute(LOCATIONS_ATTR_META);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiRef";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/testContexts/propertySources/SpringTestPropertySource";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesFiles";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/testContexts/propertySources/SpringTestPropertySource";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationElements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationsAttr";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueAttr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPropertiesFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

