/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.view.editor;

import com.intellij.jpa.view.editor.PersistencePackageAsVirtualFileImpl;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ImplicitPersistencePackagePointer
implements PersistencePackagePointer {
    private final PersistenceFacet myPersistenceFacet;
    private final String myElementName;
    private final String myModuleName;

    ImplicitPersistencePackagePointer(@NotNull PersistenceFacet facet, @NotNull String name, @NotNull String moduleName) {
        if (facet == null) {
            ImplicitPersistencePackagePointer.$$$reportNull$$$0(0);
        }
        if (name == null) {
            ImplicitPersistencePackagePointer.$$$reportNull$$$0(1);
        }
        if (moduleName == null) {
            ImplicitPersistencePackagePointer.$$$reportNull$$$0(2);
        }
        this.myPersistenceFacet = facet;
        this.myElementName = name;
        this.myModuleName = moduleName;
    }

    public String getElementName() {
        return this.myElementName;
    }

    public String getModuleName() {
        return this.myModuleName;
    }

    @NotNull
    public String getPath() {
        String string = this.myElementName;
        if (string == null) {
            ImplicitPersistencePackagePointer.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getPresentableUrl() {
        String string = this.myElementName;
        if (string == null) {
            ImplicitPersistencePackagePointer.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myPersistenceFacet.getModule().getProject();
        if (project == null) {
            ImplicitPersistencePackagePointer.$$$reportNull$$$0(5);
        }
        return project;
    }

    @Nullable
    public PersistencePackage findElement() {
        String elementName = this.getElementName();
        List units = this.getPersistenceFacet().getPersistenceUnits();
        for (PersistencePackage unit : units) {
            if (!Objects.equals(PersistencePackageAsVirtualFileImpl.getElementName(unit), elementName)) continue;
            return unit;
        }
        return null;
    }

    public PersistenceFacet getPersistenceFacet() {
        return this.myPersistenceFacet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImplicitPersistencePackagePointer pointer = (ImplicitPersistencePackagePointer)o;
        return Objects.equals(this.myPersistenceFacet, pointer.myPersistenceFacet) && Objects.equals(this.myElementName, pointer.myElementName) && Objects.equals(this.myModuleName, pointer.myModuleName);
    }

    public int hashCode() {
        return Objects.hash(this.myPersistenceFacet, this.myElementName, this.myModuleName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/view/editor/ImplicitPersistencePackagePointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/view/editor/ImplicitPersistencePackagePointer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableUrl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

