/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.ide.folding;

import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;

public final class ProtoFoldingUtils {
    public static <T> void addIfNotNull(Collection<T> collection, T item) {
        if (item != null) {
            collection.add(item);
        }
    }

    public static boolean isOnOwnLine(PsiElement element, Document document) {
        PsiElement prevElement = PsiTreeUtil.prevVisibleLeaf((PsiElement)element);
        PsiElement nextElement = PsiTreeUtil.nextVisibleLeaf((PsiElement)element);
        TextRange prevRange = prevElement != null ? prevElement.getTextRange() : null;
        TextRange nextRange = nextElement != null ? nextElement.getTextRange() : null;
        TextRange currentRange = element.getTextRange();
        int startLine = document.getLineNumber(currentRange.getStartOffset());
        int endLine = document.getLineNumber(currentRange.getEndOffset());
        if (prevRange != null && document.getLineNumber(prevRange.getEndOffset()) == startLine) {
            return false;
        }
        return nextRange == null || document.getLineNumber(nextRange.getStartOffset()) != endLine;
    }

    public static class ConsecutiveElementGrouper {
        private PsiElement firstElement = null;
        private PsiElement lastElement = null;

        public FoldingDescriptor pushElement(PsiElement element) {
            FoldingDescriptor result = null;
            if (this.lastElement == null) {
                this.firstElement = element;
                this.lastElement = element;
            } else if (element.getPrevSibling() == this.lastElement || element.getPrevSibling() instanceof PsiWhiteSpace && element.getPrevSibling().getPrevSibling() == this.lastElement) {
                this.lastElement = element;
            } else {
                result = this.buildBlock();
                this.firstElement = element;
                this.lastElement = element;
            }
            return result;
        }

        public FoldingDescriptor buildBlock() {
            FoldingDescriptor result = null;
            if (this.firstElement != this.lastElement) {
                result = new FoldingDescriptor(this.firstElement.getNode(), new TextRange(this.firstElement.getTextRange().getStartOffset(), this.lastElement.getTextRange().getEndOffset()));
            }
            this.firstElement = null;
            this.lastElement = null;
            return result;
        }
    }
}

