/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v0;

import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.flightrecorder.internal.InvalidJfrFileException;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.ChunkStructure;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.IValueReader;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.Offset;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.DataType;
import org.openjdk.jmc.flightrecorder.internal.util.DataInputToolkit;
import org.openjdk.jmc.flightrecorder.parser.ByteBufferWrapper;

final class ArrayReader
implements IValueReader {
    private final IValueReader reader;
    private final ChunkStructure header;
    private static final int UNREASONABLE_ARRAY_LENGTH = 10000000;

    ArrayReader(IValueReader reader, ChunkStructure header) {
        this.reader = reader;
        this.header = header;
    }

    @Override
    public Object readValue(ByteBufferWrapper bytes, Offset offset, long timestamp) throws InvalidJfrFileException {
        int arraySize = ArrayReader.readArraySize(bytes, offset.get());
        offset.increase(DataType.INTEGER.getSize());
        if ((long)arraySize > this.header.getChunkSize()) {
            throw new InvalidJfrFileException("Found array larger than chunk size");
        }
        Object[] array = new Object[arraySize];
        for (int n = 0; n < arraySize; ++n) {
            array[n] = this.reader.readValue(bytes, offset, timestamp);
        }
        return array;
    }

    private static int readArraySize(ByteBufferWrapper data2, int offset) throws InvalidJfrFileException {
        int length = DataInputToolkit.readInt(data2, offset);
        if (length < 0 || length > 10000000) {
            throw new InvalidJfrFileException();
        }
        return length;
    }

    @Override
    public ContentType<?> getValueType() {
        return UnitLookup.UNKNOWN;
    }
}

