/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.jasmine;

import com.intellij.javascript.testFramework.jasmine.AbstractJasmineElement;
import com.intellij.javascript.testFramework.jasmine.JasmineSpecStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineSuiteNode;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JasmineSuiteStructure
extends AbstractJasmineElement {
    private final JSFunctionExpression mySpecDefinitions;
    private final JasmineSuiteNode myNode;

    public JasmineSuiteStructure(@NotNull JSCallExpression enclosingCallExpression, @Nullable JSFunctionExpression specDefinition, @NotNull JSExpression nameExpression, @NotNull String name, @Nullable JasmineSuiteStructure parent) {
        if (enclosingCallExpression == null) {
            JasmineSuiteStructure.$$$reportNull$$$0(0);
        }
        if (nameExpression == null) {
            JasmineSuiteStructure.$$$reportNull$$$0(1);
        }
        if (name == null) {
            JasmineSuiteStructure.$$$reportNull$$$0(2);
        }
        super(enclosingCallExpression, nameExpression, name, parent);
        this.myNode = new JasmineSuiteNode();
        this.mySpecDefinitions = specDefinition;
    }

    @Nullable
    public JSFunctionExpression getSpecDefinitions() {
        return this.mySpecDefinitions;
    }

    public void addChild(@NotNull AbstractJasmineElement child) {
        if (child == null) {
            JasmineSuiteStructure.$$$reportNull$$$0(3);
        }
        this.myNode.addChild(child);
    }

    @Nullable
    public JasmineSuiteStructure findChildSuiteByName(@NotNull String childSuiteName) {
        if (childSuiteName == null) {
            JasmineSuiteStructure.$$$reportNull$$$0(4);
        }
        return this.myNode.findChildSuiteByName(childSuiteName);
    }

    @Nullable
    public JasmineSpecStructure findChildSpecByName(@NotNull String childSuiteName) {
        if (childSuiteName == null) {
            JasmineSuiteStructure.$$$reportNull$$$0(5);
        }
        return this.myNode.findChildSpecByName(childSuiteName);
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public JasmineSpecStructure getInnerSpecByName(@NotNull String specName) {
        if (specName == null) {
            JasmineSuiteStructure.$$$reportNull$$$0(6);
        }
        return this.findChildSpecByName(specName);
    }

    @Nullable
    public JasmineSpecStructure findSpecContainingOffset(int offset) {
        for (JasmineSpecStructure specChild : this.myNode.getChildSpecs()) {
            TextRange specTextRange = specChild.getEnclosingCallExpression().getTextRange();
            if (!JsPsiUtils.containsOffsetStrictly(specTextRange, offset)) continue;
            return specChild;
        }
        for (JasmineSuiteStructure suiteChild : this.myNode.getChildSuites()) {
            JasmineSpecStructure specStructure = suiteChild.findSpecContainingOffset(offset);
            if (specStructure == null) continue;
            return specStructure;
        }
        return null;
    }

    @Nullable
    public JasmineSuiteStructure findLowestSuiteStructureContainingOffset(int offset) {
        for (JasmineSuiteStructure suiteStructure : this.myNode.getChildSuites()) {
            JasmineSuiteStructure inner = suiteStructure.findLowestSuiteStructureContainingOffset(offset);
            if (inner == null) continue;
            return null;
        }
        TextRange suiteTextRange = this.getEnclosingCallExpression().getTextRange();
        if (JsPsiUtils.containsOffsetStrictly(suiteTextRange, offset)) {
            return this;
        }
        return null;
    }

    @NotNull
    public List<JasmineSuiteStructure> getSuites() {
        List<JasmineSuiteStructure> list = this.myNode.getChildSuites();
        if (list == null) {
            JasmineSuiteStructure.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public List<JasmineSpecStructure> getSpecs() {
        List<JasmineSpecStructure> list = this.myNode.getChildSpecs();
        if (list == null) {
            JasmineSuiteStructure.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    @NotNull
    public List<AbstractJasmineElement> getChildren() {
        List<AbstractJasmineElement> list = this.myNode.getChildren();
        if (list == null) {
            JasmineSuiteStructure.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    public AbstractJasmineElement findJasmineElement(@NotNull TextRange textRange) {
        if (textRange == null) {
            JasmineSuiteStructure.$$$reportNull$$$0(10);
        }
        if (!this.getEnclosingCallExpression().getTextRange().contains(textRange)) {
            return null;
        }
        for (JasmineSpecStructure specChild : this.getSpecs()) {
            TextRange callTextRange = specChild.getEnclosingCallExpression().getTextRange();
            if (!callTextRange.contains(textRange)) continue;
            return specChild;
        }
        for (JasmineSuiteStructure suiteChild : this.getSuites()) {
            AbstractJasmineElement result2 = suiteChild.findJasmineElement(textRange);
            if (result2 == null) continue;
            return result2;
        }
        return this;
    }

    public void forEachTest(@NotNull Consumer<JasmineSpecStructure> specConsumer) {
        if (specConsumer == null) {
            JasmineSuiteStructure.$$$reportNull$$$0(11);
        }
        for (JasmineSuiteStructure suite : this.getSuites()) {
            suite.forEachTest(specConsumer);
        }
        this.getSpecs().forEach(specConsumer);
    }

    @NotNull
    JasmineSuiteNode getNode() {
        JasmineSuiteNode jasmineSuiteNode = this.myNode;
        if (jasmineSuiteNode == null) {
            JasmineSuiteStructure.$$$reportNull$$$0(12);
        }
        return jasmineSuiteNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enclosingCallExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameExpression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childSuiteName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/jasmine/JasmineSuiteStructure";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/jasmine/JasmineSuiteStructure";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuites";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpecs";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findChildSuiteByName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findChildSpecByName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInnerSpecByName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findJasmineElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "forEachTest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 12 -> new IllegalStateException(string);
        };
    }
}

