/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.lsp;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.typescript.library.TypeScriptServiceDirectoryWatcher;
import com.intellij.lang.typescript.lsp.JSFrameworkLsp4jServer;
import com.intellij.lang.typescript.lsp.TypeScriptGoServiceUtilKt;
import com.intellij.lang.typescript.lsp.TypeScriptGoTypeEvaluationLspServiceKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.ProjectWideLspServerDescriptor;
import com.intellij.platform.lsp.api.customization.LspCallHierarchyCustomizer;
import com.intellij.platform.lsp.api.customization.LspCallHierarchyDisabled;
import com.intellij.platform.lsp.api.customization.LspCodeActionsDisabled;
import com.intellij.platform.lsp.api.customization.LspCompletionDisabled;
import com.intellij.platform.lsp.api.customization.LspCustomization;
import com.intellij.platform.lsp.api.customization.LspDiagnosticsDisabled;
import com.intellij.platform.lsp.api.customization.LspDocumentHighlightsCustomizer;
import com.intellij.platform.lsp.api.customization.LspDocumentHighlightsDisabled;
import com.intellij.platform.lsp.api.customization.LspDocumentSymbolCustomizer;
import com.intellij.platform.lsp.api.customization.LspDocumentSymbolDisabled;
import com.intellij.platform.lsp.api.customization.LspFoldingRangeDisabled;
import com.intellij.platform.lsp.api.customization.LspGoToDefinitionDisabled;
import com.intellij.platform.lsp.api.customization.LspGoToTypeDefinitionDisabled;
import com.intellij.platform.lsp.api.customization.LspHoverDisabled;
import com.intellij.platform.lsp.api.customization.LspInlayHintDisabled;
import com.intellij.platform.lsp.api.customization.LspSelectionRangeCustomizer;
import com.intellij.platform.lsp.api.customization.LspSelectionRangeDisabled;
import com.intellij.platform.lsp.api.customization.LspSignatureHelpCustomizer;
import com.intellij.platform.lsp.api.customization.LspSignatureHelpDisabled;
import com.intellij.platform.lsp.api.customization.LspWorkspaceSymbolCustomizer;
import com.intellij.platform.lsp.api.customization.LspWorkspaceSymbolDisabled;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R \u0010\u0006\u001a\u000e\u0012\n\b\u0001\u0012\u00060\bj\u0002`\t0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/lang/typescript/lsp/TypeScriptGoLspTypeEvaluationServerDescriptor;", "Lcom/intellij/platform/lsp/api/ProjectWideLspServerDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "lsp4jServerClass", "Ljava/lang/Class;", "Lorg/eclipse/lsp4j/services/LanguageServer;", "Lcom/intellij/platform/lsp/api/Lsp4jServer;", "getLsp4jServerClass", "()Ljava/lang/Class;", "lspCustomization", "Lcom/intellij/platform/lsp/api/customization/LspCustomization;", "getLspCustomization", "()Lcom/intellij/platform/lsp/api/customization/LspCustomization;", "isSupportedFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "startServerProcess", "Lcom/intellij/execution/process/OSProcessHandler;", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "intellij.javascript.backend"})
public final class TypeScriptGoLspTypeEvaluationServerDescriptor
extends ProjectWideLspServerDescriptor {
    @NotNull
    private final Class<? extends LanguageServer> lsp4jServerClass;
    @NotNull
    private final LspCustomization lspCustomization;

    public TypeScriptGoLspTypeEvaluationServerDescriptor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = JavaScriptBundle.message((String)"typescript.go.type.evaluation.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        super(project, string);
        this.lsp4jServerClass = JSFrameworkLsp4jServer.class;
        this.lspCustomization = new LspCustomization(){
            private final LspGoToDefinitionDisabled goToDefinitionCustomizer;
            private final LspGoToTypeDefinitionDisabled goToTypeDefinitionCustomizer;
            private final LspHoverDisabled hoverCustomizer;
            private final LspCompletionDisabled completionCustomizer;
            private final LspDiagnosticsDisabled diagnosticsCustomizer;
            private final LspCodeActionsDisabled codeActionsCustomizer;
            private final LspFoldingRangeDisabled foldingRangeCustomizer;
            private final LspInlayHintDisabled inlayHintCustomizer;
            private final LspWorkspaceSymbolCustomizer workspaceSymbolCustomizer;
            private final LspDocumentSymbolCustomizer documentSymbolCustomizer;
            private final LspDocumentHighlightsCustomizer documentHighlightsCustomizer;
            private final LspSignatureHelpCustomizer signatureHelpCustomizer;
            private final LspSelectionRangeCustomizer selectionRangeCustomizer;
            private final LspCallHierarchyCustomizer callHierarchyCustomizer;
            {
                this.goToDefinitionCustomizer = LspGoToDefinitionDisabled.INSTANCE;
                this.goToTypeDefinitionCustomizer = LspGoToTypeDefinitionDisabled.INSTANCE;
                this.hoverCustomizer = LspHoverDisabled.INSTANCE;
                this.completionCustomizer = LspCompletionDisabled.INSTANCE;
                this.diagnosticsCustomizer = LspDiagnosticsDisabled.INSTANCE;
                this.codeActionsCustomizer = LspCodeActionsDisabled.INSTANCE;
                this.foldingRangeCustomizer = LspFoldingRangeDisabled.INSTANCE;
                this.inlayHintCustomizer = LspInlayHintDisabled.INSTANCE;
                this.workspaceSymbolCustomizer = (LspWorkspaceSymbolCustomizer)LspWorkspaceSymbolDisabled.INSTANCE;
                this.documentSymbolCustomizer = (LspDocumentSymbolCustomizer)LspDocumentSymbolDisabled.INSTANCE;
                this.documentHighlightsCustomizer = (LspDocumentHighlightsCustomizer)LspDocumentHighlightsDisabled.INSTANCE;
                this.signatureHelpCustomizer = (LspSignatureHelpCustomizer)LspSignatureHelpDisabled.INSTANCE;
                this.selectionRangeCustomizer = (LspSelectionRangeCustomizer)LspSelectionRangeDisabled.INSTANCE;
                this.callHierarchyCustomizer = (LspCallHierarchyCustomizer)LspCallHierarchyDisabled.INSTANCE;
            }

            public LspGoToDefinitionDisabled getGoToDefinitionCustomizer() {
                return this.goToDefinitionCustomizer;
            }

            public LspGoToTypeDefinitionDisabled getGoToTypeDefinitionCustomizer() {
                return this.goToTypeDefinitionCustomizer;
            }

            public LspHoverDisabled getHoverCustomizer() {
                return this.hoverCustomizer;
            }

            public LspCompletionDisabled getCompletionCustomizer() {
                return this.completionCustomizer;
            }

            public LspDiagnosticsDisabled getDiagnosticsCustomizer() {
                return this.diagnosticsCustomizer;
            }

            public LspCodeActionsDisabled getCodeActionsCustomizer() {
                return this.codeActionsCustomizer;
            }

            public LspFoldingRangeDisabled getFoldingRangeCustomizer() {
                return this.foldingRangeCustomizer;
            }

            public LspInlayHintDisabled getInlayHintCustomizer() {
                return this.inlayHintCustomizer;
            }

            public LspWorkspaceSymbolCustomizer getWorkspaceSymbolCustomizer() {
                return this.workspaceSymbolCustomizer;
            }

            public LspDocumentSymbolCustomizer getDocumentSymbolCustomizer() {
                return this.documentSymbolCustomizer;
            }

            public LspDocumentHighlightsCustomizer getDocumentHighlightsCustomizer() {
                return this.documentHighlightsCustomizer;
            }

            public LspSignatureHelpCustomizer getSignatureHelpCustomizer() {
                return this.signatureHelpCustomizer;
            }

            public LspSelectionRangeCustomizer getSelectionRangeCustomizer() {
                return this.selectionRangeCustomizer;
            }

            public LspCallHierarchyCustomizer getCallHierarchyCustomizer() {
                return this.callHierarchyCustomizer;
            }
        };
    }

    @NotNull
    public Class<? extends LanguageServer> getLsp4jServerClass() {
        return this.lsp4jServerClass;
    }

    @NotNull
    public LspCustomization getLspCustomization() {
        return this.lspCustomization;
    }

    public boolean isSupportedFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return TypeScriptGoServiceUtilKt.isTsGoSupports(file);
    }

    @NotNull
    public OSProcessHandler startServerProcess() {
        OSProcessHandler oSProcessHandler = TypeScriptGoServiceUtilKt.tryStartInWsl(this.createCommandLine(), LspServerDescriptor.LOG);
        if (oSProcessHandler == null) {
            oSProcessHandler = super.startServerProcess();
        }
        return oSProcessHandler;
    }

    @NotNull
    public GeneralCommandLine createCommandLine() {
        String serviceDirectory = (String)ReadAction.nonBlocking(() -> TypeScriptGoLspTypeEvaluationServerDescriptor.createCommandLine$lambda$0(this)).executeSynchronously();
        Object[] objectArray = new String[]{"--defaultLibraryPath", serviceDirectory};
        return new GeneralCommandLine(CollectionsKt.plus((Collection)TypeScriptGoServiceUtilKt.getTsGoCommandLine(TypeScriptGoTypeEvaluationLspServiceKt.access$getExecutablePath()), (Iterable)CollectionsKt.listOf((Object[])objectArray)));
    }

    private static final String createCommandLine$lambda$0(TypeScriptGoLspTypeEvaluationServerDescriptor this$0) {
        return TypeScriptServiceDirectoryWatcher.getService(this$0.getProject()).calcServiceDirectory();
    }
}

