/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteConnectionCredentialsWrapper;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshUiData;
import com.jetbrains.plugins.remotesdk.SshConfigCredentialsType;
import com.jetbrains.plugins.remotesdk.SshCredentialsType;
import com.jetbrains.plugins.remotesdk.VagrantCredentialsType;
import com.jetbrains.plugins.remotesdk.VagrantCredentialsUtil;
import com.jetbrains.plugins.remotesdk.WebDeploymentCredentialsType;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class RemoteCredentialsProducer {
    private final RemoteConnectionCredentialsWrapper myWrapper;

    public RemoteCredentialsProducer(@NotNull RemoteConnectionCredentialsWrapper wrapper) {
        if (wrapper == null) {
            RemoteCredentialsProducer.$$$reportNull$$$0(0);
        }
        this.myWrapper = wrapper;
    }

    @NotNull
    public RemoteCredentials getRemoteCredentials(@Nullable Project project, boolean allowSynchronousInteraction) throws ExecutionException, InterruptedException {
        MyRemoteCredentialsConsumer consumer = new MyRemoteCredentialsConsumer();
        try {
            this.produceRemoteCredentials(project, allowSynchronousInteraction, consumer);
        }
        catch (RuntimeException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        consumer.latch.await();
        RemoteCredentials remoteCredentials = consumer.credentials;
        if (remoteCredentials == null) {
            RemoteCredentialsProducer.$$$reportNull$$$0(1);
        }
        return remoteCredentials;
    }

    public void produceRemoteCredentials(@Nullable Project project, boolean allowSynchronousInteraction, @NotNull Consumer<RemoteCredentials> consumer) {
        if (consumer == null) {
            RemoteCredentialsProducer.$$$reportNull$$$0(2);
        }
        this.myWrapper.switchType(new CredentialsCase[]{CredentialsCase.create((CredentialsType)SshCredentialsType.getInstance(), consumer), CredentialsCase.create((CredentialsType)VagrantCredentialsType.getInstance(), credentials -> consumer.accept(VagrantCredentialsUtil.getAndCheckVagrantRemoteCredentials(credentials, allowSynchronousInteraction))), CredentialsCase.create((CredentialsType)WebDeploymentCredentialsType.getInstance(), credentials -> consumer.accept(WebDeploymentCredentialsType.createRemoteCredentials(project, credentials))), CredentialsCase.create((CredentialsType)SshConfigCredentialsType.getInstance(), credentials -> consumer.accept(SshConfigCredentialsType.createRemoteCredentials(project, credentials)))});
    }

    @Nullable
    public static RemoteCredentials getCredentialsBySftpServerId(@Nullable Project project, @Nullable String id) {
        WebServerConfig server = GroupedServersConfigManager.getInstance((Project)project).findServer(id, true);
        if (server != null && server.getFileTransferConfig().getAccessType() == AccessType.SFTP) {
            return WebDeploymentCredentialHelper.getRemoteCredentials((WebServerConfig)server, (Project)project);
        }
        return null;
    }

    @Nullable
    public static RemoteCredentials getCredentialsBySshConfigName(@Nullable Project project, @Nullable String name) {
        SshUiData sshUiData = SshConfigManager.getInstance((Project)project).findCurrentDataByName(name);
        return sshUiData == null ? null : sshUiData.copyToCredentials();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/RemoteCredentialsProducer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/RemoteCredentialsProducer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteCredentials";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "produceRemoteCredentials";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class MyRemoteCredentialsConsumer
    implements Consumer<RemoteCredentials> {
        private final CountDownLatch latch = new CountDownLatch(1);
        private RemoteCredentials credentials;

        private MyRemoteCredentialsConsumer() {
        }

        @Override
        public void accept(RemoteCredentials data) {
            this.credentials = data;
            this.latch.countDown();
        }
    }
}

