/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.parser.resources;

import com.github.weisj.jsvg.SVGRenderingHints;
import com.github.weisj.jsvg.geometry.size.FloatSize;
import com.github.weisj.jsvg.parser.resources.RenderableResource;
import com.github.weisj.jsvg.renderer.GraphicsUtil;
import com.github.weisj.jsvg.renderer.RenderContext;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;

public class ImageResource
implements RenderableResource {
    @NotNull
    private final BufferedImage image;

    public ImageResource(@NotNull BufferedImage image) {
        this.image = image;
    }

    @Override
    @NotNull
    public FloatSize intrinsicSize(@NotNull RenderContext context) {
        return new FloatSize(this.image.getWidth(context.platformSupport().imageObserver()), this.image.getHeight(context.platformSupport().imageObserver()));
    }

    @Override
    public void render(@NotNull Graphics2D g, @NotNull RenderContext context, @NotNull AffineTransform imgTransform) {
        int imgWidth = this.image.getWidth();
        int imgHeight = this.image.getHeight();
        Object imageAntialiasing = g.getRenderingHint(SVGRenderingHints.KEY_IMAGE_ANTIALIASING);
        if (imageAntialiasing == SVGRenderingHints.VALUE_IMAGE_ANTIALIASING_OFF) {
            g.drawImage(this.image, imgTransform, context.platformSupport().imageObserver());
        } else {
            g.transform(imgTransform);
            Rectangle imgRect = new Rectangle(0, 0, imgWidth, imgHeight);
            GraphicsUtil.safelySetPaint(g, new TexturePaint(this.image, imgRect));
            g.fill(imgRect);
        }
    }
}

