/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.dom.traversal;

import org.jetbrains.relocated.apache.batik.dom.AbstractNode;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class DOMTreeWalker
implements TreeWalker {
    protected Node root;
    protected int whatToShow;
    protected NodeFilter filter;
    protected boolean expandEntityReferences;
    protected Node currentNode;

    public DOMTreeWalker(Node n, int what, NodeFilter nf, boolean exp) {
        this.root = n;
        this.whatToShow = what;
        this.filter = nf;
        this.expandEntityReferences = exp;
        this.currentNode = this.root;
    }

    @Override
    public Node getRoot() {
        return this.root;
    }

    @Override
    public int getWhatToShow() {
        return this.whatToShow;
    }

    @Override
    public NodeFilter getFilter() {
        return this.filter;
    }

    @Override
    public boolean getExpandEntityReferences() {
        return this.expandEntityReferences;
    }

    @Override
    public Node getCurrentNode() {
        return this.currentNode;
    }

    @Override
    public void setCurrentNode(Node n) {
        if (n == null) {
            throw ((AbstractNode)this.root).createDOMException((short)9, "null.current.node", null);
        }
        this.currentNode = n;
    }

    @Override
    public Node parentNode() {
        Node result2 = this.parentNode(this.currentNode);
        if (result2 != null) {
            this.currentNode = result2;
        }
        return result2;
    }

    @Override
    public Node firstChild() {
        Node result2 = this.firstChild(this.currentNode);
        if (result2 != null) {
            this.currentNode = result2;
        }
        return result2;
    }

    @Override
    public Node lastChild() {
        Node result2 = this.lastChild(this.currentNode);
        if (result2 != null) {
            this.currentNode = result2;
        }
        return result2;
    }

    @Override
    public Node previousSibling() {
        Node result2 = this.previousSibling(this.currentNode, this.root);
        if (result2 != null) {
            this.currentNode = result2;
        }
        return result2;
    }

    @Override
    public Node nextSibling() {
        Node result2 = this.nextSibling(this.currentNode, this.root);
        if (result2 != null) {
            this.currentNode = result2;
        }
        return result2;
    }

    @Override
    public Node previousNode() {
        Node n;
        Node result2 = this.previousSibling(this.currentNode, this.root);
        if (result2 == null) {
            result2 = this.parentNode(this.currentNode);
            if (result2 != null) {
                this.currentNode = result2;
            }
            return result2;
        }
        Node last = n = this.lastChild(result2);
        while (n != null) {
            last = n;
            n = this.lastChild(last);
        }
        this.currentNode = last != null ? last : result2;
        return this.currentNode;
    }

    @Override
    public Node nextNode() {
        Node result2 = this.firstChild(this.currentNode);
        if (result2 != null) {
            this.currentNode = result2;
            return this.currentNode;
        }
        result2 = this.nextSibling(this.currentNode, this.root);
        if (result2 != null) {
            this.currentNode = result2;
            return this.currentNode;
        }
        Node parent = this.currentNode;
        do {
            if ((parent = this.parentNode(parent)) != null) continue;
            return null;
        } while ((result2 = this.nextSibling(parent, this.root)) == null);
        this.currentNode = result2;
        return this.currentNode;
    }

    protected Node parentNode(Node n) {
        if (n == this.root) {
            return null;
        }
        Node result2 = n;
        do {
            if ((result2 = result2.getParentNode()) != null) continue;
            return null;
        } while ((this.whatToShow & 1 << result2.getNodeType() - 1) == 0 || this.filter != null && this.filter.acceptNode(result2) != 1);
        return result2;
    }

    protected Node firstChild(Node n) {
        if (n.getNodeType() == 5 && !this.expandEntityReferences) {
            return null;
        }
        Node result2 = n.getFirstChild();
        if (result2 == null) {
            return null;
        }
        switch (this.acceptNode(result2)) {
            case 1: {
                return result2;
            }
            case 3: {
                Node t = this.firstChild(result2);
                if (t == null) break;
                return t;
            }
        }
        return this.nextSibling(result2, n);
    }

    protected Node lastChild(Node n) {
        if (n.getNodeType() == 5 && !this.expandEntityReferences) {
            return null;
        }
        Node result2 = n.getLastChild();
        if (result2 == null) {
            return null;
        }
        switch (this.acceptNode(result2)) {
            case 1: {
                return result2;
            }
            case 3: {
                Node t = this.lastChild(result2);
                if (t == null) break;
                return t;
            }
        }
        return this.previousSibling(result2, n);
    }

    protected Node previousSibling(Node n, Node root) {
        while (n != root) {
            Node result2 = n.getPreviousSibling();
            if (result2 == null) {
                result2 = n.getParentNode();
                if (result2 == null || result2 == root) {
                    return null;
                }
                if (this.acceptNode(result2) == 3) {
                    n = result2;
                    continue;
                }
                return null;
            }
            switch (this.acceptNode(result2)) {
                case 1: {
                    return result2;
                }
                case 3: {
                    Node t = this.lastChild(result2);
                    if (t == null) break;
                    return t;
                }
            }
            n = result2;
        }
        return null;
    }

    protected Node nextSibling(Node n, Node root) {
        while (n != root) {
            Node result2 = n.getNextSibling();
            if (result2 == null) {
                result2 = n.getParentNode();
                if (result2 == null || result2 == root) {
                    return null;
                }
                if (this.acceptNode(result2) == 3) {
                    n = result2;
                    continue;
                }
                return null;
            }
            switch (this.acceptNode(result2)) {
                case 1: {
                    return result2;
                }
                case 3: {
                    Node t = this.firstChild(result2);
                    if (t == null) break;
                    return t;
                }
            }
            n = result2;
        }
        return null;
    }

    protected short acceptNode(Node n) {
        if ((this.whatToShow & 1 << n.getNodeType() - 1) != 0) {
            if (this.filter == null) {
                return 1;
            }
            return this.filter.acceptNode(n);
        }
        return 3;
    }
}

