/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.util;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.formatter.xml.XmlCodeStyleSettings;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XmlHelper {
    @Nullable
    public static String getNamespace(@NotNull XmlFile xmlFile) {
        XmlDocument doc;
        if (xmlFile == null) {
            XmlHelper.$$$reportNull$$$0(0);
        }
        if ((doc = xmlFile.getDocument()) == null) {
            return null;
        }
        XmlTag rootTag = doc.getRootTag();
        if (rootTag == null) {
            return null;
        }
        return rootTag.getNamespace();
    }

    @Nullable
    public static XmlTag getContainingTag(XmlElement xmlElement) {
        XmlElement element;
        for (element = xmlElement; element != null && !(element instanceof XmlTag); element = element.getParent()) {
            PsiElement parent = element.getParent();
            if (parent instanceof XmlElement || XmlHelper.isCdata(parent)) {
                continue;
            }
            return null;
        }
        return (XmlTag)element;
    }

    public static boolean isCdata(PsiElement element) {
        return element instanceof CompositePsiElement && ((CompositePsiElement)element).getElementType() == XmlElementType.XML_CDATA;
    }

    @Contract(value="null -> null")
    @Nullable
    public static String getNamespace(@Nullable PsiElement psiElement) {
        if (!(psiElement instanceof XmlElement)) {
            return null;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        if (!(containingFile instanceof XmlFile)) {
            return null;
        }
        return XmlHelper.getNamespace((XmlFile)containingFile);
    }

    @Nullable
    public static XmlTag findParentWithName(XmlTag tag, String tagName) {
        XmlTag parent;
        for (parent = tag.getParentTag(); parent != null && !tagName.equals(parent.getName()); parent = parent.getParentTag()) {
        }
        return parent;
    }

    public static void copyFrom(DomElement target, DomElement source2) {
        target.copyFrom(source2);
        for (XmlTag tag : target.getXmlTag().getSubTags()) {
            tag.delete();
        }
        for (XmlTag tag : source2.getXmlTag().getSubTags()) {
            target.getXmlTag().addSubTag(tag, false);
        }
    }

    public static String reformatXmlSource(Project project, String source2) {
        XmlFile tempChangeSetFile = (XmlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("dummy.xml", (FileType)XmlFileType.INSTANCE, (CharSequence)source2);
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((Project)project);
        CodeStyleSettings cloneSettings = CodeStyleSettingsManager.getInstance().cloneSettings(codeStyleSettings);
        XmlCodeStyleSettings xmlSettings = (XmlCodeStyleSettings)cloneSettings.getCustomSettings(XmlCodeStyleSettings.class);
        xmlSettings.XML_ATTRIBUTE_WRAP = 2;
        CodeStyle.runWithLocalSettings((Project)project, (CodeStyleSettings)cloneSettings, () -> CodeStyleManager.getInstance((Project)project).reformat((PsiElement)tempChangeSetFile));
        return tempChangeSetFile.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/jpa/jpb/model/util/XmlHelper", "getNamespace"));
    }
}

