/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.engine;

import com.intellij.database.console.RemoteConsoleProcessSupport;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.execution.rmi.RemoteProcessSupport;
import com.intellij.hibernate.engine.HibernateConnectionManager;
import com.intellij.hibernate.engine.HibernateConsoleRunContext;
import com.intellij.hibernate.remote.HibernateFacade;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.util.EventDispatcher;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HibernateConnectionManagerImpl
extends HibernateConnectionManager
implements Disposable {
    private final EventDispatcher<ModificationTrackerListener> myDispatcher = EventDispatcher.create(ModificationTrackerListener.class);
    private final RemoteConsoleProcessSupport<PersistencePackagePointer, HibernateFacade> mySupport = new RemoteConsoleProcessSupport<PersistencePackagePointer, HibernateFacade>(HibernateFacade.class){

        protected void fireModificationCountChanged() {
            HibernateConnectionManagerImpl.this.incModificationCount();
            ApplicationManager.getApplication().invokeLater(() -> ((ModificationTrackerListener)HibernateConnectionManagerImpl.this.myDispatcher.getMulticaster()).modificationCountChanged((Object)HibernateConnectionManagerImpl.this));
        }

        @NotNull
        protected ConsoleRunConfiguration.RunContext createRunContext(@NotNull PersistencePackagePointer target) {
            if (target == null) {
                1.$$$reportNull$$$0(0);
            }
            return new HibernateConsoleRunContext(target);
        }

        protected String getName(@NotNull PersistencePackagePointer file) {
            if (file == null) {
                1.$$$reportNull$$$0(1);
            }
            return file.getElementName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/hibernate/engine/HibernateConnectionManagerImpl$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createRunContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getName";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public HibernateConnectionManagerImpl(Project project) {
        Disposer.register((Disposable)this, this.mySupport);
    }

    @Override
    public List<ConsoleRunConfiguration> getActiveConfigurations(@NotNull PersistencePackagePointer unitFile) {
        if (unitFile == null) {
            HibernateConnectionManagerImpl.$$$reportNull$$$0(0);
        }
        return this.mySupport.getActiveConfigurations((Object)unitFile);
    }

    @Override
    public HibernateFacade getConnection(@NotNull PersistencePackagePointer unitFile, @NotNull ConsoleRunConfiguration configuration) throws Exception {
        if (unitFile == null) {
            HibernateConnectionManagerImpl.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            HibernateConnectionManagerImpl.$$$reportNull$$$0(2);
        }
        return (HibernateFacade)this.mySupport.acquire((Object)unitFile, (Object)configuration);
    }

    @Override
    public void releaseConnection(@NotNull PersistencePackagePointer unitFile, @Nullable ConsoleRunConfiguration configuration) {
        if (unitFile == null) {
            HibernateConnectionManagerImpl.$$$reportNull$$$0(3);
        }
        try {
            this.mySupport.release((Object)unitFile, (Object)configuration).get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException e) {
            RemoteProcessSupport.LOG.warn((Throwable)e);
        }
    }

    @Override
    public ModificationTracker getModificationTracker() {
        return this;
    }

    @Override
    public void addModificationTrackerListener(ModificationTrackerListener<HibernateConnectionManager> listener, Disposable disposable) {
        this.myDispatcher.addListener(listener, disposable);
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        objectArray2[1] = "com/intellij/hibernate/engine/HibernateConnectionManagerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getActiveConfigurations";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getConnection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "releaseConnection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

