/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.migration;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.diff.DbDiffElement;
import com.intellij.database.model.migration.DbDiffElementFilter;
import com.intellij.database.model.migration.DbMigrationOptions;
import com.intellij.database.model.migration.DbMigrationOptionsService;
import com.intellij.database.model.migration.DbMigrationTreeModel;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.sql.database.SqlDataSource;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u001a\u001a\u00020\u0012J\u0006\u0010\u001b\u001a\u00020\u0012J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002J\u000e\u0010!\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u001fJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020\u001fJ\u0010\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010 \u001a\u00020\u001fJ\u000e\u0010(\u001a\u00020)2\u0006\u0010 \u001a\u00020\u001fJ\u0006\u00106\u001a\u00020\u0017J\u0006\u00107\u001a\u00020\u0017R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0019\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010*\u001a\u0004\u0018\u00010+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0013\u0010.\u001a\u0004\u0018\u00010/8F\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0013\u00102\u001a\u0004\u0018\u000103\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105\u00a8\u00068"}, d2={"Lcom/intellij/database/model/migration/DbMigrationRequest;", "", "diffRootElements", "Lcom/intellij/openapi/util/Couple;", "Lcom/intellij/database/model/diff/DbDiffElement;", "options", "Lcom/intellij/database/model/migration/DbMigrationOptions;", "<init>", "(Lcom/intellij/openapi/util/Couple;Lcom/intellij/database/model/migration/DbMigrationOptions;)V", "getOptions", "()Lcom/intellij/database/model/migration/DbMigrationOptions;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getMigrationOptionsService", "Lcom/intellij/database/model/migration/DbMigrationOptionsService;", "saveScriptingOptions", "", "scriptingOptions", "Lcom/intellij/database/script/generator/ScriptingOptions;", "saveIgnoreImplicitObjects", "value", "", "saveIgnoreSourceCode", "swapped", "swap", "reinitializeAltModels", "reinitializeAltElement", "element", "realSide", "Lcom/intellij/database/model/migration/DbMigrationTreeModel$Side;", "side", "getRoot", "getElement", "Lcom/intellij/database/model/basic/BasicElement;", "getAltElement", "Lcom/intellij/database/model/basic/BasicModElement;", "settings", "Lcom/intellij/ide/diff/DirDiffSettings;", "getDataSource", "Lcom/intellij/database/psi/DbDataSource;", "targetNamespace", "Lcom/intellij/database/model/basic/BasicNamespace;", "getTargetNamespace", "()Lcom/intellij/database/model/basic/BasicNamespace;", "targetSearchPath", "Lcom/intellij/database/util/SearchPath;", "getTargetSearchPath", "()Lcom/intellij/database/util/SearchPath;", "elementFilter", "Lcom/intellij/database/model/migration/DbDiffElementFilter;", "getElementFilter", "()Lcom/intellij/database/model/migration/DbDiffElementFilter;", "isComparingLeaves", "isToDdl", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbMigrationRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMigrationRequest.kt\ncom/intellij/database/model/migration/DbMigrationRequest\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,101:1\n30#2,2:102\n*S KotlinDebug\n*F\n+ 1 DbMigrationRequest.kt\ncom/intellij/database/model/migration/DbMigrationRequest\n*L\n31#1:102,2\n*E\n"})
public final class DbMigrationRequest {
    @NotNull
    private final Couple<DbDiffElement> diffRootElements;
    @NotNull
    private final DbMigrationOptions options;
    @NotNull
    private final Project project;
    private boolean swapped;
    @NotNull
    private final DirDiffSettings settings;
    @Nullable
    private final DbDiffElementFilter elementFilter;

    public DbMigrationRequest(@NotNull Couple<DbDiffElement> diffRootElements, @NotNull DbMigrationOptions options) {
        Intrinsics.checkNotNullParameter(diffRootElements, (String)"diffRootElements");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.diffRootElements = diffRootElements;
        this.options = options;
        Project project = this.getRoot(DbMigrationTreeModel.Side.ORIGIN).getRoot().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        DirDiffSettings dirDiffSettings = this.getRoot(DbMigrationTreeModel.Side.ORIGIN).getRoot().getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)dirDiffSettings, (String)"getSettings(...)");
        this.settings = dirDiffSettings;
        Object v = this.settings.customSettings.get("DB_DIFF_FILTER");
        this.elementFilter = v instanceof DbDiffElementFilter ? (DbDiffElementFilter)v : null;
    }

    @NotNull
    public final DbMigrationOptions getOptions() {
        return this.options;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final DbMigrationOptionsService getMigrationOptionsService() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<DbMigrationOptionsService> serviceClass$iv = DbMigrationOptionsService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (DbMigrationOptionsService)object;
    }

    public final void saveScriptingOptions(@NotNull ScriptingOptions scriptingOptions) {
        Intrinsics.checkNotNullParameter((Object)scriptingOptions, (String)"scriptingOptions");
        this.options.setScriptingOptions(scriptingOptions);
        this.getMigrationOptionsService().setScriptingOptions(scriptingOptions);
    }

    public final void saveIgnoreImplicitObjects(boolean value) {
        this.options.setIgnoreImplicitObjects(value);
        this.getMigrationOptionsService().setIgnoreImplicitObjects(value);
    }

    public final void saveIgnoreSourceCode(boolean value) {
        this.options.setIgnoreSourceCode(value);
        this.getMigrationOptionsService().setIgnoreSourceCode(value);
    }

    public final void swap() {
        this.swapped = !this.swapped;
        this.reinitializeAltModels();
    }

    public final void reinitializeAltModels() {
        this.reinitializeAltElement(this.getRoot(DbMigrationTreeModel.Side.ORIGIN));
    }

    private final void reinitializeAltElement(DbDiffElement element) {
        element.getRoot().reinitializeAltModel();
        element.reinitializeAltElement();
    }

    private final DbMigrationTreeModel.Side realSide(DbMigrationTreeModel.Side side) {
        return this.swapped ? side.getOpposite() : side;
    }

    @NotNull
    public final DbDiffElement getRoot(@NotNull DbMigrationTreeModel.Side side) {
        Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
        return switch (WhenMappings.$EnumSwitchMapping$0[this.realSide(side).ordinal()]) {
            case 1 -> {
                Object v0 = this.diffRootElements.first;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"first");
                yield (DbDiffElement)((Object)v0);
            }
            case 2 -> {
                Object v2 = this.diffRootElements.second;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"second");
                yield (DbDiffElement)((Object)v2);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final BasicElement getElement(@NotNull DbMigrationTreeModel.Side side) {
        Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
        BasicElement basicElement = this.getRoot(side).getValue();
        Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"getValue(...)");
        return basicElement;
    }

    @Nullable
    public final BasicModElement getAltElement(@NotNull DbMigrationTreeModel.Side side) {
        Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
        return this.getRoot(side).getAltElement();
    }

    @NotNull
    public final DbDataSource getDataSource(@NotNull DbMigrationTreeModel.Side side) {
        Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
        DbDataSource dbDataSource = this.getRoot(side).getRoot().getDataSource();
        Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"getDataSource(...)");
        return dbDataSource;
    }

    @Nullable
    public final BasicNamespace getTargetNamespace() {
        DbDataSource ds = this.getDataSource(DbMigrationTreeModel.Side.TARGET);
        BasicElement basicElement = this.getRoot(DbMigrationTreeModel.Side.TARGET).getValue();
        Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"getValue(...)");
        BasicElement e = basicElement;
        return (BasicNamespace)DbImplUtilCore.getSearchPathObjectForSwitch((DbDataSource)ds, (DasObject)((DasObject)e));
    }

    @Nullable
    public final SearchPath getTargetSearchPath() {
        return ObjectPaths.searchPathOf((DasObject)((DasObject)this.getTargetNamespace()));
    }

    @Nullable
    public final DbDiffElementFilter getElementFilter() {
        return this.elementFilter;
    }

    public final boolean isComparingLeaves() {
        DbDiffElement originRootDiffElement = this.getRoot(DbMigrationTreeModel.Side.ORIGIN);
        List<BasicElement> list = originRootDiffElement.getRoot().getRootElements();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getRootElements(...)");
        List<BasicElement> requestedElements = list;
        return requestedElements.size() == 1 && !Intrinsics.areEqual((Object)CollectionsKt.first(requestedElements), (Object)originRootDiffElement.getValue());
    }

    public final boolean isToDdl() {
        return this.getDataSource(DbMigrationTreeModel.Side.TARGET).getDelegate() instanceof SqlDataSource;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DbMigrationTreeModel.Side.values().length];
            try {
                nArray[DbMigrationTreeModel.Side.ORIGIN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DbMigrationTreeModel.Side.TARGET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

