/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.data.parser;

import com.intellij.javaee.utils.persistence.data.parser.PartTree;
import com.intellij.javaee.utils.persistence.data.parser.PartTreeParserContext;
import com.intellij.javaee.utils.persistence.data.parser.PartTypes;
import com.intellij.javaee.utils.persistence.data.parser.domain.OrderBySource;
import com.intellij.micronaut.data.parser.MicronautPartTypes;
import com.intellij.micronaut.data.parser.MicronautProjection;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MicronautPartTreeParserContext
implements PartTreeParserContext {
    private static final MicronautPartTypes TYPES = new MicronautPartTypes();
    private static final String KEYWORD_TEMPLATE = "(%s)(?=(\\p{Lu}|\\P{InBASIC_LATIN}))";
    private static final String QUERY_PATTERN = "find|search|query|get|read|retrieve";
    private static final String COUNT_PATTERN = "count";
    private static final String EXISTS_PATTERN = "exists";
    private static final String UPDATE_DELETE_PATTERN = "delete|remove";
    private static final String UPDATE_PATTERN = "update";
    private static final String IGNORE_CASE = "IgnoreCase";
    public static final List<String> COUNT_PROJECTION_PREDICATES = List.of("Max", "Min", "Avg", "Sum");
    public static final List<String> PROJECTION_PREDICATES = List.of("Distinct", "Max", "Min", "Avg", "Sum");
    private static final String ALL_METHODS = "find|search|query|get|read|retrieve|update|count|exists|delete|remove";
    private static final String SIMPLE_METHOD_PATTERN = "^(find|search|query|get|read|retrieve|update|count|exists|delete|remove)$";
    private static final String SIMPLE_ORDER_METHOD_PATTERN = "^(?<subject>(find|search|query|get|read|retrieve|update|count|exists|delete|remove)(All|First)??)OrderBy";
    private static final String CRITERIA_PATTERN = "^(find|search|query|get|read|retrieve|update|count|exists|delete|remove)((\\p{Lu}.*?))??By";
    private final Pattern[] PREFIX_TEMPLATES = new Pattern[]{Pattern.compile("^(find|search|query|get|read|retrieve|update|count|exists|delete|remove)$"), Pattern.compile("^(?<subject>(find|search|query|get|read|retrieve|update|count|exists|delete|remove)(All|First)??)OrderBy"), Pattern.compile("^(find|search|query|get|read|retrieve|update|count|exists|delete|remove)((\\p{Lu}.*?))??By")};

    public static MicronautPartTreeParserContext create() {
        return new MicronautPartTreeParserContext();
    }

    public PartTypes types() {
        return TYPES;
    }

    public String keywordTemplate() {
        return KEYWORD_TEMPLATE;
    }

    public String queryPattern() {
        return QUERY_PATTERN;
    }

    public String countPattern() {
        return COUNT_PATTERN;
    }

    public String existsPattern() {
        return EXISTS_PATTERN;
    }

    public String deletePattern() {
        return UPDATE_DELETE_PATTERN;
    }

    public String updatePattern() {
        return UPDATE_PATTERN;
    }

    public Pattern[] prefixTemplates() {
        return this.PREFIX_TEMPLATES;
    }

    @Nullable
    public static MicronautProjection extractProjection(PartTree.Subject subject) {
        String subjectExpression = subject.getExpression();
        for (String prefix : MicronautPartTreeParserContext.getQueryMethodPrefixes()) {
            String projectionExpression;
            if (!subjectExpression.startsWith(prefix) || !subjectExpression.endsWith("By") || !StringUtil.isNotEmpty((String)(projectionExpression = subjectExpression.substring(prefix.length(), subjectExpression.length() - 2)))) continue;
            return new MicronautProjection(projectionExpression);
        }
        return null;
    }

    @NotNull
    public static List<String> getQueryMethodPrefixes() {
        List<String> list = Arrays.asList(QUERY_PATTERN.split("\\|"));
        if (list == null) {
            MicronautPartTreeParserContext.$$$reportNull$$$0(0);
        }
        return list;
    }

    public String ignoreCase() {
        return IGNORE_CASE;
    }

    public String[] splitOrderBy(@NotNull String orderClause) {
        if (orderClause == null) {
            MicronautPartTreeParserContext.$$$reportNull$$$0(1);
        }
        ArrayList<String> orders = new ArrayList<String>();
        for (String order : StringUtil.split((String)orderClause, (String)"And")) {
            orders.addAll(Arrays.asList(OrderBySource.splitOrderClause((String)order)));
        }
        return ArrayUtil.toStringArray(orders);
    }

    public String[] suffixes() {
        return new String[]{"ForUpdate", "Returning"};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/micronaut/data/parser/MicronautPartTreeParserContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderClause";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueryMethodPrefixes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/micronaut/data/parser/MicronautPartTreeParserContext";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "splitOrderBy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

